<?php

	if( !function_exists('gdlr_core_include_icon_font') ){
		function gdlr_core_include_icon_font($type = ''){
			
			switch($type){
				case 'font-awesome':
					wp_enqueue_style('font-awesome', GDLR_CORE_URL . '/plugins/fontawesome/font-awesome.css');
					break;
				case 'fa6':
					wp_enqueue_style('fa6', GDLR_CORE_URL . '/plugins/fa6/all.css');
					break;
				case 'fa5':
					wp_enqueue_style('fa5', GDLR_CORE_URL . '/plugins/fa5/fa5.css');
					break;
				case 'elegant-font':
					wp_enqueue_style('elegant-font', GDLR_CORE_URL . '/plugins/elegant/elegant-font.css');
					break;
				case 'ionicons':
					wp_enqueue_style('ionicons', GDLR_CORE_URL . '/plugins/ionicons/ionicons.css');
					break;
				case 'simpleline':
					wp_enqueue_style('simple-line-icons', GDLR_CORE_URL . '/plugins/simpleline/simpleline.css');
					break;
				case 'gdlr-custom-icon':
					wp_enqueue_style('gdlr-custom-icon', GDLR_CORE_URL . '/plugins/gdlr-custom-icon/gdlr-custom-icon.css');
					break;
				case 'gdlr-cannabis':
					wp_enqueue_style('gdlr-cannabis', GDLR_CORE_URL . '/plugins/gdlr-cannabis/style.css');
					break;
				case 'gdlr-travel':
					wp_enqueue_style('gdlr-travel', GDLR_CORE_URL . '/plugins/gdlr-travel/style.css');
					break;
			}
			
		}
	}

	if( !function_exists('gdlr_core_get_icon_font_type') ){
		function gdlr_core_get_icon_font_type($icon_class = '', $allow_none = false){

			$font_type = 'font-awesome';
			if( !empty($settings['allow-none']) && (empty($icon_class) || $icon_class == 'none') ){
				$font_type = 'none';
			}else if( !empty($icon_class) && (strpos($icon_class, 'icon_') === 0 || strpos($icon_class, 'arrow_') === 0 || strpos($icon_class, 'social_') === 0) ){
				$font_type = 'elegant-font';
			}else if( !empty($icon_class) && strpos($icon_class, 'ion-') === 0 ){
				$font_type = 'ionicons';
			}else if( !empty($icon_class) && strpos($icon_class, 'fa6') === 0 ){
				$font_type = 'fa6';
			}else if( !empty($icon_class) && strpos($icon_class, 'fa5') === 0 ){
				$font_type = 'fa5';
			}else if( !empty($icon_class) && strpos($icon_class, 'gdlr-icon-') === 0 ){
				$font_type = 'gdlr-custom-icon';
			}else if( !empty($icon_class) && strpos($icon_class, 'icon-') === 0 ){
				$font_type = 'simpleline';
			}else if( !empty($icon_class) && strpos($icon_class, 'gdl-cannabis-') === 0 ){
				$font_type = 'gdlr-cannabis';
			}else if( !empty($icon_class) && strpos($icon_class, 'gdl-travel-') === 0 ){
				$font_type = 'gdlr-travel';
			}

			return $font_type;
		}
	}

	if( !function_exists('gdlr_core_get_icon_font_title') ){
		function gdlr_core_get_icon_font_title($type = ''){

			$fonts = array(
				'font-awesome' => esc_html__('Font Awesome', 'goodlayers-core'),
				'fa6' => esc_html__('Font Awesome 6', 'goodlayers-core'),
				'fa5' => esc_html__('Font Awesome 5', 'goodlayers-core'),
				'elegant-font' => esc_html__('Elegant Font', 'goodlayers-core'),
				'ionicons' => esc_html__('Ionicons', 'goodlayers-core'),
				'simpleline' => esc_html__('Simple Line Icon', 'goodlayers-core'),
				'gdlr-custom-icon' => esc_html__('Custom Icon', 'goodlayers-core'),
				'gdlr-cannabis' => esc_html__('Custom Cannabis Icon', 'goodlayers-core'),
				'gdlr-travel' => esc_html__('Custom Travel Icon', 'goodlayers-core')
			);

			if( !empty($type) ){
				if( !empty($fonts[$type]) ){
					return $fonts[$type];
				}
			}else{
				return $fonts;
			}
			
		}
	}

	if( !function_exists('gdlr_core_get_icon_font_list') ){
		function gdlr_core_get_icon_font_list($type){
			switch($type){
				case 'font-awesome':
					return array('fa fa-address-book', 'fa fa-address-book-o', 'fa fa-address-card', 'fa fa-address-card-o', 'fa fa-bandcamp', 'fa fa-bath', 'fa fa-bathtub', 'fa fa-drivers-license', 'fa fa-drivers-license-o', 'fa fa-eercast', 'fa fa-envelope-open', 'fa fa-envelope-open-o', 'fa fa-etsy', 'fa fa-free-code-camp', 'fa fa-grav', 'fa fa-handshake-o', 'fa fa-id-badge', 'fa fa-id-card', 'fa fa-id-card-o', 'fa fa-imdb', 'fa fa-linode', 'fa fa-meetup', 'fa fa-microchip', 'fa fa-podcast', 'fa fa-quora', 'fa fa-ravelry', 'fa fa-s15', 'fa fa-shower', 'fa fa-snowflake-o', 'fa fa-superpowers', 'fa fa-telegram', 'fa fa-thermometer', 'fa fa-thermometer-0', 'fa fa-thermometer-1', 'fa fa-thermometer-2', 'fa fa-thermometer-3', 'fa fa-thermometer-4', 'fa fa-thermometer-empty', 'fa fa-thermometer-full', 'fa fa-thermometer-half', 'fa fa-thermometer-quarter', 'fa fa-thermometer-three-quarters', 'fa fa-times-rectangle', 'fa fa-times-rectangle-o', 'fa fa-user-circle', 'fa fa-user-circle-o', 'fa fa-user-o', 'fa fa-vcard', 'fa fa-vcard-o', 'fa fa-window-close', 'fa fa-window-close-o', 'fa fa-window-maximize', 'fa fa-window-minimize', 'fa fa-window-restore', 'fa fa-wpexplorer', 'fa fa-address-book', 'fa fa-address-book-o', 'fa fa-address-card', 'fa fa-address-card-o', 'fa fa-adjust', 'fa fa-american-sign-language-interpreting', 'fa fa-anchor', 'fa fa-archive', 'fa fa-area-chart', 'fa fa-arrows', 'fa fa-arrows-h', 'fa fa-arrows-v', 'fa fa-asl-interpreting', 'fa fa-assistive-listening-systems', 'fa fa-asterisk', 'fa fa-at', 'fa fa-audio-description', 'fa fa-automobile', 'fa fa-balance-scale', 'fa fa-ban', 'fa fa-bank', 'fa fa-bar-chart', 'fa fa-bar-chart-o', 'fa fa-barcode', 'fa fa-bars', 'fa fa-bath', 'fa fa-bathtub', 'fa fa-battery', 'fa fa-battery-0', 'fa fa-battery-1', 'fa fa-battery-2', 'fa fa-battery-3', 'fa fa-battery-4', 'fa fa-battery-empty', 'fa fa-battery-full', 'fa fa-battery-half', 'fa fa-battery-quarter', 'fa fa-battery-three-quarters', 'fa fa-bed', 'fa fa-beer', 'fa fa-bell', 'fa fa-bell-o', 'fa fa-bell-slash', 'fa fa-bell-slash-o', 'fa fa-bicycle', 'fa fa-binoculars', 'fa fa-birthday-cake', 'fa fa-blind', 'fa fa-bluetooth', 'fa fa-bluetooth-b', 'fa fa-bolt', 'fa fa-bomb', 'fa fa-book', 'fa fa-bookmark', 'fa fa-bookmark-o', 'fa fa-braille', 'fa fa-briefcase', 'fa fa-bug', 'fa fa-building', 'fa fa-building-o', 'fa fa-bullhorn', 'fa fa-bullseye', 'fa fa-bus', 'fa fa-cab', 'fa fa-calculator', 'fa fa-calendar', 'fa fa-calendar-check-o', 'fa fa-calendar-minus-o', 'fa fa-calendar-o', 'fa fa-calendar-plus-o', 'fa fa-calendar-times-o', 'fa fa-camera', 'fa fa-camera-retro', 'fa fa-car', 'fa fa-caret-square-o-down', 'fa fa-caret-square-o-left', 'fa fa-caret-square-o-right', 'fa fa-caret-square-o-up', 'fa fa-cart-arrow-down', 'fa fa-cart-plus', 'fa fa-cc', 'fa fa-certificate', 'fa fa-check', 'fa fa-check-circle', 'fa fa-check-circle-o', 'fa fa-check-square', 'fa fa-check-square-o', 'fa fa-child', 'fa fa-circle', 'fa fa-circle-o', 'fa fa-circle-o-notch', 'fa fa-circle-thin', 'fa fa-clock-o', 'fa fa-clone', 'fa fa-close', 'fa fa-cloud', 'fa fa-cloud-download', 'fa fa-cloud-upload', 'fa fa-code', 'fa fa-code-fork', 'fa fa-coffee', 'fa fa-cog', 'fa fa-cogs', 'fa fa-comment', 'fa fa-comment-o', 'fa fa-commenting', 'fa fa-commenting-o', 'fa fa-comments', 'fa fa-comments-o', 'fa fa-compass', 'fa fa-copyright', 'fa fa-creative-commons', 'fa fa-credit-card', 'fa fa-credit-card-alt', 'fa fa-crop', 'fa fa-crosshairs', 'fa fa-cube', 'fa fa-cubes', 'fa fa-cutlery', 'fa fa-dashboard', 'fa fa-database', 'fa fa-deaf', 'fa fa-deafness', 'fa fa-desktop', 'fa fa-diamond', 'fa fa-dot-circle-o', 'fa fa-download', 'fa fa-drivers-license', 'fa fa-drivers-license-o', 'fa fa-edit', 'fa fa-ellipsis-h', 'fa fa-ellipsis-v', 'fa fa-envelope', 'fa fa-envelope-o', 'fa fa-envelope-open', 'fa fa-envelope-open-o', 'fa fa-envelope-square', 'fa fa-eraser', 'fa fa-exchange', 'fa fa-exclamation', 'fa fa-exclamation-circle', 'fa fa-exclamation-triangle', 'fa fa-external-link', 'fa fa-external-link-square', 'fa fa-eye', 'fa fa-eye-slash', 'fa fa-eyedropper', 'fa fa-fax', 'fa fa-feed', 'fa fa-female', 'fa fa-fighter-jet', 'fa fa-file-archive-o', 'fa fa-file-audio-o', 'fa fa-file-code-o', 'fa fa-file-excel-o', 'fa fa-file-image-o', 'fa fa-file-movie-o', 'fa fa-file-pdf-o', 'fa fa-file-photo-o', 'fa fa-file-picture-o', 'fa fa-file-powerpoint-o', 'fa fa-file-sound-o', 'fa fa-file-video-o', 'fa fa-file-word-o', 'fa fa-file-zip-o', 'fa fa-film', 'fa fa-filter', 'fa fa-fire', 'fa fa-fire-extinguisher', 'fa fa-flag', 'fa fa-flag-checkered', 'fa fa-flag-o', 'fa fa-flash', 'fa fa-flask', 'fa fa-folder', 'fa fa-folder-o', 'fa fa-folder-open', 'fa fa-folder-open-o', 'fa fa-frown-o', 'fa fa-futbol-o', 'fa fa-gamepad', 'fa fa-gavel', 'fa fa-gear', 'fa fa-gears', 'fa fa-gift', 'fa fa-glass', 'fa fa-globe', 'fa fa-graduation-cap', 'fa fa-group', 'fa fa-hand-grab-o', 'fa fa-hand-lizard-o', 'fa fa-hand-paper-o', 'fa fa-hand-peace-o', 'fa fa-hand-pointer-o', 'fa fa-hand-rock-o', 'fa fa-hand-scissors-o', 'fa fa-hand-spock-o', 'fa fa-hand-stop-o', 'fa fa-handshake-o', 'fa fa-hard-of-hearing', 'fa fa-hashtag', 'fa fa-hdd-o', 'fa fa-headphones', 'fa fa-heart', 'fa fa-heart-o', 'fa fa-heartbeat', 'fa fa-history', 'fa fa-home', 'fa fa-hotel', 'fa fa-hourglass', 'fa fa-hourglass-1', 'fa fa-hourglass-2', 'fa fa-hourglass-3', 'fa fa-hourglass-end', 'fa fa-hourglass-half', 'fa fa-hourglass-o', 'fa fa-hourglass-start', 'fa fa-i-cursor', 'fa fa-id-badge', 'fa fa-id-card', 'fa fa-id-card-o', 'fa fa-image', 'fa fa-inbox', 'fa fa-industry', 'fa fa-info', 'fa fa-info-circle', 'fa fa-institution', 'fa fa-key', 'fa fa-keyboard-o', 'fa fa-language', 'fa fa-laptop', 'fa fa-leaf', 'fa fa-legal', 'fa fa-lemon-o', 'fa fa-level-down', 'fa fa-level-up', 'fa fa-life-bouy', 'fa fa-life-buoy', 'fa fa-life-ring', 'fa fa-life-saver', 'fa fa-lightbulb-o', 'fa fa-line-chart', 'fa fa-location-arrow', 'fa fa-lock', 'fa fa-low-vision', 'fa fa-magic', 'fa fa-magnet', 'fa fa-mail-forward', 'fa fa-mail-reply', 'fa fa-mail-reply-all', 'fa fa-male', 'fa fa-map', 'fa fa-map-marker', 'fa fa-map-o', 'fa fa-map-pin', 'fa fa-map-signs', 'fa fa-meh-o', 'fa fa-microchip', 'fa fa-microphone', 'fa fa-microphone-slash', 'fa fa-minus', 'fa fa-minus-circle', 'fa fa-minus-square', 'fa fa-minus-square-o', 'fa fa-mobile', 'fa fa-mobile-phone', 'fa fa-money', 'fa fa-moon-o', 'fa fa-mortar-board', 'fa fa-motorcycle', 'fa fa-mouse-pointer', 'fa fa-music', 'fa fa-navicon', 'fa fa-newspaper-o', 'fa fa-object-group', 'fa fa-object-ungroup', 'fa fa-paint-brush', 'fa fa-paper-plane', 'fa fa-paper-plane-o', 'fa fa-paw', 'fa fa-pencil', 'fa fa-pencil-square', 'fa fa-pencil-square-o', 'fa fa-percent', 'fa fa-phone', 'fa fa-phone-square', 'fa fa-photo', 'fa fa-picture-o', 'fa fa-pie-chart', 'fa fa-plane', 'fa fa-plug', 'fa fa-plus', 'fa fa-plus-circle', 'fa fa-plus-square', 'fa fa-plus-square-o', 'fa fa-podcast', 'fa fa-power-off', 'fa fa-print', 'fa fa-puzzle-piece', 'fa fa-qrcode', 'fa fa-question', 'fa fa-question-circle', 'fa fa-question-circle-o', 'fa fa-quote-left', 'fa fa-quote-right', 'fa fa-random', 'fa fa-recycle', 'fa fa-refresh', 'fa fa-registered', 'fa fa-remove', 'fa fa-reorder', 'fa fa-reply', 'fa fa-reply-all', 'fa fa-retweet', 'fa fa-road', 'fa fa-rocket', 'fa fa-rss', 'fa fa-rss-square', 'fa fa-s15', 'fa fa-search', 'fa fa-search-minus', 'fa fa-search-plus', 'fa fa-send', 'fa fa-send-o', 'fa fa-server', 'fa fa-share', 'fa fa-share-alt', 'fa fa-share-alt-square', 'fa fa-share-square', 'fa fa-share-square-o', 'fa fa-shield', 'fa fa-ship', 'fa fa-shopping-bag', 'fa fa-shopping-basket', 'fa fa-shopping-cart', 'fa fa-shower', 'fa fa-sign-in', 'fa fa-sign-language', 'fa fa-sign-out', 'fa fa-signal', 'fa fa-signing', 'fa fa-sitemap', 'fa fa-sliders', 'fa fa-smile-o', 'fa fa-snowflake-o', 'fa fa-soccer-ball-o', 'fa fa-sort', 'fa fa-sort-alpha-asc', 'fa fa-sort-alpha-desc', 'fa fa-sort-amount-asc', 'fa fa-sort-amount-desc', 'fa fa-sort-asc', 'fa fa-sort-desc', 'fa fa-sort-down', 'fa fa-sort-numeric-asc', 'fa fa-sort-numeric-desc', 'fa fa-sort-up', 'fa fa-space-shuttle', 'fa fa-spinner', 'fa fa-spoon', 'fa fa-square', 'fa fa-square-o', 'fa fa-star', 'fa fa-star-half', 'fa fa-star-half-empty', 'fa fa-star-half-full', 'fa fa-star-half-o', 'fa fa-star-o', 'fa fa-sticky-note', 'fa fa-sticky-note-o', 'fa fa-street-view', 'fa fa-suitcase', 'fa fa-sun-o', 'fa fa-support', 'fa fa-tablet', 'fa fa-tachometer', 'fa fa-tag', 'fa fa-tags', 'fa fa-tasks', 'fa fa-taxi', 'fa fa-television', 'fa fa-terminal', 'fa fa-thermometer', 'fa fa-thermometer-0', 'fa fa-thermometer-1', 'fa fa-thermometer-2', 'fa fa-thermometer-3', 'fa fa-thermometer-4', 'fa fa-thermometer-empty', 'fa fa-thermometer-full', 'fa fa-thermometer-half', 'fa fa-thermometer-quarter', 'fa fa-thermometer-three-quarters', 'fa fa-thumb-tack', 'fa fa-thumbs-down', 'fa fa-thumbs-o-down', 'fa fa-thumbs-o-up', 'fa fa-thumbs-up', 'fa fa-ticket', 'fa fa-times', 'fa fa-times-circle', 'fa fa-times-circle-o', 'fa fa-times-rectangle', 'fa fa-times-rectangle-o', 'fa fa-tint', 'fa fa-toggle-down', 'fa fa-toggle-left', 'fa fa-toggle-off', 'fa fa-toggle-on', 'fa fa-toggle-right', 'fa fa-toggle-up', 'fa fa-trademark', 'fa fa-trash', 'fa fa-trash-o', 'fa fa-tree', 'fa fa-trophy', 'fa fa-truck', 'fa fa-tty', 'fa fa-tv', 'fa fa-umbrella', 'fa fa-universal-access', 'fa fa-university', 'fa fa-unlock', 'fa fa-unlock-alt', 'fa fa-unsorted', 'fa fa-upload', 'fa fa-user', 'fa fa-user-circle', 'fa fa-user-circle-o', 'fa fa-user-o', 'fa fa-user-plus', 'fa fa-user-secret', 'fa fa-user-times', 'fa fa-users', 'fa fa-vcard', 'fa fa-vcard-o', 'fa fa-video-camera', 'fa fa-volume-control-phone', 'fa fa-volume-down', 'fa fa-volume-off', 'fa fa-volume-up', 'fa fa-warning', 'fa fa-wheelchair', 'fa fa-wheelchair-alt', 'fa fa-wifi', 'fa fa-window-close', 'fa fa-window-close-o', 'fa fa-window-maximize', 'fa fa-window-minimize', 'fa fa-window-restore', 'fa fa-wrench', 'fa fa-american-sign-language-interpreting', 'fa fa-asl-interpreting', 'fa fa-assistive-listening-systems', 'fa fa-audio-description', 'fa fa-blind', 'fa fa-braille', 'fa fa-cc', 'fa fa-deaf', 'fa fa-deafness', 'fa fa-hard-of-hearing', 'fa fa-low-vision', 'fa fa-question-circle-o', 'fa fa-sign-language', 'fa fa-signing', 'fa fa-tty', 'fa fa-universal-access', 'fa fa-volume-control-phone', 'fa fa-wheelchair', 'fa fa-wheelchair-alt', 'fa fa-hand-grab-o', 'fa fa-hand-lizard-o', 'fa fa-hand-o-down', 'fa fa-hand-o-left', 'fa fa-hand-o-right', 'fa fa-hand-o-up', 'fa fa-hand-paper-o', 'fa fa-hand-peace-o', 'fa fa-hand-pointer-o', 'fa fa-hand-rock-o', 'fa fa-hand-scissors-o', 'fa fa-hand-spock-o', 'fa fa-hand-stop-o', 'fa fa-thumbs-down', 'fa fa-thumbs-o-down', 'fa fa-thumbs-o-up', 'fa fa-thumbs-up', 'fa fa-ambulance', 'fa fa-automobile', 'fa fa-bicycle', 'fa fa-bus', 'fa fa-cab', 'fa fa-car', 'fa fa-fighter-jet', 'fa fa-motorcycle', 'fa fa-plane', 'fa fa-rocket', 'fa fa-ship', 'fa fa-space-shuttle', 'fa fa-subway', 'fa fa-taxi', 'fa fa-train', 'fa fa-truck', 'fa fa-wheelchair', 'fa fa-wheelchair-alt', 'fa fa-genderless', 'fa fa-intersex', 'fa fa-mars', 'fa fa-mars-double', 'fa fa-mars-stroke', 'fa fa-mars-stroke-h', 'fa fa-mars-stroke-v', 'fa fa-mercury', 'fa fa-neuter', 'fa fa-transgender', 'fa fa-transgender-alt', 'fa fa-venus', 'fa fa-venus-double', 'fa fa-venus-mars', 'fa fa-file', 'fa fa-file-archive-o', 'fa fa-file-audio-o', 'fa fa-file-code-o', 'fa fa-file-excel-o', 'fa fa-file-image-o', 'fa fa-file-movie-o', 'fa fa-file-o', 'fa fa-file-pdf-o', 'fa fa-file-photo-o', 'fa fa-file-picture-o', 'fa fa-file-powerpoint-o', 'fa fa-file-sound-o', 'fa fa-file-text', 'fa fa-file-text-o', 'fa fa-file-video-o', 'fa fa-file-word-o', 'fa fa-file-zip-o', 'fa fa-circle-o-notch', 'fa fa-cog', 'fa fa-gear', 'fa fa-refresh', 'fa fa-spinner', 'fa fa-check-square', 'fa fa-check-square-o', 'fa fa-circle', 'fa fa-circle-o', 'fa fa-dot-circle-o', 'fa fa-minus-square', 'fa fa-minus-square-o', 'fa fa-plus-square', 'fa fa-plus-square-o', 'fa fa-square', 'fa fa-square-o', 'fa fa-cc-amex', 'fa fa-cc-diners-club', 'fa fa-cc-discover', 'fa fa-cc-jcb', 'fa fa-cc-mastercard', 'fa fa-cc-paypal', 'fa fa-cc-stripe', 'fa fa-cc-visa', 'fa fa-credit-card', 'fa fa-credit-card-alt', 'fa fa-google-wallet', 'fa fa-paypal', 'fa fa-area-chart', 'fa fa-bar-chart', 'fa fa-bar-chart-o', 'fa fa-line-chart', 'fa fa-pie-chart', 'fa fa-bitcoin', 'fa fa-btc', 'fa fa-cny', 'fa fa-dollar', 'fa fa-eur', 'fa fa-euro', 'fa fa-gbp', 'fa fa-gg', 'fa fa-gg-circle', 'fa fa-ils', 'fa fa-inr', 'fa fa-jpy', 'fa fa-krw', 'fa fa-money', 'fa fa-rmb', 'fa fa-rouble', 'fa fa-rub', 'fa fa-ruble', 'fa fa-rupee', 'fa fa-shekel', 'fa fa-sheqel', 'fa fa-try', 'fa fa-turkish-lira', 'fa fa-usd', 'fa fa-won', 'fa fa-yen', 'fa fa-align-center', 'fa fa-align-justify', 'fa fa-align-left', 'fa fa-align-right', 'fa fa-bold', 'fa fa-chain', 'fa fa-chain-broken', 'fa fa-clipboard', 'fa fa-columns', 'fa fa-copy', 'fa fa-cut', 'fa fa-dedent', 'fa fa-eraser', 'fa fa-file', 'fa fa-file-o', 'fa fa-file-text', 'fa fa-file-text-o', 'fa fa-files-o', 'fa fa-floppy-o', 'fa fa-font', 'fa fa-header', 'fa fa-indent', 'fa fa-italic', 'fa fa-link', 'fa fa-list', 'fa fa-list-alt', 'fa fa-list-ol', 'fa fa-list-ul', 'fa fa-outdent', 'fa fa-paperclip', 'fa fa-paragraph', 'fa fa-paste', 'fa fa-repeat', 'fa fa-rotate-left', 'fa fa-rotate-right', 'fa fa-save', 'fa fa-scissors', 'fa fa-strikethrough', 'fa fa-subscript', 'fa fa-superscript', 'fa fa-table', 'fa fa-text-height', 'fa fa-text-width', 'fa fa-th', 'fa fa-th-large', 'fa fa-th-list', 'fa fa-underline', 'fa fa-undo', 'fa fa-unlink', 'fa fa-angle-double-down', 'fa fa-angle-double-left', 'fa fa-angle-double-right', 'fa fa-angle-double-up', 'fa fa-angle-down', 'fa fa-angle-left', 'fa fa-angle-right', 'fa fa-angle-up', 'fa fa-arrow-circle-down', 'fa fa-arrow-circle-left', 'fa fa-arrow-circle-o-down', 'fa fa-arrow-circle-o-left', 'fa fa-arrow-circle-o-right', 'fa fa-arrow-circle-o-up', 'fa fa-arrow-circle-right', 'fa fa-arrow-circle-up', 'fa fa-arrow-down', 'fa fa-arrow-left', 'fa fa-arrow-right', 'fa fa-arrow-up', 'fa fa-arrows', 'fa fa-arrows-alt', 'fa fa-arrows-h', 'fa fa-arrows-v', 'fa fa-caret-down', 'fa fa-caret-left', 'fa fa-caret-right', 'fa fa-caret-square-o-down', 'fa fa-caret-square-o-left', 'fa fa-caret-square-o-right', 'fa fa-caret-square-o-up', 'fa fa-caret-up', 'fa fa-chevron-circle-down', 'fa fa-chevron-circle-left', 'fa fa-chevron-circle-right', 'fa fa-chevron-circle-up', 'fa fa-chevron-down', 'fa fa-chevron-left', 'fa fa-chevron-right', 'fa fa-chevron-up', 'fa fa-exchange', 'fa fa-hand-o-down', 'fa fa-hand-o-left', 'fa fa-hand-o-right', 'fa fa-hand-o-up', 'fa fa-long-arrow-down', 'fa fa-long-arrow-left', 'fa fa-long-arrow-right', 'fa fa-long-arrow-up', 'fa fa-toggle-down', 'fa fa-toggle-left', 'fa fa-toggle-right', 'fa fa-toggle-up', 'fa fa-arrows-alt', 'fa fa-backward', 'fa fa-compress', 'fa fa-eject', 'fa fa-expand', 'fa fa-fast-backward', 'fa fa-fast-forward', 'fa fa-forward', 'fa fa-pause', 'fa fa-pause-circle', 'fa fa-pause-circle-o', 'fa fa-play', 'fa fa-play-circle', 'fa fa-play-circle-o', 'fa fa-random', 'fa fa-step-backward', 'fa fa-step-forward', 'fa fa-stop', 'fa fa-stop-circle', 'fa fa-stop-circle-o', 'fa fa-youtube-play', 'fa fa-500px', 'fa fa-adn', 'fa fa-amazon', 'fa fa-android', 'fa fa-angellist', 'fa fa-apple', 'fa fa-bandcamp', 'fa fa-behance', 'fa fa-behance-square', 'fa fa-bitbucket', 'fa fa-bitbucket-square', 'fa fa-bitcoin', 'fa fa-black-tie', 'fa fa-bluetooth', 'fa fa-bluetooth-b', 'fa fa-btc', 'fa fa-buysellads', 'fa fa-cc-amex', 'fa fa-cc-diners-club', 'fa fa-cc-discover', 'fa fa-cc-jcb', 'fa fa-cc-mastercard', 'fa fa-cc-paypal', 'fa fa-cc-stripe', 'fa fa-cc-visa', 'fa fa-chrome', 'fa fa-codepen', 'fa fa-codiepie', 'fa fa-connectdevelop', 'fa fa-contao', 'fa fa-css3', 'fa fa-dashcube', 'fa fa-delicious', 'fa fa-deviantart', 'fa fa-digg', 'fa fa-dribbble', 'fa fa-dropbox', 'fa fa-drupal', 'fa fa-edge', 'fa fa-eercast', 'fa fa-empire', 'fa fa-envira', 'fa fa-etsy', 'fa fa-expeditedssl', 'fa fa-fa', 'fa fa-facebook', 'fa fa-facebook-f', 'fa fa-facebook-official', 'fa fa-facebook-square', 'fa fa-firefox', 'fa fa-first-order', 'fa fa-flickr', 'fa fa-font-awesome', 'fa fa-fonticons', 'fa fa-fort-awesome', 'fa fa-forumbee', 'fa fa-foursquare', 'fa fa-free-code-camp', 'fa fa-ge', 'fa fa-get-pocket', 'fa fa-gg', 'fa fa-gg-circle', 'fa fa-git', 'fa fa-git-square', 'fa fa-github', 'fa fa-github-alt', 'fa fa-github-square', 'fa fa-gitlab', 'fa fa-gittip', 'fa fa-glide', 'fa fa-glide-g', 'fa fa-google', 'fa fa-google-plus', 'fa fa-google-plus-circle', 'fa fa-google-plus-official', 'fa fa-google-plus-square', 'fa fa-google-wallet', 'fa fa-gratipay', 'fa fa-grav', 'fa fa-hacker-news', 'fa fa-houzz', 'fa fa-html5', 'fa fa-imdb', 'fa fa-instagram', 'fa fa-internet-explorer', 'fa fa-ioxhost', 'fa fa-joomla', 'fa fa-jsfiddle', 'fa fa-lastfm', 'fa fa-lastfm-square', 'fa fa-leanpub', 'fa fa-linkedin', 'fa fa-linkedin-square', 'fa fa-linode', 'fa fa-linux', 'fa fa-maxcdn', 'fa fa-meanpath', 'fa fa-medium', 'fa fa-meetup', 'fa fa-mixcloud', 'fa fa-modx', 'fa fa-odnoklassniki', 'fa fa-odnoklassniki-square', 'fa fa-opencart', 'fa fa-openid', 'fa fa-opera', 'fa fa-optin-monster', 'fa fa-pagelines', 'fa fa-paypal', 'fa fa-pied-piper', 'fa fa-pied-piper-alt', 'fa fa-pied-piper-pp', 'fa fa-pinterest', 'fa fa-pinterest-p', 'fa fa-pinterest-square', 'fa fa-product-hunt', 'fa fa-qq', 'fa fa-quora', 'fa fa-ra', 'fa fa-ravelry', 'fa fa-rebel', 'fa fa-reddit', 'fa fa-reddit-alien', 'fa fa-reddit-square', 'fa fa-renren', 'fa fa-resistance', 'fa fa-safari', 'fa fa-scribd', 'fa fa-sellsy', 'fa fa-share-alt', 'fa fa-share-alt-square', 'fa fa-shirtsinbulk', 'fa fa-simplybuilt', 'fa fa-skyatlas', 'fa fa-skype', 'fa fa-slack', 'fa fa-slideshare', 'fa fa-snapchat', 'fa fa-snapchat-ghost', 'fa fa-snapchat-square', 'fa fa-soundcloud', 'fa fa-spotify', 'fa fa-stack-exchange', 'fa fa-stack-overflow', 'fa fa-steam', 'fa fa-steam-square', 'fa fa-stumbleupon', 'fa fa-stumbleupon-circle', 'fa fa-superpowers', 'fa fa-telegram', 'fa fa-tencent-weibo', 'fa fa-themeisle', 'fa fa-trello', 'fa fa-tripadvisor', 'fa fa-tumblr', 'fa fa-tumblr-square', 'fa fa-twitch', 'fa fa-twitter', 'fa fa-twitter-square', 'fa fa-usb', 'fa fa-viacoin', 'fa fa-viadeo', 'fa fa-viadeo-square', 'fa fa-vimeo', 'fa fa-vimeo-square', 'fa fa-vine', 'fa fa-vk', 'fa fa-wechat', 'fa fa-weibo', 'fa fa-weixin', 'fa fa-whatsapp', 'fa fa-wikipedia-w', 'fa fa-windows', 'fa fa-wordpress', 'fa fa-wpbeginner', 'fa fa-wpexplorer', 'fa fa-wpforms', 'fa fa-xing', 'fa fa-xing-square', 'fa fa-y-combinator', 'fa fa-y-combinator-square', 'fa fa-yahoo', 'fa fa-yc', 'fa fa-yc-square', 'fa fa-yelp', 'fa fa-yoast', 'fa fa-youtube', 'fa fa-youtube-play', 'fa fa-youtube-square');
				case 'fa6':
					return array('fa6b fa6-facebook', 'fa6b fa6-twitter', 'fa6b fa6-instagram', 'fa6b fa6-tiktok', 'fa6b fa6-linkedin', 'fa6b fa6-github', 'fa6b fa6-discord', 'fa6b fa6-youtube', 'fa6b fa6-wordpress', 'fa6b fa6-slack', 'fa6b fa6-figma', 'fa6b fa6-apple', 'fa6b fa6-google', 'fa6b fa6-stripe', 'fa6b fa6-algolia', 'fa6b fa6-docker', 'fa6b fa6-windows', 'fa6b fa6-paypal', 'fa6b fa6-stack-overflow', 'fa6b fa6-kickstarter', 'fa6b fa6-dribbble', 'fa6b fa6-dropbox', 'fa6b fa6-squarespace', 'fa6b fa6-android', 'fa6b fa6-shopify', 'fa6b fa6-medium', 'fa6b fa6-codepen', 'fa6b fa6-cloudflare', 'fa6b fa6-airbnb', 'fa6b fa6-vimeo', 'fa6b fa6-whatsapp', 'fa6b fa6-intercom', 'fa6b fa6-usps', 'fa6b fa6-wix', 'fa6b fa6-line', 'fa6b fa6-behance', 'fa6b fa6-openid', 'fa6b fa6-product-hunt', 'fa6b fa6-internet-explorer', 'fa6b fa6-pagelines', 'fa6b fa6-teamspeak', 'fa6b fa6-html5', 'fa6b fa6-telegram', 'fa6b fa6-pinterest', 'fa6b fa6-dashcube', 'fa6b fa6-ideal', 'fa6b fa6-salesforce', 'fa6b fa6-readme', 'fa6b fa6-free-code-camp', 'fa6b fa6-soundcloud', 'fa6b fa6-square-twitter', 'fa6b fa6-accessible-icon', 'fa6b fa6-cc-visa', 'fa6b fa6-goodreads-g', 'fa6b fa6-google-play', 'fa6b fa6-react', 'fa6b fa6-wikipedia-w', 'fa6b fa6-square-js', 'fa6b fa6-java', 'fa6b fa6-square-pinterest', 'fa6b fa6-python', 'fa6b fa6-skype', 'fa6b fa6-linux', 'fa6b fa6-node', 'fa6b fa6-rebel', 'fa6b fa6-etsy', 'fa6b fa6-discourse', 'fa6b fa6-amazon', 'fa6b fa6-glide-g', 'fa6b fa6-gitlab', 'fa6b fa6-spotify', 'fa6b fa6-think-peaks', 'fa6b fa6-microsoft', 'fa6b fa6-elementor', 'fa6b fa6-pied-piper', 'fa6b fa6-square-youtube', 'fa6b fa6-cc-mastercard', 'fa6b fa6-facebook-messenger', 'fa6b fa6-atlassian', 'fa6b fa6-playstation', 'fa6b fa6-fly', 'fa6b fa6-meetup', 'fa6b fa6-twitch', 'fa6b fa6-waze', 'fa6b fa6-zhihu', 'fa6b fa6-yoast', 'fa6b fa6-yelp', 'fa6b fa6-yarn', 'fa6b fa6-yandex-international', 'fa6b fa6-yandex', 'fa6b fa6-yammer', 'fa6b fa6-yahoo', 'fa6b fa6-y-combinator', 'fa6b fa6-xing', 'fa6b fa6-xbox', 'fa6b fa6-x-twitter', 'fa6b fa6-wpressr', 'fa6b fa6-wpforms', 'fa6b fa6-wpexplorer', 'fa6b fa6-wpbeginner', 'fa6b fa6-wordpress-simple', 'fa6b fa6-wolf-pack-battalion', 'fa6b fa6-wodu', 'fa6b fa6-wizards-of-the-coast', 'fa6b fa6-wirsindhandwerk', 'fa6b fa6-whmcs', 'fa6b fa6-weixin', 'fa6b fa6-weibo', 'fa6b fa6-weebly', 'fa6b fa6-watchman-monitoring', 'fa6b fa6-vuejs', 'fa6b fa6-vnv', 'fa6b fa6-vk', 'fa6b fa6-vine', 'fa6b fa6-vimeo-v', 'fa6b fa6-viber', 'fa6b fa6-viadeo', 'fa6b fa6-viacoin', 'fa6b fa6-vaadin', 'fa6b fa6-ussunnah', 'fa6b fa6-usb', 'fa6b fa6-ups', 'fa6b fa6-untappd', 'fa6b fa6-unsplash', 'fa6b fa6-unity', 'fa6b fa6-uniregistry', 'fa6b fa6-uncharted', 'fa6b fa6-umbraco', 'fa6b fa6-uikit', 'fa6b fa6-ubuntu', 'fa6b fa6-uber', 'fa6b fa6-typo3', 'fa6b fa6-tumblr', 'fa6b fa6-trello', 'fa6b fa6-trade-federation', 'fa6b fa6-threads', 'fa6b fa6-themeisle', 'fa6b fa6-themeco', 'fa6b fa6-the-red-yeti', 'fa6b fa6-tencent-weibo', 'fa6b fa6-symfony', 'fa6b fa6-swift', 'fa6b fa6-suse', 'fa6b fa6-supple', 'fa6b fa6-superpowers', 'fa6b fa6-stumbleupon-circle', 'fa6b fa6-stumbleupon', 'fa6b fa6-studiovinari', 'fa6b fa6-stubber', 'fa6b fa6-stripe-s', 'fa6b fa6-strava', 'fa6b fa6-sticker-mule', 'fa6b fa6-steam-symbol', 'fa6b fa6-steam', 'fa6b fa6-staylinked', 'fa6b fa6-stackpath', 'fa6b fa6-stack-exchange', 'fa6b fa6-square-xing', 'fa6b fa6-square-x-twitter', 'fa6b fa6-square-whatsapp', 'fa6b fa6-square-vimeo', 'fa6b fa6-square-viadeo', 'fa6b fa6-square-tumblr', 'fa6b fa6-square-threads', 'fa6b fa6-square-steam', 'fa6b fa6-square-snapchat', 'fa6b fa6-square-reddit', 'fa6b fa6-square-pied-piper', 'fa6b fa6-square-odnoklassniki', 'fa6b fa6-square-lastfm', 'fa6b fa6-square-instagram', 'fa6b fa6-square-hacker-news', 'fa6b fa6-square-google-plus', 'fa6b fa6-square-gitlab', 'fa6b fa6-square-github', 'fa6b fa6-square-git', 'fa6b fa6-square-font-awesome-stroke', 'fa6b fa6-square-font-awesome', 'fa6b fa6-square-facebook', 'fa6b fa6-square-dribbble', 'fa6b fa6-square-behance', 'fa6b fa6-speaker-deck', 'fa6b fa6-speakap', 'fa6b fa6-space-awesome', 'fa6b fa6-sourcetree', 'fa6b fa6-snapchat', 'fa6b fa6-slideshare', 'fa6b fa6-skyatlas', 'fa6b fa6-sketch', 'fa6b fa6-sitrox', 'fa6b fa6-sith', 'fa6b fa6-sistrix', 'fa6b fa6-simplybuilt', 'fa6b fa6-shopware', 'fa6b fa6-shirtsinbulk', 'fa6b fa6-servicestack', 'fa6b fa6-sellsy', 'fa6b fa6-sellcast', 'fa6b fa6-searchengin', 'fa6b fa6-scribd', 'fa6b fa6-screenpal', 'fa6b fa6-schlix', 'fa6b fa6-sass', 'fa6b fa6-safari', 'fa6b fa6-rust', 'fa6b fa6-rockrms', 'fa6b fa6-rocketchat', 'fa6b fa6-rev', 'fa6b fa6-resolving', 'fa6b fa6-researchgate', 'fa6b fa6-replyd', 'fa6b fa6-renren', 'fa6b fa6-redhat', 'fa6b fa6-reddit-alien', 'fa6b fa6-reddit', 'fa6b fa6-red-river', 'fa6b fa6-reacteurope', 'fa6b fa6-ravelry', 'fa6b fa6-raspberry-pi', 'fa6b fa6-r-project', 'fa6b fa6-quora', 'fa6b fa6-quinscape', 'fa6b fa6-qq', 'fa6b fa6-pushed', 'fa6b fa6-pix', 'fa6b fa6-pinterest-p', 'fa6b fa6-pied-piper-pp', 'fa6b fa6-pied-piper-hat', 'fa6b fa6-pied-piper-alt', 'fa6b fa6-php', 'fa6b fa6-phoenix-squadron', 'fa6b fa6-phoenix-framework', 'fa6b fa6-phabricator', 'fa6b fa6-periscope', 'fa6b fa6-perbyte', 'fa6b fa6-patreon', 'fa6b fa6-palfed', 'fa6b fa6-page4', 'fa6b fa6-padlet', 'fa6b fa6-osi', 'fa6b fa6-orcid', 'fa6b fa6-optin-monster', 'fa6b fa6-opera', 'fa6b fa6-opencart', 'fa6b fa6-old-republic', 'fa6b fa6-odysee', 'fa6b fa6-odnoklassniki', 'fa6b fa6-octopus-deploy', 'fa6b fa6-nutritionix', 'fa6b fa6-ns8', 'fa6b fa6-npm', 'fa6b fa6-node-js', 'fa6b fa6-nimblr', 'fa6b fa6-nfc-symbol', 'fa6b fa6-nfc-directional', 'fa6b fa6-neos', 'fa6b fa6-napster', 'fa6b fa6-monero', 'fa6b fa6-modx', 'fa6b fa6-mizuni', 'fa6b fa6-mixer', 'fa6b fa6-mixcloud', 'fa6b fa6-mix', 'fa6b fa6-microblog', 'fa6b fa6-meta', 'fa6b fa6-mendeley', 'fa6b fa6-megaport', 'fa6b fa6-medrt', 'fa6b fa6-medapps', 'fa6b fa6-mdb', 'fa6b fa6-maxcdn', 'fa6b fa6-mastodon', 'fa6b fa6-markdown', 'fa6b fa6-mandalorian', 'fa6b fa6-mailchimp', 'fa6b fa6-magento', 'fa6b fa6-lyft', 'fa6b fa6-linode', 'fa6b fa6-linkedin-in', 'fa6b fa6-less', 'fa6b fa6-leanpub', 'fa6b fa6-lastfm', 'fa6b fa6-laravel', 'fa6b fa6-korvue', 'fa6b fa6-kickstarter-k', 'fa6b fa6-keycdn', 'fa6b fa6-keybase', 'fa6b fa6-kaggle', 'fa6b fa6-jsfiddle', 'fa6b fa6-js', 'fa6b fa6-joomla', 'fa6b fa6-joget', 'fa6b fa6-jira', 'fa6b fa6-jenkins', 'fa6b fa6-jedi-order', 'fa6b fa6-itunes-note', 'fa6b fa6-itunes', 'fa6b fa6-itch-io', 'fa6b fa6-ioxhost', 'fa6b fa6-invision', 'fa6b fa6-instalod', 'fa6b fa6-imdb', 'fa6b fa6-hubspot', 'fa6b fa6-houzz', 'fa6b fa6-hotjar', 'fa6b fa6-hornbill', 'fa6b fa6-hooli', 'fa6b fa6-hive', 'fa6b fa6-hire-a-helper', 'fa6b fa6-hips', 'fa6b fa6-hashnode', 'fa6b fa6-hackerrank', 'fa6b fa6-hacker-news', 'fa6b fa6-gulp', 'fa6b fa6-guilded', 'fa6b fa6-grunt', 'fa6b fa6-gripfire', 'fa6b fa6-grav', 'fa6b fa6-gratipay', 'fa6b fa6-google-wallet', 'fa6b fa6-google-plus-g', 'fa6b fa6-google-plus', 'fa6b fa6-google-pay', 'fa6b fa6-google-drive', 'fa6b fa6-goodreads', 'fa6b fa6-golang', 'fa6b fa6-gofore', 'fa6b fa6-glide', 'fa6b fa6-gitter', 'fa6b fa6-gitkraken', 'fa6b fa6-github-alt', 'fa6b fa6-git-alt', 'fa6b fa6-git', 'fa6b fa6-gg-circle', 'fa6b fa6-gg', 'fa6b fa6-get-pocket', 'fa6b fa6-galactic-senate', 'fa6b fa6-galactic-republic', 'fa6b fa6-fulcrum', 'fa6b fa6-freebsd', 'fa6b fa6-foursquare', 'fa6b fa6-forumbee', 'fa6b fa6-fort-awesome-alt', 'fa6b fa6-fort-awesome', 'fa6b fa6-fonticons-fi', 'fa6b fa6-fonticons', 'fa6b fa6-font-awesome', 'fa6b fa6-flipboard', 'fa6b fa6-flickr', 'fa6b fa6-firstdraft', 'fa6b fa6-first-order-alt', 'fa6b fa6-first-order', 'fa6b fa6-firefox-browser', 'fa6b fa6-firefox', 'fa6b fa6-fedora', 'fa6b fa6-fedex', 'fa6b fa6-fantasy-flight-games', 'fa6b fa6-facebook-f', 'fa6b fa6-expeditedssl', 'fa6b fa6-evernote', 'fa6b fa6-ethereum', 'fa6b fa6-erlang', 'fa6b fa6-envira', 'fa6b fa6-empire', 'fa6b fa6-ember', 'fa6b fa6-ello', 'fa6b fa6-edge-legacy', 'fa6b fa6-edge', 'fa6b fa6-ebay', 'fa6b fa6-earlybirds', 'fa6b fa6-dyalog', 'fa6b fa6-drupal', 'fa6b fa6-draft2digital', 'fa6b fa6-dochub', 'fa6b fa6-digital-ocean', 'fa6b fa6-digg', 'fa6b fa6-diaspora', 'fa6b fa6-dhl', 'fa6b fa6-deviantart', 'fa6b fa6-dev', 'fa6b fa6-deskpro', 'fa6b fa6-deploydog', 'fa6b fa6-delicious', 'fa6b fa6-deezer', 'fa6b fa6-debian', 'fa6b fa6-dailymotion', 'fa6b fa6-d-and-d-beyond', 'fa6b fa6-d-and-d', 'fa6b fa6-cuttlefish', 'fa6b fa6-css3-alt', 'fa6b fa6-css3', 'fa6b fa6-critical-role', 'fa6b fa6-creative-commons-zero', 'fa6b fa6-creative-commons-share', 'fa6b fa6-creative-commons-sampling-plus', 'fa6b fa6-creative-commons-sampling', 'fa6b fa6-creative-commons-sa', 'fa6b fa6-creative-commons-remix', 'fa6b fa6-creative-commons-pd-alt', 'fa6b fa6-creative-commons-pd', 'fa6b fa6-creative-commons-nd', 'fa6b fa6-creative-commons-nc-jp', 'fa6b fa6-creative-commons-nc-eu', 'fa6b fa6-creative-commons-nc', 'fa6b fa6-creative-commons-by', 'fa6b fa6-creative-commons', 'fa6b fa6-cpanel', 'fa6b fa6-cotton-bureau', 'fa6b fa6-contao', 'fa6b fa6-connectdevelop', 'fa6b fa6-confluence', 'fa6b fa6-codiepie', 'fa6b fa6-cmplid', 'fa6b fa6-cloudversify', 'fa6b fa6-cloudsmith', 'fa6b fa6-cloudscale', 'fa6b fa6-chromecast', 'fa6b fa6-chrome', 'fa6b fa6-centos', 'fa6b fa6-centercode', 'fa6b fa6-cc-stripe', 'fa6b fa6-cc-paypal', 'fa6b fa6-cc-jcb', 'fa6b fa6-cc-discover', 'fa6b fa6-cc-diners-club', 'fa6b fa6-cc-apple-pay', 'fa6b fa6-cc-amex', 'fa6b fa6-cc-amazon-pay', 'fa6b fa6-canadian-maple-leaf', 'fa6b fa6-buysellads', 'fa6b fa6-buy-n-large', 'fa6b fa6-buromobelexperte', 'fa6b fa6-buffer', 'fa6b fa6-btc', 'fa6b fa6-bots', 'fa6b fa6-bootstrap', 'fa6b fa6-bluetooth-b', 'fa6b fa6-bluetooth', 'fa6b fa6-blogger-b', 'fa6b fa6-blogger', 'fa6b fa6-blackberry', 'fa6b fa6-black-tie', 'fa6b fa6-bity', 'fa6b fa6-bitcoin', 'fa6b fa6-bitbucket', 'fa6b fa6-bimobject', 'fa6b fa6-bilibili', 'fa6b fa6-battle-net', 'fa6b fa6-bandcamp', 'fa6b fa6-aws', 'fa6b fa6-aviato', 'fa6b fa6-avianex', 'fa6b fa6-autoprefixer', 'fa6b fa6-audible', 'fa6b fa6-asymmetrik', 'fa6b fa6-artstation', 'fa6b fa6-apple-pay', 'fa6b fa6-apper', 'fa6b fa6-app-store-ios', 'fa6b fa6-app-store', 'fa6b fa6-angular', 'fa6b fa6-angrycreative', 'fa6b fa6-angellist', 'fa6b fa6-amilia', 'fa6b fa6-amazon-pay', 'fa6b fa6-alipay', 'fa6b fa6-affiliatetheme', 'fa6b fa6-adversal', 'fa6b fa6-adn', 'fa6b fa6-accusoft', 'fa6b fa6-500px', 'fa6b fa6-42-group', 'fa6r fa6-user', 'fa6r fa6-image', 'fa6r fa6-envelope', 'fa6r fa6-star', 'fa6r fa6-heart', 'fa6r fa6-circle-xmark', 'fa6r fa6-comment', 'fa6r fa6-face-smile', 'fa6r fa6-calendar-days', 'fa6r fa6-file', 'fa6r fa6-bell', 'fa6r fa6-clipboard', 'fa6r fa6-circle-user', 'fa6r fa6-circle-up', 'fa6r fa6-circle-down', 'fa6r fa6-bookmark', 'fa6r fa6-pen-to-square', 'fa6r fa6-share-from-square', 'fa6r fa6-eye', 'fa6r fa6-eye-slash', 'fa6r fa6-hand', 'fa6r fa6-folder', 'fa6r fa6-folder-open', 'fa6r fa6-thumbs-up', 'fa6r fa6-thumbs-down', 'fa6r fa6-comments', 'fa6r fa6-lemon', 'fa6r fa6-paper-plane', 'fa6r fa6-compass', 'fa6r fa6-address-book', 'fa6r fa6-handshake', 'fa6r fa6-snowflake', 'fa6r fa6-sun', 'fa6r fa6-calendar', 'fa6r fa6-clock', 'fa6r fa6-circle', 'fa6r fa6-credit-card', 'fa6r fa6-copy', 'fa6r fa6-square', 'fa6r fa6-newspaper', 'fa6r fa6-building', 'fa6r fa6-flag', 'fa6r fa6-file-excel', 'fa6r fa6-hand-point-up', 'fa6r fa6-address-card', 'fa6r fa6-registered', 'fa6r fa6-moon', 'fa6r fa6-file-word', 'fa6r fa6-closed-captioning', 'fa6r fa6-file-pdf', 'fa6r fa6-hospital', 'fa6r fa6-square-check', 'fa6r fa6-copyright', 'fa6r fa6-circle-check', 'fa6r fa6-square-minus', 'fa6r fa6-lightbulb', 'fa6r fa6-keyboard', 'fa6r fa6-clone', 'fa6r fa6-images', 'fa6r fa6-window-restore', 'fa6r fa6-window-minimize', 'fa6r fa6-window-maximize', 'fa6r fa6-trash-can', 'fa6r fa6-star-half-stroke', 'fa6r fa6-star-half', 'fa6r fa6-square-plus', 'fa6r fa6-square-full', 'fa6r fa6-square-caret-up', 'fa6r fa6-square-caret-right', 'fa6r fa6-square-caret-left', 'fa6r fa6-square-caret-down', 'fa6r fa6-rectangle-xmark', 'fa6r fa6-rectangle-list', 'fa6r fa6-paste', 'fa6r fa6-object-ungroup', 'fa6r fa6-object-group', 'fa6r fa6-note-sticky', 'fa6r fa6-money-bill-1', 'fa6r fa6-message', 'fa6r fa6-map', 'fa6r fa6-life-ring', 'fa6r fa6-id-card', 'fa6r fa6-id-badge', 'fa6r fa6-hourglass-half', 'fa6r fa6-hourglass', 'fa6r fa6-hard-drive', 'fa6r fa6-hand-spock', 'fa6r fa6-hand-scissors', 'fa6r fa6-hand-pointer', 'fa6r fa6-hand-point-right', 'fa6r fa6-hand-point-left', 'fa6r fa6-hand-point-down', 'fa6r fa6-hand-peace', 'fa6r fa6-hand-lizard', 'fa6r fa6-hand-back-fist', 'fa6r fa6-gem', 'fa6r fa6-futbol', 'fa6r fa6-font-awesome', 'fa6r fa6-folder-closed', 'fa6r fa6-floppy-disk', 'fa6r fa6-file-zipper', 'fa6r fa6-file-video', 'fa6r fa6-file-powerpoint', 'fa6r fa6-file-lines', 'fa6r fa6-file-image', 'fa6r fa6-file-code', 'fa6r fa6-file-audio', 'fa6r fa6-face-tired', 'fa6r fa6-face-surprise', 'fa6r fa6-face-smile-wink', 'fa6r fa6-face-smile-beam', 'fa6r fa6-face-sad-tear', 'fa6r fa6-face-sad-cry', 'fa6r fa6-face-rolling-eyes', 'fa6r fa6-face-meh-blank', 'fa6r fa6-face-meh', 'fa6r fa6-face-laugh-wink', 'fa6r fa6-face-laugh-squint', 'fa6r fa6-face-laugh-beam', 'fa6r fa6-face-laugh', 'fa6r fa6-face-kiss-wink-heart', 'fa6r fa6-face-kiss-beam', 'fa6r fa6-face-kiss', 'fa6r fa6-face-grin-wink', 'fa6r fa6-face-grin-wide', 'fa6r fa6-face-grin-tongue-wink', 'fa6r fa6-face-grin-tongue-squint', 'fa6r fa6-face-grin-tongue', 'fa6r fa6-face-grin-tears', 'fa6r fa6-face-grin-stars', 'fa6r fa6-face-grin-squint-tears', 'fa6r fa6-face-grin-squint', 'fa6r fa6-face-grin-hearts', 'fa6r fa6-face-grin-beam-sweat', 'fa6r fa6-face-grin-beam', 'fa6r fa6-face-grin', 'fa6r fa6-face-grimace', 'fa6r fa6-face-frown-open', 'fa6r fa6-face-frown', 'fa6r fa6-face-flushed', 'fa6r fa6-face-dizzy', 'fa6r fa6-face-angry', 'fa6r fa6-envelope-open', 'fa6r fa6-comment-dots', 'fa6r fa6-circle-stop', 'fa6r fa6-circle-right', 'fa6r fa6-circle-question', 'fa6r fa6-circle-play', 'fa6r fa6-circle-pause', 'fa6r fa6-circle-left', 'fa6r fa6-circle-dot', 'fa6r fa6-chess-rook', 'fa6r fa6-chess-queen', 'fa6r fa6-chess-pawn', 'fa6r fa6-chess-knight', 'fa6r fa6-chess-king', 'fa6r fa6-chess-bishop', 'fa6r fa6-chart-bar', 'fa6r fa6-calendar-xmark', 'fa6r fa6-calendar-plus', 'fa6r fa6-calendar-minus', 'fa6r fa6-calendar-check', 'fa6r fa6-bell-slash', 'fa6s fa6-house', 'fa6s fa6-magnifying-glass', 'fa6s fa6-user', 'fa6s fa6-check', 'fa6s fa6-download', 'fa6s fa6-image', 'fa6s fa6-phone', 'fa6s fa6-bars', 'fa6s fa6-envelope', 'fa6s fa6-star', 'fa6s fa6-location-dot', 'fa6s fa6-music', 'fa6s fa6-wand-magic-sparkles', 'fa6s fa6-heart', 'fa6s fa6-arrow-right', 'fa6s fa6-circle-xmark', 'fa6s fa6-bomb', 'fa6s fa6-poo', 'fa6s fa6-camera-retro', 'fa6s fa6-xmark', 'fa6s fa6-cloud', 'fa6s fa6-comment', 'fa6s fa6-caret-up', 'fa6s fa6-truck-fast', 'fa6s fa6-pen-nib', 'fa6s fa6-arrow-up', 'fa6s fa6-hippo', 'fa6s fa6-face-smile', 'fa6s fa6-calendar-days', 'fa6s fa6-paperclip', 'fa6s fa6-shield-halved', 'fa6s fa6-file', 'fa6s fa6-bell', 'fa6s fa6-cart-shopping', 'fa6s fa6-clipboard', 'fa6s fa6-filter', 'fa6s fa6-circle-info', 'fa6s fa6-arrow-up-from-bracket', 'fa6s fa6-bolt', 'fa6s fa6-car', 'fa6s fa6-ghost', 'fa6s fa6-mug-hot', 'fa6s fa6-circle-user', 'fa6s fa6-pen', 'fa6s fa6-umbrella', 'fa6s fa6-gift', 'fa6s fa6-film', 'fa6s fa6-list', 'fa6s fa6-gear', 'fa6s fa6-trash', 'fa6s fa6-circle-up', 'fa6s fa6-circle-down', 'fa6s fa6-inbox', 'fa6s fa6-rotate-right', 'fa6s fa6-lock', 'fa6s fa6-headphones', 'fa6s fa6-barcode', 'fa6s fa6-tag', 'fa6s fa6-book', 'fa6s fa6-bookmark', 'fa6s fa6-print', 'fa6s fa6-camera', 'fa6s fa6-font', 'fa6s fa6-video', 'fa6s fa6-circle-half-stroke', 'fa6s fa6-droplet', 'fa6s fa6-pen-to-square', 'fa6s fa6-share-from-square', 'fa6s fa6-plus', 'fa6s fa6-minus', 'fa6s fa6-share', 'fa6s fa6-circle-exclamation', 'fa6s fa6-fire', 'fa6s fa6-eye', 'fa6s fa6-eye-slash', 'fa6s fa6-plane', 'fa6s fa6-magnet', 'fa6s fa6-hand', 'fa6s fa6-folder', 'fa6s fa6-folder-open', 'fa6s fa6-money-bill', 'fa6s fa6-thumbs-up', 'fa6s fa6-thumbs-down', 'fa6s fa6-comments', 'fa6s fa6-lemon', 'fa6s fa6-key', 'fa6s fa6-thumbtack', 'fa6s fa6-gears', 'fa6s fa6-paper-plane', 'fa6s fa6-code', 'fa6s fa6-globe', 'fa6s fa6-truck', 'fa6s fa6-city', 'fa6s fa6-ticket', 'fa6s fa6-tree', 'fa6s fa6-wifi', 'fa6s fa6-paint-roller', 'fa6s fa6-bicycle', 'fa6s fa6-sliders', 'fa6s fa6-brush', 'fa6s fa6-hashtag', 'fa6s fa6-flask', 'fa6s fa6-briefcase', 'fa6s fa6-compass', 'fa6s fa6-dumpster-fire', 'fa6s fa6-person', 'fa6s fa6-person-dress', 'fa6s fa6-address-book', 'fa6s fa6-bath', 'fa6s fa6-handshake', 'fa6s fa6-snowflake', 'fa6s fa6-right-to-bracket', 'fa6s fa6-earth-americas', 'fa6s fa6-cloud-arrow-up', 'fa6s fa6-binoculars', 'fa6s fa6-palette', 'fa6s fa6-layer-group', 'fa6s fa6-users', 'fa6s fa6-gamepad', 'fa6s fa6-business-time', 'fa6s fa6-feather', 'fa6s fa6-sun', 'fa6s fa6-link', 'fa6s fa6-pen-fancy', 'fa6s fa6-fish', 'fa6s fa6-bug', 'fa6s fa6-shop', 'fa6s fa6-mug-saucer', 'fa6s fa6-landmark', 'fa6s fa6-poo-storm', 'fa6s fa6-chart-simple', 'fa6s fa6-shirt', 'fa6s fa6-anchor', 'fa6s fa6-quote-left', 'fa6s fa6-bag-shopping', 'fa6s fa6-gauge', 'fa6s fa6-code-compare', 'fa6s fa6-user-secret', 'fa6s fa6-stethoscope', 'fa6s fa6-car-side', 'fa6s fa6-hand-holding-heart', 'fa6s fa6-truck-front', 'fa6s fa6-cable-car', 'fa6s fa6-mountain-sun', 'fa6s fa6-location-pin', 'fa6s fa6-info', 'fa6s fa6-user-minus', 'fa6s fa6-calendar', 'fa6s fa6-cart-plus', 'fa6s fa6-clock', 'fa6s fa6-circle', 'fa6s fa6-play', 'fa6s fa6-cross', 'fa6s fa6-backward', 'fa6s fa6-handshake-slash', 'fa6s fa6-chevron-up', 'fa6s fa6-passport', 'fa6s fa6-question', 'fa6s fa6-pencil', 'fa6s fa6-phone-volume', 'fa6s fa6-upload', 'fa6s fa6-strikethrough', 'fa6s fa6-credit-card', 'fa6s fa6-street-view', 'fa6s fa6-database', 'fa6s fa6-copy', 'fa6s fa6-mobile', 'fa6s fa6-square', 'fa6s fa6-sort', 'fa6s fa6-forward', 'fa6s fa6-hourglass-start', 'fa6s fa6-newspaper', 'fa6s fa6-notes-medical', 'fa6s fa6-table', 'fa6s fa6-building', 'fa6s fa6-stop', 'fa6s fa6-store', 'fa6s fa6-flag', 'fa6s fa6-file-excel', 'fa6s fa6-network-wired', 'fa6s fa6-cash-register', 'fa6s fa6-file-export', 'fa6s fa6-hand-point-up', 'fa6s fa6-angle-up', 'fa6s fa6-shield', 'fa6s fa6-address-card', 'fa6s fa6-expand', 'fa6s fa6-flag-checkered', 'fa6s fa6-quote-right', 'fa6s fa6-tags', 'fa6s fa6-server', 'fa6s fa6-user-nurse', 'fa6s fa6-video-slash', 'fa6s fa6-arrow-down', 'fa6s fa6-blog', 'fa6s fa6-school', 'fa6s fa6-file-invoice', 'fa6s fa6-rocket', 'fa6s fa6-spinner', 'fa6s fa6-tty', 'fa6s fa6-exclamation', 'fa6s fa6-water', 'fa6s fa6-registered', 'fa6s fa6-signature', 'fa6s fa6-laptop', 'fa6s fa6-restroom', 'fa6s fa6-power-off', 'fa6s fa6-sitemap', 'fa6s fa6-icons', 'fa6s fa6-desktop', 'fa6s fa6-moon', 'fa6s fa6-calendar-week', 'fa6s fa6-pause', 'fa6s fa6-file-word', 'fa6s fa6-vials', 'fa6s fa6-language', 'fa6s fa6-door-open', 'fa6s fa6-brain', 'fa6s fa6-hotel', 'fa6s fa6-marker', 'fa6s fa6-star-of-life', 'fa6s fa6-leaf', 'fa6s fa6-walkie-talkie', 'fa6s fa6-shower', 'fa6s fa6-caret-down', 'fa6s fa6-file-import', 'fa6s fa6-place-of-worship', 'fa6s fa6-wallet', 'fa6s fa6-slash', 'fa6s fa6-award', 'fa6s fa6-toggle-on', 'fa6s fa6-ship', 'fa6s fa6-chalkboard', 'fa6s fa6-hands', 'fa6s fa6-signal', 'fa6s fa6-motorcycle', 'fa6s fa6-arrow-up-right-from-square', 'fa6s fa6-audio-description', 'fa6s fa6-seedling', 'fa6s fa6-closed-captioning', 'fa6s fa6-train', 'fa6s fa6-arrow-left', 'fa6s fa6-wrench', 'fa6s fa6-microchip', 'fa6s fa6-record-vinyl', 'fa6s fa6-trophy', 'fa6s fa6-hammer', 'fa6s fa6-diamond', 'fa6s fa6-robot', 'fa6s fa6-file-pdf', 'fa6s fa6-hospital', 'fa6s fa6-file-contract', 'fa6s fa6-square-xmark', 'fa6s fa6-square-check', 'fa6s fa6-crown', 'fa6s fa6-user-plus', 'fa6s fa6-virus', 'fa6s fa6-child', 'fa6s fa6-repeat', 'fa6s fa6-cube', 'fa6s fa6-copyright', 'fa6s fa6-medal', 'fa6s fa6-bullseye', 'fa6s fa6-mask', 'fa6s fa6-circle-check', 'fa6s fa6-radio', 'fa6s fa6-reply', 'fa6s fa6-chair', 'fa6s fa6-route', 'fa6s fa6-plug', 'fa6s fa6-calculator', 'fa6s fa6-dragon', 'fa6s fa6-certificate', 'fa6s fa6-fingerprint', 'fa6s fa6-road', 'fa6s fa6-crosshairs', 'fa6s fa6-heading', 'fa6s fa6-percent', 'fa6s fa6-user-tie', 'fa6s fa6-square-minus', 'fa6s fa6-i-cursor', 'fa6s fa6-church', 'fa6s fa6-joint', 'fa6s fa6-comments-dollar', 'fa6s fa6-truck-monster', 'fa6s fa6-recycle', 'fa6s fa6-warehouse', 'fa6s fa6-ruler', 'fa6s fa6-soap', 'fa6s fa6-scroll', 'fa6s fa6-coins', 'fa6s fa6-wind', 'fa6s fa6-baby', 'fa6s fa6-lightbulb', 'fa6s fa6-voicemail', 'fa6s fa6-puzzle-piece', 'fa6s fa6-keyboard', 'fa6s fa6-clone', 'fa6s fa6-eraser', 'fa6s fa6-wine-bottle', 'fa6s fa6-dice', 'fa6s fa6-receipt', 'fa6s fa6-ring', 'fa6s fa6-unlock', 'fa6s fa6-solar-panel', 'fa6s fa6-ruler-vertical', 'fa6s fa6-circle-notch', 'fa6s fa6-people-arrows', 'fa6s fa6-dollar-sign', 'fa6s fa6-tablet', 'fa6s fa6-not-equal', 'fa6s fa6-glasses', 'fa6s fa6-headset', 'fa6s fa6-code-branch', 'fa6s fa6-gopuram', 'fa6s fa6-images', 'fa6s fa6-window-restore', 'fa6s fa6-industry', 'fa6s fa6-stamp', 'fa6s fa6-microphone-slash', 'fa6s fa6-cookie-bite', 'fa6s fa6-otter', 'fa6s fa6-chevron-down', 'fa6s fa6-kiwi-bird', 'fa6s fa6-viruses', 'fa6s fa6-umbrella-beach', 'fa6s fa6-subscript', 'fa6s fa6-tablets', 'fa6s fa6-microphone', 'fa6s fa6-border-none', 'fa6s fa6-dumbbell', 'fa6s fa6-plane-departure', 'fa6s fa6-z', 'fa6s fa6-yin-yang', 'fa6s fa6-yen-sign', 'fa6s fa6-y', 'fa6s fa6-xmarks-lines', 'fa6s fa6-x-ray', 'fa6s fa6-x', 'fa6s fa6-worm', 'fa6s fa6-won-sign', 'fa6s fa6-wine-glass-empty', 'fa6s fa6-wine-glass', 'fa6s fa6-window-minimize', 'fa6s fa6-window-maximize', 'fa6s fa6-whiskey-glass', 'fa6s fa6-wheelchair-move', 'fa6s fa6-wheelchair', 'fa6s fa6-wheat-awn-circle-exclamation', 'fa6s fa6-wheat-awn', 'fa6s fa6-weight-scale', 'fa6s fa6-weight-hanging', 'fa6s fa6-wave-square', 'fa6s fa6-water-ladder', 'fa6s fa6-wand-sparkles', 'fa6s fa6-wand-magic', 'fa6s fa6-w', 'fa6s fa6-vr-cardboard', 'fa6s fa6-volume-xmark', 'fa6s fa6-volume-off', 'fa6s fa6-volume-low', 'fa6s fa6-volume-high', 'fa6s fa6-volleyball', 'fa6s fa6-volcano', 'fa6s fa6-virus-slash', 'fa6s fa6-virus-covid-slash', 'fa6s fa6-virus-covid', 'fa6s fa6-vihara', 'fa6s fa6-vial-virus', 'fa6s fa6-vial-circle-check', 'fa6s fa6-vial', 'fa6s fa6-vest-patches', 'fa6s fa6-vest', 'fa6s fa6-venus-mars', 'fa6s fa6-venus-double', 'fa6s fa6-venus', 'fa6s fa6-vector-square', 'fa6s fa6-vault', 'fa6s fa6-van-shuttle', 'fa6s fa6-v', 'fa6s fa6-utensils', 'fa6s fa6-users-viewfinder', 'fa6s fa6-users-slash', 'fa6s fa6-users-rectangle', 'fa6s fa6-users-rays', 'fa6s fa6-users-line', 'fa6s fa6-users-gear', 'fa6s fa6-users-between-lines', 'fa6s fa6-user-xmark', 'fa6s fa6-user-tag', 'fa6s fa6-user-slash', 'fa6s fa6-user-shield', 'fa6s fa6-user-pen', 'fa6s fa6-user-ninja', 'fa6s fa6-user-lock', 'fa6s fa6-user-large-slash', 'fa6s fa6-user-large', 'fa6s fa6-user-injured', 'fa6s fa6-user-group', 'fa6s fa6-user-graduate', 'fa6s fa6-user-gear', 'fa6s fa6-user-doctor', 'fa6s fa6-user-clock', 'fa6s fa6-user-check', 'fa6s fa6-user-astronaut', 'fa6s fa6-up-right-from-square', 'fa6s fa6-up-right-and-down-left-from-center', 'fa6s fa6-up-long', 'fa6s fa6-up-down-left-right', 'fa6s fa6-up-down', 'fa6s fa6-unlock-keyhole', 'fa6s fa6-universal-access', 'fa6s fa6-underline', 'fa6s fa6-u', 'fa6s fa6-tv', 'fa6s fa6-turn-up', 'fa6s fa6-turn-down', 'fa6s fa6-turkish-lira-sign', 'fa6s fa6-truck-ramp-box', 'fa6s fa6-truck-plane', 'fa6s fa6-truck-pickup', 'fa6s fa6-truck-moving', 'fa6s fa6-truck-medical', 'fa6s fa6-truck-field-un', 'fa6s fa6-truck-field', 'fa6s fa6-truck-droplet', 'fa6s fa6-truck-arrow-right', 'fa6s fa6-trowel-bricks', 'fa6s fa6-trowel', 'fa6s fa6-triangle-exclamation', 'fa6s fa6-tree-city', 'fa6s fa6-trash-can-arrow-up', 'fa6s fa6-trash-can', 'fa6s fa6-trash-arrow-up', 'fa6s fa6-transgender', 'fa6s fa6-train-tram', 'fa6s fa6-train-subway', 'fa6s fa6-trailer', 'fa6s fa6-traffic-light', 'fa6s fa6-trademark', 'fa6s fa6-tractor', 'fa6s fa6-tower-observation', 'fa6s fa6-tower-cell', 'fa6s fa6-tower-broadcast', 'fa6s fa6-tornado', 'fa6s fa6-torii-gate', 'fa6s fa6-tooth', 'fa6s fa6-toolbox', 'fa6s fa6-toilets-portable', 'fa6s fa6-toilet-portable', 'fa6s fa6-toilet-paper-slash', 'fa6s fa6-toilet-paper', 'fa6s fa6-toilet', 'fa6s fa6-toggle-off', 'fa6s fa6-timeline', 'fa6s fa6-ticket-simple', 'fa6s fa6-thermometer', 'fa6s fa6-text-width', 'fa6s fa6-text-slash', 'fa6s fa6-text-height', 'fa6s fa6-terminal', 'fa6s fa6-tents', 'fa6s fa6-tent-arrows-down', 'fa6s fa6-tent-arrow-turn-left', 'fa6s fa6-tent-arrow-left-right', 'fa6s fa6-tent-arrow-down-to-line', 'fa6s fa6-tent', 'fa6s fa6-tenge-sign', 'fa6s fa6-temperature-three-quarters', 'fa6s fa6-temperature-quarter', 'fa6s fa6-temperature-low', 'fa6s fa6-temperature-high', 'fa6s fa6-temperature-half', 'fa6s fa6-temperature-full', 'fa6s fa6-temperature-empty', 'fa6s fa6-temperature-arrow-up', 'fa6s fa6-temperature-arrow-down', 'fa6s fa6-teeth-open', 'fa6s fa6-teeth', 'fa6s fa6-taxi', 'fa6s fa6-tarp-droplet', 'fa6s fa6-tarp', 'fa6s fa6-tape', 'fa6s fa6-tachograph-digital', 'fa6s fa6-tablet-screen-button', 'fa6s fa6-tablet-button', 'fa6s fa6-table-tennis-paddle-ball', 'fa6s fa6-table-list', 'fa6s fa6-table-columns', 'fa6s fa6-table-cells-large', 'fa6s fa6-table-cells', 'fa6s fa6-t', 'fa6s fa6-syringe', 'fa6s fa6-synagogue', 'fa6s fa6-swatchbook', 'fa6s fa6-superscript', 'fa6s fa6-sun-plant-wilt', 'fa6s fa6-suitcase-rolling', 'fa6s fa6-suitcase-medical', 'fa6s fa6-suitcase', 'fa6s fa6-stroopwafel', 'fa6s fa6-store-slash', 'fa6s fa6-stopwatch-20', 'fa6s fa6-stopwatch', 'fa6s fa6-sterling-sign', 'fa6s fa6-star-of-david', 'fa6s fa6-star-half-stroke', 'fa6s fa6-star-half', 'fa6s fa6-star-and-crescent', 'fa6s fa6-stapler', 'fa6s fa6-stairs', 'fa6s fa6-staff-snake', 'fa6s fa6-square-virus', 'fa6s fa6-square-up-right', 'fa6s fa6-square-share-nodes', 'fa6s fa6-square-rss', 'fa6s fa6-square-root-variable', 'fa6s fa6-square-poll-vertical', 'fa6s fa6-square-poll-horizontal', 'fa6s fa6-square-plus', 'fa6s fa6-square-phone-flip', 'fa6s fa6-square-phone', 'fa6s fa6-square-person-confined', 'fa6s fa6-square-pen', 'fa6s fa6-square-parking', 'fa6s fa6-square-nfi', 'fa6s fa6-square-h', 'fa6s fa6-square-full', 'fa6s fa6-square-envelope', 'fa6s fa6-square-caret-up', 'fa6s fa6-square-caret-right', 'fa6s fa6-square-caret-left', 'fa6s fa6-square-caret-down', 'fa6s fa6-square-arrow-up-right', 'fa6s fa6-spray-can-sparkles', 'fa6s fa6-spray-can', 'fa6s fa6-spoon', 'fa6s fa6-splotch', 'fa6s fa6-spider', 'fa6s fa6-spell-check', 'fa6s fa6-spaghetti-monster-flying', 'fa6s fa6-spa', 'fa6s fa6-sort-up', 'fa6s fa6-sort-down', 'fa6s fa6-socks', 'fa6s fa6-snowplow', 'fa6s fa6-snowman', 'fa6s fa6-smoking', 'fa6s fa6-smog', 'fa6s fa6-sleigh', 'fa6s fa6-skull-crossbones', 'fa6s fa6-skull', 'fa6s fa6-sink', 'fa6s fa6-sim-card', 'fa6s fa6-signs-post', 'fa6s fa6-sign-hanging', 'fa6s fa6-shuttle-space', 'fa6s fa6-shuffle', 'fa6s fa6-shrimp', 'fa6s fa6-shop-slash', 'fa6s fa6-shop-lock', 'fa6s fa6-shoe-prints', 'fa6s fa6-shield-virus', 'fa6s fa6-shield-heart', 'fa6s fa6-shield-dog', 'fa6s fa6-shield-cat', 'fa6s fa6-shekel-sign', 'fa6s fa6-sheet-plastic', 'fa6s fa6-share-nodes', 'fa6s fa6-shapes', 'fa6s fa6-section', 'fa6s fa6-sd-card', 'fa6s fa6-scroll-torah', 'fa6s fa6-screwdriver-wrench', 'fa6s fa6-screwdriver', 'fa6s fa6-scissors', 'fa6s fa6-school-lock', 'fa6s fa6-school-flag', 'fa6s fa6-school-circle-xmark', 'fa6s fa6-school-circle-exclamation', 'fa6s fa6-school-circle-check', 'fa6s fa6-scale-unbalanced-flip', 'fa6s fa6-scale-unbalanced', 'fa6s fa6-scale-balanced', 'fa6s fa6-satellite-dish', 'fa6s fa6-satellite', 'fa6s fa6-sailboat', 'fa6s fa6-sack-xmark', 'fa6s fa6-sack-dollar', 'fa6s fa6-s', 'fa6s fa6-rupiah-sign', 'fa6s fa6-rupee-sign', 'fa6s fa6-ruler-horizontal', 'fa6s fa6-ruler-combined', 'fa6s fa6-rug', 'fa6s fa6-ruble-sign', 'fa6s fa6-rss', 'fa6s fa6-rotate-left', 'fa6s fa6-rotate', 'fa6s fa6-road-spikes', 'fa6s fa6-road-lock', 'fa6s fa6-road-circle-xmark', 'fa6s fa6-road-circle-exclamation', 'fa6s fa6-road-circle-check', 'fa6s fa6-road-bridge', 'fa6s fa6-road-barrier', 'fa6s fa6-right-long', 'fa6s fa6-right-left', 'fa6s fa6-right-from-bracket', 'fa6s fa6-ribbon', 'fa6s fa6-retweet', 'fa6s fa6-republican', 'fa6s fa6-reply-all', 'fa6s fa6-rectangle-xmark', 'fa6s fa6-rectangle-list', 'fa6s fa6-rectangle-ad', 'fa6s fa6-ranking-star', 'fa6s fa6-rainbow', 'fa6s fa6-radiation', 'fa6s fa6-r', 'fa6s fa6-qrcode', 'fa6s fa6-q', 'fa6s fa6-pump-soap', 'fa6s fa6-pump-medical', 'fa6s fa6-prescription-bottle-medical', 'fa6s fa6-prescription-bottle', 'fa6s fa6-prescription', 'fa6s fa6-poop', 'fa6s fa6-podcast', 'fa6s fa6-plus-minus', 'fa6s fa6-plug-circle-xmark', 'fa6s fa6-plug-circle-plus', 'fa6s fa6-plug-circle-minus', 'fa6s fa6-plug-circle-exclamation', 'fa6s fa6-plug-circle-check', 'fa6s fa6-plug-circle-bolt', 'fa6s fa6-plate-wheat', 'fa6s fa6-plant-wilt', 'fa6s fa6-plane-up', 'fa6s fa6-plane-slash', 'fa6s fa6-plane-lock', 'fa6s fa6-plane-circle-xmark', 'fa6s fa6-plane-circle-exclamation', 'fa6s fa6-plane-circle-check', 'fa6s fa6-plane-arrival', 'fa6s fa6-pizza-slice', 'fa6s fa6-pills', 'fa6s fa6-piggy-bank', 'fa6s fa6-photo-film', 'fa6s fa6-phone-slash', 'fa6s fa6-phone-flip', 'fa6s fa6-peso-sign', 'fa6s fa6-peseta-sign', 'fa6s fa6-person-walking-with-cane', 'fa6s fa6-person-walking-luggage', 'fa6s fa6-person-walking-dashed-line-arrow-right', 'fa6s fa6-person-walking-arrow-right', 'fa6s fa6-person-walking-arrow-loop-left', 'fa6s fa6-person-walking', 'fa6s fa6-person-through-window', 'fa6s fa6-person-swimming', 'fa6s fa6-person-snowboarding', 'fa6s fa6-person-skiing-nordic', 'fa6s fa6-person-skiing', 'fa6s fa6-person-skating', 'fa6s fa6-person-shelter', 'fa6s fa6-person-running', 'fa6s fa6-person-rifle', 'fa6s fa6-person-rays', 'fa6s fa6-person-pregnant', 'fa6s fa6-person-praying', 'fa6s fa6-person-military-to-person', 'fa6s fa6-person-military-rifle', 'fa6s fa6-person-military-pointing', 'fa6s fa6-person-hiking', 'fa6s fa6-person-harassing', 'fa6s fa6-person-half-dress', 'fa6s fa6-person-falling-burst', 'fa6s fa6-person-falling', 'fa6s fa6-person-drowning', 'fa6s fa6-person-dress-burst', 'fa6s fa6-person-dots-from-line', 'fa6s fa6-person-digging', 'fa6s fa6-person-circle-xmark', 'fa6s fa6-person-circle-question', 'fa6s fa6-person-circle-plus', 'fa6s fa6-person-circle-minus', 'fa6s fa6-person-circle-exclamation', 'fa6s fa6-person-circle-check', 'fa6s fa6-person-chalkboard', 'fa6s fa6-person-cane', 'fa6s fa6-person-burst', 'fa6s fa6-person-breastfeeding', 'fa6s fa6-person-booth', 'fa6s fa6-person-biking', 'fa6s fa6-person-arrow-up-from-line', 'fa6s fa6-person-arrow-down-to-line', 'fa6s fa6-pepper-hot', 'fa6s fa6-people-roof', 'fa6s fa6-people-robbery', 'fa6s fa6-people-pulling', 'fa6s fa6-people-line', 'fa6s fa6-people-group', 'fa6s fa6-people-carry-box', 'fa6s fa6-pen-ruler', 'fa6s fa6-pen-clip', 'fa6s fa6-peace', 'fa6s fa6-paw', 'fa6s fa6-paste', 'fa6s fa6-paragraph', 'fa6s fa6-parachute-box', 'fa6s fa6-panorama', 'fa6s fa6-pallet', 'fa6s fa6-paintbrush', 'fa6s fa6-pager', 'fa6s fa6-p', 'fa6s fa6-outdent', 'fa6s fa6-om', 'fa6s fa6-oil-well', 'fa6s fa6-oil-can', 'fa6s fa6-object-ungroup', 'fa6s fa6-object-group', 'fa6s fa6-o', 'fa6s fa6-note-sticky', 'fa6s fa6-notdef', 'fa6s fa6-neuter', 'fa6s fa6-naira-sign', 'fa6s fa6-n', 'fa6s fa6-mountain-city', 'fa6s fa6-mountain', 'fa6s fa6-mound', 'fa6s fa6-mosquito-net', 'fa6s fa6-mosquito', 'fa6s fa6-mosque', 'fa6s fa6-mortar-pestle', 'fa6s fa6-monument', 'fa6s fa6-money-check-dollar', 'fa6s fa6-money-check', 'fa6s fa6-money-bills', 'fa6s fa6-money-bill-wheat', 'fa6s fa6-money-bill-wave', 'fa6s fa6-money-bill-trend-up', 'fa6s fa6-money-bill-transfer', 'fa6s fa6-money-bill-1-wave', 'fa6s fa6-money-bill-1', 'fa6s fa6-mobile-screen-button', 'fa6s fa6-mobile-screen', 'fa6s fa6-mobile-retro', 'fa6s fa6-mobile-button', 'fa6s fa6-mitten', 'fa6s fa6-minimize', 'fa6s fa6-mill-sign', 'fa6s fa6-microscope', 'fa6s fa6-microphone-lines-slash', 'fa6s fa6-microphone-lines', 'fa6s fa6-meteor', 'fa6s fa6-message', 'fa6s fa6-mercury', 'fa6s fa6-menorah', 'fa6s fa6-memory', 'fa6s fa6-maximize', 'fa6s fa6-mattress-pillow', 'fa6s fa6-masks-theater', 'fa6s fa6-mask-ventilator', 'fa6s fa6-mask-face', 'fa6s fa6-martini-glass-empty', 'fa6s fa6-martini-glass-citrus', 'fa6s fa6-martini-glass', 'fa6s fa6-mars-stroke-up', 'fa6s fa6-mars-stroke-right', 'fa6s fa6-mars-stroke', 'fa6s fa6-mars-double', 'fa6s fa6-mars-and-venus-burst', 'fa6s fa6-mars-and-venus', 'fa6s fa6-mars', 'fa6s fa6-map-pin', 'fa6s fa6-map-location-dot', 'fa6s fa6-map-location', 'fa6s fa6-map', 'fa6s fa6-manat-sign', 'fa6s fa6-magnifying-glass-plus', 'fa6s fa6-magnifying-glass-minus', 'fa6s fa6-magnifying-glass-location', 'fa6s fa6-magnifying-glass-dollar', 'fa6s fa6-magnifying-glass-chart', 'fa6s fa6-magnifying-glass-arrow-right', 'fa6s fa6-m', 'fa6s fa6-lungs-virus', 'fa6s fa6-lungs', 'fa6s fa6-locust', 'fa6s fa6-lock-open', 'fa6s fa6-location-pin-lock', 'fa6s fa6-location-crosshairs', 'fa6s fa6-location-arrow', 'fa6s fa6-litecoin-sign', 'fa6s fa6-list-ul', 'fa6s fa6-list-ol', 'fa6s fa6-list-check', 'fa6s fa6-lira-sign', 'fa6s fa6-link-slash', 'fa6s fa6-lines-leaning', 'fa6s fa6-life-ring', 'fa6s fa6-less-than-equal', 'fa6s fa6-less-than', 'fa6s fa6-left-right', 'fa6s fa6-left-long', 'fa6s fa6-lari-sign', 'fa6s fa6-laptop-medical', 'fa6s fa6-laptop-file', 'fa6s fa6-laptop-code', 'fa6s fa6-landmark-flag', 'fa6s fa6-landmark-dome', 'fa6s fa6-land-mine-on', 'fa6s fa6-l', 'fa6s fa6-kitchen-set', 'fa6s fa6-kit-medical', 'fa6s fa6-kip-sign', 'fa6s fa6-khanda', 'fa6s fa6-kaaba', 'fa6s fa6-k', 'fa6s fa6-jug-detergent', 'fa6s fa6-jet-fighter-up', 'fa6s fa6-jet-fighter', 'fa6s fa6-jedi', 'fa6s fa6-jar-wheat', 'fa6s fa6-jar', 'fa6s fa6-j', 'fa6s fa6-italic', 'fa6s fa6-infinity', 'fa6s fa6-indian-rupee-sign', 'fa6s fa6-indent', 'fa6s fa6-image-portrait', 'fa6s fa6-igloo', 'fa6s fa6-id-card-clip', 'fa6s fa6-id-card', 'fa6s fa6-id-badge', 'fa6s fa6-icicles', 'fa6s fa6-ice-cream', 'fa6s fa6-i', 'fa6s fa6-hurricane', 'fa6s fa6-hryvnia-sign', 'fa6s fa6-house-user', 'fa6s fa6-house-tsunami', 'fa6s fa6-house-signal', 'fa6s fa6-house-medical-flag', 'fa6s fa6-house-medical-circle-xmark', 'fa6s fa6-house-medical-circle-exclamation', 'fa6s fa6-house-medical-circle-check', 'fa6s fa6-house-medical', 'fa6s fa6-house-lock', 'fa6s fa6-house-laptop', 'fa6s fa6-house-flood-water-circle-arrow-right', 'fa6s fa6-house-flood-water', 'fa6s fa6-house-flag', 'fa6s fa6-house-fire', 'fa6s fa6-house-crack', 'fa6s fa6-house-circle-xmark', 'fa6s fa6-house-circle-exclamation', 'fa6s fa6-house-circle-check', 'fa6s fa6-house-chimney-window', 'fa6s fa6-house-chimney-user', 'fa6s fa6-house-chimney-medical', 'fa6s fa6-house-chimney-crack', 'fa6s fa6-house-chimney', 'fa6s fa6-hourglass-half', 'fa6s fa6-hourglass-end', 'fa6s fa6-hourglass', 'fa6s fa6-hotdog', 'fa6s fa6-hot-tub-person', 'fa6s fa6-hospital-user', 'fa6s fa6-horse-head', 'fa6s fa6-horse', 'fa6s fa6-holly-berry', 'fa6s fa6-hockey-puck', 'fa6s fa6-hill-rockslide', 'fa6s fa6-hill-avalanche', 'fa6s fa6-highlighter', 'fa6s fa6-helmet-un', 'fa6s fa6-helmet-safety', 'fa6s fa6-helicopter-symbol', 'fa6s fa6-helicopter', 'fa6s fa6-heart-pulse', 'fa6s fa6-heart-crack', 'fa6s fa6-heart-circle-xmark', 'fa6s fa6-heart-circle-plus', 'fa6s fa6-heart-circle-minus', 'fa6s fa6-heart-circle-exclamation', 'fa6s fa6-heart-circle-check', 'fa6s fa6-heart-circle-bolt', 'fa6s fa6-headphones-simple', 'fa6s fa6-head-side-virus', 'fa6s fa6-head-side-mask', 'fa6s fa6-head-side-cough-slash', 'fa6s fa6-head-side-cough', 'fa6s fa6-hat-wizard', 'fa6s fa6-hat-cowboy-side', 'fa6s fa6-hat-cowboy', 'fa6s fa6-hard-drive', 'fa6s fa6-hanukiah', 'fa6s fa6-handshake-simple-slash', 'fa6s fa6-handshake-simple', 'fa6s fa6-handshake-angle', 'fa6s fa6-hands-praying', 'fa6s fa6-hands-holding-circle', 'fa6s fa6-hands-holding-child', 'fa6s fa6-hands-holding', 'fa6s fa6-hands-clapping', 'fa6s fa6-hands-bubbles', 'fa6s fa6-hands-bound', 'fa6s fa6-hands-asl-interpreting', 'fa6s fa6-handcuffs', 'fa6s fa6-hand-spock', 'fa6s fa6-hand-sparkles', 'fa6s fa6-hand-scissors', 'fa6s fa6-hand-pointer', 'fa6s fa6-hand-point-right', 'fa6s fa6-hand-point-left', 'fa6s fa6-hand-point-down', 'fa6s fa6-hand-peace', 'fa6s fa6-hand-middle-finger', 'fa6s fa6-hand-lizard', 'fa6s fa6-hand-holding-medical', 'fa6s fa6-hand-holding-hand', 'fa6s fa6-hand-holding-droplet', 'fa6s fa6-hand-holding-dollar', 'fa6s fa6-hand-holding', 'fa6s fa6-hand-fist', 'fa6s fa6-hand-dots', 'fa6s fa6-hand-back-fist', 'fa6s fa6-hamsa', 'fa6s fa6-h', 'fa6s fa6-gun', 'fa6s fa6-guitar', 'fa6s fa6-guarani-sign', 'fa6s fa6-group-arrows-rotate', 'fa6s fa6-grip-vertical', 'fa6s fa6-grip-lines-vertical', 'fa6s fa6-grip-lines', 'fa6s fa6-grip', 'fa6s fa6-greater-than-equal', 'fa6s fa6-greater-than', 'fa6s fa6-graduation-cap', 'fa6s fa6-golf-ball-tee', 'fa6s fa6-glass-water-droplet', 'fa6s fa6-glass-water', 'fa6s fa6-gifts', 'fa6s fa6-genderless', 'fa6s fa6-gem', 'fa6s fa6-gavel', 'fa6s fa6-gauge-simple-high', 'fa6s fa6-gauge-simple', 'fa6s fa6-gauge-high', 'fa6s fa6-gas-pump', 'fa6s fa6-g', 'fa6s fa6-futbol', 'fa6s fa6-frog', 'fa6s fa6-franc-sign', 'fa6s fa6-forward-step', 'fa6s fa6-forward-fast', 'fa6s fa6-football', 'fa6s fa6-font-awesome', 'fa6s fa6-folder-tree', 'fa6s fa6-folder-plus', 'fa6s fa6-folder-minus', 'fa6s fa6-folder-closed', 'fa6s fa6-florin-sign', 'fa6s fa6-floppy-disk', 'fa6s fa6-flask-vial', 'fa6s fa6-flag-usa', 'fa6s fa6-fish-fins', 'fa6s fa6-fire-flame-simple', 'fa6s fa6-fire-flame-curved', 'fa6s fa6-fire-extinguisher', 'fa6s fa6-fire-burner', 'fa6s fa6-filter-circle-xmark', 'fa6s fa6-filter-circle-dollar', 'fa6s fa6-fill-drip', 'fa6s fa6-fill', 'fa6s fa6-file-zipper', 'fa6s fa6-file-waveform', 'fa6s fa6-file-video', 'fa6s fa6-file-signature', 'fa6s fa6-file-shield', 'fa6s fa6-file-prescription', 'fa6s fa6-file-powerpoint', 'fa6s fa6-file-pen', 'fa6s fa6-file-medical', 'fa6s fa6-file-lines', 'fa6s fa6-file-invoice-dollar', 'fa6s fa6-file-image', 'fa6s fa6-file-csv', 'fa6s fa6-file-code', 'fa6s fa6-file-circle-xmark', 'fa6s fa6-file-circle-question', 'fa6s fa6-file-circle-plus', 'fa6s fa6-file-circle-minus', 'fa6s fa6-file-circle-exclamation', 'fa6s fa6-file-circle-check', 'fa6s fa6-file-audio', 'fa6s fa6-file-arrow-up', 'fa6s fa6-file-arrow-down', 'fa6s fa6-ferry', 'fa6s fa6-feather-pointed', 'fa6s fa6-fax', 'fa6s fa6-faucet-drip', 'fa6s fa6-faucet', 'fa6s fa6-fan', 'fa6s fa6-face-tired', 'fa6s fa6-face-surprise', 'fa6s fa6-face-smile-wink', 'fa6s fa6-face-smile-beam', 'fa6s fa6-face-sad-tear', 'fa6s fa6-face-sad-cry', 'fa6s fa6-face-rolling-eyes', 'fa6s fa6-face-meh-blank', 'fa6s fa6-face-meh', 'fa6s fa6-face-laugh-wink', 'fa6s fa6-face-laugh-squint', 'fa6s fa6-face-laugh-beam', 'fa6s fa6-face-laugh', 'fa6s fa6-face-kiss-wink-heart', 'fa6s fa6-face-kiss-beam', 'fa6s fa6-face-kiss', 'fa6s fa6-face-grin-wink', 'fa6s fa6-face-grin-wide', 'fa6s fa6-face-grin-tongue-wink', 'fa6s fa6-face-grin-tongue-squint', 'fa6s fa6-face-grin-tongue', 'fa6s fa6-face-grin-tears', 'fa6s fa6-face-grin-stars', 'fa6s fa6-face-grin-squint-tears', 'fa6s fa6-face-grin-squint', 'fa6s fa6-face-grin-hearts', 'fa6s fa6-face-grin-beam-sweat', 'fa6s fa6-face-grin-beam', 'fa6s fa6-face-grin', 'fa6s fa6-face-grimace', 'fa6s fa6-face-frown-open', 'fa6s fa6-face-frown', 'fa6s fa6-face-flushed', 'fa6s fa6-face-dizzy', 'fa6s fa6-face-angry', 'fa6s fa6-f', 'fa6s fa6-eye-low-vision', 'fa6s fa6-eye-dropper', 'fa6s fa6-explosion', 'fa6s fa6-euro-sign', 'fa6s fa6-ethernet', 'fa6s fa6-equals', 'fa6s fa6-envelopes-bulk', 'fa6s fa6-envelope-open-text', 'fa6s fa6-envelope-open', 'fa6s fa6-envelope-circle-check', 'fa6s fa6-ellipsis-vertical', 'fa6s fa6-ellipsis', 'fa6s fa6-elevator', 'fa6s fa6-eject', 'fa6s fa6-egg', 'fa6s fa6-earth-oceania', 'fa6s fa6-earth-europe', 'fa6s fa6-earth-asia', 'fa6s fa6-earth-africa', 'fa6s fa6-ear-listen', 'fa6s fa6-ear-deaf', 'fa6s fa6-e', 'fa6s fa6-dungeon', 'fa6s fa6-dumpster', 'fa6s fa6-drumstick-bite', 'fa6s fa6-drum-steelpan', 'fa6s fa6-drum', 'fa6s fa6-droplet-slash', 'fa6s fa6-draw-polygon', 'fa6s fa6-down-long', 'fa6s fa6-down-left-and-up-right-to-center', 'fa6s fa6-dove', 'fa6s fa6-door-closed', 'fa6s fa6-dong-sign', 'fa6s fa6-dolly', 'fa6s fa6-dog', 'fa6s fa6-dna', 'fa6s fa6-divide', 'fa6s fa6-display', 'fa6s fa6-disease', 'fa6s fa6-dice-two', 'fa6s fa6-dice-three', 'fa6s fa6-dice-six', 'fa6s fa6-dice-one', 'fa6s fa6-dice-four', 'fa6s fa6-dice-five', 'fa6s fa6-dice-d6', 'fa6s fa6-dice-d20', 'fa6s fa6-diamond-turn-right', 'fa6s fa6-diagram-successor', 'fa6s fa6-diagram-project', 'fa6s fa6-diagram-predecessor', 'fa6s fa6-diagram-next', 'fa6s fa6-dharmachakra', 'fa6s fa6-democrat', 'fa6s fa6-delete-left', 'fa6s fa6-d', 'fa6s fa6-cubes-stacked', 'fa6s fa6-cubes', 'fa6s fa6-cruzeiro-sign', 'fa6s fa6-crutch', 'fa6s fa6-crow', 'fa6s fa6-crop-simple', 'fa6s fa6-crop', 'fa6s fa6-cow', 'fa6s fa6-couch', 'fa6s fa6-cookie', 'fa6s fa6-computer-mouse', 'fa6s fa6-computer', 'fa6s fa6-compress', 'fa6s fa6-compass-drafting', 'fa6s fa6-compact-disc', 'fa6s fa6-comment-sms', 'fa6s fa6-comment-slash', 'fa6s fa6-comment-medical', 'fa6s fa6-comment-dots', 'fa6s fa6-comment-dollar', 'fa6s fa6-colon-sign', 'fa6s fa6-code-pull-request', 'fa6s fa6-code-merge', 'fa6s fa6-code-fork', 'fa6s fa6-code-commit', 'fa6s fa6-clover', 'fa6s fa6-cloud-sun-rain', 'fa6s fa6-cloud-sun', 'fa6s fa6-cloud-showers-water', 'fa6s fa6-cloud-showers-heavy', 'fa6s fa6-cloud-rain', 'fa6s fa6-cloud-moon-rain', 'fa6s fa6-cloud-moon', 'fa6s fa6-cloud-meatball', 'fa6s fa6-cloud-bolt', 'fa6s fa6-cloud-arrow-down', 'fa6s fa6-clock-rotate-left', 'fa6s fa6-clipboard-user', 'fa6s fa6-clipboard-question', 'fa6s fa6-clipboard-list', 'fa6s fa6-clipboard-check', 'fa6s fa6-clapperboard', 'fa6s fa6-circle-stop', 'fa6s fa6-circle-right', 'fa6s fa6-circle-radiation', 'fa6s fa6-circle-question', 'fa6s fa6-circle-plus', 'fa6s fa6-circle-play', 'fa6s fa6-circle-pause', 'fa6s fa6-circle-nodes', 'fa6s fa6-circle-minus', 'fa6s fa6-circle-left', 'fa6s fa6-circle-h', 'fa6s fa6-circle-dot', 'fa6s fa6-circle-dollar-to-slot', 'fa6s fa6-circle-chevron-up', 'fa6s fa6-circle-chevron-right', 'fa6s fa6-circle-chevron-left', 'fa6s fa6-circle-chevron-down', 'fa6s fa6-circle-arrow-up', 'fa6s fa6-circle-arrow-right', 'fa6s fa6-circle-arrow-left', 'fa6s fa6-circle-arrow-down', 'fa6s fa6-children', 'fa6s fa6-child-reaching', 'fa6s fa6-child-dress', 'fa6s fa6-child-combatant', 'fa6s fa6-chevron-right', 'fa6s fa6-chevron-left', 'fa6s fa6-chess-rook', 'fa6s fa6-chess-queen', 'fa6s fa6-chess-pawn', 'fa6s fa6-chess-knight', 'fa6s fa6-chess-king', 'fa6s fa6-chess-board', 'fa6s fa6-chess-bishop', 'fa6s fa6-chess', 'fa6s fa6-cheese', 'fa6s fa6-check-to-slot', 'fa6s fa6-check-double', 'fa6s fa6-chart-pie', 'fa6s fa6-chart-line', 'fa6s fa6-chart-gantt', 'fa6s fa6-chart-column', 'fa6s fa6-chart-bar', 'fa6s fa6-chart-area', 'fa6s fa6-charging-station', 'fa6s fa6-champagne-glasses', 'fa6s fa6-chalkboard-user', 'fa6s fa6-cent-sign', 'fa6s fa6-cedi-sign', 'fa6s fa6-cat', 'fa6s fa6-cart-flatbed-suitcase', 'fa6s fa6-cart-flatbed', 'fa6s fa6-cart-arrow-down', 'fa6s fa6-carrot', 'fa6s fa6-caret-right', 'fa6s fa6-caret-left', 'fa6s fa6-caravan', 'fa6s fa6-car-tunnel', 'fa6s fa6-car-rear', 'fa6s fa6-car-on', 'fa6s fa6-car-burst', 'fa6s fa6-car-battery', 'fa6s fa6-capsules', 'fa6s fa6-cannabis', 'fa6s fa6-candy-cane', 'fa6s fa6-campground', 'fa6s fa6-camera-rotate', 'fa6s fa6-calendar-xmark', 'fa6s fa6-calendar-plus', 'fa6s fa6-calendar-minus', 'fa6s fa6-calendar-day', 'fa6s fa6-calendar-check', 'fa6s fa6-cake-candles', 'fa6s fa6-c', 'fa6s fa6-bus-simple', 'fa6s fa6-bus', 'fa6s fa6-burst', 'fa6s fa6-burger', 'fa6s fa6-bullhorn', 'fa6s fa6-building-wheat', 'fa6s fa6-building-user', 'fa6s fa6-building-un', 'fa6s fa6-building-shield', 'fa6s fa6-building-ngo', 'fa6s fa6-building-lock', 'fa6s fa6-building-flag', 'fa6s fa6-building-columns', 'fa6s fa6-building-circle-xmark', 'fa6s fa6-building-circle-exclamation', 'fa6s fa6-building-circle-check', 'fa6s fa6-building-circle-arrow-right', 'fa6s fa6-bugs', 'fa6s fa6-bug-slash', 'fa6s fa6-bucket', 'fa6s fa6-broom-ball', 'fa6s fa6-broom', 'fa6s fa6-briefcase-medical', 'fa6s fa6-bridge-water', 'fa6s fa6-bridge-lock', 'fa6s fa6-bridge-circle-xmark', 'fa6s fa6-bridge-circle-exclamation', 'fa6s fa6-bridge-circle-check', 'fa6s fa6-bridge', 'fa6s fa6-bread-slice', 'fa6s fa6-brazilian-real-sign', 'fa6s fa6-braille', 'fa6s fa6-boxes-stacked', 'fa6s fa6-boxes-packing', 'fa6s fa6-box-tissue', 'fa6s fa6-box-open', 'fa6s fa6-box-archive', 'fa6s fa6-box', 'fa6s fa6-bowling-ball', 'fa6s fa6-bowl-rice', 'fa6s fa6-bowl-food', 'fa6s fa6-bottle-water', 'fa6s fa6-bottle-droplet', 'fa6s fa6-bore-hole', 'fa6s fa6-border-top-left', 'fa6s fa6-border-all', 'fa6s fa6-book-tanakh', 'fa6s fa6-book-skull', 'fa6s fa6-book-quran', 'fa6s fa6-book-open-reader', 'fa6s fa6-book-open', 'fa6s fa6-book-medical', 'fa6s fa6-book-journal-whills', 'fa6s fa6-book-bookmark', 'fa6s fa6-book-bible', 'fa6s fa6-book-atlas', 'fa6s fa6-bong', 'fa6s fa6-bone', 'fa6s fa6-bolt-lightning', 'fa6s fa6-bold', 'fa6s fa6-blender-phone', 'fa6s fa6-blender', 'fa6s fa6-bitcoin-sign', 'fa6s fa6-biohazard', 'fa6s fa6-bezier-curve', 'fa6s fa6-bell-slash', 'fa6s fa6-bell-concierge', 'fa6s fa6-beer-mug-empty', 'fa6s fa6-bed-pulse', 'fa6s fa6-bed', 'fa6s fa6-battery-three-quarters', 'fa6s fa6-battery-quarter', 'fa6s fa6-battery-half', 'fa6s fa6-battery-full', 'fa6s fa6-battery-empty', 'fa6s fa6-basketball', 'fa6s fa6-basket-shopping', 'fa6s fa6-baseball-bat-ball', 'fa6s fa6-baseball', 'fa6s fa6-bars-staggered', 'fa6s fa6-bars-progress', 'fa6s fa6-bangladeshi-taka-sign', 'fa6s fa6-bandage', 'fa6s fa6-ban-smoking', 'fa6s fa6-ban', 'fa6s fa6-baht-sign', 'fa6s fa6-bahai', 'fa6s fa6-bacterium', 'fa6s fa6-bacteria', 'fa6s fa6-bacon', 'fa6s fa6-backward-step', 'fa6s fa6-backward-fast', 'fa6s fa6-baby-carriage', 'fa6s fa6-b', 'fa6s fa6-austral-sign', 'fa6s fa6-atom', 'fa6s fa6-at', 'fa6s fa6-asterisk', 'fa6s fa6-arrows-up-to-line', 'fa6s fa6-arrows-up-down-left-right', 'fa6s fa6-arrows-up-down', 'fa6s fa6-arrows-turn-to-dots', 'fa6s fa6-arrows-turn-right', 'fa6s fa6-arrows-to-eye', 'fa6s fa6-arrows-to-dot', 'fa6s fa6-arrows-to-circle', 'fa6s fa6-arrows-split-up-and-left', 'fa6s fa6-arrows-spin', 'fa6s fa6-arrows-rotate', 'fa6s fa6-arrows-left-right-to-line', 'fa6s fa6-arrows-left-right', 'fa6s fa6-arrows-down-to-people', 'fa6s fa6-arrows-down-to-line', 'fa6s fa6-arrow-up-z-a', 'fa6s fa6-arrow-up-wide-short', 'fa6s fa6-arrow-up-short-wide', 'fa6s fa6-arrow-up-right-dots', 'fa6s fa6-arrow-up-long', 'fa6s fa6-arrow-up-from-water-pump', 'fa6s fa6-arrow-up-from-ground-water', 'fa6s fa6-arrow-up-a-z', 'fa6s fa6-arrow-up-9-1', 'fa6s fa6-arrow-up-1-9', 'fa6s fa6-arrow-turn-up', 'fa6s fa6-arrow-turn-down', 'fa6s fa6-arrow-trend-up', 'fa6s fa6-arrow-trend-down', 'fa6s fa6-arrow-rotate-right', 'fa6s fa6-arrow-rotate-left', 'fa6s fa6-arrow-right-to-city', 'fa6s fa6-arrow-right-to-bracket', 'fa6s fa6-arrow-right-long', 'fa6s fa6-arrow-right-from-bracket', 'fa6s fa6-arrow-right-arrow-left', 'fa6s fa6-arrow-pointer', 'fa6s fa6-arrow-left-long', 'fa6s fa6-arrow-down-z-a', 'fa6s fa6-arrow-down-wide-short', 'fa6s fa6-arrow-down-up-lock', 'fa6s fa6-arrow-down-up-across-line', 'fa6s fa6-arrow-down-short-wide', 'fa6s fa6-arrow-down-long', 'fa6s fa6-arrow-down-a-z', 'fa6s fa6-arrow-down-9-1', 'fa6s fa6-arrow-down-1-9', 'fa6s fa6-archway', 'fa6s fa6-apple-whole', 'fa6s fa6-ankh', 'fa6s fa6-angles-up', 'fa6s fa6-angles-right', 'fa6s fa6-angles-left', 'fa6s fa6-angles-down', 'fa6s fa6-angle-right', 'fa6s fa6-angle-left', 'fa6s fa6-angle-down', 'fa6s fa6-anchor-lock', 'fa6s fa6-anchor-circle-xmark', 'fa6s fa6-anchor-circle-exclamation', 'fa6s fa6-anchor-circle-check', 'fa6s fa6-align-right', 'fa6s fa6-align-left', 'fa6s fa6-align-justify', 'fa6s fa6-align-center', 'fa6s fa6-a', 'fa6s fa6-9', 'fa6s fa6-8', 'fa6s fa6-7', 'fa6s fa6-6', 'fa6s fa6-5', 'fa6s fa6-4', 'fa6s fa6-3', 'fa6s fa6-2', 'fa6s fa6-1', 'fa6s fa6-0');
				case 'fa5':
					return array('fa5b fa5-500px', 'fa5b fa5-accessible-icon', 'fa5b fa5-accusoft', 'fa5b fa5-acquisitions-incorporated', 'fa5s fa5-ad', 'fa5s fa5-address-book', 'fa5r fa5-address-book', 'fa5s fa5-address-card', 'fa5r fa5-address-card', 'fa5s fa5-adjust', 'fa5b fa5-adn', 'fa5b fa5-adobe', 'fa5b fa5-adversal', 'fa5b fa5-affiliatetheme', 'fa5s fa5-air-freshener', 'fa5b fa5-airbnb', 'fa5b fa5-algolia', 'fa5s fa5-align-center', 'fa5s fa5-align-justify', 'fa5s fa5-align-left', 'fa5s fa5-align-right', 'fa5b fa5-alipay', 'fa5s fa5-allergies', 'fa5b fa5-amazon', 'fa5b fa5-amazon-pay', 'fa5s fa5-ambulance', 'fa5s fa5-american-sign-language-interpreting', 'fa5b fa5-amilia', 'fa5s fa5-anchor', 'fa5b fa5-android', 'fa5b fa5-angellist', 'fa5s fa5-angle-double-down', 'fa5s fa5-angle-double-left', 'fa5s fa5-angle-double-right', 'fa5s fa5-angle-double-up', 'fa5s fa5-angle-down', 'fa5s fa5-angle-left', 'fa5s fa5-angle-right', 'fa5s fa5-angle-up', 'fa5s fa5-angry', 'fa5r fa5-angry', 'fa5b fa5-angrycreative', 'fa5b fa5-angular', 'fa5s fa5-ankh', 'fa5b fa5-app-store', 'fa5b fa5-app-store-ios', 'fa5b fa5-apper', 'fa5b fa5-apple', 'fa5s fa5-apple-alt', 'fa5b fa5-apple-pay', 'fa5s fa5-archive', 'fa5s fa5-archway', 'fa5s fa5-arrow-alt-circle-down', 'fa5r fa5-arrow-alt-circle-down', 'fa5s fa5-arrow-alt-circle-left', 'fa5r fa5-arrow-alt-circle-left', 'fa5s fa5-arrow-alt-circle-right', 'fa5r fa5-arrow-alt-circle-right', 'fa5s fa5-arrow-alt-circle-up', 'fa5r fa5-arrow-alt-circle-up', 'fa5s fa5-arrow-circle-down', 'fa5s fa5-arrow-circle-left', 'fa5s fa5-arrow-circle-right', 'fa5s fa5-arrow-circle-up', 'fa5s fa5-arrow-down', 'fa5s fa5-arrow-left', 'fa5s fa5-arrow-right', 'fa5s fa5-arrow-up', 'fa5s fa5-arrows-alt', 'fa5s fa5-arrows-alt-h', 'fa5s fa5-arrows-alt-v', 'fa5b fa5-artstation', 'fa5s fa5-assistive-listening-systems', 'fa5s fa5-asterisk', 'fa5b fa5-asymmetrik', 'fa5s fa5-at', 'fa5s fa5-atlas', 'fa5b fa5-atlassian', 'fa5s fa5-atom', 'fa5b fa5-audible', 'fa5s fa5-audio-description', 'fa5b fa5-autoprefixer', 'fa5b fa5-avianex', 'fa5b fa5-aviato', 'fa5s fa5-award', 'fa5b fa5-aws', 'fa5s fa5-baby', 'fa5s fa5-baby-carriage', 'fa5s fa5-backspace', 'fa5s fa5-backward', 'fa5s fa5-bacon', 'fa5s fa5-balance-scale', 'fa5s fa5-balance-scale-left', 'fa5s fa5-balance-scale-right', 'fa5s fa5-ban', 'fa5s fa5-band-aid', 'fa5b fa5-bandcamp', 'fa5s fa5-barcode', 'fa5s fa5-bars', 'fa5s fa5-baseball-ball', 'fa5s fa5-basketball-ball', 'fa5s fa5-bath', 'fa5s fa5-battery-empty', 'fa5s fa5-battery-full', 'fa5s fa5-battery-half', 'fa5s fa5-battery-quarter', 'fa5s fa5-battery-three-quarters', 'fa5b fa5-battle-net', 'fa5s fa5-bed', 'fa5s fa5-beer', 'fa5b fa5-behance', 'fa5b fa5-behance-square', 'fa5s fa5-bell', 'fa5r fa5-bell', 'fa5s fa5-bell-slash', 'fa5r fa5-bell-slash', 'fa5s fa5-bezier-curve', 'fa5s fa5-bible', 'fa5s fa5-bicycle', 'fa5s fa5-biking', 'fa5b fa5-bimobject', 'fa5s fa5-binoculars', 'fa5s fa5-biohazard', 'fa5s fa5-birthday-cake', 'fa5b fa5-bitbucket', 'fa5b fa5-bitcoin', 'fa5b fa5-bity', 'fa5b fa5-black-tie', 'fa5b fa5-blackberry', 'fa5s fa5-blender', 'fa5s fa5-blender-phone', 'fa5s fa5-blind', 'fa5s fa5-blog', 'fa5b fa5-blogger', 'fa5b fa5-blogger-b', 'fa5b fa5-bluetooth', 'fa5b fa5-bluetooth-b', 'fa5s fa5-bold', 'fa5s fa5-bolt', 'fa5s fa5-bomb', 'fa5s fa5-bone', 'fa5s fa5-bong', 'fa5s fa5-book', 'fa5s fa5-book-dead', 'fa5s fa5-book-medical', 'fa5s fa5-book-open', 'fa5s fa5-book-reader', 'fa5s fa5-bookmark', 'fa5r fa5-bookmark', 'fa5b fa5-bootstrap', 'fa5s fa5-border-all', 'fa5s fa5-border-none', 'fa5s fa5-border-style', 'fa5s fa5-bowling-ball', 'fa5s fa5-box', 'fa5s fa5-box-open', 'fa5s fa5-boxes', 'fa5s fa5-braille', 'fa5s fa5-brain', 'fa5s fa5-bread-slice', 'fa5s fa5-briefcase', 'fa5s fa5-briefcase-medical', 'fa5s fa5-broadcast-tower', 'fa5s fa5-broom', 'fa5s fa5-brush', 'fa5b fa5-btc', 'fa5b fa5-buffer', 'fa5s fa5-bug', 'fa5s fa5-building', 'fa5r fa5-building', 'fa5s fa5-bullhorn', 'fa5s fa5-bullseye', 'fa5s fa5-burn', 'fa5b fa5-buromobelexperte', 'fa5s fa5-bus', 'fa5s fa5-bus-alt', 'fa5s fa5-business-time', 'fa5b fa5-buysellads', 'fa5s fa5-calculator', 'fa5s fa5-calendar', 'fa5r fa5-calendar', 'fa5s fa5-calendar-alt', 'fa5r fa5-calendar-alt', 'fa5s fa5-calendar-check', 'fa5r fa5-calendar-check', 'fa5s fa5-calendar-day', 'fa5s fa5-calendar-minus', 'fa5r fa5-calendar-minus', 'fa5s fa5-calendar-plus', 'fa5r fa5-calendar-plus', 'fa5s fa5-calendar-times', 'fa5r fa5-calendar-times', 'fa5s fa5-calendar-week', 'fa5s fa5-camera', 'fa5s fa5-camera-retro', 'fa5s fa5-campground', 'fa5b fa5-canadian-maple-leaf', 'fa5s fa5-candy-cane', 'fa5s fa5-cannabis', 'fa5s fa5-capsules', 'fa5s fa5-car', 'fa5s fa5-car-alt', 'fa5s fa5-car-battery', 'fa5s fa5-car-crash', 'fa5s fa5-car-side', 'fa5s fa5-caret-down', 'fa5s fa5-caret-left', 'fa5s fa5-caret-right', 'fa5s fa5-caret-square-down', 'fa5r fa5-caret-square-down', 'fa5s fa5-caret-square-left', 'fa5r fa5-caret-square-left', 'fa5s fa5-caret-square-right', 'fa5r fa5-caret-square-right', 'fa5s fa5-caret-square-up', 'fa5r fa5-caret-square-up', 'fa5s fa5-caret-up', 'fa5s fa5-carrot', 'fa5s fa5-cart-arrow-down', 'fa5s fa5-cart-plus', 'fa5s fa5-cash-register', 'fa5s fa5-cat', 'fa5b fa5-cc-amazon-pay', 'fa5b fa5-cc-amex', 'fa5b fa5-cc-apple-pay', 'fa5b fa5-cc-diners-club', 'fa5b fa5-cc-discover', 'fa5b fa5-cc-jcb', 'fa5b fa5-cc-mastercard', 'fa5b fa5-cc-paypal', 'fa5b fa5-cc-stripe', 'fa5b fa5-cc-visa', 'fa5b fa5-centercode', 'fa5b fa5-centos', 'fa5s fa5-certificate', 'fa5s fa5-chair', 'fa5s fa5-chalkboard', 'fa5s fa5-chalkboard-teacher', 'fa5s fa5-charging-station', 'fa5s fa5-chart-area', 'fa5s fa5-chart-bar', 'fa5r fa5-chart-bar', 'fa5s fa5-chart-line', 'fa5s fa5-chart-pie', 'fa5s fa5-check', 'fa5s fa5-check-circle', 'fa5r fa5-check-circle', 'fa5s fa5-check-double', 'fa5s fa5-check-square', 'fa5r fa5-check-square', 'fa5s fa5-cheese', 'fa5s fa5-chess', 'fa5s fa5-chess-bishop', 'fa5s fa5-chess-board', 'fa5s fa5-chess-king', 'fa5s fa5-chess-knight', 'fa5s fa5-chess-pawn', 'fa5s fa5-chess-queen', 'fa5s fa5-chess-rook', 'fa5s fa5-chevron-circle-down', 'fa5s fa5-chevron-circle-left', 'fa5s fa5-chevron-circle-right', 'fa5s fa5-chevron-circle-up', 'fa5s fa5-chevron-down', 'fa5s fa5-chevron-left', 'fa5s fa5-chevron-right', 'fa5s fa5-chevron-up', 'fa5s fa5-child', 'fa5b fa5-chrome', 'fa5b fa5-chromecast', 'fa5s fa5-church', 'fa5s fa5-circle', 'fa5r fa5-circle', 'fa5s fa5-circle-notch', 'fa5s fa5-city', 'fa5s fa5-clinic-medical', 'fa5s fa5-clipboard', 'fa5r fa5-clipboard', 'fa5s fa5-clipboard-check', 'fa5s fa5-clipboard-list', 'fa5s fa5-clock', 'fa5r fa5-clock', 'fa5s fa5-clone', 'fa5r fa5-clone', 'fa5s fa5-closed-captioning', 'fa5r fa5-closed-captioning', 'fa5s fa5-cloud', 'fa5s fa5-cloud-download-alt', 'fa5s fa5-cloud-meatball', 'fa5s fa5-cloud-moon', 'fa5s fa5-cloud-moon-rain', 'fa5s fa5-cloud-rain', 'fa5s fa5-cloud-showers-heavy', 'fa5s fa5-cloud-sun', 'fa5s fa5-cloud-sun-rain', 'fa5s fa5-cloud-upload-alt', 'fa5b fa5-cloudscale', 'fa5b fa5-cloudsmith', 'fa5b fa5-cloudversify', 'fa5s fa5-cocktail', 'fa5s fa5-code', 'fa5s fa5-code-branch', 'fa5b fa5-codepen', 'fa5b fa5-codiepie', 'fa5s fa5-coffee', 'fa5s fa5-cog', 'fa5s fa5-cogs', 'fa5s fa5-coins', 'fa5s fa5-columns', 'fa5s fa5-comment', 'fa5r fa5-comment', 'fa5s fa5-comment-alt', 'fa5r fa5-comment-alt', 'fa5s fa5-comment-dollar', 'fa5s fa5-comment-dots', 'fa5r fa5-comment-dots', 'fa5s fa5-comment-medical', 'fa5s fa5-comment-slash', 'fa5s fa5-comments', 'fa5r fa5-comments', 'fa5s fa5-comments-dollar', 'fa5s fa5-compact-disc', 'fa5s fa5-compass', 'fa5r fa5-compass', 'fa5s fa5-compress', 'fa5s fa5-compress-arrows-alt', 'fa5s fa5-concierge-bell', 'fa5b fa5-confluence', 'fa5b fa5-connectdevelop', 'fa5b fa5-contao', 'fa5s fa5-cookie', 'fa5s fa5-cookie-bite', 'fa5s fa5-copy', 'fa5r fa5-copy', 'fa5s fa5-copyright', 'fa5r fa5-copyright', 'fa5s fa5-couch', 'fa5b fa5-cpanel', 'fa5b fa5-creative-commons', 'fa5b fa5-creative-commons-by', 'fa5b fa5-creative-commons-nc', 'fa5b fa5-creative-commons-nc-eu', 'fa5b fa5-creative-commons-nc-jp', 'fa5b fa5-creative-commons-nd', 'fa5b fa5-creative-commons-pd', 'fa5b fa5-creative-commons-pd-alt', 'fa5b fa5-creative-commons-remix', 'fa5b fa5-creative-commons-sa', 'fa5b fa5-creative-commons-sampling', 'fa5b fa5-creative-commons-sampling-plus', 'fa5b fa5-creative-commons-share', 'fa5b fa5-creative-commons-zero', 'fa5s fa5-credit-card', 'fa5r fa5-credit-card', 'fa5b fa5-critical-role', 'fa5s fa5-crop', 'fa5s fa5-crop-alt', 'fa5s fa5-cross', 'fa5s fa5-crosshairs', 'fa5s fa5-crow', 'fa5s fa5-crown', 'fa5s fa5-crutch', 'fa5b fa5-css3', 'fa5b fa5-css3-alt', 'fa5s fa5-cube', 'fa5s fa5-cubes', 'fa5s fa5-cut', 'fa5b fa5-cuttlefish', 'fa5b fa5-d-and-d', 'fa5b fa5-d-and-d-beyond', 'fa5b fa5-dashcube', 'fa5s fa5-database', 'fa5s fa5-deaf', 'fa5b fa5-delicious', 'fa5s fa5-democrat', 'fa5b fa5-deploydog', 'fa5b fa5-deskpro', 'fa5s fa5-desktop', 'fa5b fa5-dev', 'fa5b fa5-deviantart', 'fa5s fa5-dharmachakra', 'fa5b fa5-dhl', 'fa5s fa5-diagnoses', 'fa5b fa5-diaspora', 'fa5s fa5-dice', 'fa5s fa5-dice-d20', 'fa5s fa5-dice-d6', 'fa5s fa5-dice-five', 'fa5s fa5-dice-four', 'fa5s fa5-dice-one', 'fa5s fa5-dice-six', 'fa5s fa5-dice-three', 'fa5s fa5-dice-two', 'fa5b fa5-digg', 'fa5b fa5-digital-ocean', 'fa5s fa5-digital-tachograph', 'fa5s fa5-directions', 'fa5b fa5-discord', 'fa5b fa5-discourse', 'fa5s fa5-divide', 'fa5s fa5-dizzy', 'fa5r fa5-dizzy', 'fa5s fa5-dna', 'fa5b fa5-dochub', 'fa5b fa5-docker', 'fa5s fa5-dog', 'fa5s fa5-dollar-sign', 'fa5s fa5-dolly', 'fa5s fa5-dolly-flatbed', 'fa5s fa5-donate', 'fa5s fa5-door-closed', 'fa5s fa5-door-open', 'fa5s fa5-dot-circle', 'fa5r fa5-dot-circle', 'fa5s fa5-dove', 'fa5s fa5-download', 'fa5b fa5-draft2digital', 'fa5s fa5-drafting-compass', 'fa5s fa5-dragon', 'fa5s fa5-draw-polygon', 'fa5b fa5-dribbble', 'fa5b fa5-dribbble-square', 'fa5b fa5-dropbox', 'fa5s fa5-drum', 'fa5s fa5-drum-steelpan', 'fa5s fa5-drumstick-bite', 'fa5b fa5-drupal', 'fa5s fa5-dumbbell', 'fa5s fa5-dumpster', 'fa5s fa5-dumpster-fire', 'fa5s fa5-dungeon', 'fa5b fa5-dyalog', 'fa5b fa5-earlybirds', 'fa5b fa5-ebay', 'fa5b fa5-edge', 'fa5s fa5-edit', 'fa5r fa5-edit', 'fa5s fa5-egg', 'fa5s fa5-eject', 'fa5b fa5-elementor', 'fa5s fa5-ellipsis-h', 'fa5s fa5-ellipsis-v', 'fa5b fa5-ello', 'fa5b fa5-ember', 'fa5b fa5-empire', 'fa5s fa5-envelope', 'fa5r fa5-envelope', 'fa5s fa5-envelope-open', 'fa5r fa5-envelope-open', 'fa5s fa5-envelope-open-text', 'fa5s fa5-envelope-square', 'fa5b fa5-envira', 'fa5s fa5-equals', 'fa5s fa5-eraser', 'fa5b fa5-erlang', 'fa5b fa5-ethereum', 'fa5s fa5-ethernet', 'fa5b fa5-etsy', 'fa5s fa5-euro-sign', 'fa5b fa5-evernote', 'fa5s fa5-exchange-alt', 'fa5s fa5-exclamation', 'fa5s fa5-exclamation-circle', 'fa5s fa5-exclamation-triangle', 'fa5s fa5-expand', 'fa5s fa5-expand-arrows-alt', 'fa5b fa5-expeditedssl', 'fa5s fa5-external-link-alt', 'fa5s fa5-external-link-square-alt', 'fa5s fa5-eye', 'fa5r fa5-eye', 'fa5s fa5-eye-dropper', 'fa5s fa5-eye-slash', 'fa5r fa5-eye-slash', 'fa5b fa5-facebook', 'fa5b fa5-facebook-f', 'fa5b fa5-facebook-messenger', 'fa5b fa5-facebook-square', 'fa5s fa5-fan', 'fa5b fa5-fantasy-flight-games', 'fa5s fa5-fast-backward', 'fa5s fa5-fast-forward', 'fa5s fa5-fax', 'fa5s fa5-feather', 'fa5s fa5-feather-alt', 'fa5b fa5-fedex', 'fa5b fa5-fedora', 'fa5s fa5-female', 'fa5s fa5-fighter-jet', 'fa5b fa5-figma', 'fa5s fa5-file', 'fa5r fa5-file', 'fa5s fa5-file-alt', 'fa5r fa5-file-alt', 'fa5s fa5-file-archive', 'fa5r fa5-file-archive', 'fa5s fa5-file-audio', 'fa5r fa5-file-audio', 'fa5s fa5-file-code', 'fa5r fa5-file-code', 'fa5s fa5-file-contract', 'fa5s fa5-file-csv', 'fa5s fa5-file-download', 'fa5s fa5-file-excel', 'fa5r fa5-file-excel', 'fa5s fa5-file-export', 'fa5s fa5-file-image', 'fa5r fa5-file-image', 'fa5s fa5-file-import', 'fa5s fa5-file-invoice', 'fa5s fa5-file-invoice-dollar', 'fa5s fa5-file-medical', 'fa5s fa5-file-medical-alt', 'fa5s fa5-file-pdf', 'fa5r fa5-file-pdf', 'fa5s fa5-file-powerpoint', 'fa5r fa5-file-powerpoint', 'fa5s fa5-file-prescription', 'fa5s fa5-file-signature', 'fa5s fa5-file-upload', 'fa5s fa5-file-video', 'fa5r fa5-file-video', 'fa5s fa5-file-word', 'fa5r fa5-file-word', 'fa5s fa5-fill', 'fa5s fa5-fill-drip', 'fa5s fa5-film', 'fa5s fa5-filter', 'fa5s fa5-fingerprint', 'fa5s fa5-fire', 'fa5s fa5-fire-alt', 'fa5s fa5-fire-extinguisher', 'fa5b fa5-firefox', 'fa5s fa5-first-aid', 'fa5b fa5-first-order', 'fa5b fa5-first-order-alt', 'fa5b fa5-firstdraft', 'fa5s fa5-fish', 'fa5s fa5-fist-raised', 'fa5s fa5-flag', 'fa5r fa5-flag', 'fa5s fa5-flag-checkered', 'fa5s fa5-flag-usa', 'fa5s fa5-flask', 'fa5b fa5-flickr', 'fa5b fa5-flipboard', 'fa5s fa5-flushed', 'fa5r fa5-flushed', 'fa5b fa5-fly', 'fa5s fa5-folder', 'fa5r fa5-folder', 'fa5s fa5-folder-minus', 'fa5s fa5-folder-open', 'fa5r fa5-folder-open', 'fa5s fa5-folder-plus', 'fa5s fa5-font', 'fa5b fa5-font-awesome', 'fa5b fa5-font-awesome-alt', 'fa5b fa5-font-awesome-flag', 'fa5b fa5-fonticons', 'fa5b fa5-fonticons-fi', 'fa5s fa5-football-ball', 'fa5b fa5-fort-awesome', 'fa5b fa5-fort-awesome-alt', 'fa5b fa5-forumbee', 'fa5s fa5-forward', 'fa5b fa5-foursquare', 'fa5b fa5-free-code-camp', 'fa5b fa5-freebsd', 'fa5s fa5-frog', 'fa5s fa5-frown', 'fa5r fa5-frown', 'fa5s fa5-frown-open', 'fa5r fa5-frown-open', 'fa5b fa5-fulcrum', 'fa5s fa5-funnel-dollar', 'fa5s fa5-futbol', 'fa5r fa5-futbol', 'fa5b fa5-galactic-republic', 'fa5b fa5-galactic-senate', 'fa5s fa5-gamepad', 'fa5s fa5-gas-pump', 'fa5s fa5-gavel', 'fa5s fa5-gem', 'fa5r fa5-gem', 'fa5s fa5-genderless', 'fa5b fa5-get-pocket', 'fa5b fa5-gg', 'fa5b fa5-gg-circle', 'fa5s fa5-ghost', 'fa5s fa5-gift', 'fa5s fa5-gifts', 'fa5b fa5-git', 'fa5b fa5-git-alt', 'fa5b fa5-git-square', 'fa5b fa5-github', 'fa5b fa5-github-alt', 'fa5b fa5-github-square', 'fa5b fa5-gitkraken', 'fa5b fa5-gitlab', 'fa5b fa5-gitter', 'fa5s fa5-glass-cheers', 'fa5s fa5-glass-martini', 'fa5s fa5-glass-martini-alt', 'fa5s fa5-glass-whiskey', 'fa5s fa5-glasses', 'fa5b fa5-glide', 'fa5b fa5-glide-g', 'fa5s fa5-globe', 'fa5s fa5-globe-africa', 'fa5s fa5-globe-americas', 'fa5s fa5-globe-asia', 'fa5s fa5-globe-europe', 'fa5b fa5-gofore', 'fa5s fa5-golf-ball', 'fa5b fa5-goodreads', 'fa5b fa5-goodreads-g', 'fa5b fa5-google', 'fa5b fa5-google-drive', 'fa5b fa5-google-play', 'fa5b fa5-google-plus', 'fa5b fa5-google-plus-g', 'fa5b fa5-google-plus-square', 'fa5b fa5-google-wallet', 'fa5s fa5-gopuram', 'fa5s fa5-graduation-cap', 'fa5b fa5-gratipay', 'fa5b fa5-grav', 'fa5s fa5-greater-than', 'fa5s fa5-greater-than-equal', 'fa5s fa5-grimace', 'fa5r fa5-grimace', 'fa5s fa5-grin', 'fa5r fa5-grin', 'fa5s fa5-grin-alt', 'fa5r fa5-grin-alt', 'fa5s fa5-grin-beam', 'fa5r fa5-grin-beam', 'fa5s fa5-grin-beam-sweat', 'fa5r fa5-grin-beam-sweat', 'fa5s fa5-grin-hearts', 'fa5r fa5-grin-hearts', 'fa5s fa5-grin-squint', 'fa5r fa5-grin-squint', 'fa5s fa5-grin-squint-tears', 'fa5r fa5-grin-squint-tears', 'fa5s fa5-grin-stars', 'fa5r fa5-grin-stars', 'fa5s fa5-grin-tears', 'fa5r fa5-grin-tears', 'fa5s fa5-grin-tongue', 'fa5r fa5-grin-tongue', 'fa5s fa5-grin-tongue-squint', 'fa5r fa5-grin-tongue-squint', 'fa5s fa5-grin-tongue-wink', 'fa5r fa5-grin-tongue-wink', 'fa5s fa5-grin-wink', 'fa5r fa5-grin-wink', 'fa5s fa5-grip-horizontal', 'fa5s fa5-grip-lines', 'fa5s fa5-grip-lines-vertical', 'fa5s fa5-grip-vertical', 'fa5b fa5-gripfire', 'fa5b fa5-grunt', 'fa5s fa5-guitar', 'fa5b fa5-gulp', 'fa5s fa5-h-square', 'fa5b fa5-hacker-news', 'fa5b fa5-hacker-news-square', 'fa5b fa5-hackerrank', 'fa5s fa5-hamburger', 'fa5s fa5-hammer', 'fa5s fa5-hamsa', 'fa5s fa5-hand-holding', 'fa5s fa5-hand-holding-heart', 'fa5s fa5-hand-holding-usd', 'fa5s fa5-hand-lizard', 'fa5r fa5-hand-lizard', 'fa5s fa5-hand-middle-finger', 'fa5s fa5-hand-paper', 'fa5r fa5-hand-paper', 'fa5s fa5-hand-peace', 'fa5r fa5-hand-peace', 'fa5s fa5-hand-point-down', 'fa5r fa5-hand-point-down', 'fa5s fa5-hand-point-left', 'fa5r fa5-hand-point-left', 'fa5s fa5-hand-point-right', 'fa5r fa5-hand-point-right', 'fa5s fa5-hand-point-up', 'fa5r fa5-hand-point-up', 'fa5s fa5-hand-pointer', 'fa5r fa5-hand-pointer', 'fa5s fa5-hand-rock', 'fa5r fa5-hand-rock', 'fa5s fa5-hand-scissors', 'fa5r fa5-hand-scissors', 'fa5s fa5-hand-spock', 'fa5r fa5-hand-spock', 'fa5s fa5-hands', 'fa5s fa5-hands-helping', 'fa5s fa5-handshake', 'fa5r fa5-handshake', 'fa5s fa5-hanukiah', 'fa5s fa5-hard-hat', 'fa5s fa5-hashtag', 'fa5s fa5-hat-wizard', 'fa5s fa5-haykal', 'fa5s fa5-hdd', 'fa5r fa5-hdd', 'fa5s fa5-heading', 'fa5s fa5-headphones', 'fa5s fa5-headphones-alt', 'fa5s fa5-headset', 'fa5s fa5-heart', 'fa5r fa5-heart', 'fa5s fa5-heart-broken', 'fa5s fa5-heartbeat', 'fa5s fa5-helicopter', 'fa5s fa5-highlighter', 'fa5s fa5-hiking', 'fa5s fa5-hippo', 'fa5b fa5-hips', 'fa5b fa5-hire-a-helper', 'fa5s fa5-history', 'fa5s fa5-hockey-puck', 'fa5s fa5-holly-berry', 'fa5s fa5-home', 'fa5b fa5-hooli', 'fa5b fa5-hornbill', 'fa5s fa5-horse', 'fa5s fa5-horse-head', 'fa5s fa5-hospital', 'fa5r fa5-hospital', 'fa5s fa5-hospital-alt', 'fa5s fa5-hospital-symbol', 'fa5s fa5-hot-tub', 'fa5s fa5-hotdog', 'fa5s fa5-hotel', 'fa5b fa5-hotjar', 'fa5s fa5-hourglass', 'fa5r fa5-hourglass', 'fa5s fa5-hourglass-end', 'fa5s fa5-hourglass-half', 'fa5s fa5-hourglass-start', 'fa5s fa5-house-damage', 'fa5b fa5-houzz', 'fa5s fa5-hryvnia', 'fa5b fa5-html5', 'fa5b fa5-hubspot', 'fa5s fa5-i-cursor', 'fa5s fa5-ice-cream', 'fa5s fa5-icicles', 'fa5s fa5-icons', 'fa5s fa5-id-badge', 'fa5r fa5-id-badge', 'fa5s fa5-id-card', 'fa5r fa5-id-card', 'fa5s fa5-id-card-alt', 'fa5s fa5-igloo', 'fa5s fa5-image', 'fa5r fa5-image', 'fa5s fa5-images', 'fa5r fa5-images', 'fa5b fa5-imdb', 'fa5s fa5-inbox', 'fa5s fa5-indent', 'fa5s fa5-industry', 'fa5s fa5-infinity', 'fa5s fa5-info', 'fa5s fa5-info-circle', 'fa5b fa5-instagram', 'fa5b fa5-intercom', 'fa5b fa5-internet-explorer', 'fa5b fa5-invision', 'fa5b fa5-ioxhost', 'fa5s fa5-italic', 'fa5b fa5-itch-io', 'fa5b fa5-itunes', 'fa5b fa5-itunes-note', 'fa5b fa5-java', 'fa5s fa5-jedi', 'fa5b fa5-jedi-order', 'fa5b fa5-jenkins', 'fa5b fa5-jira', 'fa5b fa5-joget', 'fa5s fa5-joint', 'fa5b fa5-joomla', 'fa5s fa5-journal-whills', 'fa5b fa5-js', 'fa5b fa5-js-square', 'fa5b fa5-jsfiddle', 'fa5s fa5-kaaba', 'fa5b fa5-kaggle', 'fa5s fa5-key', 'fa5b fa5-keybase', 'fa5s fa5-keyboard', 'fa5r fa5-keyboard', 'fa5b fa5-keycdn', 'fa5s fa5-khanda', 'fa5b fa5-kickstarter', 'fa5b fa5-kickstarter-k', 'fa5s fa5-kiss', 'fa5r fa5-kiss', 'fa5s fa5-kiss-beam', 'fa5r fa5-kiss-beam', 'fa5s fa5-kiss-wink-heart', 'fa5r fa5-kiss-wink-heart', 'fa5s fa5-kiwi-bird', 'fa5b fa5-korvue', 'fa5s fa5-landmark', 'fa5s fa5-language', 'fa5s fa5-laptop', 'fa5s fa5-laptop-code', 'fa5s fa5-laptop-medical', 'fa5b fa5-laravel', 'fa5b fa5-lastfm', 'fa5b fa5-lastfm-square', 'fa5s fa5-laugh', 'fa5r fa5-laugh', 'fa5s fa5-laugh-beam', 'fa5r fa5-laugh-beam', 'fa5s fa5-laugh-squint', 'fa5r fa5-laugh-squint', 'fa5s fa5-laugh-wink', 'fa5r fa5-laugh-wink', 'fa5s fa5-layer-group', 'fa5s fa5-leaf', 'fa5b fa5-leanpub', 'fa5s fa5-lemon', 'fa5r fa5-lemon', 'fa5b fa5-less', 'fa5s fa5-less-than', 'fa5s fa5-less-than-equal', 'fa5s fa5-level-down-alt', 'fa5s fa5-level-up-alt', 'fa5s fa5-life-ring', 'fa5r fa5-life-ring', 'fa5s fa5-lightbulb', 'fa5r fa5-lightbulb', 'fa5b fa5-line', 'fa5s fa5-link', 'fa5b fa5-linkedin', 'fa5b fa5-linkedin-in', 'fa5b fa5-linode', 'fa5b fa5-linux', 'fa5s fa5-lira-sign', 'fa5s fa5-list', 'fa5s fa5-list-alt', 'fa5r fa5-list-alt', 'fa5s fa5-list-ol', 'fa5s fa5-list-ul', 'fa5s fa5-location-arrow', 'fa5s fa5-lock', 'fa5s fa5-lock-open', 'fa5s fa5-long-arrow-alt-down', 'fa5s fa5-long-arrow-alt-left', 'fa5s fa5-long-arrow-alt-right', 'fa5s fa5-long-arrow-alt-up', 'fa5s fa5-low-vision', 'fa5s fa5-luggage-cart', 'fa5b fa5-lyft', 'fa5b fa5-magento', 'fa5s fa5-magic', 'fa5s fa5-magnet', 'fa5s fa5-mail-bulk', 'fa5b fa5-mailchimp', 'fa5s fa5-male', 'fa5b fa5-mandalorian', 'fa5s fa5-map', 'fa5r fa5-map', 'fa5s fa5-map-marked', 'fa5s fa5-map-marked-alt', 'fa5s fa5-map-marker', 'fa5s fa5-map-marker-alt', 'fa5s fa5-map-pin', 'fa5s fa5-map-signs', 'fa5b fa5-markdown', 'fa5s fa5-marker', 'fa5s fa5-mars', 'fa5s fa5-mars-double', 'fa5s fa5-mars-stroke', 'fa5s fa5-mars-stroke-h', 'fa5s fa5-mars-stroke-v', 'fa5s fa5-mask', 'fa5b fa5-mastodon', 'fa5b fa5-maxcdn', 'fa5s fa5-medal', 'fa5b fa5-medapps', 'fa5b fa5-medium', 'fa5b fa5-medium-m', 'fa5s fa5-medkit', 'fa5b fa5-medrt', 'fa5b fa5-meetup', 'fa5b fa5-megaport', 'fa5s fa5-meh', 'fa5r fa5-meh', 'fa5s fa5-meh-blank', 'fa5r fa5-meh-blank', 'fa5s fa5-meh-rolling-eyes', 'fa5r fa5-meh-rolling-eyes', 'fa5s fa5-memory', 'fa5b fa5-mendeley', 'fa5s fa5-menorah', 'fa5s fa5-mercury', 'fa5s fa5-meteor', 'fa5s fa5-microchip', 'fa5s fa5-microphone', 'fa5s fa5-microphone-alt', 'fa5s fa5-microphone-alt-slash', 'fa5s fa5-microphone-slash', 'fa5s fa5-microscope', 'fa5b fa5-microsoft', 'fa5s fa5-minus', 'fa5s fa5-minus-circle', 'fa5s fa5-minus-square', 'fa5r fa5-minus-square', 'fa5s fa5-mitten', 'fa5b fa5-mix', 'fa5b fa5-mixcloud', 'fa5b fa5-mizuni', 'fa5s fa5-mobile', 'fa5s fa5-mobile-alt', 'fa5b fa5-modx', 'fa5b fa5-monero', 'fa5s fa5-money-bill', 'fa5s fa5-money-bill-alt', 'fa5r fa5-money-bill-alt', 'fa5s fa5-money-bill-wave', 'fa5s fa5-money-bill-wave-alt', 'fa5s fa5-money-check', 'fa5s fa5-money-check-alt', 'fa5s fa5-monument', 'fa5s fa5-moon', 'fa5r fa5-moon', 'fa5s fa5-mortar-pestle', 'fa5s fa5-mosque', 'fa5s fa5-motorcycle', 'fa5s fa5-mountain', 'fa5s fa5-mouse-pointer', 'fa5s fa5-mug-hot', 'fa5s fa5-music', 'fa5b fa5-napster', 'fa5b fa5-neos', 'fa5s fa5-network-wired', 'fa5s fa5-neuter', 'fa5s fa5-newspaper', 'fa5r fa5-newspaper', 'fa5b fa5-nimblr', 'fa5b fa5-node', 'fa5b fa5-node-js', 'fa5s fa5-not-equal', 'fa5s fa5-notes-medical', 'fa5b fa5-npm', 'fa5b fa5-ns8', 'fa5b fa5-nutritionix', 'fa5s fa5-object-group', 'fa5r fa5-object-group', 'fa5s fa5-object-ungroup', 'fa5r fa5-object-ungroup', 'fa5b fa5-odnoklassniki', 'fa5b fa5-odnoklassniki-square', 'fa5s fa5-oil-can', 'fa5b fa5-old-republic', 'fa5s fa5-om', 'fa5b fa5-opencart', 'fa5b fa5-openid', 'fa5b fa5-opera', 'fa5b fa5-optin-monster', 'fa5b fa5-osi', 'fa5s fa5-otter', 'fa5s fa5-outdent', 'fa5b fa5-page4', 'fa5b fa5-pagelines', 'fa5s fa5-pager', 'fa5s fa5-paint-brush', 'fa5s fa5-paint-roller', 'fa5s fa5-palette', 'fa5b fa5-palfed', 'fa5s fa5-pallet', 'fa5s fa5-paper-plane', 'fa5r fa5-paper-plane', 'fa5s fa5-paperclip', 'fa5s fa5-parachute-box', 'fa5s fa5-paragraph', 'fa5s fa5-parking', 'fa5s fa5-passport', 'fa5s fa5-pastafarianism', 'fa5s fa5-paste', 'fa5b fa5-patreon', 'fa5s fa5-pause', 'fa5s fa5-pause-circle', 'fa5r fa5-pause-circle', 'fa5s fa5-paw', 'fa5b fa5-paypal', 'fa5s fa5-peace', 'fa5s fa5-pen', 'fa5s fa5-pen-alt', 'fa5s fa5-pen-fancy', 'fa5s fa5-pen-nib', 'fa5s fa5-pen-square', 'fa5s fa5-pencil-alt', 'fa5s fa5-pencil-ruler', 'fa5b fa5-penny-arcade', 'fa5s fa5-people-carry', 'fa5s fa5-pepper-hot', 'fa5s fa5-percent', 'fa5s fa5-percentage', 'fa5b fa5-periscope', 'fa5s fa5-person-booth', 'fa5b fa5-phabricator', 'fa5b fa5-phoenix-framework', 'fa5b fa5-phoenix-squadron', 'fa5s fa5-phone', 'fa5s fa5-phone-alt', 'fa5s fa5-phone-slash', 'fa5s fa5-phone-square', 'fa5s fa5-phone-square-alt', 'fa5s fa5-phone-volume', 'fa5s fa5-photo-video', 'fa5b fa5-php', 'fa5b fa5-pied-piper', 'fa5b fa5-pied-piper-alt', 'fa5b fa5-pied-piper-hat', 'fa5b fa5-pied-piper-pp', 'fa5s fa5-piggy-bank', 'fa5s fa5-pills', 'fa5b fa5-pinterest', 'fa5b fa5-pinterest-p', 'fa5b fa5-pinterest-square', 'fa5s fa5-pizza-slice', 'fa5s fa5-place-of-worship', 'fa5s fa5-plane', 'fa5s fa5-plane-arrival', 'fa5s fa5-plane-departure', 'fa5s fa5-play', 'fa5s fa5-play-circle', 'fa5r fa5-play-circle', 'fa5b fa5-playstation', 'fa5s fa5-plug', 'fa5s fa5-plus', 'fa5s fa5-plus-circle', 'fa5s fa5-plus-square', 'fa5r fa5-plus-square', 'fa5s fa5-podcast', 'fa5s fa5-poll', 'fa5s fa5-poll-h', 'fa5s fa5-poo', 'fa5s fa5-poo-storm', 'fa5s fa5-poop', 'fa5s fa5-portrait', 'fa5s fa5-pound-sign', 'fa5s fa5-power-off', 'fa5s fa5-pray', 'fa5s fa5-praying-hands', 'fa5s fa5-prescription', 'fa5s fa5-prescription-bottle', 'fa5s fa5-prescription-bottle-alt', 'fa5s fa5-print', 'fa5s fa5-procedures', 'fa5b fa5-product-hunt', 'fa5s fa5-project-diagram', 'fa5b fa5-pushed', 'fa5s fa5-puzzle-piece', 'fa5b fa5-python', 'fa5b fa5-qq', 'fa5s fa5-qrcode', 'fa5s fa5-question', 'fa5s fa5-question-circle', 'fa5r fa5-question-circle', 'fa5s fa5-quidditch', 'fa5b fa5-quinscape', 'fa5b fa5-quora', 'fa5s fa5-quote-left', 'fa5s fa5-quote-right', 'fa5s fa5-quran', 'fa5b fa5-r-project', 'fa5s fa5-radiation', 'fa5s fa5-radiation-alt', 'fa5s fa5-rainbow', 'fa5s fa5-random', 'fa5b fa5-raspberry-pi', 'fa5b fa5-ravelry', 'fa5b fa5-react', 'fa5b fa5-reacteurope', 'fa5b fa5-readme', 'fa5b fa5-rebel', 'fa5s fa5-receipt', 'fa5s fa5-recycle', 'fa5b fa5-red-river', 'fa5b fa5-reddit', 'fa5b fa5-reddit-alien', 'fa5b fa5-reddit-square', 'fa5b fa5-redhat', 'fa5s fa5-redo', 'fa5s fa5-redo-alt', 'fa5s fa5-registered', 'fa5r fa5-registered', 'fa5s fa5-remove-format', 'fa5b fa5-renren', 'fa5s fa5-reply', 'fa5s fa5-reply-all', 'fa5b fa5-replyd', 'fa5s fa5-republican', 'fa5b fa5-researchgate', 'fa5b fa5-resolving', 'fa5s fa5-restroom', 'fa5s fa5-retweet', 'fa5b fa5-rev', 'fa5s fa5-ribbon', 'fa5s fa5-ring', 'fa5s fa5-road', 'fa5s fa5-robot', 'fa5s fa5-rocket', 'fa5b fa5-rocketchat', 'fa5b fa5-rockrms', 'fa5s fa5-route', 'fa5s fa5-rss', 'fa5s fa5-rss-square', 'fa5s fa5-ruble-sign', 'fa5s fa5-ruler', 'fa5s fa5-ruler-combined', 'fa5s fa5-ruler-horizontal', 'fa5s fa5-ruler-vertical', 'fa5s fa5-running', 'fa5s fa5-rupee-sign', 'fa5s fa5-sad-cry', 'fa5r fa5-sad-cry', 'fa5s fa5-sad-tear', 'fa5r fa5-sad-tear', 'fa5b fa5-safari', 'fa5b fa5-salesforce', 'fa5b fa5-sass', 'fa5s fa5-satellite', 'fa5s fa5-satellite-dish', 'fa5s fa5-save', 'fa5r fa5-save', 'fa5b fa5-schlix', 'fa5s fa5-school', 'fa5s fa5-screwdriver', 'fa5b fa5-scribd', 'fa5s fa5-scroll', 'fa5s fa5-sd-card', 'fa5s fa5-search', 'fa5s fa5-search-dollar', 'fa5s fa5-search-location', 'fa5s fa5-search-minus', 'fa5s fa5-search-plus', 'fa5b fa5-searchengin', 'fa5s fa5-seedling', 'fa5b fa5-sellcast', 'fa5b fa5-sellsy', 'fa5s fa5-server', 'fa5b fa5-servicestack', 'fa5s fa5-shapes', 'fa5s fa5-share', 'fa5s fa5-share-alt', 'fa5s fa5-share-alt-square', 'fa5s fa5-share-square', 'fa5r fa5-share-square', 'fa5s fa5-shekel-sign', 'fa5s fa5-shield-alt', 'fa5s fa5-ship', 'fa5s fa5-shipping-fast', 'fa5b fa5-shirtsinbulk', 'fa5s fa5-shoe-prints', 'fa5s fa5-shopping-bag', 'fa5s fa5-shopping-basket', 'fa5s fa5-shopping-cart', 'fa5b fa5-shopware', 'fa5s fa5-shower', 'fa5s fa5-shuttle-van', 'fa5s fa5-sign', 'fa5s fa5-sign-in-alt', 'fa5s fa5-sign-language', 'fa5s fa5-sign-out-alt', 'fa5s fa5-signal', 'fa5s fa5-signature', 'fa5s fa5-sim-card', 'fa5b fa5-simplybuilt', 'fa5b fa5-sistrix', 'fa5s fa5-sitemap', 'fa5b fa5-sith', 'fa5s fa5-skating', 'fa5b fa5-sketch', 'fa5s fa5-skiing', 'fa5s fa5-skiing-nordic', 'fa5s fa5-skull', 'fa5s fa5-skull-crossbones', 'fa5b fa5-skyatlas', 'fa5b fa5-skype', 'fa5b fa5-slack', 'fa5b fa5-slack-hash', 'fa5s fa5-slash', 'fa5s fa5-sleigh', 'fa5s fa5-sliders-h', 'fa5b fa5-slideshare', 'fa5s fa5-smile', 'fa5r fa5-smile', 'fa5s fa5-smile-beam', 'fa5r fa5-smile-beam', 'fa5s fa5-smile-wink', 'fa5r fa5-smile-wink', 'fa5s fa5-smog', 'fa5s fa5-smoking', 'fa5s fa5-smoking-ban', 'fa5s fa5-sms', 'fa5b fa5-snapchat', 'fa5b fa5-snapchat-ghost', 'fa5b fa5-snapchat-square', 'fa5s fa5-snowboarding', 'fa5s fa5-snowflake', 'fa5r fa5-snowflake', 'fa5s fa5-snowman', 'fa5s fa5-snowplow', 'fa5s fa5-socks', 'fa5s fa5-solar-panel', 'fa5s fa5-sort', 'fa5s fa5-sort-alpha-down', 'fa5s fa5-sort-alpha-down-alt', 'fa5s fa5-sort-alpha-up', 'fa5s fa5-sort-alpha-up-alt', 'fa5s fa5-sort-amount-down', 'fa5s fa5-sort-amount-down-alt', 'fa5s fa5-sort-amount-up', 'fa5s fa5-sort-amount-up-alt', 'fa5s fa5-sort-down', 'fa5s fa5-sort-numeric-down', 'fa5s fa5-sort-numeric-down-alt', 'fa5s fa5-sort-numeric-up', 'fa5s fa5-sort-numeric-up-alt', 'fa5s fa5-sort-up', 'fa5b fa5-soundcloud', 'fa5b fa5-sourcetree', 'fa5s fa5-spa', 'fa5s fa5-space-shuttle', 'fa5b fa5-speakap', 'fa5b fa5-speaker-deck', 'fa5s fa5-spell-check', 'fa5s fa5-spider', 'fa5s fa5-spinner', 'fa5s fa5-splotch', 'fa5b fa5-spotify', 'fa5s fa5-spray-can', 'fa5s fa5-square', 'fa5r fa5-square', 'fa5s fa5-square-full', 'fa5s fa5-square-root-alt', 'fa5b fa5-squarespace', 'fa5b fa5-stack-exchange', 'fa5b fa5-stack-overflow', 'fa5b fa5-stackpath', 'fa5s fa5-stamp', 'fa5s fa5-star', 'fa5r fa5-star', 'fa5s fa5-star-and-crescent', 'fa5s fa5-star-half', 'fa5r fa5-star-half', 'fa5s fa5-star-half-alt', 'fa5s fa5-star-of-david', 'fa5s fa5-star-of-life', 'fa5b fa5-staylinked', 'fa5b fa5-steam', 'fa5b fa5-steam-square', 'fa5b fa5-steam-symbol', 'fa5s fa5-step-backward', 'fa5s fa5-step-forward', 'fa5s fa5-stethoscope', 'fa5b fa5-sticker-mule', 'fa5s fa5-sticky-note', 'fa5r fa5-sticky-note', 'fa5s fa5-stop', 'fa5s fa5-stop-circle', 'fa5r fa5-stop-circle', 'fa5s fa5-stopwatch', 'fa5s fa5-store', 'fa5s fa5-store-alt', 'fa5b fa5-strava', 'fa5s fa5-stream', 'fa5s fa5-street-view', 'fa5s fa5-strikethrough', 'fa5b fa5-stripe', 'fa5b fa5-stripe-s', 'fa5s fa5-stroopwafel', 'fa5b fa5-studiovinari', 'fa5b fa5-stumbleupon', 'fa5b fa5-stumbleupon-circle', 'fa5s fa5-subscript', 'fa5s fa5-subway', 'fa5s fa5-suitcase', 'fa5s fa5-suitcase-rolling', 'fa5s fa5-sun', 'fa5r fa5-sun', 'fa5b fa5-superpowers', 'fa5s fa5-superscript', 'fa5b fa5-supple', 'fa5s fa5-surprise', 'fa5r fa5-surprise', 'fa5b fa5-suse', 'fa5s fa5-swatchbook', 'fa5s fa5-swimmer', 'fa5s fa5-swimming-pool', 'fa5b fa5-symfony', 'fa5s fa5-synagogue', 'fa5s fa5-sync', 'fa5s fa5-sync-alt', 'fa5s fa5-syringe', 'fa5s fa5-table', 'fa5s fa5-table-tennis', 'fa5s fa5-tablet', 'fa5s fa5-tablet-alt', 'fa5s fa5-tablets', 'fa5s fa5-tachometer-alt', 'fa5s fa5-tag', 'fa5s fa5-tags', 'fa5s fa5-tape', 'fa5s fa5-tasks', 'fa5s fa5-taxi', 'fa5b fa5-teamspeak', 'fa5s fa5-teeth', 'fa5s fa5-teeth-open', 'fa5b fa5-telegram', 'fa5b fa5-telegram-plane', 'fa5s fa5-temperature-high', 'fa5s fa5-temperature-low', 'fa5b fa5-tencent-weibo', 'fa5s fa5-tenge', 'fa5s fa5-terminal', 'fa5s fa5-text-height', 'fa5s fa5-text-width', 'fa5s fa5-th', 'fa5s fa5-th-large', 'fa5s fa5-th-list', 'fa5b fa5-the-red-yeti', 'fa5s fa5-theater-masks', 'fa5b fa5-themeco', 'fa5b fa5-themeisle', 'fa5s fa5-thermometer', 'fa5s fa5-thermometer-empty', 'fa5s fa5-thermometer-full', 'fa5s fa5-thermometer-half', 'fa5s fa5-thermometer-quarter', 'fa5s fa5-thermometer-three-quarters', 'fa5b fa5-think-peaks', 'fa5s fa5-thumbs-down', 'fa5r fa5-thumbs-down', 'fa5s fa5-thumbs-up', 'fa5r fa5-thumbs-up', 'fa5s fa5-thumbtack', 'fa5s fa5-ticket-alt', 'fa5s fa5-times', 'fa5s fa5-times-circle', 'fa5r fa5-times-circle', 'fa5s fa5-tint', 'fa5s fa5-tint-slash', 'fa5s fa5-tired', 'fa5r fa5-tired', 'fa5s fa5-toggle-off', 'fa5s fa5-toggle-on', 'fa5s fa5-toilet', 'fa5s fa5-toilet-paper', 'fa5s fa5-toolbox', 'fa5s fa5-tools', 'fa5s fa5-tooth', 'fa5s fa5-torah', 'fa5s fa5-torii-gate', 'fa5s fa5-tractor', 'fa5b fa5-trade-federation', 'fa5s fa5-trademark', 'fa5s fa5-traffic-light', 'fa5s fa5-train', 'fa5s fa5-tram', 'fa5s fa5-transgender', 'fa5s fa5-transgender-alt', 'fa5s fa5-trash', 'fa5s fa5-trash-alt', 'fa5r fa5-trash-alt', 'fa5s fa5-trash-restore', 'fa5s fa5-trash-restore-alt', 'fa5s fa5-tree', 'fa5b fa5-trello', 'fa5b fa5-tripadvisor', 'fa5s fa5-trophy', 'fa5s fa5-truck', 'fa5s fa5-truck-loading', 'fa5s fa5-truck-monster', 'fa5s fa5-truck-moving', 'fa5s fa5-truck-pickup', 'fa5s fa5-tshirt', 'fa5s fa5-tty', 'fa5b fa5-tumblr', 'fa5b fa5-tumblr-square', 'fa5s fa5-tv', 'fa5b fa5-twitch', 'fa5b fa5-twitter', 'fa5b fa5-twitter-square', 'fa5b fa5-typo3', 'fa5b fa5-uber', 'fa5b fa5-ubuntu', 'fa5b fa5-uikit', 'fa5s fa5-umbrella', 'fa5s fa5-umbrella-beach', 'fa5s fa5-underline', 'fa5s fa5-undo', 'fa5s fa5-undo-alt', 'fa5b fa5-uniregistry', 'fa5s fa5-universal-access', 'fa5s fa5-university', 'fa5s fa5-unlink', 'fa5s fa5-unlock', 'fa5s fa5-unlock-alt', 'fa5b fa5-untappd', 'fa5s fa5-upload', 'fa5b fa5-ups', 'fa5b fa5-usb', 'fa5s fa5-user', 'fa5r fa5-user', 'fa5s fa5-user-alt', 'fa5s fa5-user-alt-slash', 'fa5s fa5-user-astronaut', 'fa5s fa5-user-check', 'fa5s fa5-user-circle', 'fa5r fa5-user-circle', 'fa5s fa5-user-clock', 'fa5s fa5-user-cog', 'fa5s fa5-user-edit', 'fa5s fa5-user-friends', 'fa5s fa5-user-graduate', 'fa5s fa5-user-injured', 'fa5s fa5-user-lock', 'fa5s fa5-user-md', 'fa5s fa5-user-minus', 'fa5s fa5-user-ninja', 'fa5s fa5-user-nurse', 'fa5s fa5-user-plus', 'fa5s fa5-user-secret', 'fa5s fa5-user-shield', 'fa5s fa5-user-slash', 'fa5s fa5-user-tag', 'fa5s fa5-user-tie', 'fa5s fa5-user-times', 'fa5s fa5-users', 'fa5s fa5-users-cog', 'fa5b fa5-usps', 'fa5b fa5-ussunnah', 'fa5s fa5-utensil-spoon', 'fa5s fa5-utensils', 'fa5b fa5-vaadin', 'fa5s fa5-vector-square', 'fa5s fa5-venus', 'fa5s fa5-venus-double', 'fa5s fa5-venus-mars', 'fa5b fa5-viacoin', 'fa5b fa5-viadeo', 'fa5b fa5-viadeo-square', 'fa5s fa5-vial', 'fa5s fa5-vials', 'fa5b fa5-viber', 'fa5s fa5-video', 'fa5s fa5-video-slash', 'fa5s fa5-vihara', 'fa5b fa5-vimeo', 'fa5b fa5-vimeo-square', 'fa5b fa5-vimeo-v', 'fa5b fa5-vine', 'fa5b fa5-vk', 'fa5b fa5-vnv', 'fa5s fa5-voicemail', 'fa5s fa5-volleyball-ball', 'fa5s fa5-volume-down', 'fa5s fa5-volume-mute', 'fa5s fa5-volume-off', 'fa5s fa5-volume-up', 'fa5s fa5-vote-yea', 'fa5s fa5-vr-cardboard', 'fa5b fa5-vuejs', 'fa5s fa5-walking', 'fa5s fa5-wallet', 'fa5s fa5-warehouse', 'fa5s fa5-water', 'fa5s fa5-wave-square', 'fa5b fa5-waze', 'fa5b fa5-weebly', 'fa5b fa5-weibo', 'fa5s fa5-weight', 'fa5s fa5-weight-hanging', 'fa5b fa5-weixin', 'fa5b fa5-whatsapp', 'fa5b fa5-whatsapp-square', 'fa5s fa5-wheelchair', 'fa5b fa5-whmcs', 'fa5s fa5-wifi', 'fa5b fa5-wikipedia-w', 'fa5s fa5-wind', 'fa5s fa5-window-close', 'fa5r fa5-window-close', 'fa5s fa5-window-maximize', 'fa5r fa5-window-maximize', 'fa5s fa5-window-minimize', 'fa5r fa5-window-minimize', 'fa5s fa5-window-restore', 'fa5r fa5-window-restore', 'fa5b fa5-windows', 'fa5s fa5-wine-bottle', 'fa5s fa5-wine-glass', 'fa5s fa5-wine-glass-alt', 'fa5b fa5-wix', 'fa5b fa5-wizards-of-the-coast', 'fa5b fa5-wolf-pack-battalion', 'fa5s fa5-won-sign', 'fa5b fa5-wordpress', 'fa5b fa5-wordpress-simple', 'fa5b fa5-wpbeginner', 'fa5b fa5-wpexplorer', 'fa5b fa5-wpforms', 'fa5b fa5-wpressr', 'fa5s fa5-wrench', 'fa5s fa5-x-ray', 'fa5b fa5-xbox', 'fa5b fa5-xing', 'fa5b fa5-xing-square', 'fa5b fa5-y-combinator', 'fa5b fa5-yahoo', 'fa5b fa5-yammer', 'fa5b fa5-yandex', 'fa5b fa5-yandex-international', 'fa5b fa5-yarn', 'fa5b fa5-yelp', 'fa5s fa5-yen-sign', 'fa5s fa5-yin-yang', 'fa5b fa5-yoast', 'fa5b fa5-youtube', 'fa5b fa5-youtube-square', 'fa5b fa5-zhihu');
				case 'elegant-font':
					return array('arrow_up', 'arrow_down', 'arrow_left', 'arrow_right', 'arrow_left-up', 'arrow_right-up', 'arrow_right-down', 'arrow_left-down', 'arrow-up-down', 'arrow_up-down_alt', 'arrow_left-right_alt', 'arrow_left-right', 'arrow_expand_alt2', 'arrow_expand_alt', 'arrow_condense', 'arrow_expand', 'arrow_move', 'arrow_carrot-up', 'arrow_carrot-down', 'arrow_carrot-left', 'arrow_carrot-right', 'arrow_carrot-2up', 'arrow_carrot-2down', 'arrow_carrot-2left', 'arrow_carrot-2right', 'arrow_carrot-up_alt2', 'arrow_carrot-down_alt2', 'arrow_carrot-left_alt2', 'arrow_carrot-right_alt2', 'arrow_carrot-2up_alt2', 'arrow_carrot-2down_alt2', 'arrow_carrot-2left_alt2', 'arrow_carrot-2right_alt2', 'arrow_triangle-up', 'arrow_triangle-down', 'arrow_triangle-left', 'arrow_triangle-right', 'arrow_triangle-up_alt2', 'arrow_triangle-down_alt2', 'arrow_triangle-left_alt2', 'arrow_triangle-right_alt2', 'arrow_back', 'icon_minus-06', 'icon_plus', 'icon_close', 'icon_check', 'icon_minus_alt2', 'icon_plus_alt2', 'icon_close_alt2', 'icon_check_alt2', 'icon_zoom-out_alt', 'icon_zoom-in_alt', 'icon_search', 'icon_box-empty', 'icon_box-selected', 'icon_minus-box', 'icon_plus-box', 'icon_box-checked', 'icon_circle-empty', 'icon_circle-slelected', 'icon_stop_alt2', 'icon_stop', 'icon_pause_alt2', 'icon_pause', 'icon_menu', 'icon_menu-square_alt2', 'icon_menu-circle_alt2', 'icon_ul', 'icon_ol', 'icon_adjust-horiz', 'icon_adjust-vert', 'icon_document_alt', 'icon_documents_alt', 'icon_pencil', 'icon_pencil-edit_alt', 'icon_pencil-edit', 'icon_folder-alt', 'icon_folder-open_alt', 'icon_folder-add_alt', 'icon_info_alt', 'icon_error-oct_alt', 'icon_error-circle_alt', 'icon_error-triangle_alt', 'icon_question_alt2', 'icon_question', 'icon_comment_alt', 'icon_chat_alt', 'icon_vol-mute_alt', 'icon_volume-low_alt', 'icon_volume-high_alt', 'icon_quotations', 'icon_quotations_alt2', 'icon_clock_alt', 'icon_lock_alt', 'icon_lock-open_alt', 'icon_key_alt', 'icon_cloud_alt', 'icon_cloud-upload_alt', 'icon_cloud-download_alt', 'icon_image', 'icon_images', 'icon_lightbulb_alt', 'icon_gift_alt', 'icon_house_alt', 'icon_genius', 'icon_mobile', 'icon_tablet', 'icon_laptop', 'icon_desktop', 'icon_camera_alt', 'icon_mail_alt', 'icon_cone_alt', 'icon_ribbon_alt', 'icon_bag_alt', 'icon_creditcard', 'icon_cart_alt', 'icon_paperclip', 'icon_tag_alt', 'icon_tags_alt', 'icon_trash_alt', 'icon_cursor_alt', 'icon_mic_alt', 'icon_compass_alt', 'icon_pin_alt', 'icon_pushpin_alt', 'icon_map_alt', 'icon_drawer_alt', 'icon_toolbox_alt', 'icon_book_alt', 'icon_calendar', 'icon_film', 'icon_table', 'icon_contacts_alt', 'icon_headphones', 'icon_lifesaver', 'icon_piechart', 'icon_refresh', 'icon_link_alt', 'icon_link', 'icon_loading', 'icon_blocked', 'icon_archive_alt', 'icon_heart_alt', 'icon_printer', 'icon_calulator', 'icon_building', 'icon_floppy', 'icon_drive', 'icon_search-2', 'icon_id', 'icon_id-2', 'icon_puzzle', 'icon_like', 'icon_dislike', 'icon_mug', 'icon_currency', 'icon_wallet', 'icon_pens', 'icon_easel', 'icon_flowchart', 'icon_datareport', 'icon_briefcase', 'icon_shield', 'icon_percent', 'icon_globe', 'icon_globe-2', 'icon_target', 'icon_hourglass', 'icon_balance', 'icon_star_alt', 'icon_star-half_alt', 'icon_star', 'icon_star-half', 'icon_tools', 'icon_tool', 'icon_cog', 'icon_cogs', 'arrow_up_alt', 'arrow_down_alt', 'arrow_left_alt', 'arrow_right_alt', 'arrow_left-up_alt', 'arrow_right-up_alt', 'arrow_right-down_alt', 'arrow_left-down_alt', 'arrow_condense_alt', 'arrow_expand_alt3', 'arrow_carrot_up_alt', 'arrow_carrot-down_alt', 'arrow_carrot-left_alt', 'arrow_carrot-right_alt', 'arrow_carrot-2up_alt', 'arrow_carrot-2dwnn_alt', 'arrow_carrot-2left_alt', 'arrow_carrot-2right_alt', 'arrow_triangle-up_alt', 'arrow_triangle-down_alt', 'arrow_triangle-left_alt', 'arrow_triangle-right_alt', 'icon_minus_alt', 'icon_plus_alt', 'icon_close_alt', 'icon_check_alt', 'icon_zoom-out', 'icon_zoom-in', 'icon_stop_alt', 'icon_menu-square_alt', 'icon_menu-circle_alt', 'icon_document', 'icon_documents', 'icon_pencil_alt', 'icon_folder', 'icon_folder-open', 'icon_folder-add', 'icon_folder_upload', 'icon_folder_download', 'icon_info', 'icon_error-circle', 'icon_error-oct', 'icon_error-triangle', 'icon_question_alt', 'icon_comment', 'icon_chat', 'icon_vol-mute', 'icon_volume-low', 'icon_volume-high', 'icon_quotations_alt', 'icon_clock', 'icon_lock', 'icon_lock-open', 'icon_key', 'icon_cloud', 'icon_cloud-upload', 'icon_cloud-download', 'icon_lightbulb', 'icon_gift', 'icon_house', 'icon_camera', 'icon_mail', 'icon_cone', 'icon_ribbon', 'icon_bag', 'icon_cart', 'icon_tag', 'icon_tags', 'icon_trash', 'icon_cursor', 'icon_mic', 'icon_compass', 'icon_pin', 'icon_pushpin', 'icon_map', 'icon_drawer', 'icon_toolbox', 'icon_book', 'icon_contacts', 'icon_archive', 'icon_heart', 'icon_profile', 'icon_group', 'icon_grid-2x2', 'icon_grid-3x3', 'icon_music', 'icon_pause_alt', 'icon_phone', 'icon_upload', 'icon_download', 'icon_rook', 'icon_printer-alt', 'icon_calculator_alt', 'icon_building_alt', 'icon_floppy_alt', 'icon_drive_alt', 'icon_search_alt', 'icon_id_alt', 'icon_id-2_alt', 'icon_puzzle_alt', 'icon_like_alt', 'icon_dislike_alt', 'icon_mug_alt', 'icon_currency_alt', 'icon_wallet_alt', 'icon_pens_alt', 'icon_easel_alt', 'icon_flowchart_alt', 'icon_datareport_alt', 'icon_briefcase_alt', 'icon_shield_alt', 'icon_percent_alt', 'icon_globe_alt', 'icon_clipboard', 'social_facebook', 'social_twitter', 'social_pinterest', 'social_googleplus', 'social_tumblr', 'social_tumbleupon', 'social_wordpress', 'social_instagram', 'social_dribbble', 'social_vimeo', 'social_linkedin', 'social_rss', 'social_deviantart', 'social_share', 'social_myspace', 'social_skype', 'social_youtube', 'social_picassa', 'social_googledrive', 'social_flickr', 'social_blogger', 'social_spotify', 'social_delicious', 'social_facebook_circle', 'social_twitter_circle', 'social_pinterest_circle', 'social_googleplus_circle', 'social_tumblr_circle', 'social_stumbleupon_circle', 'social_wordpress_circle', 'social_instagram_circle', 'social_dribbble_circle', 'social_vimeo_circle', 'social_linkedin_circle', 'social_rss_circle', 'social_deviantart_circle', 'social_share_circle', 'social_myspace_circle', 'social_skype_circle', 'social_youtube_circle', 'social_picassa_circle', 'social_googledrive_alt2', 'social_flickr_circle', 'social_blogger_circle', 'social_spotify_circle', 'social_delicious_circle', 'social_facebook_square', 'social_twitter_square', 'social_pinterest_square', 'social_googleplus_square', 'social_tumblr_square', 'social_stumbleupon_square', 'social_wordpress_square', 'social_instagram_square', 'social_dribbble_square', 'social_vimeo_square', 'social_linkedin_square', 'social_rss_square', 'social_deviantart_square', 'social_share_square', 'social_myspace_square', 'social_skype_square', 'social_youtube_square', 'social_picassa_square', 'social_googledrive_square', 'social_flickr_square', 'social_blogger_square', 'social_spotify_square', 'social_delicious_square');
				case 'ionicons':
					return array('ion-ionic', 'ion-arrow-up-a', 'ion-arrow-right-a', 'ion-arrow-down-a', 'ion-arrow-left-a', 'ion-arrow-up-b', 'ion-arrow-right-b', 'ion-arrow-down-b', 'ion-arrow-left-b', 'ion-arrow-up-c', 'ion-arrow-right-c', 'ion-arrow-down-c', 'ion-arrow-left-c', 'ion-arrow-return-right', 'ion-arrow-return-left', 'ion-arrow-swap', 'ion-arrow-shrink', 'ion-arrow-expand', 'ion-arrow-move', 'ion-arrow-resize', 'ion-chevron-up', 'ion-chevron-right', 'ion-chevron-down', 'ion-chevron-left', 'ion-navicon-round', 'ion-navicon', 'ion-drag', 'ion-log-in', 'ion-log-out', 'ion-checkmark-round', 'ion-checkmark', 'ion-checkmark-circled', 'ion-close-round', 'ion-close', 'ion-close-circled', 'ion-plus-round', 'ion-plus', 'ion-plus-circled', 'ion-minus-round', 'ion-minus', 'ion-minus-circled', 'ion-information', 'ion-information-circled', 'ion-help', 'ion-help-circled', 'ion-backspace-outline', 'ion-backspace', 'ion-help-buoy', 'ion-asterisk', 'ion-alert', 'ion-alert-circled', 'ion-refresh', 'ion-loop', 'ion-shuffle', 'ion-home', 'ion-search', 'ion-flag', 'ion-star', 'ion-heart', 'ion-heart-broken', 'ion-gear-a', 'ion-gear-b', 'ion-toggle-filled', 'ion-toggle', 'ion-settings', 'ion-wrench', 'ion-hammer', 'ion-edit', 'ion-trash-a', 'ion-trash-b', 'ion-document', 'ion-document-text', 'ion-clipboard', 'ion-scissors', 'ion-funnel', 'ion-bookmark', 'ion-email', 'ion-email-unread', 'ion-folder', 'ion-filing', 'ion-archive', 'ion-reply', 'ion-reply-all', 'ion-forward', 'ion-share', 'ion-paper-airplane', 'ion-link', 'ion-paperclip', 'ion-compose', 'ion-briefcase', 'ion-medkit', 'ion-at', 'ion-pound', 'ion-quote', 'ion-cloud', 'ion-upload', 'ion-more', 'ion-grid', 'ion-calendar', 'ion-clock', 'ion-compass', 'ion-pinpoint', 'ion-pin', 'ion-navigate', 'ion-location', 'ion-map', 'ion-lock-combination', 'ion-locked', 'ion-unlocked', 'ion-key', 'ion-arrow-graph-up-right', 'ion-arrow-graph-down-right', 'ion-arrow-graph-up-left', 'ion-arrow-graph-down-left', 'ion-stats-bars', 'ion-connection-bars', 'ion-pie-graph', 'ion-chatbubble', 'ion-chatbubble-working', 'ion-chatbubbles', 'ion-chatbox', 'ion-chatbox-working', 'ion-chatboxes', 'ion-person', 'ion-person-add', 'ion-person-stalker', 'ion-woman', 'ion-man', 'ion-female', 'ion-male', 'ion-transgender', 'ion-fork', 'ion-knife', 'ion-spoon', 'ion-soup-can-outline', 'ion-soup-can', 'ion-beer', 'ion-wineglass', 'ion-coffee', 'ion-icecream', 'ion-pizza', 'ion-power', 'ion-mouse', 'ion-battery-full', 'ion-battery-half', 'ion-battery-low', 'ion-battery-empty', 'ion-battery-charging', 'ion-wifi', 'ion-bluetooth', 'ion-calculator', 'ion-camera', 'ion-eye', 'ion-eye-disabled', 'ion-flash', 'ion-flash-off', 'ion-qr-scanner', 'ion-image', 'ion-images', 'ion-wand', 'ion-contrast', 'ion-aperture', 'ion-crop', 'ion-easel', 'ion-paintbrush', 'ion-paintbucket', 'ion-monitor', 'ion-laptop', 'ion-ipad', 'ion-iphone', 'ion-ipod', 'ion-printer', 'ion-usb', 'ion-outlet', 'ion-bug', 'ion-code', 'ion-code-working', 'ion-code-download', 'ion-fork-repo', 'ion-network', 'ion-pull-request', 'ion-merge', 'ion-xbox', 'ion-playstation', 'ion-steam', 'ion-closed-captioning', 'ion-videocamera', 'ion-film-marker', 'ion-disc', 'ion-headphone', 'ion-music-note', 'ion-radio-waves', 'ion-speakerphone', 'ion-mic-a', 'ion-mic-b', 'ion-mic-c', 'ion-volume-high', 'ion-volume-medium', 'ion-volume-low', 'ion-volume-mute', 'ion-levels', 'ion-play', 'ion-pause', 'ion-stop', 'ion-record', 'ion-skip-forward', 'ion-skip-backward', 'ion-eject', 'ion-bag', 'ion-card', 'ion-cash', 'ion-pricetag', 'ion-pricetags', 'ion-thumbsup', 'ion-thumbsdown', 'ion-happy-outline', 'ion-happy', 'ion-sad-outline', 'ion-sad', 'ion-bowtie', 'ion-tshirt-outline', 'ion-tshirt', 'ion-trophy', 'ion-podium', 'ion-ribbon-a', 'ion-ribbon-b', 'ion-university', 'ion-magnet', 'ion-beaker', 'ion-erlenmeyer-flask', 'ion-egg', 'ion-earth', 'ion-planet', 'ion-lightbulb', 'ion-cube', 'ion-leaf', 'ion-waterdrop', 'ion-flame', 'ion-fireball', 'ion-bonfire', 'ion-umbrella', 'ion-nuclear', 'ion-no-smoking', 'ion-thermometer', 'ion-speedometer', 'ion-model-s', 'ion-plane', 'ion-jet', 'ion-load-a', 'ion-load-b', 'ion-load-c', 'ion-load-d', 'undefined', 'ion-ios-ionic-outline', 'ion-ios-arrow-back', 'ion-ios-arrow-forward', 'ion-ios-arrow-up', 'ion-ios-arrow-right', 'ion-ios-arrow-down', 'ion-ios-arrow-left', 'ion-ios-arrow-thin-up', 'ion-ios-arrow-thin-right', 'ion-ios-arrow-thin-down', 'ion-ios-arrow-thin-left', 'ion-ios-circle-filled', 'ion-ios-circle-outline', 'ion-ios-checkmark-empty', 'ion-ios-checkmark-outline', 'ion-ios-checkmark', 'ion-ios-plus-empty', 'ion-ios-plus-outline', 'ion-ios-plus', 'ion-ios-close-empty', 'ion-ios-close-outline', 'ion-ios-close', 'ion-ios-minus-empty', 'ion-ios-minus-outline', 'ion-ios-minus', 'ion-ios-information-empty', 'ion-ios-information-outline', 'ion-ios-information', 'ion-ios-help-empty', 'ion-ios-help-outline', 'ion-ios-help', 'ion-ios-search', 'ion-ios-search-strong', 'ion-ios-star', 'ion-ios-star-half', 'ion-ios-star-outline', 'ion-ios-heart', 'ion-ios-heart-outline', 'ion-ios-more', 'ion-ios-more-outline', 'ion-ios-home', 'ion-ios-home-outline', 'ion-ios-cloud', 'ion-ios-cloud-outline', 'ion-ios-cloud-upload', 'ion-ios-cloud-upload-outline', 'ion-ios-cloud-download', 'ion-ios-cloud-download-outline', 'ion-ios-upload', 'ion-ios-upload-outline', 'ion-ios-download', 'ion-ios-download-outline', 'ion-ios-refresh', 'ion-ios-refresh-outline', 'ion-ios-refresh-empty', 'ion-ios-reload', 'ion-ios-loop-strong', 'ion-ios-loop', 'ion-ios-bookmarks', 'ion-ios-bookmarks-outline', 'ion-ios-book', 'ion-ios-book-outline', 'ion-ios-flag', 'ion-ios-flag-outline', 'ion-ios-glasses', 'ion-ios-glasses-outline', 'ion-ios-browsers', 'ion-ios-browsers-outline', 'ion-ios-at', 'ion-ios-at-outline', 'ion-ios-pricetag', 'ion-ios-pricetag-outline', 'ion-ios-pricetags', 'ion-ios-pricetags-outline', 'ion-ios-cart', 'ion-ios-cart-outline', 'ion-ios-chatboxes', 'ion-ios-chatboxes-outline', 'ion-ios-chatbubble', 'ion-ios-chatbubble-outline', 'ion-ios-cog', 'ion-ios-cog-outline', 'ion-ios-gear', 'ion-ios-gear-outline', 'ion-ios-settings', 'ion-ios-settings-strong', 'ion-ios-toggle', 'ion-ios-toggle-outline', 'ion-ios-analytics', 'ion-ios-analytics-outline', 'ion-ios-pie', 'ion-ios-pie-outline', 'ion-ios-pulse', 'ion-ios-pulse-strong', 'ion-ios-filing', 'ion-ios-filing-outline', 'ion-ios-box', 'ion-ios-box-outline', 'ion-ios-compose', 'ion-ios-compose-outline', 'ion-ios-trash', 'ion-ios-trash-outline', 'ion-ios-copy', 'ion-ios-copy-outline', 'ion-ios-email', 'ion-ios-email-outline', 'ion-ios-undo', 'ion-ios-undo-outline', 'ion-ios-redo', 'ion-ios-redo-outline', 'ion-ios-paperplane', 'ion-ios-paperplane-outline', 'ion-ios-folder', 'ion-ios-folder-outline', 'ion-ios-paper', 'ion-ios-paper-outline', 'ion-ios-list', 'ion-ios-list-outline', 'ion-ios-world', 'ion-ios-world-outline', 'ion-ios-alarm', 'ion-ios-alarm-outline', 'ion-ios-speedometer', 'ion-ios-speedometer-outline', 'ion-ios-stopwatch', 'ion-ios-stopwatch-outline', 'ion-ios-timer', 'ion-ios-timer-outline', 'ion-ios-clock', 'ion-ios-clock-outline', 'ion-ios-time', 'ion-ios-time-outline', 'ion-ios-calendar', 'ion-ios-calendar-outline', 'ion-ios-photos', 'ion-ios-photos-outline', 'ion-ios-albums', 'ion-ios-albums-outline', 'ion-ios-camera', 'ion-ios-camera-outline', 'ion-ios-reverse-camera', 'ion-ios-reverse-camera-outline', 'ion-ios-eye', 'ion-ios-eye-outline', 'ion-ios-bolt', 'ion-ios-bolt-outline', 'ion-ios-color-wand', 'ion-ios-color-wand-outline', 'ion-ios-color-filter', 'ion-ios-color-filter-outline', 'ion-ios-grid-view', 'ion-ios-grid-view-outline', 'ion-ios-crop-strong', 'ion-ios-crop', 'ion-ios-barcode', 'ion-ios-barcode-outline', 'ion-ios-briefcase', 'ion-ios-briefcase-outline', 'ion-ios-medkit', 'ion-ios-medkit-outline', 'ion-ios-medical', 'ion-ios-medical-outline', 'ion-ios-infinite', 'ion-ios-infinite-outline', 'ion-ios-calculator', 'ion-ios-calculator-outline', 'ion-ios-keypad', 'ion-ios-keypad-outline', 'ion-ios-telephone', 'ion-ios-telephone-outline', 'ion-ios-drag', 'ion-ios-location', 'ion-ios-location-outline', 'ion-ios-navigate', 'ion-ios-navigate-outline', 'ion-ios-locked', 'ion-ios-locked-outline', 'ion-ios-unlocked', 'ion-ios-unlocked-outline', 'ion-ios-monitor', 'ion-ios-monitor-outline', 'ion-ios-printer', 'ion-ios-printer-outline', 'ion-ios-game-controller-a', 'ion-ios-game-controller-a-outline', 'ion-ios-game-controller-b', 'ion-ios-game-controller-b-outline', 'ion-ios-americanfootball', 'ion-ios-americanfootball-outline', 'ion-ios-baseball', 'ion-ios-baseball-outline', 'ion-ios-basketball', 'ion-ios-basketball-outline', 'ion-ios-tennisball', 'ion-ios-tennisball-outline', 'ion-ios-football', 'ion-ios-football-outline', 'ion-ios-body', 'ion-ios-body-outline', 'ion-ios-person', 'ion-ios-person-outline', 'ion-ios-personadd', 'ion-ios-personadd-outline', 'ion-ios-people', 'ion-ios-people-outline', 'ion-ios-musical-notes', 'ion-ios-musical-note', 'ion-ios-bell', 'ion-ios-bell-outline', 'ion-ios-mic', 'ion-ios-mic-outline', 'ion-ios-mic-off', 'ion-ios-volume-high', 'ion-ios-volume-low', 'ion-ios-play', 'ion-ios-play-outline', 'ion-ios-pause', 'ion-ios-pause-outline', 'ion-ios-recording', 'ion-ios-recording-outline', 'ion-ios-fastforward', 'ion-ios-fastforward-outline', 'ion-ios-rewind', 'ion-ios-rewind-outline', 'ion-ios-skipbackward', 'ion-ios-skipbackward-outline', 'ion-ios-skipforward', 'ion-ios-skipforward-outline', 'ion-ios-shuffle-strong', 'ion-ios-shuffle', 'ion-ios-videocam', 'ion-ios-videocam-outline', 'ion-ios-film', 'ion-ios-film-outline', 'ion-ios-flask', 'ion-ios-flask-outline', 'ion-ios-lightbulb', 'ion-ios-lightbulb-outline', 'ion-ios-wineglass', 'ion-ios-wineglass-outline', 'ion-ios-pint', 'ion-ios-pint-outline', 'ion-ios-nutrition', 'ion-ios-nutrition-outline', 'ion-ios-flower', 'ion-ios-flower-outline', 'ion-ios-rose', 'ion-ios-rose-outline', 'ion-ios-paw', 'ion-ios-paw-outline', 'ion-ios-flame', 'ion-ios-flame-outline', 'ion-ios-sunny', 'ion-ios-sunny-outline', 'ion-ios-partlysunny', 'ion-ios-partlysunny-outline', 'ion-ios-cloudy', 'ion-ios-cloudy-outline', 'ion-ios-rainy', 'ion-ios-rainy-outline', 'ion-ios-thunderstorm', 'ion-ios-thunderstorm-outline', 'ion-ios-snowy', 'ion-ios-moon', 'ion-ios-moon-outline', 'ion-ios-cloudy-night', 'ion-ios-cloudy-night-outline', 'undefined', 'ion-android-arrow-up', 'ion-android-arrow-forward', 'ion-android-arrow-down', 'ion-android-arrow-back', 'ion-android-arrow-dropup', 'ion-android-arrow-dropup-circle', 'ion-android-arrow-dropright', 'ion-android-arrow-dropright-circle', 'ion-android-arrow-dropdown', 'ion-android-arrow-dropdown-circle', 'ion-android-arrow-dropleft', 'ion-android-arrow-dropleft-circle', 'ion-android-add', 'ion-android-add-circle', 'ion-android-remove', 'ion-android-remove-circle', 'ion-android-close', 'ion-android-cancel', 'ion-android-radio-button-off', 'ion-android-radio-button-on', 'ion-android-checkmark-circle', 'ion-android-checkbox-outline-blank', 'ion-android-checkbox-outline', 'ion-android-checkbox-blank', 'ion-android-checkbox', 'ion-android-done', 'ion-android-done-all', 'ion-android-menu', 'ion-android-more-horizontal', 'ion-android-more-vertical', 'ion-android-refresh', 'ion-android-sync', 'ion-android-wifi', 'ion-android-call', 'ion-android-apps', 'ion-android-settings', 'ion-android-options', 'ion-android-funnel', 'ion-android-search', 'ion-android-home', 'ion-android-cloud-outline', 'ion-android-cloud', 'ion-android-download', 'ion-android-upload', 'ion-android-cloud-done', 'ion-android-cloud-circle', 'ion-android-favorite-outline', 'ion-android-favorite', 'ion-android-star-outline', 'ion-android-star-half', 'ion-android-star', 'ion-android-calendar', 'ion-android-alarm-clock', 'ion-android-time', 'ion-android-stopwatch', 'ion-android-watch', 'ion-android-locate', 'ion-android-navigate', 'ion-android-pin', 'ion-android-compass', 'ion-android-map', 'ion-android-walk', 'ion-android-bicycle', 'ion-android-car', 'ion-android-bus', 'ion-android-subway', 'ion-android-train', 'ion-android-boat', 'ion-android-plane', 'ion-android-restaurant', 'ion-android-bar', 'ion-android-cart', 'ion-android-camera', 'ion-android-image', 'ion-android-film', 'ion-android-color-palette', 'ion-android-create', 'ion-android-mail', 'ion-android-drafts', 'ion-android-send', 'ion-android-archive', 'ion-android-delete', 'ion-android-attach', 'ion-android-share', 'ion-android-share-alt', 'ion-android-bookmark', 'ion-android-document', 'ion-android-clipboard', 'ion-android-list', 'ion-android-folder-open', 'ion-android-folder', 'ion-android-print', 'ion-android-open', 'ion-android-exit', 'ion-android-contract', 'ion-android-expand', 'ion-android-globe', 'ion-android-chat', 'ion-android-textsms', 'ion-android-hangout', 'ion-android-happy', 'ion-android-sad', 'ion-android-person', 'ion-android-people', 'ion-android-person-add', 'ion-android-contact', 'ion-android-contacts', 'ion-android-playstore', 'ion-android-lock', 'ion-android-unlock', 'ion-android-microphone', 'ion-android-microphone-off', 'ion-android-notifications-none', 'ion-android-notifications', 'ion-android-notifications-off', 'ion-android-volume-mute', 'ion-android-volume-down', 'ion-android-volume-up', 'ion-android-volume-off', 'ion-android-hand', 'ion-android-desktop', 'ion-android-laptop', 'ion-android-phone-portrait', 'ion-android-phone-landscape', 'ion-android-bulb', 'ion-android-sunny', 'ion-android-alert', 'ion-android-warning', 'undefined', 'ion-social-twitter', 'ion-social-twitter-outline', 'ion-social-facebook', 'ion-social-facebook-outline', 'ion-social-googleplus', 'ion-social-googleplus-outline', 'ion-social-google', 'ion-social-google-outline', 'ion-social-dribbble', 'ion-social-dribbble-outline', 'ion-social-octocat', 'ion-social-github', 'ion-social-github-outline', 'ion-social-instagram', 'ion-social-instagram-outline', 'ion-social-whatsapp', 'ion-social-whatsapp-outline', 'ion-social-snapchat', 'ion-social-snapchat-outline', 'ion-social-foursquare', 'ion-social-foursquare-outline', 'ion-social-pinterest', 'ion-social-pinterest-outline', 'ion-social-rss', 'ion-social-rss-outline', 'ion-social-tumblr', 'ion-social-tumblr-outline', 'ion-social-wordpress', 'ion-social-wordpress-outline', 'ion-social-reddit', 'ion-social-reddit-outline', 'ion-social-hackernews', 'ion-social-hackernews-outline', 'ion-social-designernews', 'ion-social-designernews-outline', 'ion-social-yahoo', 'ion-social-yahoo-outline', 'ion-social-buffer', 'ion-social-buffer-outline', 'ion-social-skype', 'ion-social-skype-outline', 'ion-social-linkedin', 'ion-social-linkedin-outline', 'ion-social-vimeo', 'ion-social-vimeo-outline', 'ion-social-twitch', 'ion-social-twitch-outline', 'ion-social-youtube', 'ion-social-youtube-outline', 'ion-social-dropbox', 'ion-social-dropbox-outline', 'ion-social-apple', 'ion-social-apple-outline', 'ion-social-android', 'ion-social-android-outline', 'ion-social-windows', 'ion-social-windows-outline', 'ion-social-html5', 'ion-social-html5-outline', 'ion-social-css3', 'ion-social-css3-outline', 'ion-social-javascript', 'ion-social-javascript-outline', 'ion-social-angular', 'ion-social-angular-outline', 'ion-social-nodejs', 'ion-social-sass', 'ion-social-python', 'ion-social-chrome', 'ion-social-chrome-outline', 'ion-social-codepen', 'ion-social-codepen-outline', 'ion-social-markdown', 'ion-social-tux', 'ion-social-freebsd-devil', 'ion-social-usd', 'ion-social-usd-outline', 'ion-social-bitcoin', 'ion-social-bitcoin-outline', 'ion-social-yen', 'ion-social-yen-outline', 'ion-social-euro', 'ion-social-euro-outline');
				case 'simpleline':
					return array('icon-user', 'icon-people', 'icon-user-female', 'icon-user-follow', 'icon-user-following', 'icon-user-unfollow', 'icon-login', 'icon-logout', 'icon-emotsmile', 'icon-phone', 'icon-call-end', 'icon-call-in', 'icon-call-out', 'icon-map', 'icon-location-pin', 'icon-direction', 'icon-directions', 'icon-compass', 'icon-layers', 'icon-menu', 'icon-list', 'icon-options-vertical', 'icon-options', 'icon-arrow-down', 'icon-arrow-left', 'icon-arrow-right', 'icon-arrow-up', 'icon-arrow-up-circle', 'icon-arrow-left-circle', 'icon-arrow-right-circle', 'icon-arrow-down-circle', 'icon-check', 'icon-clock', 'icon-plus', 'icon-minus', 'icon-close', 'icon-event', 'icon-exclamation', 'icon-organization', 'icon-trophy', 'icon-screen-smartphone', 'icon-screen-desktop', 'icon-plane', 'icon-notebook', 'icon-mustache', 'icon-mouse', 'icon-magnet', 'icon-energy', 'icon-disc', 'icon-cursor', 'icon-cursor-move', 'icon-crop', 'icon-chemistry', 'icon-speedometer', 'icon-shield', 'icon-screen-tablet', 'icon-magic-wand', 'icon-hourglass', 'icon-graduation', 'icon-ghost', 'icon-game-controller', 'icon-fire', 'icon-eyeglass', 'icon-envelope-open', 'icon-envelope-letter', 'icon-bell', 'icon-badge', 'icon-anchor', 'icon-wallet', 'icon-vector', 'icon-speech', 'icon-puzzle', 'icon-printer', 'icon-present', 'icon-playlist', 'icon-pin', 'icon-picture', 'icon-handbag', 'icon-globe-alt', 'icon-globe', 'icon-folder-alt', 'icon-folder', 'icon-film', 'icon-feed', 'icon-drop', 'icon-drawer', 'icon-docs', 'icon-doc', 'icon-diamond', 'icon-cup', 'icon-calculator', 'icon-bubbles', 'icon-briefcase', 'icon-book-open', 'icon-basket-loaded', 'icon-basket', 'icon-bag', 'icon-action-undo', 'icon-action-redo', 'icon-wrench', 'icon-umbrella', 'icon-trash', 'icon-tag', 'icon-support', 'icon-frame', 'icon-size-fullscreen', 'icon-size-actual', 'icon-shuffle', 'icon-share-alt', 'icon-share', 'icon-rocket', 'icon-question', 'icon-pie-chart', 'icon-pencil', 'icon-note', 'icon-loop', 'icon-home', 'icon-grid', 'icon-graph', 'icon-microphone', 'icon-music-tone-alt', 'icon-music-tone', 'icon-earphones-alt', 'icon-earphones', 'icon-equalizer', 'icon-like', 'icon-dislike', 'icon-control-start', 'icon-control-rewind', 'icon-control-play', 'icon-control-pause', 'icon-control-forward', 'icon-control-end', 'icon-volume-1', 'icon-volume-2', 'icon-volume-off', 'icon-calendar', 'icon-bulb', 'icon-chart', 'icon-ban', 'icon-bubble', 'icon-camrecorder', 'icon-camera', 'icon-cloud-download', 'icon-cloud-upload', 'icon-envelope', 'icon-eye', 'icon-flag', 'icon-heart', 'icon-info', 'icon-key', 'icon-link', 'icon-lock', 'icon-lock-open', 'icon-magnifier', 'icon-magnifier-add', 'icon-magnifier-remove', 'icon-paper-clip', 'icon-paper-plane', 'icon-power', 'icon-refresh', 'icon-reload', 'icon-settings', 'icon-star', 'icon-symbol-female', 'icon-symbol-male', 'icon-target', 'icon-credit-card', 'icon-paypal', 'icon-social-tumblr', 'icon-social-twitter', 'icon-social-facebook', 'icon-social-instagram', 'icon-social-linkedin', 'icon-social-pinterest', 'icon-social-github', 'icon-social-google', 'icon-social-reddit', 'icon-social-skype', 'icon-social-dribbble', 'icon-social-behance', 'icon-social-foursqare', 'icon-social-soundcloud', 'icon-social-spotify', 'icon-social-stumbleupon', 'icon-social-youtube', 'icon-social-dropbox', 'icon-social-vkontakte', 'icon-social-steam');
				case 'gdlr-custom-icon':
					return array('gdlr-icon-oblique-arrow', 'gdlr-icon-muscle', 'gdlr-icon-passport', 'gdlr-icon-receptionist', 'gdlr-icon-breakfast', 'gdlr-icon-electric-kettle', 'gdlr-icon-sofa', 'gdlr-icon-lamp', 'gdlr-icon-swimming-pool', 'gdlr-icon-door-handle', 'gdlr-icon-double-bed', 'gdlr-icon-heater', 'gdlr-icon-bathtub', 'gdlr-icon-bell', 'gdlr-icon-room-service', 'gdlr-icon-elevator', 'gdlr-icon-door-hanger', 'gdlr-icon-exit', 'gdlr-icon-taxi', 'gdlr-icon-door', 'gdlr-icon-spoon', 'gdlr-icon-menu', 'gdlr-icon-safe-box', 'gdlr-icon-no-smoking', 'gdlr-icon-shower-head', 'gdlr-icon-iron', 'gdlr-icon-bellboy', 'gdlr-icon-towel', 'gdlr-icon-luggage', 'gdlr-icon-slippers', 'gdlr-icon-double-bed1', 'gdlr-icon-room-key', 'gdlr-icon-chef', 'gdlr-icon-television', 'gdlr-icon-receptionist1', 'gdlr-icon-wifi-connection', 'gdlr-icon-maid', 'gdlr-icon-hotel', 'gdlr-icon-hair-dryer', 'gdlr-icon-washing-machine', 'gdlr-icon-hotel-cart', 'gdlr-icon-hotel1', 'gdlr-icon-fire-extinguisher', 'gdlr-icon-no-pets', 'gdlr-icon-telephone', 'gdlr-icon-mini', 'gdlr-icon-security-camera', 'gdlr-icon-baby-crib', 'gdlr-icon-air-conditioner', 'gdlr-icon-food-tray', 'gdlr-icon-bathrobe', 'gdlr-icon-air-conditioner1', 'gdlr-icon-airplane', 'gdlr-icon-bathtub1', 'gdlr-icon-car', 'gdlr-icon-city-1', 'gdlr-icon-city', 'gdlr-icon-cityscape', 'gdlr-icon-clock', 'gdlr-icon-concierge', 'gdlr-icon-dish', 'gdlr-icon-double-bed2', 'gdlr-icon-egg-and-bacon', 'gdlr-icon-food-service-copy', 'gdlr-icon-food-service', 'gdlr-icon-garden', 'gdlr-icon-group', 'gdlr-icon-hair-dryer1', 'gdlr-icon-hotel-cart1', 'gdlr-icon-iron1', 'gdlr-icon-massage', 'gdlr-icon-nature', 'gdlr-icon-no-smoking1', 'gdlr-icon-oil-heater-1', 'gdlr-icon-oil-heater', 'gdlr-icon-paper-plane-1', 'gdlr-icon-paper-plane', 'gdlr-icon-plane-1', 'gdlr-icon-plane-copy', 'gdlr-icon-plane', 'gdlr-icon-play-button', 'gdlr-icon-resize', 'gdlr-icon-safe-box1', 'gdlr-icon-shower', 'gdlr-icon-small-plane', 'gdlr-icon-swimming-pool1', 'gdlr-icon-toilet', 'gdlr-icon-umbrella', 'gdlr-icon-vacations', 'gdlr-icon-washing-machine1', 'gdlr-icon-watch-tv', 'gdlr-icon-weights', 'gdlr-icon-wheelchair-1', 'gdlr-icon-wheelchair-2', 'gdlr-icon-wheelchair-3', 'gdlr-icon-wheelchair', 'gdlr-icon-wifi-signal', 'gdlr-icon-workspace', 'gdlr-icon-parking');
				case 'gdlr-cannabis': 
					return array('gdl-cannabis-chocolate', 'gdl-cannabis-heart-rate', 'gdl-cannabis-bag', 'gdl-cannabis-cancer', 'gdl-cannabis-molecule', 'gdl-cannabis-Marijuana', 'gdl-cannabis-olive-oil', 'gdl-cannabis-diagram', 'gdl-cannabis-bong', 'gdl-cannabis-bud', 'gdl-cannabis-cupcake', 'gdl-cannabis-heart', 'gdl-cannabis-candy', 'gdl-cannabis-brownie', 'gdl-cannabis-cream', 'gdl-cannabis-online', 'gdl-cannabis-scales', 'gdl-cannabis-certification', 'gdl-cannabis-pipe', 'gdl-cannabis-book', 'gdl-cannabis-pills', 'gdl-cannabis-greenhouse', 'gdl-cannabis-placeholder', 'gdl-cannabis-cultivation', 'gdl-cannabis-can', 'gdl-cannabis-vape', 'gdl-cannabis-cookies', 'gdl-cannabis-oil', 'gdl-cannabis-hydrophonics', 'gdl-cannabis-medicine', 'gdl-cannabis-magnifying-glass', 'gdl-cannabis-Marijuana1', 'gdl-cannabis-sleep', 'gdl-cannabis-Marijuana2', 'gdl-cannabis-shop', 'gdl-cannabis-shopping-bag', 'gdl-cannabis-tea', 'gdl-cannabis-extraction', 'gdl-cannabis-joint', 'gdl-cannabis-legal', 'gdl-cannabis-medal', 'gdl-cannabis-cigar', 'gdl-cannabis-flask', 'gdl-cannabis-tincture', 'gdl-cannabis-stethoscope', 'gdl-cannabis-no-thc', 'gdl-cannabis-card', 'gdl-cannabis-prescription', 'gdl-cannabis-body-lotion', 'gdl-cannabis-inhaler', 'gdl-cannabis-cannabis-oil', 'gdl-cannabis-research', 'gdl-cannabis-scales1', 'gdl-cannabis-seeds', 'gdl-cannabis-serum', 'gdl-cannabis-stock', 'gdl-cannabis-store', 'gdl-cannabis-t-shirt', 'gdl-cannabis-tea1', 'gdl-cannabis-test-tube', 'gdl-cannabis-watering', 'gdl-cannabis-lips', 'gdl-cannabis-cannabis-law', 'gdl-cannabis-slow', 'gdl-cannabis-bored', 'gdl-cannabis-leaf', 'gdl-cannabis-bong1', 'gdl-cannabis-chocolate1', 'gdl-cannabis-cream1', 'gdl-cannabis-cupcake1', 'gdl-cannabis-delivery-truck', 'gdl-cannabis-cold-drink', 'gdl-cannabis-medicine1', 'gdl-cannabis-planting', 'gdl-cannabis-growing-plant', 'gdl-cannabis-envelope', 'gdl-cannabis-pot', 'gdl-cannabis-body-lotion1', 'gdl-cannabis-medical', 'gdl-cannabis-medical1');
				case 'gdlr-travel':
					return array('gdl-travel-invoice-1', 'gdl-travel-padlock', 'gdl-travel-location-1', 'gdl-travel-technical-support-2', 'gdl-travel-hotel-4', 'gdl-travel-shopping-cart', 'gdl-travel-send', 'gdl-travel-internet', 'gdl-travel-optimization', 'gdl-travel-mechanics', 'gdl-travel-clock', 'gdl-travel-improvement', 'gdl-travel-information-4', 'gdl-travel-price-tag', 'gdl-travel-cogwheel', 'gdl-travel-invoice-11', 'gdl-travel-clock1', 'gdl-travel-smiley', 'gdl-travel-filter-1', 'gdl-travel-captcha-1', 'gdl-travel-chat', 'gdl-travel-map-4', 'gdl-travel-percentage-1', 'gdl-travel-price-tag1', 'gdl-travel-sound-mixer-1', 'gdl-travel-coupon', 'gdl-travel-travel', 'gdl-travel-date', 'gdl-travel-pay-per-click', 'gdl-travel-piggy-bank', 'gdl-travel-calendar', 'gdl-travel-transfer', 'gdl-travel-stock', 'gdl-travel-account', 'gdl-travel-fi-rs-map-marker', 'gdl-travel-account1', 'gdl-travel-location', 'gdl-travel-and-tourism', 'gdl-travel-plane', 'gdl-travel-washing-machine-1', 'gdl-travel-concierge-1', 'gdl-travel-swimming-pool-2', 'gdl-travel-food-service-1', 'gdl-travel-dish-1', 'gdl-travel-hair-dryer-1', 'gdl-travel-telephone-1', 'gdl-travel-oil-heater-1-1', 'gdl-travel-air-conditioner-1', 'gdl-travel-shower-1', 'gdl-travel-swimming-pool-1', 'gdl-travel-parking-1', 'gdl-travel-Frame-5781', 'gdl-travel-wifi-signal-2', 'gdl-travel-massage-1', 'gdl-travel-fi-rs-building', 'gdl-travel-fi-rs-mountains', 'gdl-travel-blueprint-1', 'gdl-travel-XMLID_874', 'gdl-travel-safe-box-1', 'gdl-travel-watch-tv-1', 'gdl-travel-video-call', 'gdl-travel-picture', 'gdl-travel-mail', 'gdl-travel-star', 'gdl-travel-hang-up', 'gdl-travel-thumbs-up', 'gdl-travel-lifebuoy', 'gdl-travel-calendar1', 'gdl-travel-wifi', 'gdl-travel-user', 'gdl-travel-45-minutes');
			}
		}
	}