<?php 
	/*	
	*	Goodlayers Getting Start Page
	*	---------------------------------------------------------------------
	*	This file that creates getting start page
	*	---------------------------------------------------------------------
	*/	

	if( class_exists('gdlr_core_getting_start') ){
		new gdlr_core_getting_start(array(
			'parent-slug' => 'goodlayers_main_menu',
			'page-title' => esc_html__('Getting Start / Import', 'infinite'),
			'menu-title' => esc_html__('Getting Start / Import', 'infinite'),
			'capability' => 'edit_theme_options'
		));
	}

	add_filter('gdlr_core_getting_start_option', 'infinite_gdlr_core_getting_start_option', 10, 2);
	if( !function_exists('infinite_gdlr_core_getting_start_option') ){
		function infinite_gdlr_core_getting_start_option( $options, $slug ){
			if( $slug == 'gdlr_core_getting_start' ){

				$content = array();

				// install plugins link
				$plugins_complete = infinite_tgmpa_complete();
				if( !$plugins_complete ){
					$content['required-plugins'] = array(
						'title' => esc_html__('Required Plugins', 'infinite'),
						'type' => 'page',
						'content' => '<p>' . wp_kses(__('<strong>Before moving on, please make sure that all required plugins are installed and activated</strong><br>This is very important step to make the theme run properly.', 'infinite'), array('strong'=>array(), 'br'=>array()) ) . 
							'</p><a class="gdlr-core-button" href="' . esc_attr(menu_page_url('tgmpa-install-plugins', false)) . '" >' . esc_html__('Install Required Plugins', 'infinite') . '</a>' .
							'<h3>' . esc_html__('1. Install plugins then click on \'Return To Require Plugins Installer', 'infinite') . '</h3><img src="' . esc_url(get_template_directory_uri() . '/images/getting-start/require-plugin1.jpg') . '" alt="infinite" />' .
							'<h3>' . esc_html__('2. Activate plugins', 'infinite') . '</h3><img src="' . esc_url(get_template_directory_uri() . '/images/getting-start/require-plugin2.jpg') . '" alt="' . esc_attr__('Required Plugin', 'infinite') . '" />'
					);
				}

				// guidelines
				$content['guidelines'] = array(
					'title' => esc_html__('Guidelines', 'infinite'),
					'type' => 'page',
					'content' => 
						wp_kses(__('<h4>1.) Installation</h4>', 'infinite'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/_b6dpkJImuY" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>2.) Importing Demo</h4>', 'infinite'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/3YmMFTXiWZU" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>3.) Creating Portfolio</h4>', 'infinite'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/XFrtHJuPW_4" frameborder="0" allowfullscreen></iframe>' . 
						wp_kses(__('<h4>4.) Creating Personnel</h4>', 'infinite'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/MwFxxSlYuAA" frameborder="0" allowfullscreen></iframe>' . 
						wp_kses(__('<h4>5.) Creating Blog</h4>', 'infinite'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/fqcdMzTjvrE" frameborder="0" allowfullscreen></iframe>' .
						wp_kses(__('<h4>6.) Goodlayers Page Builder</h4>', 'infinite'), array('h4'=>array())) . '<iframe width="560" height="315" src="https://www.youtube.com/embed/N0haJbDM8ac" frameborder="0" allowfullscreen></iframe>'
				);

				// import demo
				$content['import-demo'] = array(
					'title' => esc_html__('Import Demo', 'infinite'),
					'type' => 'demo',
					'content' => wp_kses(__('<strong>Get import error?</strong> Please make sure that your server has PHP max_execution_time at least 300, memory_limit at least 512MB. You may set these values temporaly and change it back after finish importing.<br><strong>If you\'re importing main demo (Full Version), PHP max_input_vars is recommended to be at least 4000</strong>', 'infinite'), array('strong'=>array(), 'br'=>array())),
					'demo-content' => wp_kses(
						__('<strong>Main demo (Full verion)</strong> - include all pages shown in demo such as elements, features, about us, services contact, all portfolio pages, all blog pages. It\'s 100+ pages and 170+ images in total.', 'infinite') . '<br><br>' . 
						__('<strong>Main demo (Lite verion)</strong> - include about us, services, few portfolios, few blog pages. Element and feature page are not included.', 'infinite') . '<br><br>' . 
						__('Please also be cautious that over 1000+ images will be generated in main demo.', 'infinite'), 
						array('strong'=>array(), 'br'=>array())),
				);

				// system status
				$content['system-status'] = array(
					'title' => esc_html__('System Status', 'infinite'),
					'type' => 'system-status',
					'content' => wp_kses(__('<strong>To import demo content</strong>, PHP max_execution_time at least 300 secs and  memory_limit at least 512MB is recommended. <strong><br>If you\'re importing main demo (Full Version)</strong>, PHP max_input_vars is recommended to be at least 4000.', 'infinite'), array('strong'=>array(), 'br'=>array()))
				);

				// obtain product validation link
				if( !empty($GLOBALS['tgmpa']) ){
					$plugin_slug = 'envato-market';
					$plugin_url = 'envato-market';
					$product_validation_url = infinite_tgmpa_auto_install_url($plugin_slug,  $plugin_url);

					$tgmpa = call_user_func(array(get_class($GLOBALS['tgmpa']), 'get_instance'));
					if( !$tgmpa->is_plugin_installed($plugin_slug) ){
						$content['get-automatic-updates'] = array(
							'title' => esc_html__('Get Automatic Updates', 'infinite'),
							'type' => 'page',
							'content' => wp_kses(__('<p><strong>To get automatic updates, you need to install and activate the plugin \'Envato Market\'</strong>.<br>You\'ll also need API Personal Token for verification. Please read for instruction in plugin settings.</p>', 'infinite'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
								'<a class="gdlr-core-button" href="' . esc_url($product_validation_url) . '" >' . esc_html__('Get envato market plugin now!', 'infinite') . '</a>'
						);
					}else{
						$content['get-automatic-updates'] = array(
							'title' => esc_html__('Get Automatic Updates', 'infinite'),
							'type' => 'page',
							'content' => wp_kses(__('<p><strong>To get automatic updates</strong>, you need to fill the infomation in \'Envato Market\' plugin page.<br>You need to retrieve API Personal Token for verification. Please read for instruction in plugin settings.</p>', 'infinite'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
								'<a class="gdlr-core-button" href="' . esc_url($product_validation_url) . '" >' . esc_html__('Go to plugin settings!', 'infinite') . '</a>'
						);
					}
				}

				// support
				$content['support'] = array(
					'title' => esc_html__('Support', 'infinite'),
					'type' => 'page',
					'content' => wp_kses(__('<p><strong>Have questions about how to use the theme?</strong></p><p>Make sure that you read all through the document we provided. The document is contained in main package that you downloaded from Themeforest. It\'s in the folder \'Document-Instruction\', open the file \'index.html\' with your browser. Or you can view online document here.</p>', 'infinite'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) . 
						'<a class="gdlr-core-button" target="_blank" href="#" >' . esc_html__('View Online Document', 'infinite') . '</a><br><br>' .
						wp_kses(__('<p><strong>Have problems or can\'t find answer in the document?</strong></p><p>1. Make sure that you are running the latest version of the theme.<br>2. Make sure that you deeply checked theme\'s instruction and try to search for public tickets in case of someone else asked the same question before. <br> 3. Try to deactivate all plugins (Except Goodlayers plugins) and see if the problem resolved or not.</p>', 'infinite'), array('strong'=>array(), 'br'=>array(), 'p'=> array()) ) .
						wp_kses(sprintf(__('<p>After doing these steps and still see the problem, feel free to submit tickets in our support website. Our supporter are happy to help you.<br><strong>Please note that you will need Purchase code to submit the ticket</strong> - <a href="%s" target="_blank" >How to get purchased code?</a></p>', 'infinite'), 'https://help.market.envato.com/hc/en-us/articles/202822600'), array('strong'=>array(), 'br'=>array(), 'p'=> array(), 'a'=>array('href'=>array(), 'target'=>array())) ) .
						'<a class="gdlr-core-button" target="_blank" href="http://support.goodlayers.com" >' . esc_html__('Go to support website', 'infinite') . '</a>'
				);

				return array(
					'header' => array(
						'logo' => get_template_directory_uri() . '/images/getting-start/header.png',
						'title' => esc_html__('Congratulations !', 'infinite'),
						'caption' => '<strong>' . esc_html__('Infinite', 'infinite') . '</strong> ' . esc_html__('WordPress theme is now installed and ready to use. Thank you so much for choosing Goodlayers!', 'infinite')
					),
					'content' => $content
				);
			}

			return $options;
		}
	}

	// add filter for demo import
	add_filter('gdlr_core_demo_options', 'infinite_gdlr_core_demo_options');
	if( !function_exists('infinite_gdlr_core_demo_options') ){
		function infinite_gdlr_core_demo_options($demo){
			return array(
				'agency01' => array(
					'title' => esc_html__('Agency 01', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/agency01/',
					'xml' => get_template_directory() . '/admin/function/files/agency01.xml',
					'page' => 7,
					'menu' => array('main_menu' => 2, 'mobile_menu' => 2),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-3"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"3":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"45px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"center-menu","header-plain-bottom-border":"1px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"50","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"30px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"23px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"5","logo-top-padding":"37px","logo-bottom-padding":"32px","max-logo-width":"144px","main-navigation-top-padding":"42px","main-navigation-bottom-padding":"42px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"100px","default-title-bottom-padding":"100px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"88px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"7","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Raleway","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Light Blue","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#c6e7ff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#c6e7ff","border":"#c6e7ff","element-background":"#2172ac","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#2172ac","button-background-hover":"#2172ac","button-border-color":"","button-border-hover-color":""},{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#a9a9a9","content":"#a9a9a9","icon":"#2d9bea","link":"#2d9bea","link-hover":"#52abea","divider":"#b5b5b5","border":"#c4c4c4","element-background":"#2d9bea","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#50a9e9","button-background-hover":"#2d9bea","button-border-color":"","button-border-hover-color":""},{"name":"Light Purple","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#c9d7fa","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#c9d7fa","border":"#c9d7fa","element-background":"#365196","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#365196","button-background-hover":"#365196","button-border-color":"","button-border-hover-color":""},{"name":"Grey","title":"#272727","title-hover":"#272727","caption":"#969696","content":"#969696","icon":"","link":"","link-hover":"","divider":"#a9a9a9","border":"#a9a9a9","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Grey Blog","title":"#303030","title-hover":"#303030","caption":"#969696","content":"#969696","icon":"","link":"","link-hover":"","divider":"","border":"#8a8a8a","element-background":"#ffffff","element-content":"#8a8a8a","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#353535","header-plain-bottom-border-color":"#565656","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#c0c0c0","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#e2e2e2","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#262626","footer-title-color":"#ffffff","footer-content-color":"#939393","footer-link-color":"#939393","footer-link-hover-color":"#ffffff","footer-divider-color":"#383838","copyright-background-color":"#111111","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2d9bea","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#2f9cea","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2f9cea","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#515151","accordion-title-color":"#949494","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#2d9bea","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#292929","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2d9bea","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#9fc612","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2d9bea","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#36bddb","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#309cea","button-top-gradient-background-color":"#52aae9","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2d9bea","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Gallery Large","width":"1280","height":"700","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"7","additional-mobile-css":""}}',
				),
				'aperture' => array(
					'title' => esc_html__('Aperture', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/aperture/',
					'xml' => get_template_directory() . '/admin/function/files/aperture.xml',
					'page' => 1321,
					'menu' => array('main_menu' => 38, 'right_menu' => 39, 'mobile_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"footer-2":null,"footer-3":null,"footer-4":null,"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"1":[],"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"30px","background-type":"color","background-image":"light","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"NaNpx","top-bar-bottom-padding":"NaNpx","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"splitted-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"0","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"27px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"6px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"24px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1346","logo-top-padding":"20px","logo-bottom-padding":"20px","max-logo-width":"130px","main-navigation-top-padding":"44px","main-navigation-bottom-padding":"0px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"disable","right-menu-type":"left","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"165px","default-title-bottom-padding":"110px","default-page-caption-top-margin":"13px","default-title-font-size":"43px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"220px","default-blog-title-bottom-padding":"110px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"disable","footer-style":"footer-1","enable-copyright":"disable","copyright-text":"","enable-maintenance":"disable","maintenance-page":"1321","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Source Sans Pro","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"light","title":"#ffffff","title-hover":"","caption":"#a8a8a8","content":"#a8a8a8","icon":"","link":"#ffffff","link-hover":"#ededed","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Dark","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#353535","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#424242","header-background-color":"#3a3a3a","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#ffffff","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2d9bea","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#2f9cea","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2f9cea","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2d9bea","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#9fc612","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2d9bea","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#36bddb","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#309cea","button-top-gradient-background-color":"#52aae9","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2d9bea","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Portfolio Thumbnail","width":"800","height":"905","hard-crop":""},{"name":"Gallery Thumb","width":"1280","height":"700","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1321","additional-mobile-css":""}}',
				),
				'appz' => array(
					'title' => esc_html__('Appz', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/appz/',
					'xml' => get_template_directory() . '/admin/function/files/appz.xml',
					'page' => 7,
					'menu' => array('main_menu' => 38, 'mobile_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-3"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"3":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1300px","container-padding":"20px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"49","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"41px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"23px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1432","logo-top-padding":"50px","logo-bottom-padding":"31px","max-logo-width":"","main-navigation-top-padding":"54px","main-navigation-bottom-padding":"42px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"100px","default-title-bottom-padding":"100px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"1404","default-portfolio-title-background":"1404","default-personnel-title-background":"1404","default-search-title-background":"1404","default-archive-title-background":"1404","default-blog-title-style":"custom","default-blog-title-top-padding":"88px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"1404","default-blog-title-background-overlay-opacity":"0","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"disable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"","enable-maintenance":"disable","maintenance-page":"7","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-social-instagram":"","top-bar-social-snapchat":"","mobile-logo":"","logo-left-padding":"","main-navigation-right-padding":"","enable-logo-on-main-navigation-sticky":"enable","enable-main-navigation-right-button":"disable","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-with-border","default-title-font-transform":"","default-title-font-weight":"","default-caption-font-weight":"","blog-date-feature":"enable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","blog-social-share-count":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"footer-1","woocommerce-archive-sidebar-right":"footer-1","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-top-padding":"70px","footer-bottom-padding":"50px","copyright-top-padding":"38px","copyright-bottom-padding":"38px","enable-back-to-top":"disable","archive-date-feature":"enable","portfolio-icon-hover-link":"arrow_right-up","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_search","portfolio-icon-hover-size":"22px","background-image-opacity":"100","main-navigation-item-right-padding":"0px","fixed-navigation-max-logo-width":"","fixed-navigation-logo-top-padding":"23px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"26px","fixed-navigation-bottom-padding":"25px","fixed-navigation-anchor-offset":"75px","blog-date-feature-year":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","copyright-style":"left-right","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","copyright-left":"Copyright 2019 GoodLayers, All Right Reserved","copyright-right":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"15px\" color=\"#111111\" margin-left=\"\" margin-right=\"18px\" link=\"#\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"15px\" color=\"#111111\" margin-left=\"\" margin-right=\"18px\" link=\"#\" ][gdlr_core_icon icon=\"fa fa-linkedin\" size=\"15px\" color=\"#111111\" margin-left=\"\" margin-right=\"18px\" link=\"#\" ][gdlr_core_icon icon=\"fa fa-pinterest\" size=\"15px\" color=\"#111111\" margin-left=\"\" margin-right=\"18px\" link=\"#\" ][gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"15px\" color=\"#111111\" margin-left=\"\" margin-right=\"18px\" link=\"#\" ]","max-mobile-logo-width":"","default-caption-font-transform":"","enable-footer-column-divider":"enable"},"gdlr_typography":{"heading-font":"Montserrat","navigation-font":"Montserrat","content-font":"Open Sans","info-font":"Open Sans","blog-info-font":"Open Sans","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"15px","navigation-font-weight":"400","navigation-text-transform":"none","content-font-size":"15px","content-line-height":"1.7","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","navigation-font-letter-spacing":"0px"},"gdlr_color":{"skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#c2c0ed","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#c2c0ed","border":"","element-background":"","element-content":"","button-text":"#5252ce","button-text-hover":"#9a9ace","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Service","title":"#ffffff","title-hover":"","caption":"","content":"#bad4ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Black Service","title":"#494949","title-hover":"","caption":"","content":"","icon":"#494949","link":"","link-hover":"","divider":"","border":"","element-background":"#ebebeb","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Skin","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#ffffff","header-plain-bottom-border-color":"#565656","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#5252ce","logo-background-color":"#ffffff","main-menu-text-color":"#585858","main-menu-text-hover-color":"#2979ff","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#424242","secondary-menu-icon-color":"#e2e2e2","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#2d2d2d","link-color":"#2979ff","link-hover-color":"#5b97ff","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#262626","footer-title-color":"#ffffff","footer-content-color":"#939393","footer-link-color":"#939393","footer-link-hover-color":"#ffffff","footer-divider-color":"#383838","copyright-background-color":"#ffffff","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2979ff","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#2979ff","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2979ff","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#2979ff","price-table-active-head-top-gradient-color":"#5492ff","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#a0c3ff","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#2979ff","price-table-active-button-background-top-gradient-color":"#6da2ff","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#515151","accordion-title-color":"#949494","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#2979ff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#292929","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2979ff","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#2979ff","column-service-caption-color":"#747474","dropdown-tab-head-background":"#2979ff","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2979ff","flipbox-border-color":"#215dd3","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#2979ff","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2979ff","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#2979ff","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#848484","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#2979ff","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2979ff","button-background-hover-color":"#609aff","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#2979ff","button-top-gradient-background-color":"#669eff","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2979ff","slider-outer-navigation-color":"#2979ff","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","page-preload-background-color":"#ffffff","woocommerce-cart-icon-number-background":"#5252ce","woocommerce-cart-icon-number-color":"#ffffff","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#bd584e","navigation-right-button-text-color":"#333333","navigation-right-button-background-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-hover-color":"","navigation-right-button-border-hover-color":"#555555","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#2979ff","woocommerce-theme-color":"#2979ff","woocommerce-price-color":"#2979ff","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#609aff","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#2979ff","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#4c67a5","widget-price-filter-handle-color":"#2979ff","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","portfolio-frame-background-color":"#f5f5f5","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","testimonial-rating-color":"#ffa127"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Gallery Large","width":"1280","height":"700","hard-crop":""},{"name":"Frame Portfolio","width":"800","height":"590","hard-crop":""},{"name":"Frame Personnel","width":"800","height":"888","hard-crop":""},{"name":"Frame Blog","width":"800","height":"490","hard-crop":""},{"name":"Frame Square","width":"600","height":"600","hard-crop":""}],"additional-css":"body .infinite-main-menu-search {\n    margin-top: -2px;\n}","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"7","additional-mobile-css":"","enable-srcset":"disable","link-to-lightbox":"enable","additional-head-script":"","enable-preload":"disable","preload-image":""}}'
				),
				'architek' => array(
					'title' => esc_html__('Architek', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/architek/',
					'xml' => get_template_directory() . '/admin/function/files/architek.xml',
					'page' => 4,
					'menu' => array('main_menu' => 38, 'mobile_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Blog","id":"blog"}],"sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-2"],"footer-3":["gdlr-core-recent-portfolio-widget-3"],"footer-4":["tag_cloud-2","recent-comments-2"],"blog":["text-3","gdlr-core-recent-portfolio-widget-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"2":{"title":"Recent Works","category":"","num-fetch":"6"},"3":{"title":"Recent Works","category":"","num-fetch":"8"},"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"Recent Comments","number":4},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of. <br\/><br\/>\r\n<strong>Phone : 1123-2234-21 <\/strong>\r\n<strong>london@architekthemes.com<\/strong>","filter":false},"3":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Donec ullamcorper nulla non metus auctor fringilla. Maecenas sed diam eget risus varius blandit sit amet non.","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"50","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"0px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"24px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1320","logo-top-padding":"0px","logo-bottom-padding":"21px","max-logo-width":"364px","main-navigation-top-padding":"126px","main-navigation-bottom-padding":"27px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"left","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"155px","default-title-bottom-padding":"115px","default-page-caption-top-margin":"13px","default-title-font-size":"71px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"1326","default-portfolio-title-background":"1326","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"1326","default-blog-title-background-overlay-opacity":"0","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-3","enable-copyright":"enable","copyright-text":"Copyright 2020 GoodLayers, All Right Reserved","enable-maintenance":"disable","maintenance-page":"1281","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"blog","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-social-instagram":"","top-bar-social-snapchat":"","enable-main-navigation-right-button":"disable","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-with-border","blog-social-share-count":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"footer-1","woocommerce-archive-sidebar-right":"footer-1","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-back-to-top":"disable","logo-left-padding":"0","main-navigation-right-padding":"55px","mobile-logo":"","default-title-font-transform":"none","default-title-font-weight":"300","default-caption-font-weight":"","blog-date-feature":"enable","meta-option":["author","category","tag","comment-number"],"personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-top-padding":"70px","footer-bottom-padding":"50px","copyright-top-padding":"38px","copyright-bottom-padding":"38px","enable-logo-on-main-navigation-sticky":"disable"},"gdlr_typography":{"heading-font":"Hind","navigation-font":"Hind","content-font":"Ubuntu","info-font":"Hind","blog-info-font":"Hind","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7","font-upload":[{"name":"Tex Gyre","eot":"","ttf":"http:\/\/demo.goodlayers.com\/infinite\/homepages\/finance\/wp-content\/uploads\/sites\/3\/2016\/05\/texgyreadventor-regular.ttf"},{"name":"Tex Gyre Bold","eot":"","ttf":"http:\/\/demo.goodlayers.com\/infinite\/homepages\/finance\/wp-content\/uploads\/sites\/3\/2016\/05\/texgyreadventor-bold.ttf"}]},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#c6c6c6","content":"#dcdcdc","icon":"#ffffff","link":"#ffffff","link-hover":"#d6d6d6","divider":"#ffffff","border":"#ffffff","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#ea6b2d","button-background-hover":"#ea6b2d","button-border-color":"","button-border-hover-color":""},{"name":"Black Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#0c0c0c","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#353535","header-background-color":"#0a0a0a","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#ffffff","logo-background-color":"#ffffff","main-menu-text-color":"#d6d6d6","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#dddddd","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#212121","footer-title-color":"#ffffff","footer-content-color":"#9b9b9b","footer-link-color":"#969696","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#0a0a0a","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#ffffff","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#878787","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#353535","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#353535","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#353535","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#ea6b2d","price-table-active-head-top-gradient-color":"#ea8452","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#eab396","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#ea6b2d","price-table-active-button-background-top-gradient-color":"#ea8856","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#353535","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#ea6b2d","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#353535","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#353535","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#353535","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#353535","button-top-gradient-background-color":"#6b6b6b","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#383838","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e","page-preload-background-color":"#ffffff","woocommerce-cart-icon-number-background":"#bd584e","woocommerce-cart-icon-number-color":"#ffffff","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#bd584e","navigation-right-button-text-color":"#333333","navigation-right-button-background-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-hover-color":"","navigation-right-button-border-hover-color":"#555555","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","woocommerce-theme-color":"#bd584e","woocommerce-price-color":"#bd584e","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#d4786e","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Portfolio Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Gallery Large","width":"1400","height":"788","hard-crop":""},{"name":"Portfolio Thumbnail 2","width":"700","height":"900","hard-crop":""},{"name":"Personnel Thumbnail","width":"500","height":"575","hard-crop":""},{"name":"Portfolio Thumbnail large","width":"1000","height":"625","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1281","additional-mobile-css":"","enable-srcset":"disable","link-to-lightbox":"enable","additional-head-script":"","enable-preload":"disable","preload-image":""}}'
				),
				'bigcorp' => array(
					'title' => esc_html__('Big Corp', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/bigcorp/',
					'xml' => get_template_directory() . '/admin/function/files/bigcorp.xml',
					'page' => 1327,
					'menu' => array('main_menu' => 38, 'mobile_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"footer-2":null,"footer-3":null,"footer-4":null,"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"1":[],"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"30px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"#","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"side","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"middle-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"13px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"65px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1323","logo-top-padding":"65px","logo-bottom-padding":"0px","max-logo-width":"150px","main-navigation-top-padding":"25px","main-navigation-bottom-padding":"20px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"disable","enable-main-navigation-cart":"disable","right-menu-type":"right","default-title-style":"small","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"disable","footer-style":"footer-2","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"1327","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Montserrat","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Open Sans","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"12px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#dbdbdb","content":"#d6d6d6","icon":"#2eb0d1","link":"#2eb0d1","link-hover":"#49b5d1","divider":"#d6d6d6","border":"#d1d1d1","element-background":"#ffffff","element-content":"#000000","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#000000","button-background-hover":"#262626","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Grey","title":"#303030","title-hover":"","caption":"#bababa","content":"#b2b2b2","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#f2f2f2","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#dddddd","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#ffffff","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2d9bea","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#2f9cea","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2f9cea","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2d9bea","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#9fc612","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2d9bea","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#36bddb","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#309cea","button-top-gradient-background-color":"#52aae9","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2d9bea","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Portfolio Thumbnail","width":"800","height":"514","hard-crop":""},{"name":"Blog Thumnnail","width":"800","height":"486","hard-crop":""},{"name":"Gallery Large Thumbnail","width":"1280","height":"700","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1327","additional-mobile-css":""}}',
				),
				'breezebiz' => array(
					'title' => esc_html__('Breezebiz', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/breezebiz/',
					'xml' => get_template_directory() . '/admin/function/files/breezebiz.xml',
					'page' => 1328,
					'menu' => array('main_menu' => 38, 'mobile_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-2"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"0","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"22px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1336","logo-top-padding":"40px","logo-bottom-padding":"20px","max-logo-width":"142px","main-navigation-top-padding":"43px","main-navigation-bottom-padding":"20px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"176px","default-title-bottom-padding":"109px","default-page-caption-top-margin":"13px","default-title-font-size":"47px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"160px","default-blog-title-bottom-padding":"90px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"1328","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"enable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Open Sans","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"600","navigation-text-transform":"none","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Green Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#4acea9","border":"#4acea9","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#989898","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#666666","border":"#5b5b5b","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Services","title":"","title-hover":"","caption":"","content":"#5e5e5e","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Call to action","title":"#4acea9","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#4acea9","button-text-hover":"#4acea9","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Accordion","title":"","title-hover":"","caption":"","content":"#e5e5e5","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#4acea9","header-background-color":"#333333","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#4acea9","logo-background-color":"#ffffff","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#4acea9","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#e5e5e5","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#232323","footer-title-color":"#ffffff","footer-content-color":"#9e9e9e","footer-link-color":"#9e9e9e","footer-link-hover-color":"#ffffff","footer-divider-color":"#424242","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#4acea9","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#4acea9","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#4acea9","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#ffffff","accordion-normal-title-color":"#ffffff","accordion-normal-icon-background-color":"#4acea9","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#4acea9","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#4acea9","dropdown-tab-head-text":"#ffffff","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#4acea9","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#4acea9","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#4acea9","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#4acea9","button-top-gradient-background-color":"#4eceaa","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#4acea9","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Gallery Thumbnail","width":"1280","height":"700","hard-crop":""},{"name":"Metro 1","width":"600","height":"950","hard-crop":""},{"name":"Metro 2","width":"600","height":"475","hard-crop":""},{"name":"Metro3","width":"1200","height":"475","hard-crop":""},{"name":"Personnel Thumbnail","width":"600","height":"476","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1328","additional-mobile-css":""}}',
				),
				'beauty' => array(
					'title' => esc_html__('Beauty', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/beauty/',
					'xml' => get_template_directory() . '/admin/function/files/beauty.xml',
					'page' => 8450,
					'menu' => array('main_menu' => 41, 'mobile_menu' => 41),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":[],"footer-1":["text-3"],"footer-2":["gdlr-core-custom-menu-widget-2"],"footer-3":["text-5"],"footer-4":["gdlr-core-newsletter-widget-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Useful Links","menu":"43","style":"half"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"2":{"title":"Subscribe to our newsletter","style":"style-1","icon-color":"#d87290","bg-color":"#ffffff"},"_multiwidget":1},"widget_gdlr-core-opening-hour-widget":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"3":{"title":"","text":"[gdlr_core_space height=\"-10px\"]<img src=\"https:\/\/demo.goodlayers.com\/infinite\/homepages\/beauty\/wp-content\/uploads\/sites\/34\/2020\/03\/footer-logo.png\" alt=\"\" width=\"133\" \/>\r\n<br\/>\r\n112 W 34th St, New York [gdlr_core_space height=\"12px\"](+1) 212-946-2707 [gdlr_core_space height=\"12px\"]<a href=\"#\">info@Infinite.com<\/a>","filter":true,"visual":true},"5":{"title":"Follow Us","text":"[gdlr_core_icon icon=\"social_facebook_circle\" size=\"35px\" color=\"#d87290\" margin-left=\"\" margin-right=\"12px\" link=\"#\" ][gdlr_core_icon icon=\"social_twitter_circle\" size=\"35px\" color=\"#d87290\" margin-left=\"\" margin-right=\"12px\" link=\"#\" ][gdlr_core_icon icon=\"social_instagram_circle\" size=\"35px\" color=\"#d87290\" margin-left=\"\" margin-right=\"12px\" link=\"#\" ][gdlr_core_icon icon=\"social_vimeo_circle\" size=\"35px\" color=\"#d87290\" margin-left=\"\" margin-right=\"12px\" link=\"#\" ]","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"_multiwidget":1},"widget_woocommerce_product_categories":{"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1240px","container-padding":"5px","enable-top-bar":"enable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"<span style=\"color: #d87290;\">info@InfiniteBeauty.com  \n<\/span>&nbsp;&nbsp;\nPhone: +1 212 946 2707","top-bar-right-text":"","top-bar-top-padding":"14px","top-bar-bottom-padding":"16px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"splitted-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"splitted-menu","boxed-top-bar-background-opacity":"100","boxed-top-bar-background-extend":"32px","boxed-header-top-margin":"28px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"28px","navigation-text-top-margin-boxed":"21px","navigation-text-side-spacing":"17px","navigation-slide-bar":"style-dot","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"8585","logo-top-padding":"0px","logo-bottom-padding":"0px","max-logo-width":"190","main-navigation-top-padding":"14px","main-navigation-bottom-padding":"44px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"medium","default-title-align":"center","default-title-top-padding":"113px","default-title-bottom-padding":"115px","default-page-caption-top-margin":"13px","default-title-font-size":"45px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"8583","default-portfolio-title-background":"8583","default-personnel-title-background":"8583","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"113px","default-blog-title-bottom-padding":"114px","default-blog-feature-image":"content","default-blog-title-background-image":"8583","default-blog-title-background-overlay-opacity":"0","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-2","enable-copyright":"enable","copyright-text":"Copyright \u00a92019 Infinite. All Rights Reserved. <a href=\"#\" style=\"text-decoration: underline;\">Terms of Use<\/a>","enable-maintenance":"disable","maintenance-page":"5","enable-main-navigation-sticky":"disable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","background-image-opacity":"100","sidebar-title-divider":"enable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-menu-position":"none","top-bar-shadow-size":"","top-bar-shadow-color":"#000","top-bar-social-instagram":"#","top-bar-social-snapchat":"","navigation-left-offset":"0","navigation-slide-bar-top-margin":"-40px","header-shadow-size":"40px","header-shadow-color":"#d87290","logo-left-padding":"","mobile-logo":"","max-tablet-logo-width":"80px","max-mobile-logo-width":"","mobile-logo-position":"logo-left","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","navigation-right-top-margin":"","enable-main-navigation-right-button":"disable","main-navigation-right-button-style":"default","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-small","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"","fixed-navigation-logo-top-padding":"20px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"30px","fixed-navigation-bottom-padding":"25px","fixed-navigation-anchor-offset":"75px","enable-mobile-navigation-sticky":"enable","default-title-font-transform":"none","default-title-font-weight":"400","default-caption-font-transform":"none","default-caption-font-weight":"400","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"0px","page-title-bottom-gradient-size":"0px","default-blog-top-bottom-gradient":"enable","single-blog-title-top-gradient-size":"370px","single-blog-title-bottom-gradient-size":"413px","blog-style":"style-1","blockquote-style":"style-1","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","enable-related-post":"enable","related-post-blog-style":"blog-column-with-frame","related-post-blog-column-style":"style-1","related-post-column-size":"20","related-post-meta-option":["date","author","category","comment-number"],"related-post-thumbnail-size":"full","related-post-num-fetch":"3","related-post-excerpt-number":"0","blog-social-share-count":"enable","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-date-feature":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-product-style":"grid","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_zoom-in_alt","portfolio-icon-hover-size":"22px","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-background":"","enable-footer-column-divider":"disable","footer-top-padding":"84px","footer-bottom-padding":"56px","copyright-style":"center","copyright-top-padding":"32px","copyright-bottom-padding":"31px","copyright-left":"","copyright-right":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-instagram\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"\" ]","enable-back-to-top":"disable","blog-title-style":"","main-navigation-search-icon":"fa fa-search","main-navigation-cart-icon":"fa fa-shopping-cart","navigation-slide-bar-width":"","navigation-slide-bar-height":"","fixed-navigation-slide-bar-top-margin":"","enable-fixed-navigation-slide-bar":"disable","header-bar2-navigation-align":"center","enable-logo":"enable","main-navigation-search-icon-top-margin":"","main-navigation-cart-icon-top-margin":"","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","single-portfolio-navigation-middle-link":"#"},"gdlr_typography":{"heading-font":"Jost","navigation-font":"Jost","content-font":"Jost","info-font":"Jost","blog-info-font":"Jost","quote-font":"Montserrat","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"500","navigation-text-transform":"uppercase","content-font-size":"17px","content-line-height":"1.5","testimonial-font":"Jost","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","header-font-weight":"","content-font-weight":"","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-letter-spacing":"","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"13px","sidebar-title-font-weight":"","sidebar-title-font-letter-spacing":"","sidebar-title-text-transform":"uppercase","footer-title-font-size":"20px","footer-title-font-weight":"400","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"15px","copyright-font-weight":"500","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","font-upload":[{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/07\/Jost-400-Book.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/07\/Jost-400-Book.ttf","woff":"","font-weight":"400","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-100-Hairline.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-100-Hairline.ttf","woff":"","font-weight":"100","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-200-Thin.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-200-Thin.ttf","woff":"","font-weight":"200","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-300-Light.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-300-Light.ttf","woff":"","font-weight":"300","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-500-Medium.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-500-Medium.ttf","woff":"","font-weight":"500","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-600-Semi.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-600-Semi.ttf","woff":"","font-weight":"600","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-700-Bold.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-700-Bold.ttf","woff":"","font-weight":"700","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-800-Heavy.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-800-Heavy.ttf","woff":"","font-weight":"800","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-900-Black.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-900-Black.ttf","woff":"","font-weight":"900","font-style":"normal"}],"google-font-display":"optional","sub-navigation-font-size":""},"gdlr_color":{"skin":[{"name":"Yellow","title":"","title-hover":"","caption":"","content":"","icon":"#333333","link":"","link-hover":"","divider":"","border":"#002e5b","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#002e5b","button-background-hover":"#002e5b","button-border-color":"","button-border-hover-color":""},{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#c3d7ea","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#355677","border":"#355677","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Light Service","title":"#f7c02e","title-hover":"#f7c02e","caption":"#9dafc0","content":"#9dafc0","icon":"#ffffff","link":"#f7c02e","link-hover":"#f7c02e","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#f7c02e","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"volumn tran","title":"#002e5b","title-hover":"","caption":"","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc","title":"#002e5b","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"counter","title":"#002e5b","title-hover":"","caption":"#373737","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"service","title":"#002e5b","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Yellow Link","title":"#002e5b","title-hover":"#f6bf40","caption":"#b1b1b1","content":"","icon":"","link":"#777777","link-hover":"#f6bf40","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Column SVC Top HP","title":"#002e5b","title-hover":"","caption":"#373737","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#c1c1c1","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#c1c1c1","top-bar-social-hover-color":"#595959","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2ed47d","logo-background-color":"#ffffff","main-menu-text-color":"#002e5b","main-menu-text-hover-color":"#00286d","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#002e5b","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#d87290","page-caption-color":"#373737","page-title-background-overlay-color":"#000000","body-content-color":"#686868","heading-color":"#002e5b","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#f5f5f5","input-box-border-color":"#f5f5f5","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#faefed","footer-title-color":"#002e5b","footer-content-color":"#777777","footer-link-color":"#d87290","footer-link-hover-color":"#d88aa2","footer-divider-color":"#444444","copyright-background-color":"#222222","copyright-text-color":"#c1c1c1","single-blog-title-color":"#d87290","single-blog-info-color":"#0a0505","single-blog-date-day-color":"#2b2b2b","single-blog-date-month-color":"#161616","single-blog-divider-color":"#3a3a3a","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#002e5b","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#002e5b","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#002e5b","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#002e5b","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#d87290","price-table-active-head-top-gradient-color":"#d87290","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#d8a6c0","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#d87290","price-table-active-button-background-top-gradient-color":"#d87290","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#002e5b","accordion-title-background-active-color":"#d87290","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#002e5b","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#f7c02e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#d87290","dropdown-tab-head-text":"#303030","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#002e5b","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#002e5b","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#002e5b","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#d87290","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#002e5b","button-top-gradient-background-color":"#10365b","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#002e5b","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#d87290","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#d6d6d6","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","top-cart-background-color":"#ffffff","top-cart-title-color":"#000000","top-cart-info-color":"#c1c1c1","top-cart-view-cart-color":"#323232","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-color":"#ffffff","top-cart-checkout-background-color":"#000000","woocommerce-cart-icon-number-background":"#28c23e","woocommerce-cart-icon-number-color":"#ffffff","navigation-right-button-text-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-color":"","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-border-hover-color":"#555555","navigation-right-button-shadow-color":"#000","page-preload-background-color":"#ffffff","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","tag-cloud-text-color":"","tag-cloud-background-color":"","tag-cloud-border-color":"","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","copyright-link-color":"#d87290","copyright-link-hover-color":"#ffffff","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-style-2-tags-color":"#d87290","single-blog-navigation2-left-overlay":"#d87290","single-blog-navigation2-overlay":"#d87290","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#272727","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#d87290","portfolio-frame-background-color":"#f5f5f5","portfolio-title-hover-color":"","portfolio-grid2-tag-background":"#d87290","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#d87290","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","slider-control-navigation-background-color":"#e7e7e7","testimonial-rating-color":"#ffa127","woocommerce-theme-color":"#d87290","woocommerce-price-color":"#d87290","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#d87290","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#d87290","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#d8a0b1","widget-price-filter-handle-color":"#d87290","testimonial-frame-background-color":"#ffffff","navigation-right-button2-text-color":"","navigation-right-button2-text-hover-color":"","navigation-right-button2-background-color":"","navigation-right-button2-background-hover-color":"","navigation-right-button2-border-color":"","navigation-right-button2-border-hover-color":"","custom-menu-widget-box-style-background-active":"#143369","single-portfolio-nav-icon":"#d87290","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#d87290","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#d89cae","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Service Thumbnail","width":"750","height":"423","hard-crop":""},{"name":"Square Thumbnail","width":"400","height":"400","hard-crop":""},{"name":"Personnel Thumbnaul","width":"700","height":"477","hard-crop":""},{"name":"Square Thumbnail Large","width":"750","height":"750","hard-crop":""}],"additional-css":"figure.alignleft.is-resized {\n    margin-right: 35px;\n}\n.infinite-single-related-post-container .gdlr-core-blog-grid .gdlr-core-blog-title {\n    font-size: 17px;\n    font-weight: 600;\n}","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"8450","additional-mobile-css":"","enable-srcset":"enable","consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-head-script":"","additional-head-script2":"","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","elegant-font"],"additional-body-script":""}}'
				),
				'conference' => array(
					'title' => esc_html__('Conference', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/conference/',
					'xml' => get_template_directory() . '/admin/function/files/conference.xml',
					'page' => 5,
					'menu' => array('main_menu' => 2, 'mobile_menu' => 2),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"footer-1":[],"footer-2":[],"footer-3":null,"footer-4":null,"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"1":[],"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"35px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"50","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"splitted-menu","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"40px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"19px","navigation-slide-bar":"disable","side-header-width-pixel":"305px","side-header-side-padding":"70px","navigation-text-top-spacing":"15px","logo-right-text":"","logo-right-text-top-padding":"27px","logo":"8","logo-top-padding":"49px","logo-bottom-padding":"32px","max-logo-width":"200px","main-navigation-top-padding":"57px","main-navigation-bottom-padding":"34px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"disable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"medium","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"7","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"75","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"gdlr-core-sidebar-preset","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"enable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-footer":"disable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","blog-max-content-width":"900px","enable-maintenance":"disable","maintenance-page":"2039","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"24","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"gdlr-core-sidebar-preset","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-social-instagram":"","top-bar-social-snapchat":"","mobile-logo":"","logo-left-padding":"","main-navigation-right-padding":"","enable-logo-on-main-navigation-sticky":"enable","enable-main-navigation-right-button":"disable","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger","default-title-font-transform":"default","default-title-font-weight":"","default-caption-font-weight":"","blog-date-feature":"enable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","blog-social-share-count":"enable","archive-date-feature":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_zoom-in_alt","portfolio-icon-hover-size":"22px","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-top-padding":"70px","footer-bottom-padding":"50px","copyright-top-padding":"38px","copyright-bottom-padding":"38px","enable-back-to-top":"disable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Poppins","info-font":"Poppins","blog-info-font":"Open Sans","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"700","navigation-text-transform":"uppercase","content-font-size":"16px","content-line-height":"1.7","additional-font":"Georgia, serif","additional-font2":"Georgia, serif"},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#cecece","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#777777","border":"#777777","element-background":"","element-content":"#3d3d3d","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#309cea","button-background-hover":"#0f82db","button-border-color":"","button-border-hover-color":""},{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#ffffff","border":"#ffffff","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#000000","button-background-hover":"#2d9bea","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Grey","title":"#3a3a3a","title-hover":"","caption":"#727272","content":"#494949","icon":"#595959","link":"","link-hover":"","divider":"#cecece","border":"#cecece","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Maintenance","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"#74abd2","border":"#74abd2","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Red Service Box","title":"#ffffff","title-hover":"","caption":"","content":"#ffabab","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Newsletter Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#f3f3f3","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"#8e2525","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Tickets","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#7b88a8","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Venue","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#2d4fad","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#212121","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#931c1c","logo-background-color":"#ffffff","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#dda4a4","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#2d2d2d","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e2e2e2","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","footer-background-color":"#282828","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#bababa","footer-link-hover-color":"#ffffff","footer-divider-color":"#494949","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#8e2525","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#353535","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#8e2525","price-table-background-color":"#f8f8f8","price-table-head-color":"#8d2520","price-table-head-top-gradient-color":"#5f1414","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#ffc4c2","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#8d2520","price-table-button-background-top-gradient-color":"#8d2520","price-table-list-border-color":"#e5e5e5","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#303030","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#8e2525","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","flipbox-background-color":"#8e2525","flipbox-border-color":"#720e0e","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#8e2525","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#8e2525","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#8e2525","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","search-overlay-background-color":"#000000","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","sidebar-title-color":"#383838","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","price-table-active-head-color":"#1b3374","price-table-active-head-top-gradient-color":"#2d50ae","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#cae5f9","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#2d50ae","price-table-active-button-background-top-gradient-color":"#193fa8","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#8e2525","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#8e2525","button-top-gradient-background-color":"#8e4141","dropdown-tab-head-background":"#8e2525","dropdown-tab-head-text":"#ffffff","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#8e2525","slider-outer-navigation-color":"#ffffff","slider-outer-navigation-background-color":"#383838","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#ffffff","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","page-preload-background-color":"#ffffff","woocommerce-cart-icon-number-background":"#bd584e","woocommerce-cart-icon-number-color":"#ffffff","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#bd584e","navigation-right-button-text-color":"#333333","navigation-right-button-background-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-hover-color":"","navigation-right-button-border-hover-color":"#555555","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","woocommerce-theme-color":"#bd584e","woocommerce-price-color":"#bd584e","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#d4786e","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Portfolio Metro 1","width":"290","height":"430","hard-crop":""},{"name":"Portfolio Metro 2","width":"290","height":"215","hard-crop":""},{"name":"Portfolio Metro 3","width":"590","height":"215","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Thumbnail 2","width":"550","height":"500","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"5","additional-mobile-css":"","enable-srcset":"disable","link-to-lightbox":"enable","additional-head-script":"","enable-preload":"disable","preload-image":""}}'
				),
				'designer' => array(
					'title' => esc_html__('Designer', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/designer/',
					'xml' => get_template_directory() . '/admin/function/files/designer.xml',
					'page' => 1322,
					'menu' => array('right_menu' => 2, 'mobile_menu' => 2),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":[],"footer-2":[],"footer-3":[],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"1":[],"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"40px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"13px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"4","logo-top-padding":"48px","logo-bottom-padding":"48px","max-logo-width":"140px","main-navigation-top-padding":"48px","main-navigation-bottom-padding":"20px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"disable","enable-main-navigation-cart":"disable","right-menu-type":"overlay","default-title-style":"small","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"disable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"1322","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Source Sans Pro","blog-info-font":"Source Sans Pro","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"12px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Heading","title":"","title-hover":"","caption":"","content":"#3b3b3b","icon":"#2f2f2f","link":"","link-hover":"","divider":"#d4d4d4","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Grey","title":"","title-hover":"","caption":"8b8b8b","content":"#8b8b8b","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Light","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"#","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Light 2","title":"#ffffff","title-hover":"#ffffff","caption":"#e5e5e5","content":"#e5e5e5","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#d1d1d1","border":"#d1d1d1","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#353535","header-background-color":"#f3f3f3","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#353535","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#ffffff","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#353535","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#353535","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#353535","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#353535","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#353535","dropdown-tab-head-text":"#ffffff","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#353535","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#353535","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#353535","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#353535","button-top-gradient-background-color":"#5b5b5b","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#353535","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Gallery Thumbnail","width":"1280","height":"700","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1322","additional-mobile-css":""}}',
				),
				'eco' => array(
					'title' => esc_html__('Eco', 'infinite'),
					'url' => 'https://demo.goodlayers.com/infinite/homepages/eco',
					'xml' => get_template_directory() . '/admin/function/files/eco.xml',
					'page' => 2050,
					'menu' => array('main_menu' => 41, 'mobile_menu' => 41, 'right_menu' => 42),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":[],"footer-1":["text-2"],"footer-2":["text-3"],"footer-3":["gdlr-core-custom-menu-widget-2"],"footer-4":["gdlr-core-newsletter-widget-2","text-4"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Useful Links","menu":"43","style":"half"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"2":{"title":"Subscribe to our newsletter","style":"style-1","icon-color":"#2ed47d","bg-color":"#ffffff"},"_multiwidget":1},"widget_gdlr-core-opening-hour-widget":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"2":{"title":"","text":"<img class=\"alignnone size-full wp-image-2304\" src=\"https:\/\/demo.goodlayers.com\/infinite\/homepages\/eco\/wp-content\/uploads\/sites\/31\/2020\/01\/icon-footer-1.png\" alt=\"\" width=\"145\" height=\"23\" \/>\r\n[gdlr_core_space height=\"-5px\"]","filter":true,"visual":true},"3":{"title":"Offices","text":"Mon - Fri: 8.00am 6.00pm [gdlr_core_space height=\"12px\"]112 W 34th St, New York [gdlr_core_space height=\"12px\"](+1) 212-946-2707 [gdlr_core_space height=\"12px\"] info@Infinite.com","filter":true,"visual":true},"4":{"title":"","text":"[gdlr_core_space height=\"-52px\"]\r\n[gdlr_core_icon icon=\"fa fa-facebook\" size=\"18px\" color=\"#444444\" margin-left=\"\" margin-right=\"20px\"\u00a0 link=\"#\"][gdlr_core_icon icon=\"fa fa-twitter\" size=\"18px\" color=\"#444444\" margin-left=\"\" margin-right=\"20px\" link=\"#\"][gdlr_core_icon icon=\"fa fa-instagram\" size=\"18px\" color=\"#444444\" margin-left=\"\" margin-right=\"20px\" link=\"#\"][gdlr_core_icon icon=\"fa fa-pinterest\" size=\"18px\" color=\"#444444\" margin-left=\"\" margin-right=\"\" link=\"#\"]","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"_multiwidget":1},"widget_woocommerce_product_categories":{"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1240px","container-padding":"5px","enable-top-bar":"enable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"10px\" ] +44 3656 4567 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#ffffff\" margin-left=\"27px\" margin-right=\"10px\" ]12 Main Street Pt. London England ","top-bar-right-text":"","top-bar-top-padding":"25px","top-bar-bottom-padding":"25px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"100","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"center-menu","boxed-top-bar-background-opacity":"100","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"28px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"21px","navigation-slide-bar":"style-dot","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"2284","logo-top-padding":"44px","logo-bottom-padding":"23px","max-logo-width":"145px","main-navigation-top-padding":"52px","main-navigation-bottom-padding":"37px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"113px","default-title-bottom-padding":"160px","default-page-caption-top-margin":"13px","default-title-font-size":"45px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"19","default-title-background":"2327","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"113px","default-blog-title-bottom-padding":"114px","default-blog-feature-image":"content","default-blog-title-background-image":"1750","default-blog-title-background-overlay-opacity":"19","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-2","enable-copyright":"enable","copyright-text":"Copyright \u00a92019 Infinite.by Viworx-Co.All Rights Reserved. <a href=\"#\" style=\"text-decoration: underline;\">Terms of Use<\/a>","enable-maintenance":"disable","maintenance-page":"5","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","background-image-opacity":"100","sidebar-title-divider":"enable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-menu-position":"none","top-bar-shadow-size":"","top-bar-shadow-color":"#000","top-bar-social-instagram":"#","top-bar-social-snapchat":"","navigation-left-offset":"0","navigation-slide-bar-top-margin":"-30px","header-shadow-size":"","header-shadow-color":"#000","logo-left-padding":"","mobile-logo":"","max-tablet-logo-width":"","max-mobile-logo-width":"","mobile-logo-position":"logo-left","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","navigation-right-top-margin":"","enable-main-navigation-right-button":"disable","main-navigation-right-button-style":"default","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-small","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"125px","fixed-navigation-logo-top-padding":"25px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"30px","fixed-navigation-bottom-padding":"25px","fixed-navigation-anchor-offset":"75px","enable-mobile-navigation-sticky":"enable","default-title-font-transform":"none","default-title-font-weight":"600","default-caption-font-transform":"","default-caption-font-weight":"","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-blog-top-bottom-gradient":"enable","single-blog-title-top-gradient-size":"370px","single-blog-title-bottom-gradient-size":"413px","blog-style":"style-1","blockquote-style":"style-1","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","enable-related-post":"enable","related-post-blog-style":"blog-column-with-frame","related-post-blog-column-style":"style-1","related-post-column-size":"20","related-post-meta-option":["date","author","category","comment-number"],"related-post-thumbnail-size":"full","related-post-num-fetch":"3","related-post-excerpt-number":"0","blog-social-share-count":"enable","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-date-feature":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-product-style":"grid","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-background":"2283","enable-footer-column-divider":"disable","footer-top-padding":"70px","footer-bottom-padding":"70px","copyright-style":"center","copyright-top-padding":"29px","copyright-bottom-padding":"29px","copyright-left":"Copyright \u00a92019 Infinite. All Rights Reserved. <a href=\"#\" style=\"text-decoration: underline;\">Terms of Use<\/a>","copyright-right":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-instagram\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"\" ]","enable-back-to-top":"disable","blog-title-style":"","main-navigation-search-icon":"fa fa-search","main-navigation-cart-icon":"fa fa-shopping-cart","navigation-slide-bar-width":"","navigation-slide-bar-height":"","fixed-navigation-slide-bar-top-margin":"-18px","enable-fixed-navigation-slide-bar":"enable","enable-logo":"enable","main-navigation-search-icon-top-margin":"","main-navigation-cart-icon-top-margin":"","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","single-portfolio-navigation-middle-link":"#","header-bar2-navigation-align":"center"},"gdlr_typography":{"heading-font":"Jost","navigation-font":"Jost","content-font":"Jost","info-font":"Jost","blog-info-font":"Jost","quote-font":"Montserrat","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"500","navigation-text-transform":"uppercase","content-font-size":"17px","content-line-height":"1.5","testimonial-font":"Jost","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","header-font-weight":"","content-font-weight":"","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-letter-spacing":"","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"13px","sidebar-title-font-weight":"","sidebar-title-font-letter-spacing":"","sidebar-title-text-transform":"uppercase","footer-title-font-size":"20px","footer-title-font-weight":"500","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"500","footer-content-text-transform":"none","copyright-font-size":"15px","copyright-font-weight":"500","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","font-upload":[{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/07\/Jost-400-Book.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/07\/Jost-400-Book.ttf","woff":"","font-weight":"400","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-100-Hairline.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-100-Hairline.ttf","woff":"","font-weight":"100","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-200-Thin.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-200-Thin.ttf","woff":"","font-weight":"200","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-300-Light.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-300-Light.ttf","woff":"","font-weight":"300","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-500-Medium.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-500-Medium.ttf","woff":"","font-weight":"500","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-600-Semi.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-600-Semi.ttf","woff":"","font-weight":"600","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-700-Bold.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-700-Bold.ttf","woff":"","font-weight":"700","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-800-Heavy.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-800-Heavy.ttf","woff":"","font-weight":"800","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-900-Black.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-900-Black.ttf","woff":"","font-weight":"900","font-style":"normal"}],"google-font-display":"optional","sub-navigation-font-size":""},"gdlr_color":{"skin":[{"name":"Yellow","title":"","title-hover":"","caption":"","content":"","icon":"#333333","link":"","link-hover":"","divider":"","border":"#002e5b","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#002e5b","button-background-hover":"#002e5b","button-border-color":"","button-border-hover-color":""},{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#c3d7ea","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#355677","border":"#355677","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Light Service","title":"#f7c02e","title-hover":"#f7c02e","caption":"#9dafc0","content":"#9dafc0","icon":"#ffffff","link":"#f7c02e","link-hover":"#f7c02e","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#f7c02e","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"volumn tran","title":"#002e5b","title-hover":"","caption":"","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc","title":"#002e5b","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"counter","title":"#002e5b","title-hover":"","caption":"#373737","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"service","title":"#002e5b","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Yellow Link","title":"#002e5b","title-hover":"#f6bf40","caption":"#b1b1b1","content":"","icon":"","link":"#777777","link-hover":"#f6bf40","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"eco-cl-content","title":"","title-hover":"","caption":"#373737","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"numberyello","title":"#fdc62e","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"numbergreen","title":"#2ed47d","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"numberP","title":"#7549ea","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"numberblue","title":"#46b7da","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"column-about","title":"#002e5b","title-hover":"","caption":"","content":"#696969","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#ffffff","header-background-color":"#111111","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2ed47d","logo-background-color":"#ffffff","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#ffffff","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#686868","heading-color":"#002e5b","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#f5f5f5","input-box-border-color":"#f5f5f5","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#222222","footer-title-color":"#002e5b","footer-content-color":"#222222","footer-link-color":"#777777","footer-link-hover-color":"#2ed47d","footer-divider-color":"#444444","copyright-background-color":"#222222","copyright-text-color":"#c1c1c1","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#002e5b","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#002e5b","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#002e5b","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#002e5b","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#002e5b","accordion-title-background-active-color":"#2ed47d","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#002e5b","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#f7c02e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#2ed47d","dropdown-tab-head-text":"#303030","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#002e5b","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#002e5b","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#002e5b","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2ed47d","button-background-hover-color":"#78d3a4","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#002e5b","button-top-gradient-background-color":"#10365b","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#002e5b","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#2ed47d","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#d6d6d6","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","top-cart-background-color":"#ffffff","top-cart-title-color":"#ffffff","top-cart-info-color":"#6c6c6c","top-cart-view-cart-color":"#323232","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-color":"#ffffff","top-cart-checkout-background-color":"#000000","woocommerce-cart-icon-number-background":"#bd584e","woocommerce-cart-icon-number-color":"#ffffff","navigation-right-button-text-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-color":"","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-border-hover-color":"#555555","navigation-right-button-shadow-color":"#000","page-preload-background-color":"#ffffff","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","tag-cloud-text-color":"","tag-cloud-background-color":"","tag-cloud-border-color":"","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","copyright-link-color":"#adb9ca","copyright-link-hover-color":"#ffffff","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-style-2-tags-color":"#2ed47d","single-blog-navigation2-left-overlay":"#2ed47d","single-blog-navigation2-overlay":"#2ed47d","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#272727","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#2ed47d","portfolio-frame-background-color":"#f5f5f5","portfolio-title-hover-color":"","portfolio-grid2-tag-background":"#2ed47d","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","slider-control-navigation-background-color":"#e7e7e7","testimonial-rating-color":"#ffa127","woocommerce-theme-color":"#bd584e","woocommerce-price-color":"#bd584e","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#d4786e","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e","testimonial-frame-background-color":"#ffffff","navigation-right-button2-text-color":"","navigation-right-button2-text-hover-color":"","navigation-right-button2-background-color":"","navigation-right-button2-background-hover-color":"","navigation-right-button2-border-color":"","navigation-right-button2-border-hover-color":"","custom-menu-widget-box-style-background-active":"#143369","single-portfolio-nav-icon":"#2ed47d","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#2ed47d","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#98d3b5","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Service Thumbnail","width":"750","height":"423","hard-crop":""},{"name":"Square Thumbnail","width":"400","height":"400","hard-crop":""},{"name":"Personnel Thumbnaul","width":"700","height":"477","hard-crop":""},{"name":"blog Thumbnaul","width":"600","height":"437","hard-crop":""},{"name":"Portfolio Thumbnail","width":"500","height":"685","hard-crop":""},{"name":"Slider Thumb","width":"1300","height":"570","hard-crop":""}],"additional-css":".gdlr-core-shape-divider-wrap {\n    z-index: 1;\n}","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"2073","additional-mobile-css":"","enable-srcset":"enable","consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-head-script":"","additional-head-script2":"","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","elegant-font"],"additional-body-script":""}}'
				),
				'emporium' => array(
					'title' => esc_html__('Emporium', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/emporium/',
					'xml' => get_template_directory() . '/admin/function/files/emporium.xml',
					'page' => 4,
					'menu' => array('main_menu' => 2, 'mobile_menu' => 2),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Woocommerce","id":"woocommerce"}],"sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-2"],"footer-3":["tag_cloud-2"],"footer-4":["recent-comments-2"],"woocommerce":["woocommerce_product_categories-2","woocommerce_top_rated_products-2","woocommerce_rating_filter-2","woocommerce_product_tag_cloud-2","woocommerce_recent_reviews-2","woocommerce_price_filter-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"Recent Comments","number":4},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of ","filter":false},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"2":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"2":{"title":"Product Categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"2":{"title":"Product Tags"},"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"2":{"title":"Average Rating"},"_multiwidget":1},"widget_woocommerce_recent_reviews":{"2":{"title":"Recent Reviews","number":4},"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"2":{"title":"Top Rated Products","number":4},"_multiwidget":1},"widget_woocommerce_widget_cart":{"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"Dark","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"center-logo","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"35px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"26px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1332","logo-top-padding":"92px","logo-bottom-padding":"48px","max-logo-width":"165px","main-navigation-top-padding":"25px","main-navigation-bottom-padding":"39px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"left","default-title-style":"medium","default-title-align":"center","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"21","default-title-background":"1340","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"Copyright 2020 GoodLayers, All Right Reserved","enable-maintenance":"disable","maintenance-page":"1281","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"31","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"footer-1","woocommerce-archive-sidebar-right":"woocommerce","woocommerce-archive-column-size":"30","woocommerce-archive-thumbnail":"shop_catalog","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full"},"gdlr_typography":{"heading-font":"Poppins","navigation-font":"Poppins","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Source Sans Pro","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"400","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7","font-upload":[{"name":"Tex Gyre","eot":"","ttf":"http:\/\/demo.goodlayers.com\/infinite\/homepages\/finance\/wp-content\/uploads\/sites\/3\/2016\/05\/texgyreadventor-regular.ttf"},{"name":"Tex Gyre Bold","eot":"","ttf":"http:\/\/demo.goodlayers.com\/infinite\/homepages\/finance\/wp-content\/uploads\/sites\/3\/2016\/05\/texgyreadventor-bold.ttf"}]},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#c6c6c6","content":"#dcdcdc","icon":"#bd584e","link":"#bd584e","link-hover":"#bc786d","divider":"#ffffff","border":"#c9c9c9","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#bd584e","button-background-hover":"#bd584e","button-border-color":"","button-border-hover-color":""},{"name":"Grey","title":"","title-hover":"","caption":"#9e9e9e","content":"","icon":"","link":"","link-hover":"","divider":"#c6c6c6","border":"#c6c6c6","element-background":"#ffffff","element-content":"#606060","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Text","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#2d2d2d","button-text-hover":"#5b5b5b","button-background":"#ffffff","button-background-hover":"#eaeaea","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#ea6b2d","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#ea6b2d","logo-background-color":"#ffffff","main-menu-text-color":"#878787","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#212121","footer-title-color":"#ffffff","footer-content-color":"#9b9b9b","footer-link-color":"#969696","footer-link-hover-color":"#ffffff","footer-divider-color":"#353535","copyright-background-color":"#0a0a0a","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#bd584e","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#bd584e","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#bd584e","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#bd584e","price-table-active-head-top-gradient-color":"#bc7169","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#d1a192","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#ea6b2d","price-table-active-button-background-top-gradient-color":"#ea8856","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#bd584e","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#bd584e","dropdown-tab-head-text":"#ffffff","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#bd584e","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#bd584e","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#bd584e","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#bd584e","button-top-gradient-background-color":"#bc756f","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#bd584e","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#bd584e","woocommerce-theme-color":"#bd584e","woocommerce-button-background-hover-color":"#d4786e","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e","woocommerce-cart-icon-number-background":"#bd584e","woocommerce-cart-icon-number-color":"#ffffff","woocommerce-price-color":"#bd584e","woocommerce-price-linethrough-color":"#949494","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Portfolio Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Gallery Large","width":"1400","height":"788","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1281","additional-mobile-css":"","link-to-lightbox":"enable"}}'
				),
				'finance' => array(
					'title' => esc_html__('Finance', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/finance/',
					'xml' => get_template_directory() . '/admin/function/files/finance.xml',
					'page' => 4,
					'menu' => array('main_menu' => 2, 'mobile_menu' => 2),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-2"],"footer-3":["tag_cloud-2"],"footer-4":["recent-comments-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"Recent Comments","number":4},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of ","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"center-logo","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"23px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1227","logo-top-padding":"73px","logo-bottom-padding":"21px","max-logo-width":"192px","main-navigation-top-padding":"25px","main-navigation-bottom-padding":"31px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"left","default-title-style":"small","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"Copyright 2020 GoodLayers, All Right Reserved","enable-maintenance":"disable","maintenance-page":"1281","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Source Sans Pro","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7","font-upload":[{"name":"Tex Gyre","eot":"","ttf":"http:\/\/demo.goodlayers.com\/infinite\/homepages\/finance\/wp-content\/uploads\/sites\/3\/2016\/05\/texgyreadventor-regular.ttf"},{"name":"Tex Gyre Bold","eot":"","ttf":"http:\/\/demo.goodlayers.com\/infinite\/homepages\/finance\/wp-content\/uploads\/sites\/3\/2016\/05\/texgyreadventor-bold.ttf"}]},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#c6c6c6","content":"#dcdcdc","icon":"#ea6b2d","link":"#ea6b2d","link-hover":"#ea9a72","divider":"#bababa","border":"#c9c9c9","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#ea6b2d","button-background-hover":"#ea6b2d","button-border-color":"","button-border-hover-color":""},{"name":"Grey","title":"","title-hover":"","caption":"#9e9e9e","content":"","icon":"","link":"","link-hover":"","divider":"#c6c6c6","border":"#c6c6c6","element-background":"#ffffff","element-content":"#606060","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Grey Orange","title":"#ea6b2d","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Orange","title":"#ffffff","title-hover":"#ffffff","caption":"#ea6b2d","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#ffffff","border":"#ffffff","element-background":"#ffffff","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#ea6b2d","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#ea6b2d","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#212121","footer-title-color":"#ffffff","footer-content-color":"#9b9b9b","footer-link-color":"#969696","footer-link-hover-color":"#ffffff","footer-divider-color":"#353535","copyright-background-color":"#0a0a0a","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#ea6b2d","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#ea6b2d","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#ea6b2d","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#ea6b2d","price-table-active-head-top-gradient-color":"#ea8452","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#eab396","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#ea6b2d","price-table-active-button-background-top-gradient-color":"#ea8856","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#ea6b2d","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#ea6b2d","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#ea6b2d","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#ea6b2d","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#ea6b2d","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#ea6b2d","button-top-gradient-background-color":"#ea804b","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#ea6b2d","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Portfolio Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Gallery Large","width":"1400","height":"788","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1281","additional-mobile-css":""}}'
				),
				'fitness' => array(
					'title' => esc_html__('Fitness', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/fitness/',
					'xml' => get_template_directory() . '/admin/function/files/fitness.xml',
					'page' => 5,
					'menu' => array('main_menu' => 2, 'mobile_menu' => 2),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-2"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of ","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"enable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#e54444\" margin-left=\"\" margin-right=\"10px\" ] +1 2223 4567 [gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#e54444\" margin-left=\"27px\" margin-right=\"10px\" ] Monday - Sunday 10:00 - 22:00 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#e54444\" margin-left=\"27px\" margin-right=\"10px\" ] 12 Main Street Pt. London England","top-bar-right-text":"","top-bar-top-padding":"23px","top-bar-bottom-padding":"23px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"#","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"100","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"20px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"10","logo-top-padding":"48px","logo-bottom-padding":"20px","max-logo-width":"200px","main-navigation-top-padding":"63px","main-navigation-bottom-padding":"20px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"left","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"240px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"disable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"Copyright 2020 GoodLayers, All Right Reserved","enable-maintenance":"disable","maintenance-page":"5","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Oswald","navigation-font":"Source Sans Pro","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Droid Serif","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"White Text","title":"#ffffff","title-hover":"#ffffff","caption":"#e54444","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#ffffff","border":"#ffffff","element-background":"#e54444","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#e8e8e8","button-background":"#000000","button-background-hover":"#606060","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Red Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#e54444","border":"#e54444","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Text","title":"","title-hover":"","caption":"","content":"#212121","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Text 2","title":"#ffffff","title-hover":"#ffffff","caption":"#e54444","content":"#d8d8d8","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#ffffff","border":"#ffffff","element-background":"#e54444","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#2b2b2b","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#b3b3b3","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#bfbfbf","secondary-menu-border-color":"#cecece","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#ffffff","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#e44444","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#e44444","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#e44444","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#e44444","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#e44444","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#e44444","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#e44444","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#e44444","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#e44444","button-top-gradient-background-color":"#e25858","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#e44444","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Portfolio Thumbnail","width":"700","height":"460","hard-crop":""},{"name":"Gallery Thumbnail","width":"1280","height":"700","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"5","additional-mobile-css":""}}',
				),
				'gardener' => array(
					'title' => esc_html__('Gardener', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/gardener/',
					'xml' => get_template_directory() . '/admin/function/files/gardener.xml',
					'page' => 1323,
					'menu' => array('main_menu' => 38, 'mobile_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-2"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":[],"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"enable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"10px\" ] +1 2223 4567 [gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#ffffff\" margin-left=\"27px\" margin-right=\"10px\" ] Monday - Sunday 10:00 - 22:00 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#ffffff\" margin-left=\"27px\" margin-right=\"10px\" ] 12 Main Street Pt. London England","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"5px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"splitted-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"0","header-background-opacity":"100","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"12px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"22px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1331","logo-top-padding":"20px","logo-bottom-padding":"20px","max-logo-width":"120px","main-navigation-top-padding":"29px","main-navigation-bottom-padding":"39px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"250px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"1404","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"250px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"1404","default-blog-title-background-overlay-opacity":"0","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"1323","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Satisfy","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Source Sans Pro","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Light","title":"#b8dd30","title-hover":"#b8dd30","caption":"#ffffff","content":"#bebebe","icon":"","link":"#b8dd30","link-hover":"#bfdd52","divider":"#b8dd30","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#b8dd30","button-background-hover":"#c1dd5d","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Counter","title":"#ffffff","title-hover":"","caption":"#303030","content":"#303030","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Green Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#b8dd30","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#b8dd30","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#b8dd30","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#b8dd30","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#abce2d","link-hover-color":"#c5dd6e","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#a5a5a5","footer-link-hover-color":"#ffffff","footer-divider-color":"#3a3a3a","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#b8dd30","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#b8dd30","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2f9cea","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#b8dd30","price-table-active-head-top-gradient-color":"#bbdd40","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#d4dd96","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#b8dd30","price-table-active-button-background-top-gradient-color":"#c2dd61","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#b8dd30","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#b8dd30","dropdown-tab-head-text":"#ffffff","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#9fc612","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#b8dd30","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#b8dd30","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#b8dd30","button-top-gradient-background-color":"#c0dd56","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#b8dd30","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Service Thumbnail","width":"600","height":"346","hard-crop":""},{"name":"About Thumbnail","width":"300","height":"368","hard-crop":""},{"name":"Portfolio Thumbnail","width":"600","height":"389","hard-crop":""},{"name":"Blog Thumbnail","width":"600","height":"366","hard-crop":""},{"name":"Gallery Thumbnail","width":"1280","height":"700","hard-crop":""}],"additional-css":"body .gdlr-core-counter-item .gdlr-core-counter-item-number{ font-weight: 700; }\nbody .gdlr-core-counter-item .gdlr-core-counter-item-bottom-text{ font-family: Satisfy; }\nbody .gdlr-core-portfolio-grid .gdlr-core-portfolio-content-wrap .gdlr-core-portfolio-title{ font-size: 23px; text-transform: none; font-weight: 400; letter-spacing: 0; }\nbody .gdlr-core-blog-grid .gdlr-core-blog-title{ font-weight: 400;  font-size: 29px; }\nbody .infinite-blog-title-wrap .infinite-single-article-title{ padding-left: 5px; } ","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1323","additional-mobile-css":""}}',
				),
				'halfbox' => array(
					'title' => esc_html__('Half Box', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/halfbox/',
					'xml' => get_template_directory() . '/admin/function/files/halfbox.xml',
					'page' => 6,
					'menu' => array('main_menu' => 38, 'right_menu' => 38, 'mobile_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-3"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"3":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":[],"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"30px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"splitted-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"0","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"25px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"6px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"22px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"4","logo-top-padding":"0px","logo-bottom-padding":"0px","max-logo-width":"140px","main-navigation-top-padding":"42px","main-navigation-bottom-padding":"19px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"overlay","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"208px","default-title-bottom-padding":"129px","default-page-caption-top-margin":"13px","default-title-font-size":"52px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"1355","default-portfolio-title-background":"1355","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"162px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"1355","default-blog-title-background-overlay-opacity":"0","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"1281","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Texgy","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Source Sans Pro","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"12px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7","font-upload":[{"name":"Texgy","eot":"","ttf":"http:\/\/demo.goodlayers.com\/infinite\/homepages\/halfbox\/wp-content\/uploads\/sites\/8\/2016\/05\/texgyreadventor-regular.ttf"},{"name":"Texgy Bold","eot":"","ttf":"http:\/\/demo.goodlayers.com\/infinite\/homepages\/halfbox\/wp-content\/uploads\/sites\/8\/2016\/05\/texgyreadventor-bold.ttf"}]},"gdlr_color":{"skin":[{"name":"grey","title":"#272727","title-hover":"","caption":"#969696","content":"#969696","icon":"","link":"","link-hover":"","divider":"#9d9d9d","border":"#9d9d9d","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"light","title":"#ffffff","title-hover":"#ffffff","caption":"#bbbbbb","content":"#dcdcdc","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#2d2d2d","page-caption-color":"#939393","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#a3a3a3","footer-link-hover-color":"#ffffff","footer-divider-color":"#474747","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#303030","single-blog-info-color":"#919191","single-blog-date-day-color":"#777777","single-blog-date-month-color":"#a8a8a8","single-blog-divider-color":"#adadad","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2d9bea","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#2f9cea","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2f9cea","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2d9bea","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#9fc612","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2d9bea","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#36bddb","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#309cea","button-top-gradient-background-color":"#52aae9","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2d9bea","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Portfolio Thumbnail","width":"600","height":"835","hard-crop":""},{"name":"Gallery Thumb","width":"1280","height":"700","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1281","additional-mobile-css":""}}',
				),
				'highrise' => array(
					'title' => esc_html__('High Rise', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/highrise/',
					'xml' => get_template_directory() . '/admin/function/files/highrise.xml',
					'page' => 1328,
					'menu' => array('main_menu' => 2, 'mobile_menu' => 2),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"footer-2":null,"footer-3":null,"footer-4":null,"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"1":[],"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"Service Thumbnail","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"center-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"51","header-background-opacity":"20","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"30px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"25px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1320","logo-top-padding":"33px","logo-bottom-padding":"32px","max-logo-width":"160px","main-navigation-top-padding":"40px","main-navigation-bottom-padding":"40px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"disable","right-menu-type":"right","default-title-style":"small","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"438","default-portfolio-title-background":"","default-personnel-title-background":"Gallery Large","default-search-title-background":"1735","default-archive-title-background":"800","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"Video gallery","default-blog-title-background-overlay-opacity":"36","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"disable","footer-style":"footer-2","enable-copyright":"disable","copyright-text":"","enable-maintenance":"disable","maintenance-page":"1328","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Poppins","navigation-font":"Poppins","content-font":"Hind","info-font":"Open Sans","blog-info-font":"Open Sans","quote-font":"Open Sans","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"500","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#96a5b8","content":"#96a5b8","icon":"","link":"","link-hover":"","divider":"#765e4b","border":"#414a5a","element-background":"#b1825f","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Brown Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#b1886a","button-background-hover":"#b1886a","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#0a0a0a","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#9eb6da","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#e5e5e5","secondary-menu-border-color":"#dddddd","body-background-color":"#2c3749","container-background-color":"#2c3749","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9aa8bc","heading-color":"#ffffff","link-color":"#ffffff","link-hover-color":"#9aa8bc","divider-color":"#9aa8bc","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#ffffff","sidebar-link-color":"#abbbd1","sidebar-link-hover-color":"#ffffff","recent-post-widget-info-icon-color":"#c9c9c9","recent-post-widget-info-link-color":"#d1d1d1","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#4d5560","search-box-icon-color":"#ffffff","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#ffffff","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#ffffff","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#ffffff","single-blog-comment-background-color":"#232323","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#adadad","blog-title-color":"#ffffff","blog-title-hover-color":"#ffffff","blog-info-color":"#d8d8d8","blog-date-day-color":"#ffffff","blog-date-month-color":"#e8e8e8","blog-frame-background-color":"#2c3749","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2c3749","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#2c3749","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#2c3749","single-portfolio-nav-color":"#dbdbdb","portfolio-title-color":"#ffffff","portfolio-info-color":"#a5b7c9","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#a2acbc","portfolio-text-filter-color":"#9aa8bc","portfolio-text-filter-active-color":"#ffffff","portfolio-button-filter-text-color":"#ffffff","portfolio-button-filter-background-color":"#2c3749","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2c3749","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#ffffff","accordion-normal-title-color":"#ffffff","accordion-normal-icon-background-color":"#1b2330","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2c3749","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#ffffff","call-to-action-caption-color":"#9aa8bc","counter-item-top-text-color":"#9aa8bc","counter-item-top-icon-color":"#ffffff","counter-item-number-color":"#ffffff","counter-item-divider-color":"#9aa8bc","counter-item-bottom-text-color":"#9aa8bc","column-service-icon-color":"#ffffff","column-service-icon-background":"#f3f3f3","column-service-title-color":"#ffffff","column-service-caption-color":"#9aa8bc","dropdown-tab-head-background":"#415275","dropdown-tab-head-text":"#ffffff","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#ffffff","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#6886ba","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#ffffff","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#96a5b8","stunning-text-title-color":"#ffffff","stunning-text-caption-color":"#383838","tab-title-color":"#92a2bf","tab-title-background-color":"#414a5a","tab-title-border-color":"#414a5a","tab-title-hover-bar-color":"#415275","tab-title-active-color":"#ffffff","tab-title-active-background-color":"#313a47","table-head-background-color":"#b1886a","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#ffffff","testimonial-content-color":"#dddddd","testimonial-author-color":"#ffffff","testimonial-position-color":"#ffffff","testimonial-quote-color":"#ffffff","title-item-title-color":"#ffffff","title-item-caption-color":"#e5e5e5","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#ffffff","twitter-widget-date-color":"#cccccc","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#18202b","button-background-hover-color":"#1d2533","button-border-color":"#ffffff","button-border-hover-color":"#ffffff","button-gradient-background-color":"#415275","button-top-gradient-background-color":"#415275","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#ffffff","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#ffffff","promo-box-content-border-color":"#9aa8bc","skill-bar-title-color":"#ffffff","skill-bar-icon-color":"#ffffff","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#415275","slider-outer-navigation-color":"#839fc4","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#ffffff","social-share-divider-color":"#e5e5e5","social-share-text-color":"#ffffff","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#ffffff","blockquote-item-content-color":"#e5e5e5"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Service Thumbnail","width":"1000","height":"438","hard-crop":""},{"name":"Gallery Large","width":"1735","height":"800","hard-crop":""},{"name":"Video gallery","width":"600","height":"370","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1328","additional-mobile-css":""}}',
				),
				'inagency' => array(
					'title' => esc_html__('Inagency', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/inagency',
					'xml' => get_template_directory() . '/admin/function/files/inagency.xml',
					'page' => 1322,
					'menu' => array('right_menu' => 27, 'mobile_menu' => 27),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":[],"footer-2":[],"footer-3":[],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"1":[],"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"boxed","body-margin":"0px","background-type":"color","background-image":"Heading","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1179px","container-padding":"35px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"35px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"13px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1435","logo-top-padding":"48px","logo-bottom-padding":"48px","max-logo-width":"122px","main-navigation-top-padding":"48px","main-navigation-bottom-padding":"20px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"disable","enable-main-navigation-cart":"disable","right-menu-type":"overlay","default-title-style":"small","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"Light","default-portfolio-title-background":"Light 2","default-personnel-title-background":"Pink Divider","default-search-title-background":"Pink Link","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"disable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"1322","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"footer-1","woocommerce-archive-sidebar-right":"footer-1","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","boxed-layout-top-margin":"55px","sidebar-width":"20","both-sidebar-width":"15","enable-main-navigation-right-button":"disable","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","right-menu-style":"hamburger","blog-social-share-count":"enable","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-back-to-top":"disable"},"gdlr_typography":{"heading-font":"Unica One","navigation-font":"Unica One","content-font":"Inconsolata","info-font":"Unica One","blog-info-font":"Unica One","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"12px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Heading","title":"","title-hover":"","caption":"","content":"#3b3b3b","icon":"#2f2f2f","link":"","link-hover":"","divider":"#d4d4d4","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Grey","title":"#494949","title-hover":"","caption":"#c6c6c6","content":"#afafaf","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Light","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"#","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Light 2","title":"#ffffff","title-hover":"#ffffff","caption":"#e5e5e5","content":"#e5e5e5","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#d1d1d1","border":"#d1d1d1","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Pink Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#ee307a","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Pink Link","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#353535","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#353535","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#dddada","container-background-color":"#fffefc","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#7c7a7a","heading-color":"#383838","link-color":"#ee307a","link-hover-color":"#ed6d9e","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#ffffff","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#dddada","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#353535","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#353535","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#ee307a","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#353535","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#353535","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#353535","dropdown-tab-head-text":"#ffffff","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#353535","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#353535","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#353535","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#353535","button-top-gradient-background-color":"#5b5b5b","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#353535","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","woocommerce-cart-icon-number-background":"#bd584e","woocommerce-cart-icon-number-color":"#ffffff","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#bd584e","woocommerce-theme-color":"#bd584e","woocommerce-price-color":"#bd584e","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#d4786e","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Gallery Thumbnail","width":"1280","height":"700","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"570","hard-crop":""},{"name":"Personnel Thumb","width":"600","height":"560","hard-crop":""},{"name":"Personnel Single","width":"600","height":"600","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1322","additional-mobile-css":"","enable-srcset":"disable","link-to-lightbox":"enable"}}'
				),
				'incorporate' => array(
					'title' => esc_html__('Incorporate', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/incorporate',
					'xml' => get_template_directory() . '/admin/function/files/incorporate.xml',
					'page' => 7,
					'menu' => array('right_menu' => 38, 'mobile_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-3"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"3":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"45px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"49","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"41px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"23px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1375","logo-top-padding":"66px","logo-bottom-padding":"32px","max-logo-width":"137px","main-navigation-top-padding":"74px","main-navigation-bottom-padding":"42px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"100px","default-title-bottom-padding":"100px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"1404","default-portfolio-title-background":"1404","default-personnel-title-background":"1404","default-search-title-background":"1404","default-archive-title-background":"1404","default-blog-title-style":"custom","default-blog-title-top-padding":"88px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"1404","default-blog-title-background-overlay-opacity":"0","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"7","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-social-instagram":"","top-bar-social-snapchat":"","mobile-logo":"","logo-left-padding":"","main-navigation-right-padding":"","enable-logo-on-main-navigation-sticky":"enable","enable-main-navigation-right-button":"disable","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-with-border","default-title-font-transform":"default","default-title-font-weight":"","default-caption-font-weight":"","blog-date-feature":"enable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","blog-social-share-count":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"footer-1","woocommerce-archive-sidebar-right":"footer-1","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-top-padding":"70px","footer-bottom-padding":"50px","copyright-top-padding":"38px","copyright-bottom-padding":"38px","enable-back-to-top":"disable","archive-date-feature":"enable","portfolio-icon-hover-link":"arrow_right-up","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_search","portfolio-icon-hover-size":"22px"},"gdlr_typography":{"heading-font":"Montserrat","navigation-font":"Montserrat","content-font":"Lora","info-font":"Lora","blog-info-font":"Lora","quote-font":"Lora","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"17px","content-line-height":"1.7","additional-font":"Georgia, serif","additional-font2":"Georgia, serif"},"gdlr_color":{"skin":[{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#a9a9a9","content":"#a9a9a9","icon":"#2d9bea","link":"#2d9bea","link-hover":"#52abea","divider":"#b5b5b5","border":"#c4c4c4","element-background":"#2d9bea","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#50a9e9","button-background-hover":"#2d9bea","button-border-color":"","button-border-hover-color":""},{"name":"Light Purple","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#d3d3ff","icon":"#d3d3ff","link":"#ffffff","link-hover":"#d3d3ff","divider":"","border":"","element-background":"","element-content":"","button-text":"#5252ce","button-text-hover":"#9a9ace","button-background":"#ffffff","button-background-hover":"#ddddff","button-border-color":"","button-border-hover-color":""},{"name":"Grey","title":"#272727","title-hover":"#272727","caption":"#adadad","content":"#878787","icon":"","link":"","link-hover":"","divider":"#c4c4c4","border":"#d1d1d1","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Grey Blog","title":"#303030","title-hover":"#303030","caption":"#969696","content":"#969696","icon":"","link":"","link-hover":"","divider":"","border":"#8a8a8a","element-background":"#ffffff","element-content":"#8a8a8a","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#c2c0ed","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#c2c0ed","border":"","element-background":"","element-content":"","button-text":"#5252ce","button-text-hover":"#9a9ace","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#363b56","header-plain-bottom-border-color":"#565656","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#5252ce","logo-background-color":"#ffffff","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#b7b7ce","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#e2e2e2","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#2d2d2d","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#262626","footer-title-color":"#ffffff","footer-content-color":"#939393","footer-link-color":"#939393","footer-link-hover-color":"#ffffff","footer-divider-color":"#383838","copyright-background-color":"#111111","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#5252ce","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#5252ce","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#5252ce","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#5252ce","price-table-active-head-top-gradient-color":"#6969ce","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#aaa7d6","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#5252ce","price-table-active-button-background-top-gradient-color":"#6d6dce","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#515151","accordion-title-color":"#949494","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#5252ce","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#292929","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#5252ce","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#5252ce","column-service-caption-color":"#747474","dropdown-tab-head-background":"#5252ce","dropdown-tab-head-text":"#252525","flipbox-background-color":"#5252ce","flipbox-border-color":"#5757af","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#5252ce","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#5252ce","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#6969ce","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#848484","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#5252ce","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#5252ce","button-background-hover-color":"#6767ce","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#5252ce","button-top-gradient-background-color":"#7171ce","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#5252ce","slider-outer-navigation-color":"#5252ce","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","page-preload-background-color":"#ffffff","woocommerce-cart-icon-number-background":"#5252ce","woocommerce-cart-icon-number-color":"#ffffff","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#bd584e","navigation-right-button-text-color":"#333333","navigation-right-button-background-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-hover-color":"","navigation-right-button-border-hover-color":"#555555","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#5252ce","woocommerce-theme-color":"#5252ce","woocommerce-price-color":"#5252ce","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#7b7bce","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Gallery Large","width":"1280","height":"700","hard-crop":""},{"name":"Frame Portfolio","width":"800","height":"590","hard-crop":""},{"name":"Frame Personnel","width":"800","height":"888","hard-crop":""},{"name":"Frame Blog","width":"800","height":"490","hard-crop":""},{"name":"Frame Square","width":"600","height":"600","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"7","additional-mobile-css":"","enable-srcset":"disable","link-to-lightbox":"enable","additional-head-script":"","enable-preload":"disable","preload-image":""}}'
				),
				'mechanic' => array(
					'title' => esc_html__('Mechanic', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/mechanic/',
					'xml' => get_template_directory() . '/admin/function/files/mechanic.xml',
					'page' => 5,
					'menu' => array('main_menu' => 38, 'right_menu' => 39, 'mobile_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-3"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"3":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"5px","enable-top-bar":"enable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"[gdlr_core_dropdown_tab]\n\n[gdlr_core_tab title=\"London\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +44 3656 4567 [gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ] Monday - Sunday 10:00 - 22:00 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ]12 Main Street Pt. London England \n\n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"New York\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +1 2223 4567 [gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ] Monday - Sunday 10:00 - 22:00 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ]4th Avenue Kingston Street New York USA\n\n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"San Francisco\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +1 8887-3342 [gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ] Monday - Sunday 10:00 - 22:00 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ]55th Floor Paulsson Building San Francisco \n\n[\/gdlr_core_tab]\n\n[\/gdlr_core_dropdown_tab]\n\n","top-bar-right-text":"","top-bar-top-padding":"18px","top-bar-bottom-padding":"18px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"boxed","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"100","boxed-top-bar-background-extend":"47px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"21px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"4","logo-top-padding":"32px","logo-bottom-padding":"23px","max-logo-width":"143px","main-navigation-top-padding":"37px","main-navigation-bottom-padding":"37px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"259px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"1325","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"258px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"1325","default-blog-title-background-overlay-opacity":"0","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"5","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Montserrat","navigation-font":"Montserrat","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Source Sans Pro","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Yellow","title":"","title-hover":"","caption":"","content":"","icon":"#333333","link":"","link-hover":"","divider":"","border":"#002e5b","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#002e5b","button-background-hover":"#002e5b","button-border-color":"","button-border-hover-color":""},{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#c3d7ea","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#355677","border":"#355677","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Light Service","title":"#f7c02e","title-hover":"#f7c02e","caption":"#9dafc0","content":"#9dafc0","icon":"#ffffff","link":"#f7c02e","link-hover":"#f7c02e","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#f7c02e","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#f7c02e","top-bar-social-hover-color":"#f7d985","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#002e5b","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#002e5b","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#282828","footer-title-color":"#ffffff","footer-content-color":"#969696","footer-link-color":"#999999","footer-link-hover-color":"#ffffff","footer-divider-color":"#444444","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#002e5b","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#002e5b","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#002e5b","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#002e5b","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#f7c02e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#303030","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#002e5b","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#002e5b","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#002e5b","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#002e5b","button-top-gradient-background-color":"#10365b","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#002e5b","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#d6d6d6","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Service Thumbnail","width":"750","height":"423","hard-crop":""},{"name":"Square Thumbnail","width":"400","height":"400","hard-crop":""},{"name":"Personnel Thumbnaul","width":"700","height":"477","hard-crop":""}],"additional-css":"#mechanic-counter .gdlr-core-counter-item-number{ font-weight: 700; }","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"5","additional-mobile-css":""}}',
				),
				'medical' => array(
					'title' => esc_html__('Medical', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/medical/',
					'xml' => get_template_directory() . '/admin/function/files/medical.xml',
					'page' => 1326,
					'menu' => array('main_menu' => 38, 'mobile_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-2"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":[],"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"21px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1334","logo-top-padding":"40px","logo-bottom-padding":"40px","max-logo-width":"200px","main-navigation-top-padding":"52px","main-navigation-bottom-padding":"45px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"disable","right-menu-type":"right","default-title-style":"small","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"1326","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"enable"},"gdlr_typography":{"heading-font":"Poppins","navigation-font":"Open Sans","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Open Sans","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"700","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Blue Light","title":"#ffffff","title-hover":"#ffffff","caption":"#cfebff","content":"#cfebff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#74a0c1","border":"#74a0c1","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Light2","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"#ffffff","link-hover":"#ffffff","divider":"#99d2fb","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Counter","title":"","title-hover":"","caption":"#30a8fe","content":"#30a8fe","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Column Service","title":"#5c91b6","title-hover":"","caption":"","content":"#8e8e8e","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact","title":"","title-hover":"","caption":"#656565","content":"#656565","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#1080d0","button-background-hover":"#1080d0","button-border-color":"","button-border-hover-color":""},{"name":"Personnel","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#242424","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#1080d0","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#aaaaaa","footer-link-hover-color":"#ffffff","footer-divider-color":"#3f3f3f","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#1080d0","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#1080d0","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#1080d0","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#ffffff","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#1166a3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#1080d0","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#1080d0","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#1080d0","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","search-overlay-background-color":"#0a0a0a","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#1080d0","button-top-gradient-background-color":"#4295d1","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#1080d0","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Personnel Thumb","width":"600","height":"387","hard-crop":""},{"name":"Blog Thumb","width":"700","height":"430","hard-crop":""}],"additional-css":"body .gdlr-core-testimonial-item .gdlr-core-testimonial-item-title{ text-transform : none; letter-spacing: 0; }\n\nbody .gdlr-core-accordion-style-box-icon .gdlr-core-accordion-item-title{ text-transform: none; letter-spacing: 0;  font-size: 17px; }\n\nbody .gdlr-core-block-item-title-wrap.gdlr-core-left-align .gdlr-core-block-item-title{ text-transform: none; letter-spacing: 0; }","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1326","additional-mobile-css":""}}',
				),
				'modernize' => array(
					'title' => esc_html__('Modernize', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/modernize/',
					'xml' => get_template_directory() . '/admin/function/files/modernize.xml',
					'page' => 4,
					'menu' => array('main_menu' => 2, 'right_menu' => 3, 'mobile_menu' => 2),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-2"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"boxed","body-margin":"0px","background-type":"pattern","background-image":"","background-pattern":"pattern-23","enable-boxed-border":"enable","item-padding":"15px","container-width":"1180px","container-padding":"30px","enable-top-bar":"enable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"<a href=\"#\" style=\"margin-right: 19px;\">About<\/a> <a href=\"#\" style=\"margin-right: 19px;\">Contact<\/a> <a href=\"#\" style=\"margin-right: 19px;\">Support<\/a>","top-bar-right-text":"[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ef7f2c\" margin-left=\"\" margin-right=\"10px\" ] +1 2223 4567 [gdlr_core_icon icon=\"fa fa-envelope\" size=\"16px\" color=\"#ef7f2c\" margin-left=\"27px\" margin-right=\"10px\" ] Contact@goodlayers.com [gdlr_core_icon icon=\"fa fa-clock-o\" size=\"16px\" color=\"#ef7f2c\" margin-left=\"27px\" margin-right=\"10px\" ] Monday - Sunday 10:00 - 22:00","top-bar-top-padding":"14px","top-bar-bottom-padding":"14px","top-bar-text-size":"13px","top-bar-bottom-border":"3px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"bar","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"left","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"23px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"15px\" color=\"#2c2c2c\" margin-right=\"25px\" link=\"http:\/\/facebook.com\/goodlayers\" link-target=\"_blank\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"15px\" color=\"#2c2c2c\" margin-right=\"25px\" link=\"#\" ][gdlr_core_icon icon=\"fa fa-pinterest\" size=\"15px\" color=\"#2c2c2c\" margin-right=\"25px\" link=\"#\" ][gdlr_core_icon icon=\"fa fa-google-plus\" size=\"15px\" color=\"#2c2c2c\" margin-right=\"\" link=\"#\" ]","logo-right-text-top-padding":"60px","logo":"1290","logo-top-padding":"49px","logo-bottom-padding":"45px","max-logo-width":"150px","main-navigation-top-padding":"23px","main-navigation-bottom-padding":"23px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"small","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"4","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Source Sans Pro","blog-info-font":"Source Sans Pro","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"12px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#d5d5d5","border":"#d5d5d5","element-background":"#000000","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#bcbcbc","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Grey","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#d5d5d5","border":"#d5d5d5","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#393939","top-bar-bottom-border-color":"#ef7f2c","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#ef7f2c","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#ef7f2c","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ededed","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#2b2b2b","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#848484","footer-link-hover-color":"#ffffff","footer-divider-color":"#494949","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#ef7f2c","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#ef7f2c","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#ef7f2c","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#ef7f2c","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#ef7f2c","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#262626","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#ef7f2c","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#ef7f2c","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#ef7f2c","button-top-gradient-background-color":"#ef8d43","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#ef7f2c","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Portfolio Thumbnail","width":"800","height":"510","hard-crop":""},{"name":"Square Thumbnail","width":"500","height":"500","hard-crop":""},{"name":"Gallery Thumbnail","width":"1280","height":"700","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"4","additional-mobile-css":""}}',
				),
				'nursinghome' => array(
					'title' => esc_html__('Nursing Home', 'infinite'),
					'url' => 'https://demo.goodlayers.com/infinite/homepages/nursinghome',
					'xml' => get_template_directory() . '/admin/function/files/nursinghome.xml',
					'page' => 5,
					'menu' => array('main_menu' => 8,  'mobile_menu' => 8),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"footer-1":[],"footer-2":[],"footer-3":[],"footer-4":[],"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"1":[],"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"35px","enable-top-bar":"enable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"20px","top-bar-left-text":"[gdlr_core_icon icon=\"fa fa-phone\" size=\"15px\" color=\"#34b5a1\" margin-left=\"\" margin-right=\"10px\" ]+1-2345-2345-54<div style=\"margin-left: 12px; margin-right: 14px; display: inline;\">&#183;<\/div>[gdlr_core_icon icon=\"fa fa-location-arrow\n\" size=\"14px\" color=\"#34b5a1\" margin-left=\"\" margin-right=\"10px\" ]Monday - Sunday 08:00 - 17:00<div style=\"margin-left: 10px; margin-right: 13px; display: inline;\">&#183;<\/div>[gdlr_core_icon icon=\"icon_clock_alt\" size=\"15px\" color=\"#34b5a1\" margin-left=\"\" margin-right=\"10px\" ]Mon - Fri 09:00-17:00","top-bar-right-text":"[gdlr_core_icon icon=\"fa fa-wheelchair\" size=\"15px\" color=\"#34b5a1\" margin-left=\"\" margin-right=\"10px\" ]24 hours service available","top-bar-top-padding":"20px","top-bar-bottom-padding":"20px","top-bar-text-size":"16px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"#","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"splitted-menu","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"30px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"20px","navigation-slide-bar":"enable","side-header-width-pixel":"305px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"104","logo-top-padding":"44px","logo-bottom-padding":"27px","max-logo-width":"145px","main-navigation-top-padding":"56px","main-navigation-bottom-padding":"54px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"medium","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"155","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"large","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"155","default-blog-title-background-overlay-opacity":"0","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"gdlr-core-sidebar-preset","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"enable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","blog-max-content-width":"900px","enable-maintenance":"disable","maintenance-page":"2039","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"gdlr-core-sidebar-preset","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"enable","boxed-layout-top-margin":"0px","background-image-opacity":"100","sidebar-title-divider":"enable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-menu-position":"none","top-bar-social-instagram":"","top-bar-social-snapchat":"","navigation-left-offset":"0","logo-left-padding":"","mobile-logo":"","max-tablet-logo-width":"","max-mobile-logo-width":"","mobile-logo-position":"logo-left","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","navigation-right-top-margin":"","enable-main-navigation-right-button":"enable","main-navigation-right-button-style":"round","main-navigation-right-button-text":"Request Help","main-navigation-right-button-link":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/nursinghome\/contact\/","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-with-border","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"","fixed-navigation-logo-top-padding":"20px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"30px","fixed-navigation-bottom-padding":"25px","fixed-navigation-anchor-offset":"75px","enable-mobile-navigation-sticky":"enable","default-title-font-transform":"","default-title-font-weight":"","default-caption-font-transform":"","default-caption-font-weight":"","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-blog-top-bottom-gradient":"enable","single-blog-title-top-gradient-size":"413px","single-blog-title-bottom-gradient-size":"382px","blog-style":"style-4","blockquote-style":"style-1","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","enable-related-post":"enable","related-post-blog-style":"blog-column","related-post-blog-column-style":"style-3","related-post-column-size":"20","related-post-meta-option":["date","author"],"related-post-thumbnail-size":"Personnel Thumbnail","related-post-num-fetch":"3","related-post-excerpt-number":"0","blog-social-share-count":"enable","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-date-feature":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_zoom-in_alt","portfolio-icon-hover-size":"22px","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-background":"","enable-footer-column-divider":"enable","footer-top-padding":"70px","footer-bottom-padding":"50px","copyright-style":"center","copyright-top-padding":"38px","copyright-bottom-padding":"38px","copyright-left":"","copyright-right":"","enable-back-to-top":"disable","top-bar-shadow-size":"","top-bar-shadow-color":"#000","navigation-slide-bar-top-margin":"-7","header-shadow-size":"","header-shadow-color":"#000","woocommerce-archive-product-style":"grid"},"gdlr_typography":{"heading-font":"Lora","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Georgia, serif","blog-info-font":"Open Sans","quote-font":"Georgia, serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"15px","navigation-font-weight":"700","navigation-text-transform":"none","content-font-size":"16px","content-line-height":"1.7","testimonial-font":"Open Sans","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","header-font-weight":"","content-font-weight":"","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-letter-spacing":"0","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"13px","sidebar-title-font-weight":"","sidebar-title-font-letter-spacing":"","sidebar-title-text-transform":"uppercase","footer-title-font-size":"13px","footer-title-font-weight":"","footer-title-font-letter-spacing":"","footer-title-text-transform":"uppercase","footer-font-size":"15px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"14px","copyright-font-weight":"","copyright-font-letter-spacing":"","copyright-text-transform":"uppercase","font-upload":""},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#cecece","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#777777","border":"#777777","element-background":"","element-content":"#3d3d3d","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#309cea","button-background-hover":"#0f82db","button-border-color":"","button-border-hover-color":""},{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#ffffff","border":"#ffffff","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#000000","button-background-hover":"#2d9bea","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Grey","title":"#3a3a3a","title-hover":"","caption":"#727272","content":"#494949","icon":"#595959","link":"","link-hover":"","divider":"#cecece","border":"#cecece","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue","title":"#ffffff","title-hover":"","caption":"#d9eef7","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#232323","button-background-hover":"#232323","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#51b0f3","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"#ffffff","caption":"#dddddd","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#b2b2b2","border":"#bcbcbc","element-background":"#191919","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Title","title":"#2d95e1","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"About Me Top","title":"#ffffff","title-hover":"","caption":"#acc3ff","content":"#95a3bc","icon":"","link":"","link-hover":"","divider":"#ffffff","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Maintenance","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"#74abd2","border":"#74abd2","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider White Text","title":"#ffffff","title-hover":"","caption":"#d6d6d6","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"#2d9bea","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Light Border","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#ebebeb","border":"#ebebeb","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Purple Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#4f66bd","button-background-hover":"#3250bc","button-border-color":"","button-border-hover-color":""},{"name":"medical examination","title":"#1f1f1f","title-hover":"","caption":"#828282","content":"#828282","icon":"","link":"","link-hover":"#34b5a1","divider":"#34b5a1","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"home care profressional","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"accordian FAQ","title":"#34b5a1","title-hover":"","caption":"#34b5a1","content":"#676767","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"FAQ","title":"#34b5a1","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Carousel","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"#b2b2b2","element-background":"","element-content":"#9b9b9b","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Stunning Text","title":"#34b5a1","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#ffffff","button-background-hover":"#ffffff","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"}],"top-bar-background-color":"#f7f7f7","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#6a6a6a","top-bar-link-color":"#6a6a6a","top-bar-link-hover-color":"#939393","top-bar-social-color":"#34b5a1","top-bar-social-hover-color":"#e44444","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#34b5a1","logo-background-color":"#ffffff","main-menu-text-color":"#828282","main-menu-text-hover-color":"#34b5a1","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#2d2d2d","body-content-color":"#666666","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e2e2e2","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","footer-background-color":"#282828","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#bababa","footer-link-hover-color":"#ffffff","footer-divider-color":"#494949","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#34b5a1","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#353535","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#34b5a1","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#303030","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2d9bea","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#2d9bea","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2d9bea","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#49b7df","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","search-overlay-background-color":"#000000","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","sidebar-title-color":"#383838","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#34b5a1","price-table-active-button-background-top-gradient-color":"#5ab5a7","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#34b5a1","button-background-hover-color":"#75b5a8","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#34b5a1","button-top-gradient-background-color":"#72b5a9","dropdown-tab-head-background":"#309cea","dropdown-tab-head-text":"#ffffff","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2d9bea","slider-outer-navigation-color":"#848484","slider-outer-navigation-background-color":"#383838","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","top-cart-background-color":"#ffffff","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-color":"#323232","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-color":"#ffffff","top-cart-checkout-background-color":"#000000","woocommerce-cart-icon-number-background":"#bd584e","woocommerce-cart-icon-number-color":"#ffffff","navigation-right-button-text-color":"#ffffff","navigation-right-button-text-hover-color":"#ffffff","navigation-right-button-background-color":"#34b5a1","navigation-right-button-background-hover-color":"#65b5a7","navigation-right-button-border-color":"#34b5a1","navigation-right-button-border-hover-color":"","page-preload-background-color":"#ffffff","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","tag-cloud-text-color":"","tag-cloud-background-color":"","tag-cloud-border-color":"","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-style-2-tags-color":"#34b5a1","single-blog-navigation2-left-overlay":"#34b5a1","single-blog-navigation2-overlay":"#34b5a1","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#272727","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#34b5a1","portfolio-frame-background-color":"#f5f5f5","portfolio-title-hover-color":"","portfolio-grid2-tag-background":"#34b5a1","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","slider-control-navigation-background-color":"#dfdfdf","testimonial-rating-color":"#ffa127","woocommerce-theme-color":"#bd584e","woocommerce-price-color":"#bd584e","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#d4786e","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e"},"gdlr_plugin":{"lightbox":"lightGallery","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Portfolio Metro 1","width":"290","height":"430","hard-crop":""},{"name":"Portfolio Metro 2","width":"290","height":"215","hard-crop":""},{"name":"Portfolio Metro 3","width":"590","height":"215","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Thumbnail 2","width":"550","height":"500","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"105","additional-mobile-css":"","enable-srcset":"disable","consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-head-script":"","additional-head-script2":"","enable-preload":"disable","preload-image":""}}'
				),
				'onepage' => array(
					'title' => esc_html__('One Page', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/onepage/',
					'xml' => get_template_directory() . '/admin/function/files/onepage.xml',
					'page' => 4,
					'menu' => array('main_menu' => 34, 'mobile_menu' => 34),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"footer-2":null,"footer-3":null,"footer-4":null,"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"1":[],"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"40px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"#","top-bar-social-lastfm":"","top-bar-social-linkedin":"#","top-bar-social-pinterest":"#","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"side","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"13px","navigation-slide-bar":"enable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1198","logo-top-padding":"77px","logo-bottom-padding":"67px","max-logo-width":"170px","main-navigation-top-padding":"0px","main-navigation-bottom-padding":"0px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"disable","enable-main-navigation-cart":"disable","right-menu-type":"left","default-title-style":"small","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"disable","footer-style":"footer-2","enable-copyright":"enable","copyright-text":"","enable-maintenance":"disable","maintenance-page":"4","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Open Sans","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#ffffff","border":"#ffffff","element-background":"#2e2e2e","element-content":"#2e2e2e","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#2d9bea","button-border-hover-color":""},{"name":"Dark Blue","title":"#2d9bea","title-hover":"#2d9bea","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Toggle","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#c6def1","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"","border":"#308acb","element-background":"#308acb","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Grey","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#cccccc","border":"#cccccc","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Blog","title":"#ffffff","title-hover":"#dddddd","caption":"#c9c9c9","content":"#ffffff","icon":"#e2e2e2","link":"#d6d6d6","link-hover":"#f7f7f7","divider":"#919191","border":"#898989","element-background":"#ffffff","element-content":"#6b6b6b","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#f5f5f5","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e2e2e2","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#ffffff","footer-link-hover-color":"#ffffff","footer-divider-color":"#303030","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2d9bea","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#2f9cea","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2f9cea","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#ffffff","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#ffffff","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2d9bea","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#9fc612","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2d9bea","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#36bddb","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#309cea","button-top-gradient-background-color":"#52aae9","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2d9bea","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Portrait","width":"600","height":"800","hard-crop":""},{"name":"Blog Thumbnail","width":"700","height":"400","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"4","additional-mobile-css":""}}',
				),
				'pet' => array(
					'title' => esc_html__('Pet', 'infinite'),
					'url' => 'https://demo.goodlayers.com/infinite/homepages/pet',
					'xml' => get_template_directory() . '/admin/function/files/pet.xml',
					'page' => 2121,
					'menu' => array('main_menu' => 41, 'mobile_menu' => 41),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":[],"footer-1":["text-2"],"footer-2":["text-3"],"footer-3":["gdlr-core-custom-menu-widget-2"],"footer-4":["text-4"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Useful Links","menu":"43","style":"half"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"_multiwidget":1},"widget_gdlr-core-opening-hour-widget":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"2":{"title":"","text":"<img class=\"size-full wp-image-1805\" src=\"https:\/\/demo.goodlayers.com\/infinite\/homepages\/pet\/wp-content\/uploads\/sites\/32\/2020\/01\/logo-footer.png\" alt=\"\" width=\"150\" \/>\r\n[gdlr_core_space height=\"5px\"]\r\nEmergency Numbers\r\n[gdlr_core_space height=\"-10px\"]\r\n[gdlr_core_icon icon=\"fa5s fa5-ambulance\" size=\"18px\" color=\"\" margin-left=\"\" margin-right=\"\" ] <span style=\"color: #f09a52; font-size: 19px;\">(+1) 212-946-2707<\/span>","filter":true,"visual":true},"3":{"title":"Contacts","text":"Mon - Fri: 8.00am 6.00pm [gdlr_core_space height=\"12px\"]112 W 34th St, New York  [gdlr_core_space height=\"12px\"] <a style=\"color: #ffffff;\" href=\"#\">sales@Infinite.com<\/a>[gdlr_core_space height=\"12px\"] <a style=\"color: #f09a52;\" href=\"#\">info@Infinite.com<\/a>","filter":true,"visual":true},"4":{"title":"Gallery","text":"[gallery ids=\"2314,2313,2315,2316,2318,2321\" source=\"gdlr-core\" style=\"grid\" thumbnail-size=\"Square Thumbnail\"]","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"_multiwidget":1},"widget_woocommerce_product_categories":{"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1280px","container-padding":"20px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"<div style=\"margin-top: -5px;\">\n[gdlr_core_dropdown_tab]\n\n[gdlr_core_tab title=\"London\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"10px\" ] +44 3656 4567 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#ffffff\" margin-left=\"27px\" margin-right=\"10px\" ]12 Main Street Pt. London England \n\n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"New York\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +1 2223 4567 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ]4th Avenue Kingston Street NY USA\n\n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"San Francisco\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +1 8887-3342 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ]55th Floor Paulsson San Francisco \n\n[\/gdlr_core_tab]\n\n[\/gdlr_core_dropdown_tab]\n<\/div>","top-bar-right-text":"<span style=\"color: #f6bf40;\">Phone: +1 212 946 2707<\/span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Help Center\n","top-bar-top-padding":"31px","top-bar-bottom-padding":"26px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"center-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"50","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"center-menu","boxed-top-bar-background-opacity":"100","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"28px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"21px","navigation-slide-bar":"style-dot","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"2284","logo-top-padding":"28px","logo-bottom-padding":"19px","max-logo-width":"145px","main-navigation-top-padding":"35px","main-navigation-bottom-padding":"32px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"113px","default-title-bottom-padding":"115px","default-page-caption-top-margin":"13px","default-title-font-size":"45px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"2307","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"113px","default-blog-title-bottom-padding":"114px","default-blog-feature-image":"content","default-blog-title-background-image":"1750","default-blog-title-background-overlay-opacity":"19","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-2","enable-copyright":"enable","copyright-text":"","enable-maintenance":"disable","maintenance-page":"5","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","background-image-opacity":"100","sidebar-title-divider":"enable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-menu-position":"none","top-bar-shadow-size":"","top-bar-shadow-color":"#000","top-bar-social-instagram":"#","top-bar-social-snapchat":"","navigation-left-offset":"0","navigation-slide-bar-top-margin":"-29px","header-shadow-size":"","header-shadow-color":"#000","logo-left-padding":"","mobile-logo":"","max-tablet-logo-width":"","max-mobile-logo-width":"","mobile-logo-position":"logo-left","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","navigation-right-top-margin":"-1px","enable-main-navigation-right-button":"enable","main-navigation-right-button-style":"round-with-shadow","main-navigation-right-button-text":"Contact Us","main-navigation-right-button-link":"#","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-small","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"","fixed-navigation-logo-top-padding":"20px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"24","fixed-navigation-bottom-padding":"25px","fixed-navigation-anchor-offset":"75px","enable-mobile-navigation-sticky":"enable","default-title-font-transform":"none","default-title-font-weight":"600","default-caption-font-transform":"","default-caption-font-weight":"","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-blog-top-bottom-gradient":"enable","single-blog-title-top-gradient-size":"370px","single-blog-title-bottom-gradient-size":"413px","blog-style":"style-1","blockquote-style":"style-1","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","enable-related-post":"enable","related-post-blog-style":"blog-column-with-frame","related-post-blog-column-style":"style-1","related-post-column-size":"20","related-post-meta-option":["date","author","category","comment-number"],"related-post-thumbnail-size":"full","related-post-num-fetch":"3","related-post-excerpt-number":"0","blog-social-share-count":"enable","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-date-feature":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-product-style":"grid","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_zoom-in_alt","portfolio-icon-hover-size":"22px","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-background":"1976","enable-footer-column-divider":"disable","footer-top-padding":"75px","footer-bottom-padding":"59px","copyright-style":"left-right","copyright-top-padding":"0px","copyright-bottom-padding":"29px","copyright-left":"Copyright \u00a92020 Infinite. All Rights Reserved. <a href=\"#\" style=\"text-decoration: underline;\">Terms of Use<\/a>","copyright-right":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-instagram\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"\" ]","enable-back-to-top":"disable","blog-title-style":"","main-navigation-search-icon":"fa fa-search","main-navigation-cart-icon":"fa fa-shopping-cart","navigation-slide-bar-width":"","navigation-slide-bar-height":"","fixed-navigation-slide-bar-top-margin":"-24px","enable-fixed-navigation-slide-bar":"enable","enable-logo":"enable","main-navigation-search-icon-top-margin":"","main-navigation-cart-icon-top-margin":"","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","single-portfolio-navigation-middle-link":"#","header-bar2-navigation-align":"center"},"gdlr_typography":{"heading-font":"Jost","navigation-font":"Jost","content-font":"Jost","info-font":"Jost","blog-info-font":"Jost","quote-font":"Montserrat","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"500","navigation-text-transform":"uppercase","content-font-size":"17px","content-line-height":"1.5","testimonial-font":"Jost","additional-font":"Playfair Display","additional-font2":"Georgia, serif","header-font-weight":"","content-font-weight":"","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-letter-spacing":"","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"13px","sidebar-title-font-weight":"","sidebar-title-font-letter-spacing":"","sidebar-title-text-transform":"uppercase","footer-title-font-size":"20px","footer-title-font-weight":"400","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"15px","copyright-font-weight":"500","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","font-upload":[{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/pet\/wp-content\/uploads\/sites\/32\/2020\/01\/Jost-400-Book.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/pet\/wp-content\/uploads\/sites\/32\/2020\/01\/Jost-400-Book.ttf","woff":"","font-weight":"400","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-100-Hairline.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-100-Hairline.ttf","woff":"","font-weight":"100","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-200-Thin.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-200-Thin.ttf","woff":"","font-weight":"200","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-300-Light.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-300-Light.ttf","woff":"","font-weight":"300","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-500-Medium.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-500-Medium.ttf","woff":"","font-weight":"500","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-600-Semi.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-600-Semi.ttf","woff":"","font-weight":"600","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-700-Bold.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-700-Bold.ttf","woff":"","font-weight":"700","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-800-Heavy.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-800-Heavy.ttf","woff":"","font-weight":"800","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-900-Black.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-900-Black.ttf","woff":"","font-weight":"900","font-style":"normal"}],"google-font-display":"optional","sub-navigation-font-size":""},"gdlr_color":{"skin":[{"name":"Yellow","title":"","title-hover":"","caption":"","content":"","icon":"#333333","link":"","link-hover":"","divider":"","border":"#002e5b","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#002e5b","button-background-hover":"#002e5b","button-border-color":"","button-border-hover-color":""},{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#c3d7ea","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#355677","border":"#355677","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Light Service","title":"#f7c02e","title-hover":"#f7c02e","caption":"#9dafc0","content":"#9dafc0","icon":"#ffffff","link":"#f7c02e","link-hover":"#f7c02e","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#f7c02e","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"volumn tran","title":"#002e5b","title-hover":"","caption":"","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc","title":"#002e5b","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"counter","title":"#002e5b","title-hover":"","caption":"#373737","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"service","title":"#002e5b","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Yellow Link","title":"#002e5b","title-hover":"#f6bf40","caption":"#b1b1b1","content":"","icon":"","link":"#777777","link-hover":"#f6bf40","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Pet Column SVC","title":"#002e5b","title-hover":"","caption":"#373737","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Pet Personal","title":"#002e5b","title-hover":"","caption":"#373737","content":"#373737","icon":"#ffffff","link":"#002e5b","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#f09a52","top-bar-social-hover-color":"#efa970","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2ed47d","logo-background-color":"#ffffff","main-menu-text-color":"#002e5b","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#686868","heading-color":"#002e5b","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#f5f5f5","input-box-border-color":"#f5f5f5","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#222222","footer-title-color":"#ffffff","footer-content-color":"#dddddd","footer-link-color":"#ffffff","footer-link-hover-color":"#f09a52","footer-divider-color":"#444444","copyright-background-color":"#222222","copyright-text-color":"#6b7a90","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#002e5b","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#002e5b","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#002e5b","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#002e5b","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#002e5b","accordion-title-background-active-color":"#f09a52","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#002e5b","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#f7c02e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f09a52","dropdown-tab-head-text":"#303030","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#002e5b","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#002e5b","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#002e5b","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#f09a52","button-background-hover-color":"#efab73","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#002e5b","button-top-gradient-background-color":"#10365b","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#002e5b","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#f09a52","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#d6d6d6","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#efefef","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","top-cart-background-color":"#ffffff","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-color":"#323232","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-color":"#ffffff","top-cart-checkout-background-color":"#000000","woocommerce-cart-icon-number-background":"#f09a52","woocommerce-cart-icon-number-color":"#ffffff","navigation-right-button-text-color":"#f09a52","navigation-right-button-text-hover-color":"#0a0703","navigation-right-button-background-color":"#ffffff","navigation-right-button-background-hover-color":"#ffffff","navigation-right-button-border-color":"#ffffff","navigation-right-button-border-hover-color":"#ffffff","navigation-right-button-shadow-color":"#0a0000","page-preload-background-color":"#ffffff","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","tag-cloud-text-color":"","tag-cloud-background-color":"","tag-cloud-border-color":"","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","copyright-link-color":"#adb9ca","copyright-link-hover-color":"#ffffff","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-style-2-tags-color":"#343de9","single-blog-navigation2-left-overlay":"#343de9","single-blog-navigation2-overlay":"#343de9","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#272727","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#343de2","portfolio-frame-background-color":"#ffffff","portfolio-title-hover-color":"","portfolio-grid2-tag-background":"#3d3ac2","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","slider-control-navigation-background-color":"#e7e7e7","testimonial-rating-color":"#ffa127","woocommerce-theme-color":"#f09a52","woocommerce-price-color":"#f09a52","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#f09a52","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#002e5b","product-item-title-hover-color":"#ed9a59","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#f09a52","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#f09a52","widget-price-filter-handle-color":"#efb88b","testimonial-frame-background-color":"#ffffff","navigation-right-button2-text-color":"","navigation-right-button2-text-hover-color":"","navigation-right-button2-background-color":"","navigation-right-button2-background-hover-color":"","navigation-right-button2-border-color":"","navigation-right-button2-border-hover-color":"","custom-menu-widget-box-style-background-active":"#143369","single-portfolio-nav-icon":"#4275dc","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#2653e3","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#abbfff","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Service Thumbnail","width":"750","height":"423","hard-crop":""},{"name":"Square Thumbnail","width":"400","height":"400","hard-crop":""},{"name":"Personnel Thumbnaul","width":"700","height":"477","hard-crop":""}],"additional-css":"figure.alignleft.is-resized {\n    margin-right: 35px;\n}\n.infinite-single-related-post-container .gdlr-core-blog-grid .gdlr-core-blog-title {\n    font-size: 17px;\n    font-weight: 600;\n}\n\n.infinite-footer-wrapper .infinite-item-mgb, .infinite-footer-wrapper .gdlr-core-item-mgb {\n    margin-bottom: 20px;\n    padding-left: 0;\n}\n.infinite-footer-wrapper .infinite-item-rvpdlr, .infinite-footer-wrapper .gdlr-core-item-rvpdlr {\n     margin-left: 0px; \n     margin-right: 0px; \n}","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"2121","additional-mobile-css":"","enable-srcset":"enable","consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-head-script":"","additional-head-script2":"","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","fa5","elegant-font"],"additional-body-script":""}}'
				),
				'restaurant' => array(
					'title' => esc_html__('Restaurant', 'infinite'),
					'url' => 'https://demo.goodlayers.com/infinite/homepages/restaurant/',
					'xml' => get_template_directory() . '/admin/function/files/restaurant.xml',
					'page' => 2051,
					'menu' => array('main_menu' => 41, 'mobile_menu' => 41),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":[],"footer-1":["text-2"],"footer-2":["text-3"],"footer-3":["gdlr-core-custom-menu-widget-2"],"footer-4":["text-4","gdlr-core-newsletter-widget-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Useful Links","menu":"40","style":"half"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"2":{"title":"","icon-color":"#ffc327"},"_multiwidget":1},"widget_gdlr-core-opening-hour-widget":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"_multiwidget":1},"widget_gdlr-core-recent-event-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"2":{"title":"","text":"<img src=\"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/07\/footer-logo.png\" alt=\"\" width=\"150\" class=\"size-full wp-image-1805\" \/>\r\n[gdlr_core_space height=\"5px\"]\r\nWe keep your business in motion and your cargo on track. We offer dedicated transport, warehousing and logistics solutions across the world.","filter":true,"visual":true},"3":{"title":"Contacts","text":"Mon - Fri: 8.00am 6.00pm [gdlr_core_space height=\"12px\"]112 W 34th St, New York [gdlr_core_space height=\"12px\"](+1) 212-946-2707 [gdlr_core_space height=\"12px\"] <a href=\"#\" style=\"color: #f6bf40;\">info@Infinite.com<\/a>","filter":true,"visual":true},"4":{"title":"Subscribe to our newsletter","text":"Get the latest business resources on the market delivered to your inbox.\r\n[gdlr_core_space height=\"-40px\"]","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"_multiwidget":1},"widget_woocommerce_product_categories":{"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1240px","container-padding":"5px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"<div style=\"margin-top: -5px;\">\n[gdlr_core_dropdown_tab]\n\n[gdlr_core_tab title=\"London\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"10px\" ] +44 3656 4567 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#ffffff\" margin-left=\"27px\" margin-right=\"10px\" ]12 Main Street Pt. London England \n\n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"New York\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +1 2223 4567 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ]4th Avenue Kingston Street NY USA\n\n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"San Francisco\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +1 8887-3342 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ]55th Floor Paulsson San Francisco \n\n[\/gdlr_core_tab]\n\n[\/gdlr_core_dropdown_tab]\n<\/div>","top-bar-right-text":"<span style=\"color: #f6bf40;\">Phone: +1 212 946 2707<\/span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Help Center\n","top-bar-top-padding":"31px","top-bar-bottom-padding":"26px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"50","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"center-menu","boxed-top-bar-background-opacity":"100","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"28px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"21px","navigation-slide-bar":"style-dot","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"2184","logo-top-padding":"37px","logo-bottom-padding":"23px","max-logo-width":"145px","main-navigation-top-padding":"45px","main-navigation-bottom-padding":"20px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"left","default-title-top-padding":"151px","default-title-bottom-padding":"150px","default-page-caption-top-margin":"22px","default-title-font-size":"52px","default-title-letter-spacing":"0px","default-caption-font-size":"18px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"2195","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"113px","default-blog-title-bottom-padding":"114px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"19","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-2","enable-copyright":"enable","copyright-text":"","enable-maintenance":"disable","maintenance-page":"5","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","background-image-opacity":"100","sidebar-title-divider":"enable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-menu-position":"none","top-bar-shadow-size":"","top-bar-shadow-color":"#000","top-bar-social-instagram":"#","top-bar-social-snapchat":"","navigation-left-offset":"0","navigation-slide-bar-top-margin":"-10px","header-shadow-size":"","header-shadow-color":"#000","logo-left-padding":"","mobile-logo":"","max-tablet-logo-width":"","max-mobile-logo-width":"","mobile-logo-position":"logo-left","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","navigation-right-top-margin":"","enable-main-navigation-right-button":"disable","main-navigation-right-button-style":"default","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-small","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"","fixed-navigation-logo-top-padding":"23px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"30px","fixed-navigation-bottom-padding":"25px","fixed-navigation-anchor-offset":"75px","enable-mobile-navigation-sticky":"enable","default-title-font-transform":"none","default-title-font-weight":"700","default-caption-font-transform":"uppercase","default-caption-font-weight":"500","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-blog-top-bottom-gradient":"enable","single-blog-title-top-gradient-size":"370px","single-blog-title-bottom-gradient-size":"413px","blog-style":"style-1","blockquote-style":"style-1","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","enable-related-post":"enable","related-post-blog-style":"blog-column-with-frame","related-post-blog-column-style":"style-1","related-post-column-size":"20","related-post-meta-option":["date","author","category","comment-number"],"related-post-thumbnail-size":"full","related-post-num-fetch":"3","related-post-excerpt-number":"0","blog-social-share-count":"enable","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-date-feature":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-product-style":"grid","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"arrow_right-up","portfolio-icon-hover-video":"fa fa-play","portfolio-icon-hover-image":"icon_plus","portfolio-icon-hover-size":"22px","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-background":"1976","enable-footer-column-divider":"disable","footer-top-padding":"100px","footer-bottom-padding":"70px","copyright-style":"left-right","copyright-top-padding":"0px","copyright-bottom-padding":"29px","copyright-left":"Copyright \u00a92019 Infinite. All Rights Reserved. <a href=\"#\" style=\"text-decoration: underline;\">Terms of Use<\/a>","copyright-right":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-instagram\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"\" ]","enable-back-to-top":"disable","blog-title-style":"","main-navigation-search-icon":"fa fa-search","main-navigation-cart-icon":"fa fa-shopping-cart","navigation-slide-bar-width":"","navigation-slide-bar-height":"","fixed-navigation-slide-bar-top-margin":"-25px","enable-fixed-navigation-slide-bar":"enable","header-bar2-navigation-align":"center","enable-logo":"enable","main-navigation-search-icon-top-margin":"","main-navigation-cart-icon-top-margin":"","main-navigation-right-button-style-2":"default","main-navigation-right-button-text-2":"Buy Now","main-navigation-right-button-link-2":"","main-navigation-right-button-link-target-2":"_self","single-portfolio-navigation-middle-link":"#","custom-header":"","sidebar-heading-tag":"h3","top-bar-social-position":"right","logo2x":"2185","fixed-navigation-bar-logo2x":"","enable-float-social":"disable","display-float-social-after-page-title":"disable","float-social-delicious":"","float-social-email":"","float-social-deviantart":"","float-social-digg":"","float-social-facebook":"","float-social-flickr":"","float-social-google-plus":"","float-social-lastfm":"","float-social-linkedin":"","float-social-pinterest":"","float-social-rss":"","float-social-skype":"","float-social-stumbleupon":"","float-social-tumblr":"","float-social-twitter":"","float-social-vimeo":"","float-social-youtube":"","float-social-instagram":"","float-social-snapchat":"","blog-facebook-access-token":"","default-event-title-background":"","default-event-sidebar":"none","default-event-sidebar-left":"gdlr-core-sidebar-preset","default-event-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-product-amount":""},"gdlr_typography":{"heading-font":"Playfair Display","navigation-font":"Jost","content-font":"Jost","info-font":"Jost","blog-info-font":"Jost","quote-font":"Montserrat","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"500","navigation-text-transform":"uppercase","content-font-size":"17px","content-line-height":"1.5","testimonial-font":"Playfair Display","additional-font":"Jost","additional-font2":"Georgia, serif","header-font-weight":"","content-font-weight":"","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-letter-spacing":"1px","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"13px","sidebar-title-font-weight":"","sidebar-title-font-letter-spacing":"","sidebar-title-text-transform":"uppercase","footer-title-font-size":"20px","footer-title-font-weight":"400","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"15px","copyright-font-weight":"500","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","font-upload":"","google-font-display":"","sub-navigation-font-size":"16px","sub-navigation-font-weight":"500","sub-navigation-text-transform":"none"},"gdlr_color":{"skin":[{"name":"Yellow","title":"","title-hover":"","caption":"","content":"","icon":"#333333","link":"","link-hover":"","divider":"","border":"#002e5b","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#002e5b","button-background-hover":"#002e5b","button-border-color":"","button-border-hover-color":""},{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#c3d7ea","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#355677","border":"#355677","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Light Service","title":"#f7c02e","title-hover":"#f7c02e","caption":"#9dafc0","content":"#9dafc0","icon":"#ffffff","link":"#f7c02e","link-hover":"#f7c02e","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#f7c02e","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"volumn tran","title":"#002e5b","title-hover":"","caption":"","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc","title":"#002e5b","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"counter","title":"#002e5b","title-hover":"","caption":"#373737","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"service","title":"#002e5b","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Yellow Link","title":"#002e5b","title-hover":"#f6bf40","caption":"#b1b1b1","content":"","icon":"","link":"#777777","link-hover":"#f6bf40","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#f6bf40","top-bar-social-hover-color":"#f7d985","header-background-color":"#191919","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#f6bf40","logo-background-color":"#ffffff","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#ffffff","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#494949","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#686868","heading-color":"#002e5b","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#f5f5f5","input-box-border-color":"#f5f5f5","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#222222","footer-title-color":"#ffffff","footer-content-color":"#dddddd","footer-link-color":"#ffffff","footer-link-hover-color":"#f6bf40","footer-divider-color":"#444444","copyright-background-color":"#222222","copyright-text-color":"#6b7a90","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#002e5b","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#002e5b","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#002e5b","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#002e5b","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#002e5b","accordion-title-background-active-color":"#f6bf40","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#002e5b","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#f7c02e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#303030","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#002e5b","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#d4af37","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#002e5b","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#424242","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#ffffff","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#3a3a3a","button-text-hover-color":"#ffffff","button-background-color":"#f6bf40","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#002e5b","button-top-gradient-background-color":"#10365b","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#002e5b","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#f6bf40","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#d6d6d6","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","top-cart-background-color":"#ffffff","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-color":"#323232","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-color":"#ffffff","top-cart-checkout-background-color":"#000000","woocommerce-cart-icon-number-background":"#bd584e","woocommerce-cart-icon-number-color":"#ffffff","navigation-right-button-text-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-color":"","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#ffffff","navigation-right-button-border-hover-color":"#ffffff","navigation-right-button-shadow-color":"#000","page-preload-background-color":"#ffffff","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","tag-cloud-text-color":"","tag-cloud-background-color":"","tag-cloud-border-color":"","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","copyright-link-color":"#adb9ca","copyright-link-hover-color":"#ffffff","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-style-2-tags-color":"#343de9","single-blog-navigation2-left-overlay":"#343de9","single-blog-navigation2-overlay":"#343de9","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#272727","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#343de2","portfolio-frame-background-color":"#f5f5f5","portfolio-title-hover-color":"","portfolio-grid2-tag-background":"#3d3ac2","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","slider-control-navigation-background-color":"#e7e7e7","testimonial-rating-color":"#ffa127","woocommerce-theme-color":"#bd584e","woocommerce-price-color":"#bd584e","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#d4786e","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e","testimonial-frame-background-color":"#ffffff","single-portfolio-nav-icon":"#4275dc","sub-menu-shadow-size":"","sub-menu-shadow-opacity":"0.15","sub-menu-shadow-color":"#000","fixed-menu-shadow-size":"","fixed-menu-shadow-opacity":"0.15","fixed-menu-shadow-color":"#000","navigation-right-button2-text-color":"","navigation-right-button2-text-hover-color":"","navigation-right-button2-background-color":"","navigation-right-button2-background-hover-color":"","navigation-right-button2-border-color":"","navigation-right-button2-border-hover-color":"","page-title-background-color":"#000000","float-social-color":"#ffffff","float-social-hover-color":"#ffffff","float-social-footer-color":"#ffffff","float-social-footer-hover-color":"#ffffff","custom-menu-widget-box-style-background-active":"#143369","blog-thumbnail-date-background":"#efefef","blog-thumbnail-date-text":"#3dbca8","event-item-date-color":"#50bd77","event-item-month-color":"#152647","event-item-title-color":"#182847","event-item-info-color":"#50bd77","single-portfolio-nav-background":"#f3f3f3","portfolio-medium-feature-content-bg-color":"#2653e3","portfolio-medium-feature-title-color":"#ffffff","portfolio-medium-feature-tag-color":"#abbfff","custom-slider-navigation-color":"#a7a7a7","custom-slider-navigation-hover-color":"#a7a7a7"},"gdlr_plugin":{"lightbox":"lightGallery","thumbnail-sizing":[{"name":"Service Thumbnail","width":"750","height":"423","hard-crop":""},{"name":"Square Thumbnail","width":"400","height":"400","hard-crop":""},{"name":"Personnel Thumbnaul","width":"700","height":"477","hard-crop":""}],"additional-css":"figure.alignleft.is-resized {\n    margin-right: 35px;\n}\n.jost-font, .jost-font h1, .jost-font h2, .jost-font h3, .jost-font h4, .jost-font h5{ font-family: Jost !important;}","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"2145","additional-mobile-css":"","enable-srcset":"enable","consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-head-script":"","additional-head-script2":"","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","elegant-font"],"additional-body-script":""}}'
				),
				'transportation' => array(
					'title' => esc_html__('Transportation', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/transportation/',
					'xml' => get_template_directory() . '/admin/function/files/transportation.xml',
					'page' => 1442,
					'menu' => array('main_menu' => 38, 'mobile_menu' => 38, 'right_menu' => 39),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":[],"footer-1":["text-2"],"footer-2":["text-3"],"footer-3":["gdlr-core-custom-menu-widget-2"],"footer-4":["text-4","gdlr-core-newsletter-widget-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Useful Links","menu":"40","style":"half"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"2":{"title":"","icon-color":"#ffc327"},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"2":{"title":"","text":"<img src=\"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/07\/footer-logo.png\" alt=\"\" width=\"150\" class=\"size-full wp-image-1805\" \/>\r\n[gdlr_core_space height=\"5px\"]\r\nWe keep your business in motion and your cargo on track. We offer dedicated transport, warehousing and logistics solutions across the world.","filter":true,"visual":true},"3":{"title":"Contacts","text":"Mon - Fri: 8.00am 6.00pm [gdlr_core_space height=\"12px\"]112 W 34th St, New York [gdlr_core_space height=\"12px\"](+1) 212-946-2707 [gdlr_core_space height=\"12px\"] <a href=\"#\" style=\"color: #f6bf40;\">info@Infinite.com<\/a>","filter":true,"visual":true},"4":{"title":"Subscribe to our newsletter","text":"Get the latest business resources on the market delivered to your inbox.\r\n[gdlr_core_space height=\"-40px\"]","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"_multiwidget":1},"widget_woocommerce_product_categories":{"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1240px","container-padding":"5px","enable-top-bar":"enable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"<div style=\"margin-top: -5px;\">\n[gdlr_core_dropdown_tab]\n\n[gdlr_core_tab title=\"London\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"10px\" ] +44 3656 4567 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#ffffff\" margin-left=\"27px\" margin-right=\"10px\" ]12 Main Street Pt. London England \n\n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"New York\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +1 2223 4567 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ]4th Avenue Kingston Street NY USA\n\n[\/gdlr_core_tab]\n\n[gdlr_core_tab title=\"San Francisco\"]\n\n[gdlr_core_icon icon=\"fa fa-phone\" size=\"16px\" color=\"#f7c02e\" margin-left=\"\" margin-right=\"10px\" ] +1 8887-3342 [gdlr_core_icon icon=\"fa fa-location-arrow\" size=\"16px\" color=\"#f7c02e\" margin-left=\"27px\" margin-right=\"10px\" ]55th Floor Paulsson San Francisco \n\n[\/gdlr_core_tab]\n\n[\/gdlr_core_dropdown_tab]\n<\/div>","top-bar-right-text":"<span style=\"color: #f6bf40;\">Phone: +1 212 946 2707<\/span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Help Center\n","top-bar-top-padding":"31px","top-bar-bottom-padding":"26px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"#","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"#","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"boxed","header-plain-style":"center-logo","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"center-menu","boxed-top-bar-background-opacity":"100","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"28px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"15px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"21px","navigation-slide-bar":"style-2","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1510","logo-top-padding":"32px","logo-bottom-padding":"23px","max-logo-width":"145px","main-navigation-top-padding":"37px","main-navigation-bottom-padding":"37px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"113px","default-title-bottom-padding":"115px","default-page-caption-top-margin":"13px","default-title-font-size":"45px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"19","default-title-background":"1748","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"113px","default-blog-title-bottom-padding":"114px","default-blog-feature-image":"content","default-blog-title-background-image":"1750","default-blog-title-background-overlay-opacity":"19","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-2","enable-copyright":"enable","copyright-text":"","enable-maintenance":"disable","maintenance-page":"5","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","background-image-opacity":"100","sidebar-title-divider":"enable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-menu-position":"none","top-bar-shadow-size":"","top-bar-shadow-color":"#000","top-bar-social-instagram":"#","top-bar-social-snapchat":"","navigation-left-offset":"0","navigation-slide-bar-top-margin":"-3px","header-shadow-size":"","header-shadow-color":"#000","logo-left-padding":"","mobile-logo":"","max-tablet-logo-width":"","max-mobile-logo-width":"","mobile-logo-position":"logo-left","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","navigation-right-top-margin":"","enable-main-navigation-right-button":"disable","main-navigation-right-button-style":"default","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-small","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"","fixed-navigation-logo-top-padding":"20px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"30px","fixed-navigation-bottom-padding":"25px","fixed-navigation-anchor-offset":"75px","enable-mobile-navigation-sticky":"enable","default-title-font-transform":"none","default-title-font-weight":"600","default-caption-font-transform":"","default-caption-font-weight":"","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-blog-top-bottom-gradient":"enable","single-blog-title-top-gradient-size":"370px","single-blog-title-bottom-gradient-size":"413px","blog-style":"style-1","blockquote-style":"style-1","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","enable-related-post":"enable","related-post-blog-style":"blog-column-with-frame","related-post-blog-column-style":"style-1","related-post-column-size":"20","related-post-meta-option":["date","author","category","comment-number"],"related-post-thumbnail-size":"full","related-post-num-fetch":"3","related-post-excerpt-number":"0","blog-social-share-count":"enable","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-date-feature":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-product-style":"grid","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"icon_zoom-in_alt","portfolio-icon-hover-size":"22px","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-background":"1976","enable-footer-column-divider":"disable","footer-top-padding":"100px","footer-bottom-padding":"70px","copyright-style":"left-right","copyright-top-padding":"0px","copyright-bottom-padding":"29px","copyright-left":"Copyright \u00a92019 Infinite. All Rights Reserved. <a href=\"#\" style=\"text-decoration: underline;\">Terms of Use<\/a>","copyright-right":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-instagram\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"\" ]","enable-back-to-top":"disable","blog-title-style":"","main-navigation-search-icon":"fa fa-search","main-navigation-cart-icon":"fa fa-shopping-cart","navigation-slide-bar-width":"","navigation-slide-bar-height":"","fixed-navigation-slide-bar-top-margin":"","enable-fixed-navigation-slide-bar":"enable"},"gdlr_typography":{"heading-font":"Jost","navigation-font":"Jost","content-font":"Jost","info-font":"Jost","blog-info-font":"Jost","quote-font":"Montserrat","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"500","navigation-text-transform":"uppercase","content-font-size":"17px","content-line-height":"1.5","testimonial-font":"Open Sans","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","header-font-weight":"","content-font-weight":"","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-letter-spacing":"","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"13px","sidebar-title-font-weight":"","sidebar-title-font-letter-spacing":"","sidebar-title-text-transform":"uppercase","footer-title-font-size":"20px","footer-title-font-weight":"400","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"16px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"15px","copyright-font-weight":"500","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","font-upload":[{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/07\/Jost-400-Book.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/07\/Jost-400-Book.ttf","woff":"","font-weight":"400","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-100-Hairline.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-100-Hairline.ttf","woff":"","font-weight":"100","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-200-Thin.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-200-Thin.ttf","woff":"","font-weight":"200","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-300-Light.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-300-Light.ttf","woff":"","font-weight":"300","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-500-Medium.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-500-Medium.ttf","woff":"","font-weight":"500","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-600-Semi.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-600-Semi.ttf","woff":"","font-weight":"600","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-700-Bold.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-700-Bold.ttf","woff":"","font-weight":"700","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-800-Heavy.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-800-Heavy.ttf","woff":"","font-weight":"800","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-900-Black.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/transportations\/wp-content\/uploads\/sites\/28\/2019\/08\/Jost-900-Black.ttf","woff":"","font-weight":"900","font-style":"normal"}],"google-font-display":"optional"},"gdlr_color":{"skin":[{"name":"Yellow","title":"","title-hover":"","caption":"","content":"","icon":"#333333","link":"","link-hover":"","divider":"","border":"#002e5b","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#002e5b","button-background-hover":"#002e5b","button-border-color":"","button-border-hover-color":""},{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#c3d7ea","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#355677","border":"#355677","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Light Service","title":"#f7c02e","title-hover":"#f7c02e","caption":"#9dafc0","content":"#9dafc0","icon":"#ffffff","link":"#f7c02e","link-hover":"#f7c02e","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Team","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#f7c02e","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"volumn tran","title":"#002e5b","title-hover":"","caption":"","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"acc","title":"#002e5b","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"counter","title":"#002e5b","title-hover":"","caption":"#373737","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"service","title":"#002e5b","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Yellow Link","title":"#002e5b","title-hover":"#f6bf40","caption":"#b1b1b1","content":"","icon":"","link":"#777777","link-hover":"#f6bf40","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#f6bf40","top-bar-social-hover-color":"#f7d985","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#f6bf40","logo-background-color":"#ffffff","main-menu-text-color":"#222222","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#686868","heading-color":"#002e5b","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e6e6e6","input-box-background-color":"#f5f5f5","input-box-border-color":"#f5f5f5","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#222222","footer-title-color":"#ffffff","footer-content-color":"#dddddd","footer-link-color":"#ffffff","footer-link-hover-color":"#f6bf40","footer-divider-color":"#444444","copyright-background-color":"#222222","copyright-text-color":"#6b7a90","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#ffffff","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#002e5b","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#002e5b","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#002e5b","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#002e5b","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#002e5b","accordion-title-background-active-color":"#f6bf40","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#002e5b","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#f7c02e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#303030","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#002e5b","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#002e5b","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#002e5b","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#3a3a3a","button-text-hover-color":"#ffffff","button-background-color":"#f6bf40","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#002e5b","button-top-gradient-background-color":"#10365b","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#002e5b","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#f6bf40","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#d6d6d6","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","top-cart-background-color":"#ffffff","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-color":"#323232","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-color":"#ffffff","top-cart-checkout-background-color":"#000000","woocommerce-cart-icon-number-background":"#bd584e","woocommerce-cart-icon-number-color":"#ffffff","navigation-right-button-text-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-color":"","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-border-hover-color":"#555555","navigation-right-button-shadow-color":"#000","page-preload-background-color":"#ffffff","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","tag-cloud-text-color":"","tag-cloud-background-color":"","tag-cloud-border-color":"","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","copyright-link-color":"#adb9ca","copyright-link-hover-color":"#ffffff","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-style-2-tags-color":"#343de9","single-blog-navigation2-left-overlay":"#343de9","single-blog-navigation2-overlay":"#343de9","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#272727","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#343de2","portfolio-frame-background-color":"#f5f5f5","portfolio-title-hover-color":"","portfolio-grid2-tag-background":"#3d3ac2","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","slider-control-navigation-background-color":"#e7e7e7","testimonial-rating-color":"#ffa127","woocommerce-theme-color":"#bd584e","woocommerce-price-color":"#bd584e","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#d4786e","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e","testimonial-frame-background-color":"#ffffff"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Service Thumbnail","width":"750","height":"423","hard-crop":""},{"name":"Square Thumbnail","width":"400","height":"400","hard-crop":""},{"name":"Personnel Thumbnaul","width":"700","height":"477","hard-crop":""}],"additional-css":"figure.alignleft.is-resized {\n    margin-right: 35px;\n}\n.infinite-single-related-post-container .gdlr-core-blog-grid .gdlr-core-blog-title {\n    font-size: 17px;\n    font-weight: 600;\n}","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1442","additional-mobile-css":"","enable-srcset":"enable","consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","link-to-lightbox":"enable","lightbox-video-autoplay":"enable","additional-head-script":"","additional-head-script2":"","enable-preload":"disable","preload-image":"","font-icon":["font-awesome","elegant-font"]}}'
				),
				'furniture' => array(
					'title' => esc_html__('Furniture', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/furniture/',
					'xml' => get_template_directory() . '/admin/function/files/furniture.xml',
					'page' => 1404,
					'menu' => array('main_menu' => 49, 'mobile_menu' => 49),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Woocommerce","id":"woocommerce"}],"sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":["recent-posts-2","recent-comments-2"],"footer-1":["text-2"],"footer-2":[],"footer-3":["tag_cloud-2"],"footer-4":[],"woocommerce":["woocommerce_product_categories-2","woocommerce_top_rated_products-2","woocommerce_rating_filter-2","woocommerce_product_tag_cloud-2","woocommerce_recent_reviews-2","woocommerce_price_filter-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"Recent Comments","number":4},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of ","filter":false},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"2":{"title":"Filter by price"},"_multiwidget":1},"widget_woocommerce_product_categories":{"2":{"title":"Product Categories","orderby":"name","dropdown":0,"count":0,"hierarchical":1,"show_children_only":0,"hide_empty":0},"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"2":{"title":"Product Tags"},"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"2":{"title":"Average Rating"},"_multiwidget":1},"widget_woocommerce_recent_reviews":{"2":{"title":"Recent Reviews","number":4},"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"2":{"title":"Top Rated Products","number":4},"_multiwidget":1},"widget_woocommerce_widget_cart":{"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"Dark","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1300px","container-padding":"20px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"center-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"center-menu","boxed-top-bar-background-opacity":"100","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"28px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"35px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"21px","navigation-slide-bar":"style-dot","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1614","logo-top-padding":"35px","logo-bottom-padding":"40px","max-logo-width":"148px","main-navigation-top-padding":"40px","main-navigation-bottom-padding":"40px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"left","default-title-style":"medium","default-title-align":"center","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"21","default-title-background":"1340","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"disable","footer-style":"footer-1","enable-copyright":"enable","copyright-text":"Copyright 2020 GoodLayers, All Right Reserved","enable-maintenance":"disable","maintenance-page":"1281","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"31","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"footer-1","woocommerce-archive-sidebar-right":"woocommerce","woocommerce-archive-column-size":"30","woocommerce-archive-thumbnail":"Product Portrait","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"Product Portrait","boxed-layout-top-margin":"0px","background-image-opacity":"100","sidebar-title-divider":"enable","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-menu-position":"none","top-bar-shadow-size":"","top-bar-shadow-color":"#000","top-bar-social-instagram":"","top-bar-social-snapchat":"","navigation-left-offset":"","navigation-slide-bar-top-margin":"-39px","header-shadow-size":"","header-shadow-color":"#000","logo-left-padding":"","mobile-logo":"","max-tablet-logo-width":"","max-mobile-logo-width":"","mobile-logo-position":"logo-left","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","navigation-right-top-margin":"","main-navigation-search-icon":"fa fa-search","main-navigation-cart-icon":"fa fa-shopping-cart","enable-main-navigation-right-button":"disable","main-navigation-right-button-style":"default","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-with-border","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-bar-logo":"","fixed-navigation-max-logo-width":"","fixed-navigation-logo-top-padding":"20px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"30px","fixed-navigation-bottom-padding":"25px","fixed-navigation-anchor-offset":"75px","enable-mobile-navigation-sticky":"enable","default-title-font-transform":"","default-title-font-weight":"","default-caption-font-transform":"","default-caption-font-weight":"","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-blog-top-bottom-gradient":"enable","single-blog-title-top-gradient-size":"413px","single-blog-title-bottom-gradient-size":"413px","blog-style":"style-1","blog-title-style":"","blog-date-feature":"enable","blog-date-feature-year":"disable","blockquote-style":"style-1","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","enable-related-post":"enable","related-post-blog-style":"blog-column-with-frame","related-post-blog-column-style":"style-1","related-post-column-size":"20","related-post-meta-option":["date","author","category","comment-number"],"related-post-thumbnail-size":"full","related-post-num-fetch":"3","related-post-excerpt-number":"0","blog-social-share-count":"enable","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-date-feature":"enable","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","woocommerce-archive-product-style":"grid-2","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"icon_link_alt","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-background":"","enable-footer-column-divider":"enable","footer-top-padding":"70px","footer-bottom-padding":"50px","copyright-style":"left-right","copyright-top-padding":"38px","copyright-bottom-padding":"38px","copyright-left":"Copyright \u00a92019 Infinite. All Rights Reserved. <a style=\"color: #ffffff;\" href=\"#\">Terms of Use<\/a>","copyright-right":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"28px\" ][gdlr_core_icon icon=\"fa fa-instagram\" size=\"17px\" color=\"#8a99c0\" margin-left=\"\" margin-right=\"\" ]","enable-back-to-top":"disable","navigation-slide-bar-width":"","navigation-slide-bar-height":"","fixed-navigation-slide-bar-top-margin":"-25px","enable-fixed-navigation-slide-bar":"enable"},"gdlr_typography":{"heading-font":"Jost","navigation-font":"Jost","content-font":"Jost","info-font":"Jost","blog-info-font":"Jost","quote-font":"Montserrat","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"500","navigation-text-transform":"uppercase","content-font-size":"17px","content-line-height":"1.7","font-upload":[{"name":"\u0e48Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-100-Hairline.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-100-Hairline.ttf","woff":"","font-weight":"100","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-200-Thin.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-200-Thin.ttf","woff":"","font-weight":"200","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-300-Light.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-300-Light.ttf","woff":"","font-weight":"300","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-400-Book.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-400-Book.ttf","woff":"","font-weight":"400","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-500-Medium.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-500-Medium.ttf","woff":"","font-weight":"500","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-600-Semi.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-600-Semi.ttf","woff":"","font-weight":"600","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-700-Bold.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-700-Bold.ttf","woff":"","font-weight":"700","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-800-Heavy.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-800-Heavy.ttf","woff":"","font-weight":"800","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-900-Black.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/furniture\/wp-content\/uploads\/sites\/30\/2019\/08\/Jost-900-Black.ttf","woff":"","font-weight":"900","font-style":"normal"}],"google-font-display":"optional","testimonial-font":"Jost","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","header-font-weight":"","content-font-weight":"","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-font-letter-spacing":"","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"13px","sidebar-title-font-weight":"","sidebar-title-font-letter-spacing":"","sidebar-title-text-transform":"uppercase","footer-title-font-size":"13px","footer-title-font-weight":"","footer-title-font-letter-spacing":"","footer-title-text-transform":"uppercase","footer-font-size":"15px","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-size":"15px","copyright-font-weight":"500","copyright-font-letter-spacing":"0px","copyright-text-transform":"none"},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#c6c6c6","content":"#dcdcdc","icon":"#bd584e","link":"#bd584e","link-hover":"#bc786d","divider":"#ffffff","border":"#c9c9c9","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#bd584e","button-background-hover":"#bd584e","button-border-color":"","button-border-hover-color":""},{"name":"Grey","title":"","title-hover":"","caption":"#9e9e9e","content":"","icon":"","link":"","link-hover":"","divider":"#c6c6c6","border":"#c6c6c6","element-background":"#ffffff","element-content":"#606060","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"White Text","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#2d2d2d","button-text-hover":"#5b5b5b","button-background":"#ffffff","button-background-hover":"#eaeaea","button-border-color":"","button-border-hover-color":""},{"name":"iconhomepage","title":"#002e5b","title-hover":"","caption":"","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"orange","title":"#002e5b","title-hover":"#d4af37","caption":"","content":"#373737","icon":"#d4af37","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"title orange","title":"#d4af37","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"hover","title":"","title-hover":"","caption":"","content":"","icon":"","link":"#d4af37","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#ea6b2d","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#65ce71","logo-background-color":"#ffffff","main-menu-text-color":"#002e5b","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#000000","body-content-color":"#707070","heading-color":"#383838","link-color":"#002e5b","link-hover-color":"#d4af37","divider-color":"#e6e6e6","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#212121","footer-title-color":"#ffffff","footer-content-color":"#9b9b9b","footer-link-color":"#969696","footer-link-hover-color":"#ffffff","footer-divider-color":"#353535","copyright-background-color":"#222222","copyright-text-color":"#6b7a90","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#bd584e","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#bd584e","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#bd584e","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#bd584e","price-table-active-head-top-gradient-color":"#bc7169","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#d1a192","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#ea6b2d","price-table-active-button-background-top-gradient-color":"#ea8856","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#bd584e","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","dropdown-tab-head-background":"#bd584e","dropdown-tab-head-text":"#ffffff","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#bd584e","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#bd584e","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#bd584e","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#d4af37","button-background-hover-color":"#2F2F2F","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#bd584e","button-top-gradient-background-color":"#bc756f","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#bd584e","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#ffffff","woocommerce-theme-color":"#d4af37","woocommerce-button-background-hover-color":"#d4af37","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#65ce71","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#65ce71","woocommerce-cart-icon-number-background":"#65ce71","woocommerce-cart-icon-number-color":"#ffffff","woocommerce-price-color":"#d4af37","woocommerce-price-linethrough-color":"#949494","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#476587","widget-price-filter-handle-color":"#003c56","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#65ce71","navigation-right-button-text-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-color":"","navigation-right-button-background-hover-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-border-hover-color":"#555555","navigation-right-button-shadow-color":"#000","page-preload-background-color":"#ffffff","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","tag-cloud-text-color":"","tag-cloud-background-color":"","tag-cloud-border-color":"","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-style-2-tags-color":"#343de9","single-blog-navigation2-left-overlay":"#343de9","single-blog-navigation2-overlay":"#343de9","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#272727","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#343de2","portfolio-frame-background-color":"#f5f5f5","portfolio-title-hover-color":"","portfolio-grid2-tag-background":"#3d3ac2","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","slider-control-navigation-background-color":"#dfdfdf","testimonial-rating-color":"#ffa127","testimonial-frame-background-color":"#ffffff"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Portfolio Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Gallery Large","width":"1400","height":"788","hard-crop":""},{"name":"Product Portrait","width":"800","height":"990","hard-crop":""}],"additional-css":"body .infinite-main-menu-search {\n    margin-top: -2px;\n}","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1281","additional-mobile-css":"","link-to-lightbox":"enable","enable-srcset":"disable","consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","font-icon":["font-awesome","elegant-font"],"additional-head-script":"","additional-head-script2":"","lightbox-video-autoplay":"enable","enable-preload":"disable","preload-image":""}}'
				),
				'software' => array(
					'title' => esc_html__('Software', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/software/',
					'xml' => get_template_directory() . '/admin/function/files/software.xml',
					'page' => 1462,
					'menu' => array('main_menu' => 38, 'mobile_menu' => 38, 'right_menu' => 38),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":[],"footer-1":["gdlr-core-custom-menu-widget-2"],"footer-2":["gdlr-core-custom-menu-widget-3"],"footer-3":["text-2"],"footer-4":[],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Services","menu":"62","style":"half"},"3":{"title":"Platform","menu":"63","style":"half"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-newsletter-widget":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"_multiwidget":1},"widget_recent-posts":{"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"_multiwidget":1},"widget_tag_cloud":{"_multiwidget":1},"widget_text":{"2":{"title":"Contact","text":"Mon - Fri: 8.00am 6.00pm [gdlr_core_space height=\"12px\"]112 W 34th St, New York [gdlr_core_space height=\"12px\"](+1) 212-946-2707 [gdlr_core_space height=\"12px\"] <a style=\"color: #375eef\" href=\"#\">info@Infinite.com<\/a>","filter":true,"visual":true},"_multiwidget":1},"widget_woocommerce_layered_nav":{"_multiwidget":1},"widget_woocommerce_layered_nav_filters":{"_multiwidget":1},"widget_woocommerce_price_filter":{"_multiwidget":1},"widget_woocommerce_product_categories":{"_multiwidget":1},"widget_woocommerce_product_search":{"_multiwidget":1},"widget_woocommerce_product_tag_cloud":{"_multiwidget":1},"widget_woocommerce_products":{"_multiwidget":1},"widget_woocommerce_rating_filter":{"_multiwidget":1},"widget_woocommerce_recent_reviews":{"_multiwidget":1},"widget_woocommerce_recently_viewed_products":{"_multiwidget":1},"widget_woocommerce_top_rated_products":{"_multiwidget":1},"widget_woocommerce_widget_cart":{"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1300px","container-padding":"20px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"center-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"49","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"41px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"20px","navigation-slide-bar":"style-2","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1851","logo-top-padding":"50px","logo-bottom-padding":"31px","max-logo-width":"145px","main-navigation-top-padding":"54px","main-navigation-bottom-padding":"42px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"127px","default-title-bottom-padding":"42px","default-page-caption-top-margin":"13px","default-title-font-size":"61px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"0","default-title-background":"1903","default-portfolio-title-background":"1903","default-personnel-title-background":"1404","default-search-title-background":"1404","default-archive-title-background":"1404","default-blog-title-style":"custom","default-blog-title-top-padding":"88px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"1404","default-blog-title-background-overlay-opacity":"0","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"Copyright \u00a92019 Infinite. All Rights Reserved. <a href=\"#\" style=\"text-decoration: underline;\">Terms of Use<\/a>","enable-maintenance":"disable","maintenance-page":"7","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-social-instagram":"","top-bar-social-snapchat":"","mobile-logo":"","logo-left-padding":"","main-navigation-right-padding":"","enable-logo-on-main-navigation-sticky":"enable","enable-main-navigation-right-button":"disable","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-small","default-title-font-transform":"none","default-title-font-weight":"600","default-caption-font-weight":"","blog-date-feature":"enable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","blog-social-share-count":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"footer-1","woocommerce-archive-sidebar-right":"footer-1","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","personnel-slug":"personnel","personnel-category-slug":"personnel_category","footer-top-padding":"70px","footer-bottom-padding":"50px","copyright-top-padding":"38px","copyright-bottom-padding":"38px","enable-back-to-top":"disable","archive-date-feature":"enable","portfolio-icon-hover-link":"arrow_right-up","portfolio-icon-hover-video":"icon_film","portfolio-icon-hover-image":"arrow_expand","portfolio-icon-hover-size":"22px","background-image-opacity":"100","main-navigation-item-right-padding":"0px","fixed-navigation-max-logo-width":"","fixed-navigation-logo-top-padding":"23px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"26px","fixed-navigation-bottom-padding":"25px","fixed-navigation-anchor-offset":"75px","blog-date-feature-year":"disable","enable-single-portfolio-navigation-in-same-tag":"enable","copyright-style":"center","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","copyright-left":"Copyright \u00a92019 Infinite. All Rights Reserved. <a href=\"#\" style=\"text-decoration: underline;\">Terms of Use<\/a>","copyright-right":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"15px\" color=\"#111111\" margin-left=\"\" margin-right=\"18px\" link=\"#\" ][gdlr_core_icon icon=\"fa fa-twitter\" size=\"15px\" color=\"#111111\" margin-left=\"\" margin-right=\"18px\" link=\"#\" ][gdlr_core_icon icon=\"fa fa-linkedin\" size=\"15px\" color=\"#111111\" margin-left=\"\" margin-right=\"18px\" link=\"#\" ][gdlr_core_icon icon=\"fa fa-pinterest\" size=\"15px\" color=\"#111111\" margin-left=\"\" margin-right=\"18px\" link=\"#\" ][gdlr_core_icon icon=\"fa fa-envelope-o\" size=\"15px\" color=\"#111111\" margin-left=\"\" margin-right=\"18px\" link=\"#\" ]","max-mobile-logo-width":"","default-caption-font-transform":"none","enable-footer-column-divider":"disable","sidebar-title-divider":"enable","top-bar-menu-position":"none","navigation-left-offset":"0","max-tablet-logo-width":"","mobile-logo-position":"logo-left","navigation-right-top-margin":"","main-navigation-right-button-style":"default","fixed-navigation-bar-logo":"","enable-mobile-navigation-sticky":"enable","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","default-blog-top-bottom-gradient":"enable","single-blog-title-top-gradient-size":"413px","single-blog-title-bottom-gradient-size":"413px","blog-style":"style-1","blockquote-style":"style-1","enable-related-post":"enable","related-post-blog-style":"blog-column-with-frame","related-post-blog-column-style":"style-1","related-post-column-size":"20","related-post-meta-option":["date","author","category","comment-number"],"related-post-thumbnail-size":"full","related-post-num-fetch":"3","related-post-excerpt-number":"0","archive-blog-full-style":"style-1","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","footer-background":"1787","top-bar-shadow-size":"","top-bar-shadow-color":"#000","navigation-slide-bar-top-margin":"-40px","header-shadow-size":"","header-shadow-color":"#000","blog-title-style":"","woocommerce-archive-product-style":"grid","main-navigation-search-icon":"fa fa-search","main-navigation-cart-icon":"fa fa-shopping-cart","navigation-slide-bar-width":"10px","navigation-slide-bar-height":"5px","fixed-navigation-slide-bar-top-margin":"-23px","enable-fixed-navigation-slide-bar":"enable"},"gdlr_typography":{"heading-font":"Jost","navigation-font":"Jost","content-font":"Jost","info-font":"Jost","blog-info-font":"Jost","quote-font":"Montserrat","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"14px","navigation-font-weight":"500","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","navigation-font-letter-spacing":"1px","testimonial-font":"Jost","header-font-weight":"","content-font-weight":"","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"13px","sidebar-title-font-weight":"","sidebar-title-font-letter-spacing":"","sidebar-title-text-transform":"none","footer-title-font-size":"20px","footer-title-font-weight":"400","footer-title-font-letter-spacing":"0px","footer-title-text-transform":"none","footer-font-size":"18px","footer-content-font-weight":"500","footer-content-text-transform":"none","copyright-font-size":"15px","copyright-font-weight":"500","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","font-upload":[{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-100-Hairline.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-100-Hairline.ttf","woff":"","font-weight":"100","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-200-Thin.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-200-Thin.ttf","woff":"","font-weight":"200","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-300-Light.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-300-Light.ttf","woff":"","font-weight":"300","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-400-Book.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-400-Book.ttf","woff":"","font-weight":"400","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-500-Medium.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-500-Medium.ttf","woff":"","font-weight":"500","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-600-Semi.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-600-Semi.ttf","woff":"","font-weight":"600","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-700-Bold.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-700-Bold.ttf","woff":"","font-weight":"700","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-800-Heavy.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-800-Heavy.ttf","woff":"","font-weight":"800","font-style":"normal"},{"name":"Jost","eot":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-900-Black.eot","ttf":"https:\/\/demo.goodlayers.com\/infinite\/homepages\/software\/wp-content\/uploads\/sites\/29\/2019\/08\/Jost-900-Black.ttf","woff":"","font-weight":"900","font-style":"normal"}],"google-font-display":"optional"},"gdlr_color":{"skin":[{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#c2c0ed","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#c2c0ed","border":"","element-background":"","element-content":"","button-text":"#5252ce","button-text-hover":"#9a9ace","button-background":"#ffffff","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Service","title":"#ffffff","title-hover":"","caption":"","content":"#bad4ff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Black Service","title":"#494949","title-hover":"","caption":"","content":"","icon":"#494949","link":"","link-hover":"","divider":"","border":"","element-background":"#ebebeb","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Skin","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":""},{"name":"software-column-sv","title":"#002e5b","title-hover":"","caption":"","content":"#373737","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"countersoftware","title":"#476af0","title-hover":"","caption":"","content":"#696969","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#375eef","header-background-color":"#ffffff","header-plain-bottom-border-color":"#565656","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#375eef","logo-background-color":"#ffffff","main-menu-text-color":"#002e5b","main-menu-text-hover-color":"#375eef","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#3c3c3c","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#424242","secondary-menu-icon-color":"#212121","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#232323","page-caption-color":"#848484","page-title-background-overlay-color":"#000000","body-content-color":"#6d6d6d","heading-color":"#2d2d2d","link-color":"#375eef","link-hover-color":"#708cef","divider-color":"#e6e6e6","input-box-background-color":"#f5f5f5","input-box-border-color":"#f5f5f5","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#383838","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","footer-background-color":"#ffffff","footer-title-color":"#002e5b","footer-content-color":"#696969","footer-link-color":"#696969","footer-link-hover-color":"#375eef","footer-divider-color":"#383838","copyright-background-color":"#eef9ff","copyright-text-color":"#6b7a90","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2979ff","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#2979ff","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#ffffff","portfolio-text-filter-color":"#002e5b","portfolio-text-filter-active-color":"#4ccf5f","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#375eef","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#2979ff","price-table-active-head-top-gradient-color":"#5492ff","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#a0c3ff","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#2979ff","price-table-active-button-background-top-gradient-color":"#6da2ff","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#515151","accordion-title-color":"#949494","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#2979ff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#292929","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2979ff","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#2979ff","column-service-caption-color":"#747474","dropdown-tab-head-background":"#2979ff","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2979ff","flipbox-border-color":"#215dd3","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#2979ff","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2979ff","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#2979ff","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#848484","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#2979ff","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","side-menu-text-color":"#979797","side-menu-text-hover-color":"#3c3c3c","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#696969","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#375eef","button-background-hover-color":"#7791ef","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#375eef","button-top-gradient-background-color":"#5879ef","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2979ff","slider-outer-navigation-color":"#2979ff","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","page-preload-background-color":"#ffffff","woocommerce-cart-icon-number-background":"#5252ce","woocommerce-cart-icon-number-color":"#ffffff","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#375eef","navigation-right-button-text-color":"#333333","navigation-right-button-background-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-hover-color":"","navigation-right-button-border-hover-color":"#555555","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#375eef","woocommerce-theme-color":"#2979ff","woocommerce-price-color":"#2979ff","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#609aff","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#2979ff","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#4c67a5","widget-price-filter-handle-color":"#2979ff","copyright-link-color":"#838383","copyright-link-hover-color":"#838383","portfolio-frame-background-color":"#f5f5f5","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","testimonial-rating-color":"#ffa127","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#000000","navigation-right-button-shadow-color":"#000","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","tag-cloud-text-color":"","tag-cloud-background-color":"","tag-cloud-border-color":"","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-style-2-tags-color":"#343de9","single-blog-navigation2-left-overlay":"#343de9","single-blog-navigation2-overlay":"#343de9","single-blog-2-related-post-background":"#f5f5f5","single-blog-magazine-tags-text":"#272727","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#343de2","portfolio-title-hover-color":"","portfolio-grid2-tag-background":"#3d3ac2","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","slider-control-navigation-background-color":"#dfdfdf","testimonial-frame-background-color":"#ffffff"},"gdlr_plugin":{"lightbox":"lightGallery","thumbnail-sizing":[{"name":"Gallery Large","width":"1280","height":"700","hard-crop":""},{"name":"Frame Portfolio","width":"800","height":"590","hard-crop":""},{"name":"Frame Personnel","width":"800","height":"888","hard-crop":""},{"name":"Frame Blog","width":"800","height":"490","hard-crop":""},{"name":"Frame Square","width":"600","height":"600","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1599","additional-mobile-css":"","enable-srcset":"enable","link-to-lightbox":"enable","additional-head-script":"","enable-preload":"disable","preload-image":"","consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox-video-autoplay":"enable","additional-head-script2":"","font-icon":["font-awesome","elegant-font"]}}'
				),
				'yellowblack' => array(
					'title' => esc_html__('Yellow Black', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/yellowblack/',
					'xml' => get_template_directory() . '/admin/function/files/yellowblack.xml',
					'page' => 1322,
					'menu' => array('main_menu' => 27, 'mobile_menu' => 27),
					'widget' => '{"gdlrcst_sidebar_name":"","sidebars_widgets":{"sidebar-1":["search-2","recent-posts-2","recent-comments-2","archives-2","categories-2","meta-2"],"wp_inactive_widgets":[],"footer-1":["text-2"],"footer-2":["recent-posts-4"],"footer-3":["tag_cloud-2"],"footer-4":[],"array_version":3},"widget_archives":{"2":{"title":"","count":0,"dropdown":0},"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"2":{"title":"","count":0,"hierarchical":0,"dropdown":0},"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"2":{"title":""},"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"2":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"2":{"title":"","number":5},"4":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"2":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":[],"2":{"title":"About Us","text":"A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"15px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"enable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"center-menu","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"menu-right","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"25px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"22px","navigation-slide-bar":"disable","side-header-width-pixel":"340px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"1326","logo-top-padding":"43px","logo-bottom-padding":"30px","max-logo-width":"150px","main-navigation-top-padding":"47px","main-navigation-bottom-padding":"47px","enable-main-navigation-submenu-indicator":"disable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"disable","right-menu-type":"right","default-title-style":"small","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"80","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"80","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"footer-1","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"disable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-maintenance":"disable","maintenance-page":"1322","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","blog-max-content-width":"900px","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"footer-1","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable"},"gdlr_typography":{"heading-font":"Lato","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Open Sans","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"800","navigation-text-transform":"uppercase","content-font-size":"15px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Light","title":"#ffffff","title-hover":"#ffffff","caption":"#bbbbbb","content":"#bbbbbb","icon":"#e6ae48","link":"#e6ae48","link-hover":"#e6ae48","divider":"#727272","border":"#7c7c7c","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Light Service","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"","divider":"#ffffff","border":"#ffffff","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Yellow Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#e6ae48","border":"#e6ae48","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark","title":"#353535","title-hover":"","caption":"","content":"#828282","icon":"","link":"","link-hover":"","divider":"#bababa","border":"#bababa","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e6ae48","header-background-color":"#161616","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#e6ae48","logo-background-color":"#ffffff","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#e6ae48","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#b5b5b5","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#e8e8e8","secondary-menu-border-color":"#dddddd","body-background-color":"#272727","container-background-color":"#2d2d2d","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#262626","body-content-color":"#c4c4c4","heading-color":"#ffffff","link-color":"#e6ae48","link-hover-color":"#e5bb6e","divider-color":"#494949","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-title-color":"#ffffff","sidebar-link-color":"#c9c9c9","sidebar-link-hover-color":"#f9f9f9","recent-post-widget-info-icon-color":"#d3d3d3","recent-post-widget-info-link-color":"#d1d1d1","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#c1c1c1","search-box-text-color":"#dddddd","search-box-border-color":"#595959","search-box-icon-color":"#eaeaea","footer-background-color":"#202020","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#adadad","footer-link-hover-color":"#ffffff","footer-divider-color":"#3f3f3f","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#1e1e1e","single-blog-author-title-color":"#ffffff","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#ffffff","single-blog-comment-background-color":"#383838","single-blog-comment-reply-color":"#ffffff","single-blog-comment-time-color":"#b1b1b1","blog-title-color":"#ffffff","blog-title-hover-color":"#ffffff","blog-info-color":"#959595","blog-date-day-color":"#cccccc","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#f9f9f9","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#e6ae48","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#e6ae48","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#ffffff","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#e6ae48","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","accordion-normal-icon-color":"#ffffff","accordion-normal-title-color":"#ffffff","accordion-normal-icon-background-color":"#494949","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#191919","accordion-title-active-color":"#191919","accordion-title-background-active-color":"#f3f3f3","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#e6ae48","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#515151","blockquote-icon-color":"#ffffff","blockquote-color":"#d8d8d8","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#ffffff","call-to-action-caption-color":"#c6c6c6","counter-item-top-text-color":"#d8d8d8","counter-item-top-icon-color":"#ffffff","counter-item-number-color":"#ffffff","counter-item-divider-color":"#c9c9c9","counter-item-bottom-text-color":"#d1d1d1","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#ffffff","column-service-caption-color":"#b2b2b2","dropdown-tab-head-background":"#f7c02e","dropdown-tab-head-text":"#252525","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","portfolio-info-head-color":"#ffffff","opening-hour-day-color":"#e5e5e5","opening-hour-open-color":"#e6ae48","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#fcfffd","opening-hour-divider-color":"#6d6d6d","personnel-grid-title-color":"#ffffff","personnel-grid-position-color":"#dddddd","personnel-grid-divider-color":"#666666","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#b5b5b5","stunning-text-caption-color":"#383838","tab-title-color":"#ffffff","tab-title-background-color":"#303030","tab-title-border-color":"#494949","tab-title-hover-bar-color":"#f7c02e","tab-title-active-color":"#ffffff","tab-title-active-background-color":"#444444","table-head-background-color":"#f7c02e","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#ffffff","testimonial-content-color":"#adadad","testimonial-author-color":"#d8d8d8","testimonial-position-color":"#969696","testimonial-quote-color":"#ffffff","title-item-title-color":"#ffffff","title-item-caption-color":"#f2f2f2","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","twitter-widget-icon-color":"#ffffff","twitter-widget-date-color":"#dbdbdb","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#e6ae48","button-background-hover-color":"#e5c07b","button-border-color":"#ffffff","button-border-hover-color":"#ffffff","button-gradient-background-color":"#f7c02e","button-top-gradient-background-color":"#f7cf60","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#ffffff","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#ffffff","promo-box-content-border-color":"#5b5b5b","skill-bar-title-color":"#ffffff","skill-bar-icon-color":"#616161","skill-bar-background-color":"#424242","skill-bar-progress-color":"#f7c02e","slider-outer-navigation-color":"#a7a7a7","slider-outer-navigation-background-color":"#f1f1f1","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#e6ae48","social-share-divider-color":"#e5e5e5","social-share-text-color":"#ffffff","search-overlay-background-color":"#000000","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","blockquote-text-color":"#333333","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#ffffff","blockquote-item-content-color":"#e2e2e2"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Metro 1","width":"600","height":"950","hard-crop":""},{"name":"Metro 2","width":"600","height":"475","hard-crop":""},{"name":"Metro 3","width":"1200","height":"475","hard-crop":""},{"name":"Gallery Thumb","width":"1280","height":"700","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"1322","additional-mobile-css":""}}',
				),
				'infinite-light' => array(
					'title' => esc_html__('Infinite Main demo (Light Version)', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite',
					'xml' => get_template_directory() . '/admin/function/files/infinite-light.xml',
					'page' => 2039,
					'menu' => array('main_menu' => 45, 'mobile_menu' => 45),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Elements","id":"elements"},{"name":"Blog","id":"blog"}],"sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-3"],"footer-2":["recent-posts-3"],"footer-3":["tag_cloud-3"],"footer-4":[],"elements":[],"blog":["search-3","text-2","gdlr-core-recent-portfolio-widget-2","recent-comments-3","tag_cloud-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"2":{"title":"Recent Works","category":"","num-fetch":"9"},"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"3":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"3":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"3":{"title":"Tag Clouds","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":[],"2":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada magna mollis euismod.","filter":false},"3":{"title":"About Us","text":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right.","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_wpgmza_map_widget":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"35px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"splitted-menu","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"30px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"20px","navigation-slide-bar":"enable","side-header-width-pixel":"305px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"","logo-top-padding":"30px","logo-bottom-padding":"32px","max-logo-width":"200px","main-navigation-top-padding":"36px","main-navigation-bottom-padding":"34px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"medium","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"76","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"75","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"blog","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"enable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","blog-max-content-width":"900px","enable-maintenance":"disable","maintenance-page":"2039","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"blog","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"enable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Open Sans","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"700","navigation-text-transform":"uppercase","content-font-size":"16px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#cecece","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#777777","border":"#777777","element-background":"","element-content":"#3d3d3d","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#309cea","button-background-hover":"#0f82db","button-border-color":"","button-border-hover-color":""},{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#ffffff","border":"#ffffff","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#000000","button-background-hover":"#2d9bea","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Grey","title":"#3a3a3a","title-hover":"","caption":"#727272","content":"#494949","icon":"#595959","link":"","link-hover":"","divider":"#cecece","border":"#cecece","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue","title":"#ffffff","title-hover":"","caption":"#d9eef7","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#232323","button-background-hover":"#232323","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#51b0f3","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"#ffffff","caption":"#dddddd","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#b2b2b2","border":"#bcbcbc","element-background":"#191919","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Title","title":"#2d95e1","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"About Me Top","title":"#ffffff","title-hover":"","caption":"#acc3ff","content":"#95a3bc","icon":"","link":"","link-hover":"","divider":"#ffffff","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Maintenance","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"#74abd2","border":"#74abd2","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider White Text","title":"#ffffff","title-hover":"","caption":"#d6d6d6","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"#2d9bea","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Light Border","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#ebebeb","border":"#ebebeb","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Purple Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#4f66bd","button-background-hover":"#3250bc","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#2d2d2d","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e2e2e2","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","footer-background-color":"#282828","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#bababa","footer-link-hover-color":"#ffffff","footer-divider-color":"#494949","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2d9bea","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#353535","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2f9cea","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#303030","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2d9bea","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#2d9bea","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2d9bea","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#49b7df","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","search-overlay-background-color":"#000000","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","sidebar-title-color":"#383838","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#309cea","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#309cea","button-top-gradient-background-color":"#52aae9","dropdown-tab-head-background":"#309cea","dropdown-tab-head-text":"#ffffff","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2d9bea","slider-outer-navigation-color":"#ffffff","slider-outer-navigation-background-color":"#383838","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Portfolio Metro 1","width":"290","height":"430","hard-crop":""},{"name":"Portfolio Metro 2","width":"290","height":"215","hard-crop":""},{"name":"Portfolio Metro 3","width":"590","height":"215","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Thumbnail 2","width":"550","height":"500","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"2013","additional-mobile-css":""}}'
				),
				'infinite-full' => array(
					'title' => esc_html__('Infinite Main demo (Full Version)', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite',
					'xml' => get_template_directory() . '/admin/function/files/infinite-full.xml',
					'page' => 2039,
					'menu' => array('main_menu' => 62, 'mobile_menu' => 62),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Elements","id":"elements"},{"name":"Blog","id":"blog"}],"sidebars_widgets":{"wp_inactive_widgets":[],"footer-1":["text-3"],"footer-2":["recent-posts-3"],"footer-3":["tag_cloud-3"],"footer-4":[],"elements":[],"blog":["search-3","text-2","gdlr-core-recent-portfolio-widget-2","recent-comments-3","tag_cloud-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"2":{"title":"Recent Works","category":"","num-fetch":"9"},"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"3":{"title":"","number":4,"show_date":false},"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"3":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"3":{"title":"Tag Clouds","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":[],"2":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada magna mollis euismod.","filter":false},"3":{"title":"About Us","text":"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right.","filter":false},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_wpgmza_map_widget":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"35px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"splitted-menu","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"30px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"20px","navigation-slide-bar":"enable","side-header-width-pixel":"305px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"","logo-top-padding":"30px","logo-bottom-padding":"32px","max-logo-width":"200px","main-navigation-top-padding":"36px","main-navigation-bottom-padding":"34px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"medium","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"76","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"75","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"blog","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"enable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","blog-max-content-width":"900px","enable-maintenance":"disable","maintenance-page":"2039","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"blog","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"enable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Open Sans","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"700","navigation-text-transform":"uppercase","content-font-size":"16px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#cecece","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#777777","border":"#777777","element-background":"","element-content":"#3d3d3d","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#309cea","button-background-hover":"#0f82db","button-border-color":"","button-border-hover-color":""},{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#ffffff","border":"#ffffff","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#000000","button-background-hover":"#2d9bea","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Grey","title":"#3a3a3a","title-hover":"","caption":"#727272","content":"#494949","icon":"#595959","link":"","link-hover":"","divider":"#cecece","border":"#cecece","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue","title":"#ffffff","title-hover":"","caption":"#d9eef7","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#232323","button-background-hover":"#232323","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#51b0f3","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"#ffffff","caption":"#dddddd","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#b2b2b2","border":"#bcbcbc","element-background":"#191919","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Title","title":"#2d95e1","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"About Me Top","title":"#ffffff","title-hover":"","caption":"#acc3ff","content":"#95a3bc","icon":"","link":"","link-hover":"","divider":"#ffffff","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Maintenance","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"#74abd2","border":"#74abd2","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider White Text","title":"#ffffff","title-hover":"","caption":"#d6d6d6","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"#2d9bea","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Light Border","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#ebebeb","border":"#ebebeb","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Purple Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#4f66bd","button-background-hover":"#3250bc","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#2d2d2d","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e2e2e2","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","footer-background-color":"#282828","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#bababa","footer-link-hover-color":"#ffffff","footer-divider-color":"#494949","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2d9bea","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#353535","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2f9cea","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#303030","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2d9bea","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#2d9bea","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2d9bea","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#49b7df","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","search-overlay-background-color":"#000000","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","sidebar-title-color":"#383838","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#309cea","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#309cea","button-top-gradient-background-color":"#52aae9","dropdown-tab-head-background":"#309cea","dropdown-tab-head-text":"#ffffff","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2d9bea","slider-outer-navigation-color":"#ffffff","slider-outer-navigation-background-color":"#383838","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Portfolio Metro 1","width":"290","height":"430","hard-crop":""},{"name":"Portfolio Metro 2","width":"290","height":"215","hard-crop":""},{"name":"Portfolio Metro 3","width":"590","height":"215","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Thumbnail 2","width":"550","height":"500","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"2013","additional-mobile-css":""}}'
				),
				'infinite-full2' => array(
					'title' => esc_html__('Infinite Main 2 demo (Full Version)', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/main2/',
					'xml' => get_template_directory() . '/admin/function/files/infinite-full2.xml',
					'page' => 2039,
					'menu' => array('main_menu' => 53, 'mobile_menu' => 53),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Elements","id":"elements"},{"name":"Blog","id":"blog"}],"sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":[],"footer-1":["text-3"],"footer-2":["text-4"],"footer-3":["gdlr-core-recent-post-widget-2"],"footer-4":["nav_menu-2"],"elements":[],"blog":["search-3","text-2","gdlr-core-recent-portfolio-widget-2","recent-comments-3","tag_cloud-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"2":{"title":"Recent Works","category":"","num-fetch":"9"},"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"2":{"title":"Recent Articles","style":"style-3","category":"","num-fetch":"3"},"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"2":{"title":"Useful Links","nav_menu":54},"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"3":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":[],"2":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada magna mollis euismod.","filter":false},"3":{"title":"","text":"<img src=\"https:\/\/demo.goodlayers.com\/infinite\/homepages\/main2\/wp-content\/uploads\/sites\/25\/2018\/01\/logo-footer.png\" \/>\r\n\r\nFar far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live.\r\n\r\nI throw myself down\r\n\r\n[gdlr_core_icon icon=\"fa fa-facebook\" size=\"15px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"18px\" ]\u00a0[gdlr_core_icon icon=\"fa fa-twitter\" size=\"15px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"18px\" ]\u00a0[gdlr_core_icon icon=\"fa fa-linkedin\" size=\"15px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"18px\" ]\u00a0[gdlr_core_icon icon=\"fa fa-pinterest\" size=\"15px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"18px\" ]\u00a0[gdlr_core_icon icon=\"fa fa-instagram\" size=\"15px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"18px\" ]","filter":true,"visual":true},"4":{"title":"Contact Us","text":"[gdlr_core_icon icon=\"fa\u00a0fa-location-arrow\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"15px\" ]\u00a022 King Street, London\r\n\r\n[gdlr_core_icon icon=\"fa\u00a0fa-phone\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"15px\" ]\u00a0(1)-2340-33-455\r\n\r\n[gdlr_core_icon icon=\"fa fa-envelope-open-o\" size=\"16px\" color=\"#ffffff\" margin-left=\"\" margin-right=\"15px\" ] sales@website.com","filter":true,"visual":true},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_wpgmza_map_widget":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1320px","container-padding":"35px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"50","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"splitted-menu","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"30px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"20px","navigation-slide-bar":"disable","side-header-width-pixel":"305px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"2352","logo-top-padding":"51px","logo-bottom-padding":"32px","max-logo-width":"136px","main-navigation-top-padding":"54px","main-navigation-bottom-padding":"34px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"medium","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"48","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"75","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"blog","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"enable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-footer":"enable","footer-style":"footer-2","enable-copyright":"enable","copyright-text":"","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","blog-max-content-width":"900px","enable-maintenance":"disable","maintenance-page":"2039","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"blog","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"enable","boxed-layout-top-margin":"0px","background-image-opacity":"100","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-social-instagram":"","top-bar-social-snapchat":"","logo-left-padding":"","mobile-logo":"","max-mobile-logo-width":"120px","mobile-logo-position":"logo-left","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-right-button":"disable","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger-with-border","enable-mobile-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-max-logo-width":"","fixed-navigation-logo-top-padding":"25px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"26px","fixed-navigation-bottom-padding":"28px","fixed-navigation-anchor-offset":"75px","default-title-font-transform":"","default-title-font-weight":"","default-caption-font-transform":"","default-caption-font-weight":"","default-blog-top-bottom-gradient":"enable","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","blog-social-share-count":"enable","archive-date-feature":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"arrow_right-up","portfolio-icon-hover-video":"fa fa-film","portfolio-icon-hover-image":"icon_search","portfolio-icon-hover-size":"22px","personnel-slug":"personnel","personnel-category-slug":"personnel_category","enable-footer-column-divider":"disable","footer-top-padding":"70px","footer-bottom-padding":"50px","copyright-style":"left-right","copyright-top-padding":"29px","copyright-bottom-padding":"29px","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","copyright-left":"Copyright 2018 , GoodLayers. All Right Reserved.","copyright-right":"<a href=\"#\" style=\"margin-right: 20px;\">Home<\/a><a href=\"#\" style=\"margin-right: 20px;\">About<\/a><a href=\"#\" style=\"margin-right: 20px;\">News<\/a><a href=\"#\" >Contact<\/a>","enable-back-to-top":"disable","navigation-right-top-margin":"5px","blog-style":"style-2","blockquote-style":"style-2","enable-related-post":"enable","related-post-blog-style":"blog-column-with-frame","related-post-blog-column-style":"style-2","related-post-column-size":"20","related-post-meta-option":["date","author","category","comment-number"],"related-post-thumbnail-size":"Portfolio Side Description Large","related-post-num-fetch":"3","related-post-excerpt-number":"0","sidebar-title-divider":"enable","main-navigation-right-button-style":"default"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Karla","content-font":"Comfortaa","info-font":"Comfortaa","blog-info-font":"Comfortaa","quote-font":"Georgia, serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"16px","navigation-font-weight":"500","navigation-text-transform":"none","content-font-size":"15px","content-line-height":"1.7","navigation-font-letter-spacing":"0","testimonial-font":"Comfortaa","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","footer-title-font-size":"14px","footer-title-font-weight":"","footer-title-font-letter-spacing":"","footer-title-text-transform":"uppercase","footer-font-size":"15px","copyright-font-size":"14px","copyright-font-weight":"600","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"13px","sidebar-title-font-weight":"","sidebar-title-font-letter-spacing":"","sidebar-title-text-transform":"uppercase"},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#cecece","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#777777","border":"#777777","element-background":"","element-content":"#3d3d3d","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#4f2ec9","button-background-hover":"#7a64c9","button-border-color":"","button-border-hover-color":""},{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#ffffff","border":"#ffffff","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#000000","button-background-hover":"#4f2ec9","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Grey","title":"#3a3a3a","title-hover":"","caption":"#727272","content":"#494949","icon":"#595959","link":"","link-hover":"","divider":"#cecece","border":"#cecece","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue","title":"#ffffff","title-hover":"","caption":"#d9eef7","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#232323","button-background-hover":"#232323","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#51b0f3","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"#ffffff","caption":"#dddddd","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#b2b2b2","border":"#bcbcbc","element-background":"#191919","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Title","title":"#2d95e1","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"About Me Top","title":"#ffffff","title-hover":"","caption":"#acc3ff","content":"#95a3bc","icon":"","link":"","link-hover":"","divider":"#ffffff","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Maintenance","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"#74abd2","border":"#74abd2","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider White Text","title":"#ffffff","title-hover":"","caption":"#d6d6d6","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"#2d9bea","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Light Border","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#ebebeb","border":"#ebebeb","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Purple Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#4f66bd","button-background-hover":"#3250bc","button-border-color":"","button-border-hover-color":""},{"name":"Purple section 1","title":"#ffffff","title-hover":"","caption":"#bfbdff","content":"#b8b7e7","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Portfolio","title":"#111111","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact Homepage","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#6b6b6b","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#000000","button-background-hover":"#3433b8","button-border-color":"","button-border-hover-color":""},{"name":"Purple Title","title":"#5b62e5","title-hover":"","caption":"#e5e5e5","content":"#dddddd","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#0a0a0a","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#ffffff","main-menu-text-hover-color":"#cecece","sub-menu-background-color":"#1e1e1e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#2d2d2d","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#ffffff","secondary-menu-icon-color":"#ffffff","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#2d2d2d","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#343de9","link-hover-color":"#6f75e8","divider-color":"#e2e2e2","input-box-background-color":"#f3f3f3","input-box-border-color":"#f3f3f3","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","footer-background-color":"#282828","footer-title-color":"#ffffff","footer-content-color":"#a3a3a3","footer-link-color":"#ffffff","footer-link-hover-color":"#ffffff","footer-divider-color":"#494949","copyright-background-color":"#181818","copyright-text-color":"#9e9e9e","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#331fce","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#353535","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#777777","portfolio-text-filter-active-color":"#2533c6","portfolio-button-filter-text-color":"#969696","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#331fce","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#303030","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#331fce","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#3433b8","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#3433b8","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#6a6ab7","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","search-overlay-background-color":"#000000","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","sidebar-title-color":"#383838","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f5f5f5","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","price-table-active-head-color":"#331fce","price-table-active-head-top-gradient-color":"#6658ce","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#a6a3ce","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#331fce","price-table-active-button-background-top-gradient-color":"#6a5cce","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#3433b8","button-background-hover-color":"#5d5db7","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#3433b8","button-top-gradient-background-color":"#6161b7","dropdown-tab-head-background":"#309cea","dropdown-tab-head-text":"#ffffff","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#3433b8","slider-outer-navigation-color":"#ffffff","slider-outer-navigation-background-color":"#383838","slider-control-navigation-color":"#3b3dc6","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","blockquote-text-color":"#343de9","blockquote-background-color":"#ffffff","blockquote-border-color":"#343de9","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#1e1e1e","anchor-bullet-background-color":"#dfdfdf","anchor-bullet-background-active-color":"#3b3dc6","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","page-preload-background-color":"#ffffff","woocommerce-cart-icon-number-background":"#bd584e","woocommerce-cart-icon-number-color":"#ffffff","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#bd584e","navigation-right-button-text-color":"#333333","navigation-right-button-background-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-hover-color":"","navigation-right-button-border-hover-color":"#555555","copyright-link-color":"#ffffff","copyright-link-hover-color":"#838383","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","portfolio-frame-background-color":"#ffffff","portfolio-title-hover-color":"","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#e24a3b","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","testimonial-rating-color":"#ffa127","woocommerce-theme-color":"#bd584e","woocommerce-price-color":"#bd584e","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#d4786e","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e","single-blog-style-2-tags-color":"#343de9","single-blog-navigation2-overlay":"#2a2dc1","single-blog-2-related-post-background":"#f5f5f5","portfolio-grid2-tag-background":"#3d3ac2","slider-control-navigation-background-color":"#d8d8d8"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Portfolio Metro 1","width":"290","height":"430","hard-crop":""},{"name":"Portfolio Metro 2","width":"290","height":"215","hard-crop":""},{"name":"Portfolio Metro 3","width":"590","height":"215","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Thumbnail 2","width":"550","height":"500","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"2013","additional-mobile-css":"","enable-srcset":"disable","link-to-lightbox":"enable","additional-head-script":"","enable-preload":"disable","preload-image":""}}'
				),
				'infinite-full3' => array(
					'title' => esc_html__('Infinite Main 3 demo (Full Version)', 'infinite'),
					'url' => 'http://demo.goodlayers.com/infinite/homepages/main3/',
					'xml' => get_template_directory() . '/admin/function/files/infinite-full3.xml',
					'page' => 2039,
					'menu' => array('main_menu' => 47, 'mobile_menu' => 47),
					'widget' => '{"gdlrcst_sidebar_name":[{"name":"Elements","id":"elements"},{"name":"Blog","id":"blog"}],"sidebars_widgets":{"wp_inactive_widgets":[],"gdlr-core-sidebar-preset":[],"footer-1":["text-5"],"footer-2":["text-4"],"footer-3":["gdlr-core-custom-menu-widget-2"],"footer-4":["text-3"],"elements":[],"blog":["search-3","text-2","gdlr-core-recent-portfolio-widget-2","recent-comments-3","tag_cloud-2"],"array_version":3},"widget_archives":{"_multiwidget":1},"widget_calendar":{"_multiwidget":1},"widget_categories":{"_multiwidget":1},"widget_custom_html":{"_multiwidget":1},"widget_gdlr-core-category-background-widget":{"_multiwidget":1},"widget_gdlr-core-custom-menu-widget":{"2":{"title":"Hot Links","menu":"48","style":"plain"},"_multiwidget":1},"widget_gdlr-core-instagram-widget":{"_multiwidget":1},"widget_gdlr-core-portfolio-slider-widget":{"_multiwidget":1},"widget_gdlr-core-post-slider-widget":{"_multiwidget":1},"widget_gdlr-core-recent-comment-widget":{"_multiwidget":1},"widget_gdlr-core-recent-portfolio-widget":{"2":{"title":"Recent Works","category":"","num-fetch":"9"},"_multiwidget":1},"widget_gdlr-core-recent-post-widget":{"_multiwidget":1},"widget_gdlr-core-twitter-widget":{"_multiwidget":1},"widget_gdlr-core-video-widget":{"_multiwidget":1},"widget_media_audio":{"_multiwidget":1},"widget_media_gallery":{"_multiwidget":1},"widget_media_image":{"_multiwidget":1},"widget_media_video":{"_multiwidget":1},"widget_meta":{"_multiwidget":1},"widget_nav_menu":{"_multiwidget":1},"widget_newsletterwidget":{"_multiwidget":1},"widget_newsletterwidgetminimal":{"_multiwidget":1},"widget_pages":{"_multiwidget":1},"widget_recent-comments":{"3":{"title":"","number":5},"_multiwidget":1},"widget_recent-posts":{"_multiwidget":1},"widget_rev-slider-widget":{"_multiwidget":1},"widget_rss":{"1":[],"_multiwidget":1},"widget_search":{"3":{"title":""},"_multiwidget":1},"widget_tag_cloud":{"2":{"title":"Tag Cloud","taxonomy":"post_tag"},"_multiwidget":1},"widget_text":{"1":[],"2":{"title":"Text Widget","text":"Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Nulla vitae elit libero, a pharetra augue. Donec sed odio dui. Etiam porta sem malesuada magna mollis euismod.","filter":false},"3":{"title":"Follow Us","text":"[gdlr_core_icon icon=\"fa fa-facebook\" size=\"16px\" color=\"#0b0b0b\" margin-left=\"\" margin-right=\"18px\" ]\u00a0[gdlr_core_icon icon=\"fa fa-twitter\" size=\"16px\" color=\"#0b0b0b\" margin-left=\"\" margin-right=\"18px\" ]\u00a0[gdlr_core_icon icon=\"fa fa-linkedin\" size=\"16px\" color=\"#0b0b0b\" margin-left=\"\" margin-right=\"18px\" ]\u00a0[gdlr_core_icon icon=\"fa fa-pinterest\" size=\"16px\" color=\"#0b0b0b\" margin-left=\"\" margin-right=\"18px\" ]\u00a0[gdlr_core_icon icon=\"fa fa-instagram\" size=\"16px\" color=\"#0b0b0b\" margin-left=\"\" margin-right=\"18px\" ]","filter":true,"visual":true},"4":{"title":"Contact Us","text":"Box 3233\r\n1810 Kings Way\r\nKing Street, 5th Avenue, New York\r\n\r\n<span style=\"color: #3646a6;\">+1-2355-3345-5<\/span>\r\n<span style=\"color: #3646a6;\">Contact@Attornasite.co<\/span>","filter":true,"visual":true},"5":{"title":"","text":"<img class=\"size-full wp-image-2564\" src=\"https:\/\/demo.goodlayers.com\/infinite\/homepages\/main3\/wp-content\/uploads\/sites\/27\/2019\/03\/logo.png\" alt=\"\" width=\"120\" \/>\r\n\r\nFar far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. ","filter":true,"visual":true},"_multiwidget":1},"widget_wpgmp_google_map_widget_class":{"_multiwidget":1},"widget_wpgmza_map_widget":{"_multiwidget":1}}',
					'theme-option' => '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"20px","container-width":"1360px","container-padding":"20px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"transparent","top-bar-background-opacity":"50","header-background-opacity":"0","navigation-background-opacity":"50","header-boxed-style":"splitted-menu","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"boxed","header-width-pixel":"1140px","header-full-side-padding":"30px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"18px","navigation-slide-bar":"disable","side-header-width-pixel":"305px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"2564","logo-top-padding":"68px","logo-bottom-padding":"32px","max-logo-width":"116px","main-navigation-top-padding":"70px","main-navigation-bottom-padding":"34px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"overlay","default-title-style":"custom","default-title-align":"center","default-title-top-padding":"121px","default-title-bottom-padding":"50px","default-page-caption-top-margin":"16px","default-title-font-size":"68px","default-title-letter-spacing":"0px","default-caption-font-size":"13px","default-caption-letter-spacing":"2px","default-title-background-overlay-opacity":"0","default-title-background":"2575","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"custom","default-blog-title-top-padding":"99px","default-blog-title-bottom-padding":"20px","default-blog-feature-image":"content","default-blog-title-background-image":"2575","default-blog-title-background-overlay-opacity":"0","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"blog","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"enable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-footer":"enable","footer-style":"footer-2","enable-copyright":"enable","copyright-text":"","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","blog-max-content-width":"900px","enable-maintenance":"disable","maintenance-page":"2039","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"blog","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"Portfolio Side Description Large","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"disable","boxed-layout-top-margin":"0px","background-image-opacity":"100","sidebar-width":"20","both-sidebar-width":"15","enable-top-bar-on-mobile":"disable","top-bar-social-instagram":"","top-bar-social-snapchat":"","logo-left-padding":"","mobile-logo":"","max-mobile-logo-width":"90px","mobile-logo-position":"logo-left","main-navigation-item-right-padding":"0px","main-navigation-right-padding":"","enable-main-navigation-right-button":"disable","main-navigation-right-button-text":"Buy Now","main-navigation-right-button-link":"","main-navigation-right-button-link-target":"_self","right-menu-style":"hamburger","enable-mobile-navigation-sticky":"enable","enable-logo-on-main-navigation-sticky":"enable","fixed-navigation-max-logo-width":"","fixed-navigation-logo-top-padding":"25px","fixed-navigation-logo-bottom-padding":"20px","fixed-navigation-top-padding":"26px","fixed-navigation-bottom-padding":"28px","fixed-navigation-anchor-offset":"75px","default-title-font-transform":"none","default-title-font-weight":"700","default-caption-font-transform":"uppercase","default-caption-font-weight":"700","default-blog-top-bottom-gradient":"disable","blog-date-feature":"enable","blog-date-feature-year":"disable","meta-option":["author","category","tag","comment-number"],"blog-navigation":"enable","blog-social-share-count":"enable","archive-date-feature":"enable","woocommerce-archive-sidebar":"right","woocommerce-archive-sidebar-left":"gdlr-core-sidebar-preset","woocommerce-archive-sidebar-right":"gdlr-core-sidebar-preset","woocommerce-archive-column-size":"15","woocommerce-archive-thumbnail":"full","woocommerce-related-product-column-size":"15","woocommerce-related-product-num-fetch":"4","woocommerce-related-product-thumbnail":"full","portfolio-slug":"portfolio","portfolio-category-slug":"portfolio_category","portfolio-tag-slug":"portfolio_tag","enable-single-portfolio-navigation-in-same-tag":"enable","portfolio-icon-hover-link":"arrow_right-up","portfolio-icon-hover-video":"fa fa-film","portfolio-icon-hover-image":"icon_search","portfolio-icon-hover-size":"22px","personnel-slug":"personnel","personnel-category-slug":"personnel_category","enable-footer-column-divider":"disable","footer-top-padding":"70px","footer-bottom-padding":"50px","copyright-style":"left-right","copyright-top-padding":"32px","copyright-bottom-padding":"32px","copyright-font-letter-spacing":"0px","copyright-text-transform":"none","copyright-left":"Copyright 2018 , GoodLayers. All Right Reserved.","copyright-right":"<a href=\"#\" style=\"margin-right: 20px;\">Home<\/a><a href=\"#\" style=\"margin-right: 20px;\">About<\/a><a href=\"#\" style=\"margin-right: 20px;\">News<\/a><a href=\"#\" >Contact<\/a>","enable-back-to-top":"disable","navigation-right-top-margin":"5px","blog-style":"style-4","blockquote-style":"style-2","enable-related-post":"enable","related-post-blog-style":"blog-column","related-post-blog-column-style":"style-3","related-post-column-size":"20","related-post-meta-option":["date","author","category"],"related-post-thumbnail-size":"Personnel Thumbnail","related-post-num-fetch":"3","related-post-excerpt-number":"0","sidebar-title-divider":"enable","main-navigation-right-button-style":"default","top-bar-menu-position":"none","navigation-left-offset":"0","max-tablet-logo-width":"","fixed-navigation-bar-logo":"","page-title-top-bottom-gradient":"none","page-title-top-gradient-size":"413px","page-title-bottom-gradient-size":"413px","single-blog-title-top-gradient-size":"413px","single-blog-title-bottom-gradient-size":"413px","archive-blog-full-style":"style-2","archive-blog-side-thumbnail-style":"style-1","archive-blog-column-style":"style-1","archive-blog-image-style":"style-1","archive-blog-title-font-size":"","archive-blog-title-font-weight":"","archive-blog-title-letter-spacing":"","archive-blog-title-text-transform":"none","footer-background":"","top-bar-shadow-size":"","top-bar-shadow-color":"#000","navigation-slide-bar-top-margin":"-28px","header-shadow-size":"","header-shadow-color":"#000","woocommerce-archive-product-style":"grid"},"gdlr_typography":{"heading-font":"Poppins","navigation-font":"Karla","content-font":"Poppins","info-font":"Poppins","blog-info-font":"Poppins","quote-font":"Montserrat","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"16px","navigation-font-weight":"600","navigation-text-transform":"none","content-font-size":"16px","content-line-height":"1.7","navigation-font-letter-spacing":"0","testimonial-font":"Merriweather","additional-font":"Georgia, serif","additional-font2":"Georgia, serif","footer-title-font-size":"16px","footer-title-font-weight":"700","footer-title-font-letter-spacing":"0","footer-title-text-transform":"none","footer-font-size":"15px","copyright-font-size":"14px","copyright-font-weight":"400","navigation-right-button-font-size":"11px","navigation-right-button-font-weight":"","navigation-right-button-font-letter-spacing":"","navigation-right-button-text-transform":"uppercase","sidebar-title-font-size":"16px","sidebar-title-font-weight":"600","sidebar-title-font-letter-spacing":"0","sidebar-title-text-transform":"none","header-font-weight":"","content-font-weight":"","mobile-h1-font-size":"","mobile-h2-font-size":"","mobile-h3-font-size":"","mobile-h4-font-size":"","mobile-h5-font-size":"","mobile-h6-font-size":"","mobile-content-font-size":"","footer-content-font-weight":"","footer-content-text-transform":"none","copyright-font-letter-spacing":"0","copyright-text-transform":"none","font-upload":""},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#cecece","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#777777","border":"#777777","element-background":"","element-content":"#3d3d3d","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#4f2ec9","button-background-hover":"#7a64c9","button-border-color":"","button-border-hover-color":""},{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#ffffff","border":"#ffffff","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#000000","button-background-hover":"#4f2ec9","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Grey","title":"#3a3a3a","title-hover":"","caption":"#727272","content":"#494949","icon":"#595959","link":"","link-hover":"","divider":"#cecece","border":"#cecece","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue","title":"#ffffff","title-hover":"","caption":"#d9eef7","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#232323","button-background-hover":"#232323","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#51b0f3","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"#ffffff","caption":"#dddddd","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#b2b2b2","border":"#bcbcbc","element-background":"#191919","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Title","title":"#2d95e1","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"About Me Top","title":"#ffffff","title-hover":"","caption":"#acc3ff","content":"#95a3bc","icon":"","link":"","link-hover":"","divider":"#ffffff","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Maintenance","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"#74abd2","border":"#74abd2","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider White Text","title":"#ffffff","title-hover":"","caption":"#d6d6d6","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"#2d9bea","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Light Border","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#ebebeb","border":"#ebebeb","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Purple Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#4f66bd","button-background-hover":"#3250bc","button-border-color":"","button-border-hover-color":""},{"name":"Purple section 1","title":"#ffffff","title-hover":"","caption":"#bfbdff","content":"#b8b7e7","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Portfolio","title":"#111111","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Contact Homepage","title":"#ffffff","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#6b6b6b","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#000000","button-background-hover":"#3433b8","button-border-color":"","button-border-hover-color":""},{"name":"Purple Title","title":"#5b62e5","title-hover":"","caption":"#e5e5e5","content":"#dddddd","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":""},{"name":"creative color","title":"#ff5443","title-hover":"","caption":"#878ba5","content":"#878ba5","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"new technology","title":"#222222","title-hover":"","caption":"#969696","content":"#969696","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"counter","title":"#ff5443","title-hover":"","caption":"#64677a","content":"#64677a","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#64677a","button-text-hover":"#64677a","button-background":"#64677a","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"number 99","title":"#3646a6","title-hover":"","caption":"","content":"#64677a","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"your create","title":"#1c1c1c","title-hover":"#ff5443","caption":"","content":"#bfbfbf","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"creative idea","title":"#292929","title-hover":"","caption":"#878ba5","content":"#878ba5","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Port info","title":"","title-hover":"","caption":"#ff5443","content":"#ff5443","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Personnel","title":"#414977","title-hover":"#161616","caption":"#878787","content":"","icon":"#2d2d2d","link":"#414977","link-hover":"#212121","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Subscribe Form","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#ffffff","element-content":"#a0a0a0","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Grey Bullet","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"#b1b1b1","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#515151","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#000000","logo-background-color":"#ffffff","main-menu-text-color":"#848484","main-menu-text-hover-color":"#1d1d1d","sub-menu-background-color":"#1e1e1e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#2d2d2d","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#232323","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#383838","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#202020","page-caption-color":"#ff5443","page-title-background-overlay-color":"#2d2d2d","body-content-color":"#777777","heading-color":"#383838","link-color":"#ff5443","link-hover-color":"#ff8075","divider-color":"#e2e2e2","input-box-background-color":"#f3f3f3","input-box-border-color":"#f3f3f3","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","footer-background-color":"#f7f7f7","footer-title-color":"#1d1d1d","footer-content-color":"#8e8e8e","footer-link-color":"#828282","footer-link-hover-color":"#3646a6","footer-divider-color":"#dddddd","copyright-background-color":"#ededed","copyright-text-color":"#8c8c8c","single-blog-title-color":"#202020","single-blog-info-color":"#a8a8a8","single-blog-date-day-color":"#a8a8a8","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#a8a8a8","single-blog-title-background-overlay-color":"#000000","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#ff5443","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#353535","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#777777","portfolio-text-filter-active-color":"#ff5443","portfolio-button-filter-text-color":"#969696","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#ff5443","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#303030","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#3646a6","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#3433b8","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#ffffff","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#3433b8","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#6a6ab7","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","search-overlay-background-color":"#000000","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","sidebar-title-color":"#383838","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","single-blog-author-title-color":"#303030","single-blog-author-caption-color":"#636363","single-blog-navigation-color":"#3646a6","single-blog-comment-title-color":"#3646a6","single-blog-comment-background-color":"#f5f5f5","single-blog-comment-reply-color":"#757575","single-blog-comment-time-color":"#999999","price-table-active-head-color":"#3646a6","price-table-active-head-top-gradient-color":"#6a73a5","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#7a81a5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#3646a6","price-table-active-button-background-top-gradient-color":"#5e69a5","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#3646a6","button-background-hover-color":"#6a73a5","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#3646a6","button-top-gradient-background-color":"#5e6aa5","dropdown-tab-head-background":"#3646a6","dropdown-tab-head-text":"#ffffff","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#3433b8","slider-outer-navigation-color":"#ffffff","slider-outer-navigation-background-color":"#383838","slider-control-navigation-color":"#3b3dc6","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","blockquote-text-color":"#3646a6","blockquote-background-color":"#ffffff","blockquote-border-color":"#3646a6","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#1e1e1e","anchor-bullet-background-color":"#dfdfdf","anchor-bullet-background-active-color":"#3b3dc6","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3","page-preload-background-color":"#ffffff","woocommerce-cart-icon-number-background":"#bd584e","woocommerce-cart-icon-number-color":"#ffffff","top-cart-background-color":"#303030","top-cart-text-color":"#b5b5b5","top-cart-view-cart-color":"#ffffff","top-cart-checkout-color":"#bd584e","navigation-right-button-text-color":"#333333","navigation-right-button-background-color":"","navigation-right-button-border-color":"#333333","navigation-right-button-text-hover-color":"#555555","navigation-right-button-background-hover-color":"","navigation-right-button-border-hover-color":"#555555","copyright-link-color":"#303030","copyright-link-hover-color":"#3646a6","back-to-top-background-color":"#dbdbdb","back-to-top-text-color":"#313131","portfolio-frame-background-color":"#ffffff","portfolio-title-hover-color":"","portfolio-badge-text-color":"#ffffff","portfolio-badge-background-color":"#ff5443","accordion-normal-title-head-color":"#191919","accordion-title-head-color":"#191919","image-overlay-icon-background":"#ffffff","testimonial-rating-color":"#ffa127","woocommerce-theme-color":"#bd584e","woocommerce-price-color":"#bd584e","woocommerce-price-linethrough-color":"#949494","woocommerce-button-background-hover-color":"#d4786e","woocommerce-button-text-color":"#ffffff","woocommerce-button-text-hover-color":"#ffffff","woocommerce-input-background-color":"#f3f3f3","product-item-title-color":"#191919","product-item-title-hover-color":"#434343","view-detail-text-color":"#ffffff","view-detail-background-color":"#000000","add-to-cart-text-color":"#ffffff","add-to-cart-background-color":"#bd584e","widget-price-filter-bar-background-color":"#e6e6e6","widget-price-filter-range-color":"#824141","widget-price-filter-handle-color":"#b3564e","single-blog-style-2-tags-color":"#ff5443","single-blog-navigation2-overlay":"#ff5443","single-blog-2-related-post-background":"#f5f5f5","portfolio-grid2-tag-background":"#ff5443","slider-control-navigation-background-color":"#d8d8d8","page-title-background-gradient-max-opacity":"1","page-title-background-gradient-color":"#000","tag-cloud-text-color":"","tag-cloud-background-color":"","tag-cloud-border-color":"","custom-menu-widget-list-style-link":"#6774a2","custom-menu-widget-list-style-link-hover":"#1c3375","custom-menu-widget-list-style-border":"#233c85","single-blog-title-background-gradient-max-opacity":"1","single-blog-title-background-gradient-color":"#000","single-blog-navigation2-left-overlay":"#ff5443","single-blog-magazine-tags-text":"#8d8d8d","single-blog-magazine-tags-background":"#f2f2f2","single-blog-magazine-author-background":"#f7f7f7","blog-modern-hover-background-color":"#000","blog-thumbnail-category-background":"#ff5443","roadmap-title-color":"#a6aafb","roadmap-title-active-color":"#ffffff","roadmap-caption-color":"#c1caf6","roadmap-number-text":"#c5c5c5","roadmap-number-background":"#223077","roadmap-number-active-text":"#223077","roadmap-number-active-background":"#ffffff","roadmap-number-divider":"#ffffff","roadmap-content-title":"#ffffff","roadmap-content-caption":"#c1caf6","roadmap-content-color":"#babdff","top-cart-title-color":"#000000","top-cart-info-color":"#6c6c6c","top-cart-view-cart-background-color":"#f4f4f4","top-cart-checkout-background-color":"#000000","custom-menu-widget-box-style-text":"#474747","custom-menu-widget-box-style-background":"#143369","custom-menu-widget-box-style-text-active":"#ffffff","navigation-right-button-shadow-color":"#000"},"gdlr_plugin":{"lightbox":"lightGallery","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Portfolio Metro 1","width":"290","height":"430","hard-crop":""},{"name":"Portfolio Metro 2","width":"290","height":"215","hard-crop":""},{"name":"Portfolio Metro 3","width":"590","height":"215","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Thumbnail 2","width":"550","height":"500","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""},{"name":"Personnel Square","width":"700","height":"700","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"2013","additional-mobile-css":"","enable-srcset":"disable","link-to-lightbox":"enable","additional-head-script":"","enable-preload":"disable","preload-image":"","consent-item":"","disable-cookie-youtube":"disable","privacy-cookie-time":"30","privacy-notification-position":"bottom-bar","privacy-box-button-color":"#1a49a8","privacy-form-logo":"","privacy-form-input-button-color":"#1a49a8","privacy-form-save-button-color":"#1a49a8","lightbox-video-autoplay":"enable","additional-head-script2":""}}'
				),
			);
		}
	}

	// add action when finish install plugins
	add_action('infinite_tgmpa_no_item_redirect', 'infinite_tgmpa_no_item_redirect');
	if( !function_exists('infinite_tgmpa_no_item_redirect') ){
		function infinite_tgmpa_no_item_redirect(){
			echo '<script type="text/javascript">';
			echo 'window.location = \'' . menu_page_url('gdlr_core_getting_start', false) . '\';';
			echo '</script>';
		}
	}

	// install required plugin and redirect to getting start page
	add_action('after_switch_theme', 'infinite_getting_start_redirect'); 	
	if( !function_exists('infinite_getting_start_redirect') ){
		function infinite_getting_start_redirect(){

			$default_theme_option = '{"gdlr_general":{"layout":"full","body-margin":"0px","background-type":"color","background-image":"","background-pattern":"pattern-1","enable-boxed-border":"disable","item-padding":"15px","container-width":"1180px","container-padding":"35px","enable-top-bar":"disable","top-bar-width":"boxed","top-bar-width-pixel":"1140px","top-bar-full-side-padding":"15px","top-bar-left-text":"","top-bar-right-text":"","top-bar-top-padding":"10px","top-bar-bottom-padding":"10px","top-bar-text-size":"15px","top-bar-bottom-border":"0px","enable-top-bar-social":"disable","top-bar-social-delicious":"","top-bar-social-email":"","top-bar-social-deviantart":"","top-bar-social-digg":"","top-bar-social-facebook":"","top-bar-social-flickr":"","top-bar-social-google-plus":"","top-bar-social-lastfm":"","top-bar-social-linkedin":"","top-bar-social-pinterest":"","top-bar-social-rss":"","top-bar-social-skype":"","top-bar-social-stumbleupon":"","top-bar-social-tumblr":"","top-bar-social-twitter":"","top-bar-social-vimeo":"","top-bar-social-youtube":"","header-style":"plain","header-plain-style":"menu-right","header-plain-bottom-border":"0px","header-bar-navigation-align":"center","header-background-style":"solid","top-bar-background-opacity":"50","header-background-opacity":"50","navigation-background-opacity":"50","header-boxed-style":"splitted-menu","boxed-top-bar-background-opacity":"0","boxed-top-bar-background-extend":"0px","boxed-header-top-margin":"0px","header-side-style":"top-left","header-side-align":"left","header-side-toggle-style":"left","header-side-toggle-menu-type":"overlay","header-side-toggle-display-logo":"enable","header-width":"full","header-width-pixel":"1140px","header-full-side-padding":"30px","boxed-header-frame-radius":"3px","boxed-header-content-padding":"30px","navigation-text-top-margin":"0px","navigation-text-top-margin-boxed":"0px","navigation-text-side-spacing":"20px","navigation-slide-bar":"enable","side-header-width-pixel":"305px","side-header-side-padding":"70px","navigation-text-top-spacing":"16px","logo-right-text":"","logo-right-text-top-padding":"30px","logo":"","logo-top-padding":"30px","logo-bottom-padding":"32px","max-logo-width":"200px","main-navigation-top-padding":"36px","main-navigation-bottom-padding":"34px","enable-main-navigation-submenu-indicator":"enable","enable-main-navigation-search":"enable","enable-main-navigation-cart":"enable","right-menu-type":"right","default-title-style":"medium","default-title-align":"left","default-title-top-padding":"93px","default-title-bottom-padding":"87px","default-page-caption-top-margin":"13px","default-title-font-size":"37px","default-title-letter-spacing":"0px","default-caption-font-size":"16px","default-caption-letter-spacing":"0px","default-title-background-overlay-opacity":"76","default-title-background":"","default-portfolio-title-background":"","default-personnel-title-background":"","default-search-title-background":"","default-archive-title-background":"","default-blog-title-style":"small","default-blog-title-top-padding":"93px","default-blog-title-bottom-padding":"87px","default-blog-feature-image":"content","default-blog-title-background-image":"","default-blog-title-background-overlay-opacity":"75","blog-sidebar":"none","blog-sidebar-left":"footer-1","blog-sidebar-right":"blog","blog-thumbnail-size":"full","blog-author":"enable","pagination-style":"round","pagination-align":"right","blog-social-share":"enable","blog-social-facebook":"enable","blog-social-linkedin":"enable","blog-social-google-plus":"enable","blog-social-pinterest":"enable","blog-social-stumbleupon":"disable","blog-social-twitter":"enable","blog-social-email":"disable","enable-footer":"enable","footer-style":"footer-4","enable-copyright":"enable","copyright-text":"COPYRIGHT 2020 GOODLAYERS, ALL RIGHT RESERVED","enable-single-portfolio-navigation":"enable","enable-related-portfolio":"disable","related-portfolio-style":"grid","related-portfolio-column-size":"15","related-portfolio-num-fetch":"4","related-portfolio-thumbnail-size":"medium","related-portfolio-num-excerpt":"20","blog-max-content-width":"900px","enable-maintenance":"disable","maintenance-page":"2039","enable-main-navigation-sticky":"enable","default-404-background":"","default-404-background-opacity":"27","archive-blog-sidebar":"right","archive-blog-sidebar-left":"footer-1","archive-blog-sidebar-right":"blog","archive-blog-style":"blog-full","archive-blog-full-alignment":"left","archive-thumbnail-size":"full","archive-show-thumbnail":"enable","archive-column-size":"20","archive-excerpt":"specify-number","archive-excerpt-number":"55","archive-meta-option":["date","author","category"],"archive-show-read-more":"enable","archive-portfolio-sidebar":"none","archive-portfolio-sidebar-left":"footer-1","archive-portfolio-sidebar-right":"footer-1","archive-portfolio-style":"medium","archive-portfolio-thumbnail-size":"full","archive-portfolio-grid-text-align":"left","archive-portfolio-grid-style":"normal","archive-enable-portfolio-tag":"enable","archive-portfolio-medium-size":"small","archive-portfolio-medium-style":"switch","archive-portfolio-hover":"icon","archive-portfolio-column-size":"20","archive-portfolio-excerpt":"specify-number","archive-portfolio-excerpt-number":"55","fixed-footer":"enable"},"gdlr_typography":{"heading-font":"Raleway","navigation-font":"Raleway","content-font":"Source Sans Pro","info-font":"Droid Serif","blog-info-font":"Open Sans","quote-font":"Droid Serif","h1-font-size":"52px","h2-font-size":"48px","h3-font-size":"36px","h4-font-size":"28px","h5-font-size":"22px","h6-font-size":"18px","navigation-font-size":"13px","navigation-font-weight":"700","navigation-text-transform":"uppercase","content-font-size":"16px","content-line-height":"1.7"},"gdlr_color":{"skin":[{"name":"Dark","title":"#ffffff","title-hover":"#ffffff","caption":"#ffffff","content":"#cecece","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#777777","border":"#777777","element-background":"","element-content":"#3d3d3d","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#309cea","button-background-hover":"#0f82db","button-border-color":"","button-border-hover-color":""},{"name":"White Text","title":"#ffffff","title-hover":"","caption":"#e5e5e5","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#ffffff","border":"#ffffff","element-background":"#ffffff","element-content":"#ffffff","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#000000","button-background-hover":"#2d9bea","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Grey","title":"#3a3a3a","title-hover":"","caption":"#727272","content":"#494949","icon":"#595959","link":"","link-hover":"","divider":"#cecece","border":"#cecece","element-background":"#ffffff","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue","title":"#ffffff","title-hover":"","caption":"#d9eef7","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"#232323","button-background-hover":"#232323","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#51b0f3","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Dark Personnel","title":"#ffffff","title-hover":"#ffffff","caption":"#dddddd","content":"#ffffff","icon":"#ffffff","link":"#ffffff","link-hover":"#ffffff","divider":"#b2b2b2","border":"#bcbcbc","element-background":"#191919","element-content":"#ffffff","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Title","title":"#2d95e1","title-hover":"","caption":"#ffffff","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"About Me Top","title":"#ffffff","title-hover":"","caption":"#acc3ff","content":"#95a3bc","icon":"","link":"","link-hover":"","divider":"#ffffff","border":"","element-background":"","element-content":"","button-text":"#ffffff","button-text-hover":"#ffffff","button-background":"","button-background-hover":"","button-border-color":"#ffffff","button-border-hover-color":"#ffffff"},{"name":"Maintenance","title":"#ffffff","title-hover":"","caption":"#ffffff","content":"#d9eef7","icon":"","link":"","link-hover":"","divider":"#74abd2","border":"#74abd2","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Blue Divider White Text","title":"#ffffff","title-hover":"","caption":"#d6d6d6","content":"#ffffff","icon":"","link":"","link-hover":"","divider":"#2d9bea","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Light Border","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"#ebebeb","border":"#ebebeb","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"","button-background-hover":"","button-border-color":"","button-border-hover-color":""},{"name":"Purple Button","title":"","title-hover":"","caption":"","content":"","icon":"","link":"","link-hover":"","divider":"","border":"","element-background":"","element-content":"","button-text":"","button-text-hover":"","button-background":"#4f66bd","button-background-hover":"#3250bc","button-border-color":"","button-border-hover-color":""}],"top-bar-background-color":"#222222","top-bar-bottom-border-color":"#ffffff","top-bar-text-color":"#ffffff","top-bar-link-color":"#ffffff","top-bar-link-hover-color":"#ffffff","top-bar-social-color":"#ffffff","top-bar-social-hover-color":"#e44444","header-background-color":"#ffffff","header-plain-bottom-border-color":"#e8e8e8","navigation-bar-background-color":"#f4f4f4","navigation-bar-top-border-color":"#e8e8e8","navigation-slide-bar-color":"#2d9bea","logo-background-color":"#ffffff","main-menu-text-color":"#999999","main-menu-text-hover-color":"#333333","sub-menu-background-color":"#2e2e2e","sub-menu-text-color":"#bebebe","sub-menu-text-hover-color":"#ffffff","sub-mega-menu-title-color":"#ffffff","sub-mega-menu-divider-color":"#424242","mobile-menu-button-color":"#404040","mobile-menu-button-border-color":"#e6e6e6","mobile-menu-head-text-color":"#e6e6e6","mobile-menu-text-color":"#e6e6e6","mobile-menu-background-color":"#e6e6e6","mobile-menu-border-color":"#e6e6e6","navigation-bar-right-icon-color":"#383838","secondary-menu-icon-color":"#383838","secondary-menu-border-color":"#dddddd","body-background-color":"#ffffff","container-background-color":"#ffffff","page-title-color":"#ffffff","page-caption-color":"#ffffff","page-title-background-overlay-color":"#2d2d2d","body-content-color":"#9b9b9b","heading-color":"#383838","link-color":"#545454","link-hover-color":"#333333","divider-color":"#e2e2e2","input-box-background-color":"#ffffff","input-box-border-color":"#d7d7d7","input-box-text-color":"#4e4e4e","input-box-placeholder-color":"#4e4e4e","sidebar-link-color":"#484848","sidebar-link-hover-color":"#323232","recent-post-widget-info-icon-color":"#9c9c9c","recent-post-widget-info-link-color":"#a0a0a0","post-slider-widget-title-color":"#ffffff","post-slider-widget-info-color":"#9c9c9c","footer-background-color":"#282828","footer-title-color":"#ffffff","footer-content-color":"#ababab","footer-link-color":"#bababa","footer-link-hover-color":"#ffffff","footer-divider-color":"#494949","copyright-background-color":"#181818","copyright-text-color":"#838383","single-blog-title-color":"#ffffff","single-blog-info-color":"#ffffff","single-blog-date-day-color":"#ffffff","single-blog-date-month-color":"#b1b1b1","single-blog-divider-color":"#ffffff","single-blog-title-background-overlay-color":"#000000","blog-title-color":"#343434","blog-title-hover-color":"#343434","blog-info-color":"#959595","blog-date-day-color":"#353535","blog-date-month-color":"#8a8a8a","blog-frame-background-color":"#ffffff","blog-modern-text-color":"#ffffff","blog-aside-background-color":"#2d9bea","blog-aside-text-color":"#ffffff","pagination-background-color":"#f0f0f0","pagination-text-color":"#929292","pagination-background-hover-color":"#353535","pagination-text-hover-color":"#ffffff","pagination-plain-color":"#b4b4b4","pagination-plain-hover-color":"#424242","single-portfolio-nav-color":"#bcbcbc","portfolio-title-color":"#191919","portfolio-info-color":"#b1b1b1","portfolio-thumbnail-title-color":"#ffffff","portfolio-thumbnail-info-color":"#cecece","portfolio-text-filter-color":"#aaaaaa","portfolio-text-filter-active-color":"#747474","portfolio-button-filter-text-color":"#838383","portfolio-button-filter-background-color":"#f1f1f1","portfolio-button-filter-text-active-color":"#ffffff","portfolio-button-filter-background-active-color":"#2f9cea","price-table-background-color":"#f8f8f8","price-table-head-color":"#3e3e3e","price-table-head-top-gradient-color":"#525252","price-table-icon-color":"#ffffff","price-table-title-color":"#ffffff","price-table-caption-color":"#acacac","price-table-price-background-color":"#ebebeb","price-table-price-color":"#323232","price-table-price-suffix-color":"#acacac","price-table-price-button-color":"#ffffff","price-table-button-background-color":"#575757","price-table-button-background-top-gradient-color":"#414141","price-table-list-border-color":"#e5e5e5","accordion-normal-icon-color":"#191919","accordion-normal-title-color":"#191919","accordion-normal-icon-background-color":"#f3f3f3","accordion-icon-color":"#191919","accordion-title-color":"#191919","accordion-title-background-color":"#f3f3f3","accordion-icon-active-color":"#ffffff","accordion-title-active-color":"#ffffff","accordion-title-background-active-color":"#303030","audio-background-color":"#e7e7e7","audio-text-color":"#202020","audio-content-background-color":"#afafaf","audio-content-progress-color":"#2d9bea","audio-volume-background-color":"#afafaf","audio-volume-progress-color":"#646464","blockquote-icon-color":"#4e4e4e","blockquote-color":"#4e4e4e","alert-box-item-background-color":"#ef5e68","alert-box-item-border-color":"#cd515a","alert-box-item-content-color":"#ffffff","alert-box-item-title-color":"#ffffff","call-to-action-title-color":"#2c2c2c","call-to-action-caption-color":"#535353","counter-item-top-text-color":"#828282","counter-item-top-icon-color":"#393939","counter-item-number-color":"#393939","counter-item-divider-color":"#393939","counter-item-bottom-text-color":"#393939","column-service-icon-color":"#9d9d9d","column-service-icon-background":"#f3f3f3","column-service-title-color":"#383838","column-service-caption-color":"#747474","flipbox-background-color":"#2d9bea","flipbox-border-color":"#2a80be","flipbox-icon-color":"#ffffff","flipbox-title-color":"#ffffff","flipbox-caption-color":"#ffffff","flipbox-content-color":"#ffffff","gallery-overlay-title":"#ffffff","gallery-overlay-caption":"#cecece","portfolio-info-head-color":"#343434","opening-hour-day-color":"#a5a5a5","opening-hour-open-color":"#2d9bea","opening-hour-close-color":"#c8c8c8","opening-hour-icon-color":"#8a8989","opening-hour-divider-color":"#a6a6a6","personnel-grid-title-color":"#383838","personnel-grid-position-color":"#888888","personnel-grid-divider-color":"#cecece","personnel-grid-frame-color":"#f9f9f9","personnel-modern-title-color":"#ffffff","personnel-modern-position-color":"#ffffff","post-slider-title-color":"#ffffff","post-slider-info-color":"#c5c5c5","stunning-text-title-color":"#747474","stunning-text-caption-color":"#383838","tab-title-color":"#8d8d8d","tab-title-background-color":"#f7f7f7","tab-title-border-color":"#ebebeb","tab-title-hover-bar-color":"#2d9bea","tab-title-active-color":"#464646","tab-title-active-background-color":"#ffffff","table-head-background-color":"#49b7df","table-head-text-color":"#ffffff","table-odd-background-color":"#f9f9f9","table-odd-text-color":"#949494","table-even-background":"#f3f3f3","table-even-text":"#949494","testimonial-title-color":"#232323","testimonial-content-color":"#707070","testimonial-author-color":"#3b3b3b","testimonial-position-color":"#3b3b3b","testimonial-quote-color":"#282828","title-item-title-color":"#383838","title-item-caption-color":"#747474","search-overlay-background-color":"#000000","side-menu-text-color":"#979797","side-menu-text-hover-color":"#ffffff","side-menu-background-color":"#1f1f1f","side-menu-border-color":"#626262","overlay-menu-background-color":"#000000","overlay-menu-border-color":"#424242","overlay-menu-text-color":"#ffffff","overlay-menu-text-hover-color":"#a8a8a8","sidebar-title-color":"#383838","search-box-text-color":"#b5b5b5","search-box-border-color":"#e0e0e0","search-box-icon-color":"#c7c7c7","twitter-widget-icon-color":"#303030","twitter-widget-date-color":"#b5b5b5","single-blog-author-title-color":"#464646","single-blog-author-caption-color":"#b1b1b1","single-blog-navigation-color":"#bcbcbc","single-blog-comment-title-color":"#464646","single-blog-comment-background-color":"#f9f9f9","single-blog-comment-reply-color":"#bcbcbc","single-blog-comment-time-color":"#b1b1b1","price-table-active-head-color":"#329eec","price-table-active-head-top-gradient-color":"#59b9fe","price-table-active-icon-color":"#ffffff","price-table-active-title-color":"#ffffff","price-table-active-caption-color":"#b1d8f5","price-table-active-price-background-color":"#ffffff","price-table-active-price-color":"#323232","price-table-active-price-suffix-color":"#acacac","price-table-active-price-button-color":"#ffffff","price-table-active-button-background-color":"#319dea","price-table-active-button-background-top-gradient-color":"#52aae9","button-text-color":"#ffffff","button-text-hover-color":"#ffffff","button-background-color":"#2F2F2F","button-background-hover-color":"#309cea","button-border-color":"#383838","button-border-hover-color":"#000000","button-gradient-background-color":"#309cea","button-top-gradient-background-color":"#52aae9","dropdown-tab-head-background":"#309cea","dropdown-tab-head-text":"#ffffff","image-overlay-background-color":"#000000","image-overlay-icon-color":"#ffffff","image-item-border-color":"#000000","item-title-color":"#343434","item-title-caption-color":"#747474","item-title-link-color":"#747474","icon-list-item-icon-color":"#222222","icon-list-item-icon-background-color":"#f3f3f3","promo-box-item-title-color":"#383838","promo-box-content-border-color":"#e8e7e7","skill-bar-title-color":"#505050","skill-bar-icon-color":"#616161","skill-bar-background-color":"#f3f3f3","skill-bar-progress-color":"#2d9bea","slider-outer-navigation-color":"#ffffff","slider-outer-navigation-background-color":"#383838","slider-control-navigation-color":"#8a8a8a","social-share-icon-color":"#202020","social-share-divider-color":"#e5e5e5","social-share-text-color":"#202020","blockquote-text-color":"#777777","blockquote-background-color":"#f5f5f5","blockquote-border-color":"#e2e2e2","blockquote-item-icon-color":"#4e4e4e","blockquote-item-content-color":"#4e4e4e","breadcrumbs-text-color":"#c0c0c0","breadcrumbs-text-active-color":"#777777","sub-menu-text-hover-background-color":"#393939","anchor-bullet-background-color":"#777777","anchor-bullet-background-active-color":"#ffffff","404-content-background-color":"#23618e","404-head-color":"#ffffff","404-title-color":"#ffffff","404-caption-color":"#c3e7ff","404-input-background-color":"#000000","404-input-text-color":"#ffffff","404-back-to-home-color":"#ffffff","blog-sticky-banner-color":"#444444","blog-sticky-banner-background":"#f3f3f3"},"gdlr_plugin":{"lightbox":"ilightbox","thumbnail-sizing":[{"name":"Personnel Thumbnail","width":"700","height":"500","hard-crop":""},{"name":"Portfolio Thumbnail","width":"700","height":"450","hard-crop":""},{"name":"Portfolio Thumbnail Portrait","width":"700","height":"660","hard-crop":""},{"name":"Portfolio Thumbnail Portrait 2","width":"600","height":"800","hard-crop":""},{"name":"Large Landscape ","width":"1280","height":"580","hard-crop":""},{"name":"Large Landscape 2","width":"1550","height":"700","hard-crop":""},{"name":"Portfolio Side Description Large","width":"900","height":"500","hard-crop":""},{"name":"Portfolio Metro 1","width":"290","height":"430","hard-crop":""},{"name":"Portfolio Metro 2","width":"290","height":"215","hard-crop":""},{"name":"Portfolio Metro 3","width":"590","height":"215","hard-crop":""},{"name":"Blog Full Thumbnail","width":"1100","height":"490","hard-crop":""},{"name":"Blog Column Thumbnail","width":"700","height":"430","hard-crop":""},{"name":"Personnel Thumbnail 2","width":"550","height":"500","hard-crop":""},{"name":"Large Landscape 3","width":"1500","height":"1000","hard-crop":""}],"additional-css":"","additional-script":"","ilightbox-skin":"dark","enable-maintenance":"disable","maintenance-page":"2013","additional-mobile-css":""}}';
			$default_theme_option = json_decode($default_theme_option, true);
			foreach( $default_theme_option as $option_slug => $option_value ){
				$option = get_option($option_slug, array());
				if( empty($option) ){
					update_option($option_slug, $option_value);
				}
			}

			// redirect to plugin installation
			$plugin_slug = 'goodlayers-core';
			$getting_start_url = 'gdlr_core_getting_start';
			// $redirect_url = infinite_tgmpa_does_plugin_active($plugin_slug,  $getting_start_url);
			$redirect_url = infinite_tgmpa_auto_install_url($plugin_slug,  $getting_start_url);
			
			if( empty($redirect_url) ){
				wp_redirect(menu_page_url('tgmpa-install-plugins', false));
			}else{
				wp_redirect($redirect_url);
			}

		}
	}